/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class CombustEffect
extends PeriodicExpirableEffect {
    private boolean expired = false;

    public CombustEffect(Skill skill, Player applier) {
        super(skill, "Combust", applier, 10L, 0L);
        this.types.add(EffectType.FIRE);
        this.setPersistent(true);
    }

    @Override
    public void applyToMonster(Monster monster) {
        super.applyToMonster(monster);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
    }

    @Override
    public boolean isExpired() {
        return this.expired;
    }

    @Override
    public void tickMonster(Monster monster) {
        int fireTicks = monster.getEntity().getFireTicks();
        if (fireTicks < 1) {
            this.expired = true;
        }
    }

    @Override
    public void tickHero(Hero hero) {
        Player player = hero.getPlayer();
        if (player.getFireTicks() < 1) {
            this.expired = true;
        }
    }
}

