/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.effects.common.CombustEffect;
import com.herocraftonline.heroes.characters.effects.common.interfaces.Burning;
import com.herocraftonline.heroes.characters.skill.Skill;
import java.util.logging.Level;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class BurningEffect
extends ExpirableEffect
implements Burning {
    private final boolean overrideCurrentFireTicks;
    private final double damageMultiplier;
    private LivingEntity currentActiveEntity;

    public BurningEffect(Skill skill, Player applier, long baseDuration) {
        this(skill, applier, baseDuration, false);
    }

    public BurningEffect(Skill skill, Player applier, long baseDuration, double damageMultiplier) {
        this(skill, applier, baseDuration, false, damageMultiplier);
    }

    public BurningEffect(Skill skill, String name, Player applier, long baseDuration) {
        this(skill, name, applier, baseDuration, false);
    }

    public BurningEffect(Skill skill, String name, Player applier, long baseDuration, double damageMultiplier) {
        this(skill, name, applier, baseDuration, false, damageMultiplier);
    }

    public BurningEffect(Skill skill, Player applier, long baseDuration, boolean overrideCurrentFireTicks) {
        this(skill, applier, baseDuration, overrideCurrentFireTicks, 1.0);
    }

    public BurningEffect(Skill skill, String name, Player applier, long baseDuration, boolean overrideCurrentFireTicks) {
        this(skill, name, applier, baseDuration, overrideCurrentFireTicks, 1.0);
    }

    public BurningEffect(Skill skill, Player applier, long baseDuration, boolean overrideCurrentFireTicks, double damageMultiplier) {
        this(skill, "Burning", applier, baseDuration, overrideCurrentFireTicks, damageMultiplier, null, null);
    }

    public BurningEffect(Skill skill, String name, Player applier, long baseDuration, boolean overrideCurrentFireTicks, double damageMultiplier) {
        this(skill, name, applier, baseDuration, overrideCurrentFireTicks, damageMultiplier, null, null);
    }

    public BurningEffect(Skill skill, String name, Player applier, long baseDuration, boolean overrideCurrentFireTicks, double damageMultiplier, String applyText, String expireText) {
        super(skill, name, applier, baseDuration, applyText, expireText);
        this.overrideCurrentFireTicks = overrideCurrentFireTicks;
        this.damageMultiplier = damageMultiplier;
        this.types.add(EffectType.FIRE);
        this.types.add(EffectType.BURNING);
        this.types.add(EffectType.DAMAGING);
    }

    @Override
    public void applyToMonster(Monster monster) {
        super.applyToMonster(monster);
        LivingEntity lEnt = monster.getEntity();
        if (this.overrideCurrentFireTicks) {
            lEnt.setFireTicks(BurningEffect.millisToFireTicks(this.getDuration()));
        } else {
            Heroes.log(Level.INFO, "Applying Burning. Current fire ticks: " + lEnt.getFireTicks());
            Heroes.log(Level.INFO, "Applying Burning. Current Duration: " + this.getDuration());
            this.setDuration(this.fireTicksToMillis(lEnt));
            lEnt.setFireTicks(BurningEffect.millisToFireTicks(this.getDuration()));
            Heroes.log(Level.INFO, "Applying Burning. New fire ticks: " + lEnt.getFireTicks());
            Heroes.log(Level.INFO, "Applying Burning. New Duration: " + this.getDuration());
        }
        monster.addEffect(new CombustEffect(this.skill, this.applier));
        this.currentActiveEntity = lEnt;
    }

    @Override
    public void removeFromMonster(Monster monster) {
        super.removeFromMonster(monster);
        monster.removeEffect(monster.getEffect("Combust"));
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        if (this.overrideCurrentFireTicks) {
            player.setFireTicks(BurningEffect.millisToFireTicks(this.getDuration()));
        } else {
            this.setDuration(this.fireTicksToMillis((LivingEntity)player));
            player.setFireTicks(BurningEffect.millisToFireTicks(this.getDuration()));
        }
        this.currentActiveEntity = player;
        hero.addEffect(new CombustEffect(this.skill, this.applier));
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        hero.removeEffect(hero.getEffect("Combust"));
    }

    @Override
    public double getDamageMultiplier() {
        return this.damageMultiplier;
    }

    @Override
    public double getRemainingDamage() {
        if (this.currentActiveEntity == null) {
            return 0.0;
        }
        return this.plugin.getDamageManager().calculateFireTickDamage(this.currentActiveEntity, this.damageMultiplier);
    }

    @Override
    public void addDuration(long additionalMillis) {
        this.setDuration(this.getDuration() + additionalMillis);
        if (this.currentActiveEntity != null) {
            this.currentActiveEntity.setFireTicks(BurningEffect.millisToFireTicks(this.getDuration()));
        }
    }

    private static int millisToFireTicks(long durationMillis) {
        return (int)(durationMillis / 50L) + 1;
    }

    private long fireTicksToMillis(LivingEntity ent) {
        if (this.overrideCurrentFireTicks) {
            return this.getDuration();
        }
        if (ent.getFireTicks() < 0) {
            return this.getDuration();
        }
        return (long)(ent.getFireTicks() * 50) + this.getDuration();
    }
}

