/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BlindEffect
extends ExpirableEffect {
    public BlindEffect(Skill skill, Player applier, long duration) {
        this(skill, "Blind", applier, duration, ChatComponents.GENERIC_SKILL + "$1 has been blinded!", ChatComponents.GENERIC_SKILL + "$1 can see again!");
    }

    public BlindEffect(Skill skill, String name, Player applier, long duration) {
        this(skill, name, applier, duration, ChatComponents.GENERIC_SKILL + "$1 has been blinded!", ChatComponents.GENERIC_SKILL + "$1 can see again!");
    }

    public BlindEffect(Skill skill, Player applier, long duration, String applyText, String expireText) {
        this(skill, "Blind", applier, duration, applyText, expireText);
    }

    public BlindEffect(Skill skill, String name, Player applier, long duration, String applyText, String expireText) {
        super(skill, name, applier, duration, applyText, expireText);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.BLIND);
        this.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, (int)(20L * duration / 1000L), 0));
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        final Player player = hero.getPlayer();
        final int currentHunger = player.getFoodLevel();
        player.setFoodLevel(1);
        Bukkit.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                player.setFoodLevel(currentHunger);
            }
        }, 2L);
    }
}

