/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.common.AbstractChangeEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class AbstractSyncChangeEffect<T extends Number>
extends AbstractChangeEffect<T> {
    public AbstractSyncChangeEffect(Skill skill, String name, Player applier, long duration, T delta, String applyText, String expireText) {
        super(skill, name, applier, duration, delta, applyText, expireText);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.syncTask(hero), 1L);
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.syncTask(hero), 1L);
    }

    protected abstract void syncTask(Hero var1);
}

