/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectStack;
import com.herocraftonline.heroes.characters.effects.ManagedStack;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class StackingEffect
extends Effect
implements ManagedStack {
    private boolean stackCountChanged = false;
    protected final EffectStack effectStack;
    protected final boolean updateDurationOnNewStack;

    public StackingEffect(Skill skill, String name, Player applier, int maxStacks) {
        this(skill, name, applier, maxStacks, false, null, null);
    }

    public StackingEffect(Skill skill, String name, Player applier, int maxStacks, boolean updateDurationOnNewStack) {
        this(skill, name, applier, maxStacks, updateDurationOnNewStack, null, null);
    }

    public StackingEffect(Skill skill, String name, Player applier, int maxStacks, String applyText, String removeText) {
        this(skill, name, applier, maxStacks, false, applyText, removeText);
    }

    public StackingEffect(Skill skill, String name, Player applier, int maxStacks, boolean updateDurationOnNewStack, String applyText, String removeText) {
        super(skill, name, applier, applyText, removeText);
        this.effectStack = new EffectStack(maxStacks);
        this.updateDurationOnNewStack = updateDurationOnNewStack;
    }

    @Override
    public int getStackCount() {
        return this.effectStack.count();
    }

    @Override
    public int getMaxStacks() {
        return this.effectStack.getMax();
    }

    public EffectStack.Entry getStackEntry(int index) {
        return this.effectStack.get(index);
    }

    @Override
    public int addStacks(Skill skill, Player applier, long duration, int amount) {
        int added;
        if (this.effectStack == null) {
            return 0;
        }
        if (this.updateDurationOnNewStack) {
            this.effectStack.resetAllStackDurationsToFull();
        }
        if ((added = this.effectStack.add(skill, applier, duration, amount)) > 0) {
            this.stackCountChanged = true;
        }
        return added;
    }

    @Override
    public int removeStacks(int amount) {
        if (this.effectStack != null) {
            int removed = this.effectStack.remove(amount);
            if (removed > 0) {
                this.stackCountChanged = true;
            }
            return removed;
        }
        return 0;
    }

    @Override
    public int removeAllStacks() {
        if (this.effectStack != null) {
            int removed = this.effectStack.removeAll();
            if (removed > 0) {
                this.stackCountChanged = true;
            }
            return removed;
        }
        return 0;
    }

    @Override
    public int refresh(CharacterTemplate character) {
        this.removeExpiredStacks();
        if (this.stackCountChanged) {
            this.stackCountChangedOnCharacter(character);
        }
        return this.getStackCount();
    }

    protected void stackCountChangedOnCharacter(CharacterTemplate character) {
        if (character instanceof Hero) {
            this.stackCountChangedOnHero((Hero)character);
        } else if (character instanceof Monster) {
            this.stackCountChangedOnMonster((Monster)character);
        }
    }

    protected void stackCountChangedOnHero(Hero hero) {
    }

    protected void stackCountChangedOnMonster(Monster monster) {
    }

    private void removeExpiredStacks() {
        if (this.effectStack != null && this.effectStack.removeExpired() > 0) {
            this.stackCountChanged = true;
        }
    }
}

