/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroRegainStaminaEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PeriodicStaminaEffect
extends PeriodicExpirableEffect {
    private int tickStamina;

    public PeriodicStaminaEffect(Skill skill, String name, Player applier, long period, long duration, int tickStamina) {
        this(skill, null, name, applier, period, duration, tickStamina, null, null);
    }

    public PeriodicStaminaEffect(Skill skill, String name, Player applier, long period, long duration, int tickStamina, String applyText, String expireText) {
        this(skill, null, name, applier, period, duration, tickStamina, applyText, expireText);
    }

    public PeriodicStaminaEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, int tickStamina) {
        this(skill, plugin, name, applier, period, duration, tickStamina, null, null);
    }

    public PeriodicStaminaEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, int tickStamina, String applyText, String expireText) {
        super(skill, plugin, name, applier, period, duration, applyText, expireText);
        this.tickStamina = tickStamina;
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.STAMINA_INCREASING);
    }

    @Override
    public void tickMonster(Monster monster) {
    }

    @Override
    public void tickHero(Hero hero) {
        HeroRegainStaminaEvent event = new HeroRegainStaminaEvent(hero, this.tickStamina, this.skill);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        hero.setStamina(hero.getStamina() + (Integer)event.getDelta());
    }
}

