/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.Periodic;
import com.herocraftonline.heroes.characters.effects.StackingEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public abstract class PeriodicStackingEffect
extends StackingEffect
implements Periodic {
    private final long period;
    protected long lastTickTime = 0L;

    public PeriodicStackingEffect(Skill skill, String name, Player applier, int maxStacks, long period, String applyText, String removeText) {
        super(skill, name, applier, maxStacks, applyText, removeText);
        this.period = period;
    }

    public PeriodicStackingEffect(Skill skill, String name, Player applier, int maxStacks, long period) {
        this(skill, name, applier, maxStacks, period, null, null);
    }

    @Override
    public long getLastTickTime() {
        return this.lastTickTime;
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    @Override
    public boolean isReady() {
        return System.currentTimeMillis() >= this.lastTickTime + this.period;
    }

    @Override
    public void tick(CharacterTemplate character) {
        this.lastTickTime = System.currentTimeMillis();
        if (character instanceof Hero) {
            this.tickHero((Hero)character);
        } else if (character instanceof Monster) {
            this.tickMonster((Monster)character);
        }
    }
}

