/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectStack;
import com.herocraftonline.heroes.characters.effects.PeriodicStackingEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class PeriodicStackingDamageEffect
extends PeriodicStackingEffect {
    protected double tickDamagePerStack;
    private final boolean knockback;
    private EffectStack.Entry recentEntry = null;

    public PeriodicStackingDamageEffect(Skill skill, String name, Player applier, int maxStacks, long period, double tickDamagePerStack, boolean knockback, String applyText, String removeText) {
        super(skill, name, applier, maxStacks, period, applyText, removeText);
        this.tickDamagePerStack = tickDamagePerStack;
        this.knockback = knockback;
    }

    public PeriodicStackingDamageEffect(Skill skill, String name, Player applier, int maxStacks, long period, double tickDamagePerStack, String applyText, String removeText) {
        this(skill, name, applier, maxStacks, period, tickDamagePerStack, false, applyText, removeText);
    }

    public PeriodicStackingDamageEffect(Skill skill, String name, Player applier, int maxStacks, long period, double tickDamagePerStack, boolean knockback) {
        this(skill, name, applier, maxStacks, period, tickDamagePerStack, knockback, null, null);
    }

    public PeriodicStackingDamageEffect(Skill skill, String name, Player applier, int maxStacks, long period, double tickDamagePerStack) {
        this(skill, name, applier, maxStacks, period, tickDamagePerStack, null, null);
    }

    public double getTickDamagePerStack() {
        return this.tickDamagePerStack;
    }

    public void setTickDamagePerStack(double tickDamagePerStack) {
        this.tickDamagePerStack = tickDamagePerStack;
    }

    @Override
    protected void stackCountChangedOnCharacter(CharacterTemplate character) {
        this.recentEntry = null;
        for (int i = 0; i < this.effectStack.count(); ++i) {
            EffectStack.Entry entry = this.effectStack.get(i);
            if (this.recentEntry != null && entry.getApplyTime() >= this.recentEntry.getApplyTime()) continue;
            this.recentEntry = entry;
        }
        super.stackCountChangedOnCharacter(character);
    }

    @Override
    public void tickHero(Hero hero) {
        Player player = hero.getPlayer();
        if (this.recentEntry != null && Skill.damageCheck(this.recentEntry.getApplier(), (LivingEntity)player)) {
            Hero applyHero = this.plugin.getCharacterManager().getHero(this.recentEntry.getApplier());
            this.recentEntry.getSkill().addSpellTarget((Entity)player, applyHero);
            this.recentEntry.getSkill().damageEntity((LivingEntity)player, (LivingEntity)this.recentEntry.getApplier(), this.tickDamagePerStack * (double)this.getStackCount(), this.knockback);
        }
    }

    @Override
    public void tickMonster(Monster monster) {
        if (this.recentEntry != null) {
            Hero applyHero = this.plugin.getCharacterManager().getHero(this.recentEntry.getApplier());
            this.recentEntry.getSkill().addSpellTarget((Entity)monster.getEntity(), applyHero);
            this.recentEntry.getSkill().damageEntity(monster.getEntity(), (LivingEntity)this.recentEntry.getApplier(), this.tickDamagePerStack * (double)this.getStackCount(), this.knockback);
        }
    }
}

