/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroRegainShieldEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PeriodicShieldEffect
extends PeriodicExpirableEffect {
    private int tickShield;

    public PeriodicShieldEffect(Skill skill, String name, Player applier, long period, long duration, int tickShield) {
        this(skill, null, name, applier, period, duration, tickShield, null, null);
    }

    public PeriodicShieldEffect(Skill skill, String name, Player applier, long period, long duration, int tickShield, String applyText, String expireText) {
        this(skill, null, name, applier, period, duration, tickShield, applyText, expireText);
    }

    public PeriodicShieldEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, int tickShield) {
        this(skill, plugin, name, applier, period, duration, tickShield, null, null);
    }

    public PeriodicShieldEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, int tickShield, String applyText, String expireText) {
        super(skill, plugin, name, applier, period, duration, applyText, expireText);
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.SHIELD_INCREASING);
        this.tickShield = tickShield;
    }

    @Override
    public void tickMonster(Monster monster) {
    }

    @Override
    public void tickHero(Hero hero) {
        HeroRegainShieldEvent event = new HeroRegainShieldEvent(hero, this.tickShield, this.skill);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        hero.setShield(hero.getShield() + (float)((Integer)event.getDelta()).intValue());
    }
}

