/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroRegainManaEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PeriodicManaEffect
extends PeriodicExpirableEffect {
    private int tickMana;

    public PeriodicManaEffect(Skill skill, String name, Player applier, long period, long duration, int tickMana) {
        this(skill, null, name, applier, period, duration, tickMana, null, null);
    }

    public PeriodicManaEffect(Skill skill, String name, Player applier, long period, long duration, int tickMana, String applyText, String expireText) {
        this(skill, null, name, applier, period, duration, tickMana, applyText, expireText);
    }

    public PeriodicManaEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, int tickMana) {
        this(skill, plugin, name, applier, period, duration, tickMana, null, null);
    }

    public PeriodicManaEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, int tickMana, String applyText, String expireText) {
        super(skill, plugin, name, applier, period, duration, applyText, expireText);
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.MANA_INCREASING);
        this.tickMana = tickMana;
    }

    @Override
    public void tickMonster(Monster monster) {
    }

    @Override
    public void tickHero(Hero hero) {
        HeroRegainManaEvent event = new HeroRegainManaEvent(hero, this.tickMana, this.skill);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        hero.setMana(hero.getMana() + (Integer)event.getDelta());
    }
}

