/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class PeriodicHealEffect
extends PeriodicExpirableEffect {
    private double tickHealth;

    public PeriodicHealEffect(Skill skill, String name, Player applier, long period, long duration, double tickHealth) {
        this(skill, null, name, applier, period, duration, tickHealth, null, null);
    }

    public PeriodicHealEffect(Skill skill, String name, Player applier, long period, long duration, double tickHealth, String applyText, String expireText) {
        this(skill, null, name, applier, period, duration, tickHealth, applyText, expireText);
    }

    public PeriodicHealEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, double tickHealth) {
        this(skill, plugin, name, applier, period, duration, tickHealth, null, null);
    }

    public PeriodicHealEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, double tickHealth, String applyText, String expireText) {
        super(skill, plugin, name, applier, period, duration, applyText, expireText);
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.HEALING);
        this.tickHealth = tickHealth;
    }

    public double getTickHealth() {
        return this.tickHealth;
    }

    public void setTickHealth(double tickHealth) {
        this.tickHealth = tickHealth;
    }

    @Override
    public void tickHero(Hero hero) {
        Hero applyHero = this.plugin.getCharacterManager().getHero(this.getApplier());
        hero.tryHeal(applyHero, this.skill, this.tickHealth);
    }

    @Override
    public void tickMonster(Monster monster) {
        Hero applyHero = this.plugin.getCharacterManager().getHero(this.getApplier());
        monster.tryHeal(applyHero, this.skill, this.tickHealth);
    }
}

