/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.effects.Periodic;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public abstract class PeriodicExpirableEffect
extends ExpirableEffect
implements Periodic {
    private final long period;
    protected long lastTickTime = 0L;

    public PeriodicExpirableEffect(Skill skill, String name, Player applier, long period, long duration) {
        this(skill, null, name, applier, period, duration, null, null);
    }

    public PeriodicExpirableEffect(Skill skill, String name, Player applier, long period, long duration, String applyText, String expireText) {
        this(skill, null, name, applier, period, duration, applyText, expireText);
    }

    public PeriodicExpirableEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration) {
        this(skill, plugin, name, applier, period, duration, null, null);
    }

    public PeriodicExpirableEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, String applyText, String expireText) {
        super(skill, plugin, name, applier, duration, applyText, expireText);
        this.period = period;
    }

    @Override
    public long getLastTickTime() {
        return this.lastTickTime;
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    @Override
    public boolean isReady() {
        return System.currentTimeMillis() >= this.lastTickTime + this.period;
    }

    @Override
    public void tick(CharacterTemplate character) {
        this.lastTickTime = System.currentTimeMillis();
        if (character instanceof Hero) {
            this.tickHero((Hero)character);
        } else if (character instanceof Monster) {
            this.tickMonster((Monster)character);
        }
    }
}

