/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.Periodic;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class PeriodicEffect
extends Effect
implements Periodic {
    private final long period;
    protected long lastTickTime = 0L;

    @Deprecated
    public PeriodicEffect(Skill skill, String name, long period) {
        this(skill, name, null, period);
    }

    @Deprecated
    public PeriodicEffect(Heroes plugin, String name, long period) {
        this(null, plugin, name, null, period);
    }

    public PeriodicEffect(Skill skill, String name, Player applier, long period) {
        this(skill, name, applier, period, null, null);
    }

    public PeriodicEffect(Skill skill, String name, Player applier, long period, String applyText, String removeText) {
        super(skill, name, applier, applyText, removeText);
        this.period = period;
    }

    public PeriodicEffect(Skill skill, Heroes plugin, String name, Player applier, long period) {
        this(skill, plugin, name, applier, period, null, null);
    }

    public PeriodicEffect(Skill skill, Heroes plugin, String name, Player applier, long period, String applyText, String removeText) {
        super(plugin, skill, name, applier, applyText, removeText, new EffectType[0]);
        this.period = period;
    }

    @Override
    public long getLastTickTime() {
        return this.lastTickTime;
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    @Override
    public boolean isReady() {
        return System.currentTimeMillis() >= this.lastTickTime + this.period;
    }

    @Override
    public void tick(CharacterTemplate character) {
        this.lastTickTime = System.currentTimeMillis();
        if (character instanceof Hero) {
            this.tickHero((Hero)character);
        } else if (character instanceof Monster) {
            this.tickMonster((Monster)character);
        }
    }

    @Override
    public void tickMonster(Monster monster) {
    }

    @Override
    public void tickHero(Hero hero) {
    }
}

