/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class PeriodicDamageEffect
extends PeriodicExpirableEffect {
    protected double tickDamage;
    private final boolean knockback;

    public PeriodicDamageEffect(Skill skill, String name, Player applier, long period, long duration, double tickDamage) {
        this(skill, name, applier, period, duration, tickDamage, false, null, null);
    }

    public PeriodicDamageEffect(Skill skill, String name, Player applier, long period, long duration, double tickDamage, boolean knockback) {
        this(skill, name, applier, period, duration, tickDamage, knockback, null, null);
    }

    public PeriodicDamageEffect(Skill skill, String name, Player applier, long period, long duration, double tickDamage, String applyText, String expireText) {
        this(skill, name, applier, period, duration, tickDamage, false, applyText, expireText);
    }

    public PeriodicDamageEffect(Skill skill, String name, Player applier, long period, long duration, double tickDamage, boolean knockback, String applyText, String expireText) {
        super(skill, name, applier, period, duration, applyText, expireText);
        this.types.add(EffectType.HARMFUL);
        this.tickDamage = tickDamage;
        this.knockback = knockback;
    }

    public PeriodicDamageEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, double tickDamage) {
        this(skill, plugin, name, applier, period, duration, tickDamage, false, null, null);
    }

    public PeriodicDamageEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, double tickDamage, boolean knockback) {
        this(skill, plugin, name, applier, period, duration, tickDamage, knockback, null, null);
    }

    public PeriodicDamageEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, double tickDamage, String applyText, String expireText) {
        this(skill, plugin, name, applier, period, duration, tickDamage, false, applyText, expireText);
    }

    public PeriodicDamageEffect(Skill skill, Heroes plugin, String name, Player applier, long period, long duration, double tickDamage, boolean knockback, String applyText, String expireText) {
        super(skill, plugin, name, applier, period, duration, applyText, expireText);
        this.types.add(EffectType.HARMFUL);
        this.tickDamage = tickDamage;
        this.knockback = knockback;
    }

    public double getTickDamage() {
        return this.tickDamage;
    }

    public void setTickDamage(double tickDamage) {
        this.tickDamage = tickDamage;
    }

    @Override
    public void tickMonster(Monster monster) {
        Hero applyHero = this.plugin.getCharacterManager().getHero(this.getApplier());
        this.skill.addSpellTarget((Entity)monster.getEntity(), applyHero);
        this.skill.damageEntity(monster.getEntity(), (LivingEntity)this.getApplier(), this.tickDamage, this.knockback);
    }

    @Override
    public void tickHero(Hero hero) {
        Player player = hero.getPlayer();
        if (!Skill.damageCheck(this.getApplier(), (LivingEntity)player)) {
            return;
        }
        Hero applyHero = this.plugin.getCharacterManager().getHero(this.getApplier());
        this.skill.addSpellTarget((Entity)player, applyHero);
        this.skill.damageEntity((LivingEntity)player, (LivingEntity)this.getApplier(), this.tickDamage, this.knockback);
    }
}

