/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.Expirable;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class ExpirableEffect
extends Effect
implements Expirable {
    private long duration;
    private long expireTime;

    public ExpirableEffect(Skill skill, String name, Player applier, long duration) {
        this(skill, name, applier, duration, null, null);
    }

    public ExpirableEffect(Skill skill, String name, Player applier, long duration, String applyText, String removeText) {
        super(skill, name, applier, applyText, removeText);
        this.duration = duration;
    }

    public ExpirableEffect(Skill skill, Heroes plugin, String name, Player applier, long duration) {
        this(skill, plugin, name, applier, duration, null, null);
    }

    public ExpirableEffect(Skill skill, Heroes plugin, String name, Player applier, long duration, String applyText, String removeText) {
        super(plugin, skill, name, applier, applyText, removeText, new EffectType[0]);
        this.setDuration(duration);
    }

    @Override
    public void applyToMonster(Monster monster) {
        super.applyToMonster(monster);
        this.calculateExpireTime();
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        this.calculateExpireTime();
    }

    @Override
    public long getApplyTime() {
        return this.applyTime;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(long duration) {
        this.duration = duration;
        if (this.applyTime > 0L) {
            this.applyTime = System.currentTimeMillis();
            this.calculateExpireTime();
        }
    }

    @Override
    public long getExpiry() {
        return this.expireTime;
    }

    @Override
    public long getRemainingTime() {
        return this.expireTime - System.currentTimeMillis();
    }

    @Override
    public boolean isExpired() {
        return !this.isPersistent() && System.currentTimeMillis() >= this.getExpiry();
    }

    @Override
    public void expire() {
        this.expireTime = System.currentTimeMillis();
    }

    @Deprecated
    public String getExpireText() {
        return this.getRemoveText();
    }

    @Deprecated
    public void setExpireText(String expireText) {
        this.setRemoveText(expireText);
    }

    private void calculateExpireTime() {
        this.expireTime = this.applyTime + this.duration;
    }
}

