/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public final class EffectStack {
    private Entry[] entries;
    private int count = 0;

    public EffectStack(int maxStacks) {
        if (maxStacks <= 0) {
            throw new IllegalArgumentException("`maxStacks` must be an integer greater than zero");
        }
        this.entries = new Entry[maxStacks];
    }

    public int count() {
        return this.count;
    }

    public boolean hasNone() {
        return this.count() == 0;
    }

    public boolean hasAny() {
        return this.count() > 0;
    }

    public int getMax() {
        return this.entries.length;
    }

    public boolean hasMax() {
        return this.count() == this.getMax();
    }

    public Entry get(int index) {
        this.rangeCheck(index);
        return this.entries[index];
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public Entry getFirst() {
        return this.hasAny() ? this.entries[0] : null;
    }

    public Entry getLast() {
        return this.hasAny() ? this.entries[this.count() - 1] : null;
    }

    public boolean add(Skill skill, Player applier, long duration) {
        return this.add(skill, applier, duration, 1) == 1;
    }

    public int add(Skill skill, Player applier, long duration, int amount) {
        int insertIndex;
        if (duration < 1L) {
            return 0;
        }
        if (amount < 1) {
            return 0;
        }
        long applyTime = System.currentTimeMillis();
        long expireTime = applyTime + duration;
        for (insertIndex = 0; insertIndex < this.count() && expireTime >= this.entries[insertIndex].expireTime; ++insertIndex) {
        }
        if (this.count() + amount <= this.getMax()) {
            System.arraycopy(this.entries, insertIndex, this.entries, insertIndex + amount, this.count() - insertIndex);
            for (int i = 0; i < amount; ++i) {
                this.entries[insertIndex + i] = new Entry(skill, applier, applyTime, expireTime);
            }
            this.count += amount;
            return amount;
        }
        int amountInserted = this.getMax() - this.count();
        if (amountInserted > 0) {
            System.arraycopy(this.entries, insertIndex, this.entries, insertIndex + amountInserted, this.count() - insertIndex);
            for (int i = 0; i < amountInserted; ++i) {
                this.entries[insertIndex + i] = new Entry(skill, applier, applyTime, expireTime);
            }
            this.count = this.getMax();
        }
        if (insertIndex > 0) {
            int i;
            int amountRemaining = amount - amountInserted;
            if (amountRemaining >= insertIndex) {
                for (int i2 = 0; i2 < insertIndex; ++i2) {
                    this.entries[i2] = new Entry(skill, applier, applyTime, expireTime);
                }
                return amountInserted + insertIndex;
            }
            int amountToShift = insertIndex - amountRemaining;
            for (i = 0; i < amountToShift; ++i) {
                this.entries[i] = this.entries[insertIndex - amountToShift + i];
            }
            for (i = amountToShift; i < insertIndex; ++i) {
                this.entries[i] = new Entry(skill, applier, applyTime, expireTime);
            }
            return amount;
        }
        return amountInserted;
    }

    public boolean remove() {
        return this.remove(1) == 1;
    }

    public int remove(int amount) {
        if (this.hasNone()) {
            return 0;
        }
        if (amount >= this.count()) {
            return this.removeAll();
        }
        this.count -= amount;
        System.arraycopy(this.entries, amount, this.entries, 0, this.count);
        this.clearUnusedEntries(this.count, this.count + amount);
        return amount;
    }

    public int removeAll() {
        int removed = this.count();
        this.count = 0;
        this.clearUnusedEntries(0, removed);
        return removed;
    }

    public int removeExpired() {
        int i;
        for (i = 0; i < this.count() && this.entries[i].isExpired(); ++i) {
        }
        return this.remove(i);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.count()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Count: " + this.count());
        }
    }

    private void clearUnusedEntries(int start, int stop) {
        for (int i = start; i < stop; ++i) {
            this.entries[i] = null;
        }
    }

    public void resetAllStackDurationsToFull() {
        for (Entry entry : this.entries) {
            if (entry == null) continue;
            entry.resetDurationToFull();
        }
    }

    public static class Entry
    implements Comparable<Entry> {
        private Skill skill;
        private Player applier;
        private long applyTime;
        private long expireTime;

        private Entry(Skill skill, Player applier, long applyTime, long expireTime) {
            this.skill = skill;
            this.applier = applier;
            this.applyTime = applyTime;
            this.expireTime = expireTime;
        }

        public Skill getSkill() {
            return this.skill;
        }

        public Player getApplier() {
            return this.applier;
        }

        public long getApplyTime() {
            return this.applyTime;
        }

        public long getExpireTime() {
            return this.expireTime;
        }

        public long getDuration() {
            return this.expireTime - this.applyTime;
        }

        public long getRemainingTime() {
            return this.expireTime - System.currentTimeMillis();
        }

        public boolean isExpired() {
            return this.expireTime <= System.currentTimeMillis();
        }

        public void resetDurationToFull() {
            long duration = this.getDuration();
            this.applyTime = System.currentTimeMillis();
            this.expireTime = this.applyTime + duration;
        }

        @Override
        public int compareTo(Entry o) {
            return Long.compare(this.expireTime, o.expireTime);
        }
    }
}

