/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.Expirable;
import com.herocraftonline.heroes.characters.effects.ManagedEffect;
import com.herocraftonline.heroes.characters.effects.ManagedStack;
import com.herocraftonline.heroes.characters.effects.Periodic;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class EffectManager {
    private final Set<ManagedEffect> managedEffects = new HashSet<ManagedEffect>();
    private final Set<ManagedEffect> pendingRemovals = new HashSet<ManagedEffect>();
    private final Set<ManagedEffect> pendingAdditions = new HashSet<ManagedEffect>();
    private static final int effectInterval = 4;

    public EffectManager(Heroes plugin) {
        EffectUpdater effectTimer = new EffectUpdater();
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, (Runnable)effectTimer, 0L, 4L);
    }

    public void manageEffect(CharacterTemplate character, Effect effect) {
        if (effect instanceof Expirable || effect instanceof Periodic || effect instanceof ManagedStack) {
            this.pendingAdditions.add(new ManagedEffect(character, effect));
        }
    }

    public void queueForRemoval(CharacterTemplate character, Effect effect) {
        ManagedEffect managed = new ManagedEffect(character, effect);
        if (this.managedEffects.contains(managed)) {
            this.pendingRemovals.add(managed);
        }
    }

    class EffectUpdater
    implements Runnable {
        EffectUpdater() {
        }

        @Override
        public void run() {
            HashSet<ManagedEffect> removals = new HashSet<ManagedEffect>(EffectManager.this.pendingRemovals);
            EffectManager.this.pendingRemovals.clear();
            for (ManagedEffect managed : removals) {
                EffectManager.this.managedEffects.remove(managed);
            }
            HashSet<ManagedEffect> additions = new HashSet<ManagedEffect>(EffectManager.this.pendingAdditions);
            EffectManager.this.pendingAdditions.clear();
            EffectManager.this.managedEffects.addAll(additions);
            for (ManagedEffect managed : EffectManager.this.managedEffects) {
                boolean remove;
                boolean bl = remove = managed.effect instanceof Expirable && ((Expirable)((Object)managed.effect)).isExpired();
                if (managed.effect instanceof ManagedStack) {
                    ManagedStack stacking = (ManagedStack)((Object)managed.effect);
                    try {
                        if (stacking.refresh(managed.character) == 0) {
                            remove = true;
                        }
                    }
                    catch (Exception e) {
                        Heroes.log(Level.SEVERE, "There was an error attempting to refresh stacking effect: " + managed.effect.getName());
                        e.printStackTrace();
                    }
                }
                if (managed.effect instanceof Periodic && !remove) {
                    Periodic periodic = (Periodic)((Object)managed.effect);
                    try {
                        if (periodic.isReady()) {
                            periodic.tick(managed.character);
                        }
                    }
                    catch (Exception e) {
                        Heroes.log(Level.SEVERE, "There was an error attempting to tick effect: " + managed.effect.getName());
                        e.printStackTrace();
                    }
                }
                if (!remove) continue;
                try {
                    managed.character.removeEffect(managed.effect);
                }
                catch (Exception e) {
                    Heroes.log(Level.SEVERE, "There was an error attempting to remove effect: " + managed.effect.getName());
                    e.printStackTrace();
                }
            }
        }
    }
}

