/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.CustomNameManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.integrations.citizens.CitizensHero;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Effect {
    protected final String name;
    protected Skill skill;
    protected final Heroes plugin;
    protected Player applier;
    private String applyText;
    private String removeText;
    public final Set<EffectType> types = EnumSet.noneOf(EffectType.class);
    protected long applyTime = -1L;
    private boolean persistent = false;
    private final Map<PotionEffectType, PotionEffect> potionEffects = new HashMap<PotionEffectType, PotionEffect>();

    public Effect(Skill skill, String name, Player applier, String applyText, String removeText) {
        this(skill == null ? null : skill.plugin, skill, name, applier, applyText, removeText, new EffectType[0]);
    }

    public Effect(Skill skill, String name, Player applier, String applyText, String removeText, EffectType ... types) {
        this(skill == null ? null : skill.plugin, skill, name, applier, applyText, removeText, types);
    }

    public Effect(Heroes plugin, Skill skill, String name, Player applier, String applyText, String removeText, EffectType ... types) {
        this.name = name;
        this.skill = skill;
        this.plugin = plugin != null ? plugin : (skill == null ? null : skill.plugin);
        this.applier = applier;
        this.applyText = applyText;
        this.removeText = removeText;
        if (types != null) {
            Collections.addAll(this.types, types);
        }
    }

    public Effect(Skill skill, String name, Player applier) {
        this(skill, name, applier, (String)null, (String)null);
    }

    public Effect(Skill skill, String name, Player applier, EffectType ... types) {
        this(skill, name, applier, (String)null, (String)null, types);
    }

    public Effect(Heroes plugin, Skill skill, String name, Player applier, EffectType ... types) {
        this(plugin, skill, name, applier, (String)null, (String)null, types);
    }

    @Deprecated
    public Effect(Skill skill, String name) {
        this(skill, name, (Player)null);
    }

    @Deprecated
    public Effect(Skill skill, String name, EffectType ... types) {
        this(skill, name, (Player)null, types);
    }

    @Deprecated
    public Effect(Heroes plugin, Skill skill, String name, EffectType ... types) {
        this(plugin, skill, name, (Player)null, types);
    }

    public void apply(CharacterTemplate character) {
        if (character instanceof Hero) {
            this.applyToHero((Hero)character);
        } else if (character instanceof Monster) {
            this.applyToMonster((Monster)character);
        }
    }

    public void applyToMonster(Monster monster) {
        this.applyTime = System.currentTimeMillis();
        this.applyPotionEffects(monster);
        if (this.applyText != null && this.applyText.length() > 0 && !monster.hasEffectType(EffectType.SILENT_ACTIONS) && this.skill != null) {
            this.broadcast(monster.getEntity().getLocation(), "    " + this.applyText, CustomNameManager.getName(monster), this.applier == null ? "<UNKNOWN PLAYER>" : this.getApplier().getName(), this.skill.getName());
        }
    }

    public void applyToHero(Hero hero) {
        this.applyTime = System.currentTimeMillis();
        this.applyPotionEffects(hero);
        this.sendApplyToHeroMessage(hero);
    }

    public void sendApplyToHeroMessage(Hero hero) {
        if (this.applyText != null && this.applyText.length() > 0) {
            if (hero instanceof CitizensHero && Properties.silenceNPCSkills) {
                return;
            }
            Player player = hero.getPlayer();
            if (hero.hasEffectType(EffectType.SILENT_ACTIONS) || this.skill == null) {
                Messaging.send((CommandSender)player, "    " + this.applyText, player.getName(), this.applier == null ? "<UNKNOWN PLAYER>" : this.getApplier().getName(), this.skill == null ? "<UNKNOWN SKILL>" : this.skill.getName());
            } else {
                this.broadcast(player.getLocation(), "    " + this.applyText, player.getName(), this.applier == null ? "<UNKNOWN PLAYER>" : this.getApplier().getName(), this.skill.getName());
            }
        }
    }

    public void reapplyPotionEffects(CharacterTemplate character) {
        this.removePotionEffects(character);
        this.applyPotionEffects(character);
    }

    public void remove(CharacterTemplate character) {
        if (character instanceof Hero) {
            this.removeFromHero((Hero)character);
        } else if (character instanceof Monster) {
            this.removeFromMonster((Monster)character);
        }
    }

    public void removeFromMonster(Monster monster) {
        this.removePotionEffects(monster);
        if (this.removeText != null && this.removeText.length() > 0 && !monster.hasEffectType(EffectType.SILENT_ACTIONS) && this.skill != null) {
            this.broadcast(monster.getEntity().getLocation(), "    " + this.removeText, CustomNameManager.getName(monster), this.applier == null ? "<UNKNOWN PLAYER>" : this.getApplier().getName(), this.skill.getName());
        }
    }

    public void removeFromHero(Hero hero) {
        this.removePotionEffects(hero);
        this.sendRemoveFromHeroMessage(hero);
    }

    public void sendRemoveFromHeroMessage(Hero hero) {
        if (this.removeText != null && this.removeText.length() > 0) {
            if (hero instanceof CitizensHero && Properties.silenceNPCSkills) {
                return;
            }
            Player player = hero.getPlayer();
            if (hero.hasEffectType(EffectType.SILENT_ACTIONS) || this.skill == null) {
                Messaging.send((CommandSender)player, "    " + this.removeText, player.getName(), this.applier == null ? "<UNKNOWN PLAYER>" : this.getApplier().getName(), this.skill == null ? "<UNKNOWN SKILL>" : this.skill.getName());
            } else {
                this.broadcast(player.getLocation(), "    " + this.removeText, player.getName(), this.applier == null ? "<UNKNOWN PLAYER>" : this.getApplier().getName(), this.skill.getName());
            }
        }
    }

    private void applyPotionEffects(CharacterTemplate character) {
        if (this.potionEffects.isEmpty()) {
            return;
        }
        Set<Effect> characterEffects = character.getEffects();
        characterEffects.remove(this);
        for (PotionEffect potionEffect : this.potionEffects.values()) {
            PotionEffectType type = potionEffect.getType();
            boolean apply = true;
            for (Effect effect : characterEffects) {
                PotionEffect existingPotionEffect = effect.getPotionEffect(type);
                if (existingPotionEffect == null || existingPotionEffect.getAmplifier() < potionEffect.getAmplifier()) continue;
                apply = false;
                break;
            }
            if (!apply) continue;
            character.getEntity().addPotionEffect(potionEffect, true);
        }
    }

    public void removePotionEffects(CharacterTemplate character) {
        if (this.potionEffects.isEmpty()) {
            return;
        }
        Set<Effect> currentEffects = character.getEffects();
        currentEffects.remove(this);
        for (PotionEffect potionEffect : this.potionEffects.values()) {
            PotionEffectType type = potionEffect.getType();
            PotionEffect replacement = null;
            for (Effect effect : currentEffects) {
                PotionEffect possibleReplacement = effect.getPotionEffect(type);
                if (possibleReplacement == null || replacement != null && possibleReplacement.getAmplifier() <= replacement.getAmplifier()) continue;
                replacement = possibleReplacement;
            }
            if (replacement != null) {
                character.getEntity().addPotionEffect(replacement, true);
                continue;
            }
            character.getEntity().removePotionEffect(type);
        }
    }

    public void broadcast(Location source, String message, Object ... args) {
        if (this.skill != null) {
            this.skill.broadcast(source, message, args);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Effect)) {
            return false;
        }
        Effect that = (Effect)other;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public String getName() {
        return this.name;
    }

    public Skill getSkill() {
        return this.skill;
    }

    public void setSkill(Skill skill) {
        this.skill = skill;
    }

    public boolean hasApplier() {
        return this.applier != null;
    }

    public Player getApplier() {
        return this.applier;
    }

    public void setApplier(Player applier) {
        this.applier = applier;
    }

    public String getApplyText() {
        return this.applyText;
    }

    public void setApplyText(String applyText) {
        this.applyText = applyText;
    }

    public String getRemoveText() {
        return this.removeText;
    }

    public void setRemoveText(String removeText) {
        this.removeText = removeText;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public long getApplyTime() {
        return this.applyTime;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isType(EffectType type) {
        return this.types.contains((Object)type);
    }

    public boolean addEffectTypes(EffectType ... effectTypes) {
        return Collections.addAll(this.types, effectTypes);
    }

    @Deprecated
    public Set<PotionEffect> getMobEffects() {
        return Collections.emptySet();
    }

    public Set<PotionEffect> getPotionEffects() {
        return new HashSet<PotionEffect>(this.potionEffects.values());
    }

    @Deprecated
    public void addPotionEffect(PotionEffect pEffect, boolean faked) {
        this.addPotionEffect(pEffect);
    }

    public void addPotionEffect(PotionEffect pEffect) {
        this.potionEffects.put(pEffect.getType(), pEffect);
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.potionEffects.containsKey(type);
    }

    public PotionEffect getPotionEffect(PotionEffectType type) {
        return this.potionEffects.get(type);
    }

    public void removePotionEffect(PotionEffectType type) {
        this.potionEffects.remove(type);
    }

    @Deprecated
    public void addPotionEffect(int id, int duration, int strength, boolean faked) {
        this.addPotionEffect(new PotionEffect(PotionEffectType.getById((int)id), duration, strength), faked);
    }

    @Deprecated
    public void addMobEffect(int id, int duration, int strength, boolean faked) {
        this.addPotionEffect(new PotionEffect(PotionEffectType.getById((int)id), duration, strength), faked);
    }
}

