/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroLeaveCombatEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicEffect;
import com.herocraftonline.heroes.util.Properties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public final class CombatEffect
extends PeriodicEffect {
    private final Map<LivingEntity, CombatReason> combatMap = new HashMap<LivingEntity, CombatReason>();
    private LivingEntity lastCombatEntity = null;

    public CombatEffect(Heroes plugin) {
        super(plugin, "Combat", (long)Properties.combatTime);
        this.types.add(EffectType.INTERNAL);
    }

    public void reset() {
        this.lastTickTime = this.applyTime = System.currentTimeMillis();
    }

    @Override
    public void applyToHero(Hero hero) {
    }

    @Override
    public void applyToMonster(Monster entity) {
    }

    @Override
    public final void tickHero(Hero hero) {
        super.tickHero(hero);
        if (!this.combatMap.isEmpty()) {
            this.combatMap.clear();
            Bukkit.getServer().getPluginManager().callEvent((Event)new HeroLeaveCombatEvent(hero, this.combatMap, LeaveCombatReason.TIMED));
            if (Heroes.properties.combatExitMessage != null && !Heroes.properties.combatExitMessage.isEmpty()) {
                hero.getPlayer().sendMessage(ChatColor.GRAY + Heroes.properties.combatExitMessage);
            }
        }
    }

    @Override
    public void tickMonster(Monster monster) {
    }

    public final boolean isInCombat() {
        if (this.combatMap.isEmpty()) {
            return false;
        }
        if (this.applyTime + this.getPeriod() < System.currentTimeMillis()) {
            this.combatMap.clear();
            return false;
        }
        return true;
    }

    public boolean isInCombatWith(LivingEntity target) {
        return this.combatMap.containsKey(target);
    }

    public void enterCombatWith(LivingEntity target, CombatReason reason) {
        this.combatMap.put(target, reason);
        this.lastCombatEntity = target;
        this.reset();
    }

    public void leaveCombatWith(Hero hero, LivingEntity target, LeaveCombatReason reason) {
        if (this.combatMap.remove(target) != null && this.combatMap.isEmpty()) {
            this.lastCombatEntity = target;
            hero.leaveCombatWith(target, reason);
        }
    }

    public void leaveCombatFromDeath(Hero hero) {
        Bukkit.getServer().getPluginManager().callEvent((Event)new HeroLeaveCombatEvent(hero, this.combatMap, LeaveCombatReason.DEATH));
        for (LivingEntity entity : new ArrayList<LivingEntity>(this.combatMap.keySet())) {
            if (!(entity instanceof Player)) continue;
            this.plugin.getCharacterManager().getHero((Player)entity).leaveCombatWith((LivingEntity)hero.getPlayer(), LeaveCombatReason.TARGET_DEATH);
        }
        this.combatMap.clear();
    }

    public void leaveCombatFromLogout(Hero hero) {
        Bukkit.getServer().getPluginManager().callEvent((Event)new HeroLeaveCombatEvent(hero, this.combatMap, LeaveCombatReason.LOGOUT));
        for (LivingEntity entity : new ArrayList<LivingEntity>(this.combatMap.keySet())) {
            if (!(entity instanceof Player)) continue;
            this.plugin.getCharacterManager().getHero((Player)entity).leaveCombatWith((LivingEntity)hero.getPlayer(), LeaveCombatReason.TARGET_LOGOUT);
        }
        this.combatMap.clear();
    }

    public void leaveCombatFromSuicide(Hero hero) {
        Bukkit.getServer().getPluginManager().callEvent((Event)new HeroLeaveCombatEvent(hero, this.combatMap, LeaveCombatReason.SUICIDE));
        for (LivingEntity entity : new ArrayList<LivingEntity>(this.combatMap.keySet())) {
            if (!(entity instanceof Player)) continue;
            this.plugin.getCharacterManager().getHero((Player)entity).leaveCombatWith((LivingEntity)hero.getPlayer(), LeaveCombatReason.TARGET_LOGOUT);
        }
        this.combatMap.clear();
    }

    public long getTimeLeft() {
        long time = (long)Properties.combatTime - (System.currentTimeMillis() - this.applyTime);
        return time > 0L ? time : 0L;
    }

    public LivingEntity getLastCombatant() {
        return this.lastCombatEntity;
    }

    public Map<LivingEntity, CombatReason> getCombatants() {
        return Collections.unmodifiableMap(this.combatMap);
    }

    public void clearCombatants() {
        this.combatMap.clear();
    }

    public static enum LeaveCombatReason {
        DEATH,
        SUICIDE,
        ERROR,
        TIMED,
        LOGOUT,
        KICK,
        TARGET_DEATH,
        TARGET_LOGOUT,
        CUSTOM;

    }

    public static enum CombatReason {
        DAMAGED_BY_MOB,
        DAMAGED_BY_PLAYER,
        ATTACKED_MOB,
        ATTACKED_PLAYER,
        BENEFIT_DEFENDER,
        BENEFIT_ATTACKER,
        CUSTOM;

    }
}

