/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class BloodUnionEffect
extends Effect {
    public static final String unionEffectName = "BloodUnionEffect";
    private static final String decayEffectName = "BloodUnionDecayEffect";
    private static final String unionLevelBaseMessage = "    " + ChatComponents.GENERIC_SKILL + ChatColor.WHITE + "<" + ChatColor.DARK_RED + "Blood Union" + ChatColor.WHITE + "> Current Level: " + ChatColor.GRAY;
    private int expireDuration;
    private int maxBloodUnion;
    private int bloodUnionLevel;
    private boolean lastTargetPlayer;
    private Player player;
    private Skill skill;

    public BloodUnionEffect(Skill skill, int expireDuration, int maxBloodUnion) {
        super(skill, unionEffectName, (Player)null);
        this.expireDuration = expireDuration;
        this.maxBloodUnion = maxBloodUnion;
        this.bloodUnionLevel = 0;
        this.lastTargetPlayer = false;
        this.skill = skill;
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        this.player = hero.getPlayer();
    }

    public int getBloodUnionLevel() {
        return this.bloodUnionLevel;
    }

    public void setBloodUnionLevel(int bloodUnionLevel) {
        this.bloodUnionLevel = bloodUnionLevel > this.maxBloodUnion ? this.maxBloodUnion : (bloodUnionLevel < 0 ? 0 : bloodUnionLevel);
        this.player.sendMessage(unionLevelBaseMessage + this.bloodUnionLevel);
    }

    public void addBloodUnion(int bloodUnionIncrease, boolean isPlayer) {
        Hero hero = this.skill.plugin.getCharacterManager().getHero(this.player);
        if (hero.hasEffect(decayEffectName)) {
            BloodUnionDecayEffect buDecayEffect = (BloodUnionDecayEffect)hero.getEffect(decayEffectName);
            buDecayEffect.decreaseBloodUnion = false;
            hero.removeEffect(buDecayEffect);
        }
        if (!this.lastTargetPlayer && isPlayer || this.lastTargetPlayer && !isPlayer) {
            this.setBloodUnionLevel(bloodUnionIncrease);
        } else {
            this.setBloodUnionLevel(this.bloodUnionLevel + bloodUnionIncrease);
        }
        this.lastTargetPlayer = isPlayer;
        hero.addEffect(new BloodUnionDecayEffect(this.skill, this.player, (long)this.expireDuration));
    }

    public void decreaseBloodUnion(int bloodUnionDecrease) {
        this.setBloodUnionLevel(this.bloodUnionLevel - bloodUnionDecrease);
    }

    public class BloodUnionDecayEffect
    extends ExpirableEffect {
        public boolean decreaseBloodUnion;

        public BloodUnionDecayEffect(Skill skill, Player applier, long duration) {
            super(skill, BloodUnionEffect.decayEffectName, applier, duration);
            this.decreaseBloodUnion = true;
        }

        @Override
        public void removeFromHero(Hero hero) {
            super.removeFromHero(hero);
            if (!this.decreaseBloodUnion || !hero.hasEffect(BloodUnionEffect.unionEffectName)) {
                return;
            }
            BloodUnionEffect effect = (BloodUnionEffect)hero.getEffect(BloodUnionEffect.unionEffectName);
            effect.setBloodUnionLevel(0);
        }
    }
}

