/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.classes.scaling;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.classes.scaling.ExplicitPowerScaling;
import com.herocraftonline.heroes.characters.classes.scaling.ExplicitScaling;
import com.herocraftonline.heroes.characters.classes.scaling.ExpressionScaling;
import com.herocraftonline.heroes.characters.classes.scaling.LevelScaling;
import com.herocraftonline.heroes.characters.classes.scaling.PowerScaling;
import java.util.HashMap;
import java.util.function.ToDoubleFunction;
import org.bukkit.configuration.ConfigurationSection;

public class Scaling {
    private final ToDoubleFunction<Hero> function;

    public Scaling(ToDoubleFunction<Hero> function) {
        this.function = function;
    }

    public double getScaled(Hero hero) {
        return this.function.applyAsDouble(hero);
    }

    public static Scaling get(HeroClass heroClass, ConfigurationSection section) {
        String scaling = section.getString("scaling", "level");
        switch (scaling.toLowerCase()) {
            case "expression": {
                String expression = section.getString("expression", "0");
                return new ExpressionScaling(heroClass, expression);
            }
            case "explicitpower": {
                double base = section.getDouble("base", 0.0);
                double perLevel = section.getDouble("per-level", 0.0);
                HashMap<Integer, Double> powers = new HashMap<Integer, Double>();
                ConfigurationSection powerSection = section.getConfigurationSection("powers");
                for (String key : powerSection.getKeys(false)) {
                    powers.put(Integer.parseInt(key), powerSection.getDouble(key, 0.0));
                }
                return new ExplicitPowerScaling(heroClass, base, perLevel, powers);
            }
            case "explicit": {
                HashMap<Integer, Double> levels = new HashMap<Integer, Double>();
                ConfigurationSection levelSection = section.getConfigurationSection("levels");
                for (String key : levelSection.getKeys(false)) {
                    levels.put(Integer.parseInt(key), levelSection.getDouble(key, 0.0));
                }
                return new ExplicitScaling(heroClass, levels);
            }
            case "power": {
                double base = section.getDouble("base", 0.0);
                double perLevel = section.getDouble("per-level", 0.0);
                double power = section.getDouble("power", 1.0);
                return new PowerScaling(heroClass, base, perLevel, power);
            }
        }
        double base = section.getDouble("base", 0.0);
        double perLevel = section.getDouble("per-level", 0.0);
        return new LevelScaling(heroClass, base, perLevel);
    }
}

