/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.classes.scaling;

import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.classes.scaling.Scaling;
import java.util.Map;
import java.util.Optional;

public class ExplicitPowerScaling
extends Scaling {
    public ExplicitPowerScaling(HeroClass heroClass, double base, double perLevel, Map<Integer, Double> powers) {
        super(hero -> {
            int level = hero.getHeroLevel(heroClass);
            double power = 1.0;
            if (powers.containsKey(level)) {
                power = (Double)powers.get(level);
            } else {
                Optional<Integer> highest = powers.keySet().stream().filter(threshold -> level >= threshold).max(Integer::compareTo);
                if (highest.isPresent()) {
                    power = (Double)powers.get(highest.get());
                }
            }
            return base + Math.pow((double)level * perLevel, power);
        });
    }
}

