/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.classes;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.characters.classes.ClassSkill;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.classes.scaling.LevelScaling;
import com.herocraftonline.heroes.characters.classes.scaling.Scaling;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.util.Pair;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class HeroClassManager {
    private final Heroes plugin;
    private final Set<HeroClass> classes = new TreeSet<HeroClass>();
    private HeroClass defaultClass;
    private HeroClass defaultProfession;
    private HeroClass defaultRace;
    private HeroClass globalSkillset;
    private HashMap<HeroClass, Set<String>> weakParents = new HashMap();
    private HashMap<HeroClass, Set<String>> strongParents = new HashMap();

    public HeroClassManager(Heroes plugin) {
        this.plugin = plugin;
    }

    public boolean addClass(HeroClass clazz) {
        return this.classes.add(clazz);
    }

    public HeroClass getClass(String name) {
        if (name != null) {
            for (HeroClass clazz : this.classes) {
                if (!name.equalsIgnoreCase(clazz.getName())) continue;
                return clazz;
            }
        }
        return null;
    }

    public Set<HeroClass> getClasses() {
        return this.classes;
    }

    public boolean removeClass(HeroClass clazz) {
        return this.classes.remove(clazz);
    }

    public HeroClass getDefaultClass() {
        return this.defaultClass;
    }

    public void setDefaultClass(HeroClass defaultClass) {
        this.defaultClass = defaultClass;
    }

    public HeroClass getDefaultProfession() {
        return this.defaultProfession;
    }

    public void setDefaultProfession(HeroClass defaultProfession) {
        this.defaultProfession = defaultProfession;
    }

    public HeroClass getDefaultRace() {
        return this.defaultRace;
    }

    public void setDefaultRace(HeroClass defaultRace) {
        this.defaultRace = defaultRace;
    }

    public HeroClass getGlobalSkillset() {
        return this.globalSkillset;
    }

    public void setGlobalSkillset(HeroClass globalSkillset) {
        this.globalSkillset = globalSkillset;
    }

    public boolean loadClasses(File file) {
        File[] directoryFiles = file.listFiles();
        if (directoryFiles == null || directoryFiles.length == 0) {
            Heroes.log(Level.WARNING, "You have no classes defined in your setup! Heroes will now disable itself!");
            return false;
        }
        this.loadClassesFromDirectoryFiles(directoryFiles);
        for (File child : directoryFiles) {
            if (!child.isDirectory()) continue;
            Heroes.debugLog(Level.INFO, "Found class subdirectory " + child.getName() + ".");
            File[] subDirectoryFiles = child.listFiles();
            if (subDirectoryFiles == null || subDirectoryFiles.length == 0) continue;
            Heroes.log(Level.INFO, "Attempting to load classes from subdirectory " + child.getName() + ".");
            this.loadClassesFromDirectoryFiles(subDirectoryFiles);
        }
        this.checkClassHierarchy();
        SkillConfigManager.saveSkillConfig();
        SkillConfigManager.setClassDefaults();
        if (this.defaultClass == null) {
            Heroes.log(Level.SEVERE, "You are missing a default class! Heroes will now disable itself!");
            return false;
        }
        if (this.defaultProfession == null) {
            Heroes.log(Level.SEVERE, "You are missing a default profession!  Heroes will now disable itself!");
            return false;
        }
        if (this.defaultRace == null) {
            Heroes.log(Level.SEVERE, "You are missing a default race !  Using default profession instead, to prevent issues.");
            this.defaultRace = this.defaultProfession;
        }
        if (this.plugin.getServer().getPluginManager().getPermission("heroes.classes.*") == null) {
            this.registerClassPermissions();
        }
        for (HeroClass heroClass : this.classes) {
            heroClass.getClassSkills().forEach(ClassSkill::reload);
        }
        return true;
    }

    private void loadClassesFromDirectoryFiles(@Nonnull File[] files) {
        for (File child : files) {
            if (!child.isFile() || !child.getName().contains(".yml")) continue;
            HeroClass newClass = this.loadClass(child);
            if (newClass == null) {
                Heroes.log(Level.WARNING, "Attempted to load " + child.getName() + " but failed. Skipping.");
                continue;
            }
            if (!this.addClass(newClass)) {
                Heroes.log(Level.WARNING, "Duplicate class (" + newClass.getName() + ") found. Skipping this class.");
                continue;
            }
            if (!Heroes.properties.debug) continue;
            Heroes.debugLog(Level.INFO, "Loaded class: " + newClass.getName());
        }
    }

    private HeroClass loadClass(File file) {
        double perLevel;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String className = config.getString("name");
        if (className == null) {
            return null;
        }
        HeroClass newClass = new HeroClass(className, this.plugin);
        newClass.setDescription(config.getString("description", ""));
        newClass.setExpModifier(config.getDouble("expmodifier", 1.0));
        newClass.setPrimary(config.getBoolean("primary", true));
        newClass.setSecondary(config.getBoolean("secondary", false));
        newClass.setRace(config.getBoolean("race", false));
        newClass.setTier(config.getInt("tier", 1));
        if (newClass.getTier() < 0) {
            newClass.setTier(0);
        }
        newClass.getOnClassGainRunCommandsInfo().setRunCommands(config.getBoolean("run-command.as-console", false), config.getStringList("run-command.command"));
        HeroClass.ClassRunCommandsInfo onClassLossRunCommandsInfo = newClass.getOnClassLossRunCommandsInfo();
        onClassLossRunCommandsInfo.setRunCommands(config.getBoolean("on-class-loss-run-command.as-console", false), config.getStringList("on-class-loss-run-command.command"));
        onClassLossRunCommandsInfo.setIgnoreDefault(config.getBoolean("on-class-loss-run-command.ignore-default", true));
        newClass.getOnMasterRunCommandsInfo().setRunCommands(config.getBoolean("on-master-run-command.as-console", false), config.getStringList("on-master-run-command.command"));
        HeroClass.ClassRunCommandsInfo onFirstClassGainRunCommandsInfo = newClass.getOnFirstClassGainRunCommandsInfo();
        onFirstClassGainRunCommandsInfo.setRunCommands(config.getBoolean("on-first-class-gain-run-command.as-console", false), config.getStringList("on-first-class-gain-run-command.command"));
        onFirstClassGainRunCommandsInfo.setOverride(config.getBoolean("on-first-class-gain-run-command.override", false));
        HeroClass.ClassRunCommandsInfo onFirstMasterRunCommandsInfo = newClass.getOnFirstMasterRunCommandsInfo();
        onFirstMasterRunCommandsInfo.setRunCommands(config.getBoolean("on-first-master-run-command.as-console", false), config.getStringList("on-first-master-run-command.command"));
        onFirstMasterRunCommandsInfo.setIgnoreDefault(config.getBoolean("on-first-master-run-command.ignore-default", true));
        onFirstMasterRunCommandsInfo.setOverride(config.getBoolean("on-first-master-run-command.override", false));
        this.loadArmor(newClass, config.getStringList("permitted-armor"));
        this.loadWeapons(newClass, config.getStringList("permitted-weapon"));
        this.loadOffhand(newClass, config.getStringList("permitted-offhand"));
        this.loadDamages(newClass, (Configuration)config);
        this.loadMitigation(newClass, config.getConfigurationSection("mitigation"));
        this.loadPermittedSkills(newClass, config.getConfigurationSection("permitted-skills"));
        this.loadPermissionSkills(newClass, config.getConfigurationSection("permission-skills"));
        this.loadPotionSkills(newClass, config.getConfigurationSection("potion-skills"));
        this.loadExperienceTypes(newClass, config.getStringList("experience-sources"));
        if (newClass.isPrimary() || newClass.isRace()) {
            this.loadAttributes(newClass, (Configuration)config);
            if (config.isConfigurationSection("max-health")) {
                ConfigurationSection health = config.getConfigurationSection("max-health");
                newClass.setMaxHealth(Scaling.get(newClass, health));
            } else if (config.isSet("base-max-health")) {
                double base = config.getDouble("base-max-health", 20.0);
                perLevel = config.getDouble("max-health-per-level", 0.0);
                newClass.setMaxHealth(new LevelScaling(newClass, base, perLevel));
            }
            if (config.isConfigurationSection("max-stamina")) {
                ConfigurationSection stamina = config.getConfigurationSection("max-stamina");
                newClass.setMaxStamina(Scaling.get(newClass, stamina));
            } else if (config.isSet("base-max-stamina")) {
                double base = config.getDouble("base-max-stamina", 500.0);
                perLevel = config.getDouble("max-stamina-per-level", 0.0);
                newClass.setMaxStamina(new LevelScaling(newClass, base, perLevel));
            }
            if (config.isConfigurationSection("stamina-regen")) {
                ConfigurationSection stamRegen = config.getConfigurationSection("stamina-regen");
                newClass.setScaledStaminaRegen(Scaling.get(newClass, stamRegen));
            } else if (config.isSet("base-stamina-regen")) {
                double base = config.getInt("base-stamina-regen", 50);
                perLevel = config.getDouble("stamina-regen-per-level", 0.0);
                newClass.setScaledStaminaRegen(new LevelScaling(newClass, base, perLevel));
            }
            if (config.isConfigurationSection("max-mana")) {
                ConfigurationSection mana = config.getConfigurationSection("max-mana");
                newClass.setMaxMana(Scaling.get(newClass, mana));
            } else if (config.isSet("base-max-mana")) {
                double base = config.getDouble("base-max-mana", 500.0);
                perLevel = config.getDouble("max-mana-per-level", 0.0);
                newClass.setMaxMana(new LevelScaling(newClass, base, perLevel));
            }
            if (config.isConfigurationSection("mana-regen")) {
                ConfigurationSection manaRegen = config.getConfigurationSection("mana-regen");
                newClass.setScaledManaRegen(Scaling.get(newClass, manaRegen));
            } else if (config.isSet("base-mana-regen")) {
                double base = config.getInt("base-mana-regen", 25);
                perLevel = config.getDouble("mana-regen-per-level", 0.0);
                newClass.setScaledManaRegen(new LevelScaling(newClass, base, perLevel));
            }
            if (config.isConfigurationSection("max-shield")) {
                ConfigurationSection shield = config.getConfigurationSection("max-shield");
                newClass.setMaxShield(Scaling.get(newClass, shield));
            } else if (config.isSet("base-max-shield")) {
                double base = config.getDouble("base-max-shield", 0.0);
                perLevel = config.getDouble("max-shield-per-level", 0.0);
                newClass.setMaxShield(new LevelScaling(newClass, base, perLevel));
            }
            if (config.isConfigurationSection("shield-regen")) {
                ConfigurationSection shieldRegen = config.getConfigurationSection("shield-regen");
                newClass.setScaledShieldRegen(Scaling.get(newClass, shieldRegen));
            } else if (config.isSet("base-shield-regen")) {
                double base = config.getInt("base-shield-regen", 0);
                perLevel = config.getDouble("shield-regen-per-level", 0.0);
                newClass.setScaledShieldRegen(new LevelScaling(newClass, base, perLevel));
            }
        }
        if (newClass.isPrimary()) {
            newClass.initEmptyStats(20, 500, 500, 0);
            newClass.setBaseMaxEquipmentWeight(config.getDouble("base-max-equipment-weight", 0.0));
            newClass.setPrepareSkillLimit(config.getInt("skill-prepare-limit", 5));
            if (config.isConfigurationSection("max-skill-prepare-points")) {
                ConfigurationSection maxSkillPreparePoints = config.getConfigurationSection("max-skill-prepare-points");
                assert (maxSkillPreparePoints != null);
                newClass.setMaxSkillPreparePoints(Scaling.get(newClass, maxSkillPreparePoints));
            } else {
                double base = config.getDouble("base-max-skill-prepare-points", 100.0);
                perLevel = config.getDouble("max-skill-prepare-points-per-level", 0.0);
                newClass.setMaxSkillPreparePoints(new LevelScaling(newClass, base, perLevel));
            }
        }
        newClass.setIsUltimate(config.getBoolean("ultimate-class", false));
        if (newClass.isUltimate()) {
            newClass.setUltimateInfo(config.getInt("ultimate-required-count", 6), config.getInt("ultimate-required-min-id", 0), config.getInt("ultimate-required-max-id", 10));
        }
        newClass.setWildcardClass(config.getBoolean("wildcard-permission", true));
        newClass.setExpLoss(config.getDouble("expLoss", -1.0));
        newClass.setPvpExpLoss(config.getDouble("pvpExpLoss", -1.0));
        newClass.setAllocationPointsPerLevel(config.getInt("allocation-points-per-level", Heroes.properties.allocationPointsPerLevel));
        int defaultMaxLevel = Properties.maxLevel;
        int maxLevel = config.getInt("max-level", defaultMaxLevel);
        if (maxLevel < 1) {
            Heroes.log(Level.WARNING, "Class (" + className + ") max level is too low. Setting max level to 1.");
            maxLevel = 1;
        } else if (maxLevel > defaultMaxLevel) {
            Heroes.log(Level.WARNING, "Class (" + className + ") max level is too high. Setting max level to " + defaultMaxLevel + ".");
            maxLevel = defaultMaxLevel;
        }
        newClass.setMaxLevel(maxLevel);
        double defaultCost = 0.0;
        if (newClass.isPrimary()) {
            defaultCost = Heroes.properties.swapCost;
        } else if (newClass.isSecondary()) {
            defaultCost = Heroes.properties.profSwapCost;
        } else if (newClass.isRace()) {
            defaultCost = Heroes.properties.raceSwapCost;
        }
        double cost = config.getDouble("cost", defaultCost);
        if (cost < 0.0) {
            Heroes.log(Level.WARNING, "Class (" + className + ") cost is too low. Setting cost to 0.");
            cost = 0.0;
        }
        newClass.setCost(cost);
        HashSet strongParents = new HashSet();
        if (config.isConfigurationSection("parents")) {
            List list = config.getStringList("parents.strong");
            if (!list.isEmpty()) {
                strongParents.addAll(list);
            }
            list = config.getStringList("parents.weak");
            HashSet weakParents = new HashSet();
            if (!list.isEmpty()) {
                weakParents.addAll(list);
            }
            this.weakParents.put(newClass, weakParents);
            this.strongParents.put(newClass, strongParents);
        }
        if (config.getBoolean("default", false)) {
            if (Heroes.properties.debug) {
                Heroes.debugLog(Level.INFO, "Default class found: " + className);
            }
            this.defaultClass = newClass;
        }
        if (config.getBoolean("default-prof", false)) {
            if (Heroes.properties.debug) {
                Heroes.debugLog(Level.INFO, "Default profession found: " + className);
            }
            this.defaultProfession = newClass;
        }
        if (config.getBoolean("default-race", false)) {
            if (Heroes.properties.debug) {
                Heroes.debugLog(Level.INFO, "Default race found: " + className);
            }
            this.defaultRace = newClass;
        }
        if (config.getBoolean("global-skillset", false)) {
            if (Heroes.properties.debug) {
                Heroes.debugLog(Level.INFO, "Global skillset found: " + className);
            }
            this.globalSkillset = newClass;
        }
        return newClass;
    }

    private void registerClassPermissions() {
        HashMap<CallSite, Boolean> classPermissions = new HashMap<CallSite, Boolean>();
        for (HeroClass heroClass : this.classes) {
            Permission permission;
            if (heroClass.isWildcardClass()) {
                permission = new Permission("heroes.classes." + heroClass.getName().toLowerCase(), PermissionDefault.OP);
                Bukkit.getServer().getPluginManager().addPermission(permission);
                classPermissions.put((CallSite)((Object)("heroes.classes." + heroClass.getName().toLowerCase())), true);
                continue;
            }
            permission = new Permission("heroes.classes." + heroClass.getName().toLowerCase(), PermissionDefault.OP);
            Bukkit.getServer().getPluginManager().addPermission(permission);
        }
        Permission permission = new Permission("heroes.classes.*", "Grants access to all classes.", PermissionDefault.OP, classPermissions);
        this.plugin.getServer().getPluginManager().addPermission(permission);
    }

    private void loadAttributes(HeroClass newClass, Configuration config) {
        block7: {
            String className;
            block6: {
                className = newClass.getName();
                ConfigurationSection section = config.getConfigurationSection("base-attributes");
                if (section == null) break block6;
                Set attributeValues = section.getKeys(false);
                if (attributeValues.isEmpty()) {
                    Heroes.log(Level.WARNING, className + " has a base-attributes section, but no base-attributes values. Defaulting to 0's.");
                    for (AttributeType type : AttributeType.values()) {
                        newClass.setBaseAttributeValue(type, 0);
                    }
                } else {
                    for (String attributeName : attributeValues) {
                        AttributeType type = AttributeType.matchAttribute(attributeName);
                        if (type != null && section.get(attributeName) instanceof Number) {
                            int value = section.getInt(attributeName);
                            newClass.setBaseAttributeValue(type, value);
                            continue;
                        }
                        Heroes.log(Level.WARNING, "Invalid base attribute (" + attributeName + ") defined for " + className);
                    }
                }
                break block7;
            }
            if (!newClass.isPrimary()) break block7;
            Heroes.log(Level.WARNING, className + " has no base-attributes section. Defaulting to 0's.");
            for (AttributeType type : AttributeType.values()) {
                newClass.setBaseAttributeValue(type, 0);
            }
        }
    }

    private void loadDamages(HeroClass newClass, Configuration config) {
        Set projectileDamages;
        Object perLevels;
        EnumMap<Object, Double> bases;
        Set itemDamages;
        String className = newClass.getName();
        ConfigurationSection section = config.getConfigurationSection("item-damages");
        if (section != null) {
            itemDamages = section.getKeys(false);
            if (itemDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has an item-damage section, but no item-damage values");
            } else {
                for (String materialName : itemDamages) {
                    Material material = Material.matchMaterial((String)materialName);
                    if (material != null && section.isConfigurationSection(materialName)) {
                        ConfigurationSection damage = section.getConfigurationSection(materialName);
                        newClass.setItemDamage(material, Scaling.get(newClass, damage));
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid item-damage (" + materialName + ") defined for " + className);
                }
            }
        } else {
            bases = new EnumMap<Material, Double>(Material.class);
            perLevels = new EnumMap(Material.class);
            section = config.getConfigurationSection("item-damage");
            if (section != null) {
                Set itemDamages2 = section.getKeys(false);
                if (itemDamages2.isEmpty()) {
                    Heroes.log(Level.WARNING, className + " has an item-damage section, but no item-damage values");
                } else {
                    for (String materialName : itemDamages2) {
                        Material material2 = Material.matchMaterial((String)materialName);
                        if (material2 != null && section.get(materialName) instanceof Number) {
                            bases.put((Material)material2, section.getDouble(materialName));
                            continue;
                        }
                        Heroes.log(Level.WARNING, "Invalid item-damage (" + materialName + ") defined for " + className);
                    }
                }
            } else if (newClass.isPrimary()) {
                Heroes.log(Level.WARNING, className + " has no item-damage section");
            }
            if ((section = config.getConfigurationSection("item-damage-level")) != null) {
                Set itemDamages2 = section.getKeys(false);
                if (itemDamages2.isEmpty()) {
                    Heroes.log(Level.WARNING, className + " has an item-damage-level section, but no item-damage-level values");
                } else {
                    Iterator iterator = itemDamages2.iterator();
                    while (iterator.hasNext()) {
                        String materialName;
                        materialName = (String)iterator.next();
                        Material material = Material.matchMaterial((String)materialName);
                        if (material != null && section.get(materialName) instanceof Number) {
                            perLevels.put(material, section.getDouble(materialName));
                            continue;
                        }
                        Heroes.log(Level.WARNING, "Invalid item-damage-level (" + materialName + ") defined for " + className);
                    }
                }
            } else if (newClass.isPrimary()) {
                Heroes.log(Level.WARNING, className + " has no item-damage-level section");
            }
            for (Map.Entry entry : bases.entrySet()) {
                double perLevel = perLevels.containsKey(entry.getKey()) ? (Double)perLevels.get(entry.getKey()) : 0.0;
                newClass.setItemDamage((Material)entry.getKey(), new LevelScaling(newClass, (Double)entry.getValue(), perLevel));
            }
        }
        if ((section = config.getConfigurationSection("pve-item-damage-multiplier")) != null) {
            itemDamages = section.getKeys(false);
            if (itemDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has an pve-item-damage-multiplier section, but no pve-item-damage-multiplier values");
            } else {
                for (String materialName : itemDamages) {
                    Material material = Material.matchMaterial((String)materialName);
                    if (material != null && section.get(materialName) instanceof Number) {
                        double multiplier = section.getDouble(materialName);
                        newClass.setPveItemDamageMultiplier(material, multiplier);
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid pve-item-damage-multiplier (" + materialName + ") defined for " + className);
                }
            }
        } else if (newClass.isPrimary()) {
            Heroes.log(Level.WARNING, className + " has no pve-item-damage-multiplier section");
        }
        if ((section = config.getConfigurationSection("pve-item-damage-multiplier-level")) != null) {
            itemDamages = section.getKeys(false);
            if (itemDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has an pve-item-damage-multiplier-level section, but no pve-item-damage-multiplier-level values");
            } else {
                for (String materialName : itemDamages) {
                    Material material = Material.matchMaterial((String)materialName);
                    if (material != null && section.get(materialName) instanceof Number) {
                        double multiplier = section.getDouble(materialName);
                        newClass.setPveItemDamageMultiplierLevel(material, multiplier);
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid pve-item-damage-multiplier-level (" + materialName + ") defined for " + className);
                }
            }
        } else if (newClass.isPrimary()) {
            Heroes.log(Level.WARNING, className + " has no pve-item-damage-multiplier-level section");
        }
        if ((section = config.getConfigurationSection("pvp-item-damage-multiplier")) != null) {
            itemDamages = section.getKeys(false);
            if (itemDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has an pvp-item-damage-multiplier section, but no pvp-item-damage-multiplier values");
            } else {
                for (String materialName : itemDamages) {
                    Material material = Material.matchMaterial((String)materialName);
                    if (material != null && section.get(materialName) instanceof Number) {
                        double multiplier = section.getDouble(materialName);
                        newClass.setPvpItemDamageMultiplier(material, multiplier);
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid pvp-item-damage-multiplier (" + materialName + ") defined for " + className);
                }
            }
        } else if (newClass.isPrimary()) {
            Heroes.log(Level.WARNING, className + " has no pvp-item-damage-multiplier section");
        }
        if ((section = config.getConfigurationSection("pvp-item-damage-multiplier-level")) != null) {
            itemDamages = section.getKeys(false);
            if (itemDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has an pvp-item-damage-multiplier-level section, but no pvp-item-damage-multiplier-level values");
            } else {
                for (String materialName : itemDamages) {
                    Material material = Material.matchMaterial((String)materialName);
                    if (material != null && section.get(materialName) instanceof Number) {
                        double multiplier = section.getDouble(materialName);
                        newClass.setPvpItemDamageMultiplierLevel(material, multiplier);
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid pvp-item-damage-multiplier-level (" + materialName + ") defined for " + className);
                }
            }
        } else if (newClass.isPrimary()) {
            Heroes.log(Level.WARNING, className + " has no pvp-item-damage-multiplier-level section");
        }
        if ((section = config.getConfigurationSection("projectile-damages")) != null) {
            projectileDamages = section.getKeys(false);
            if (projectileDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has a projectile-damage section, but no projectile-damage values");
            } else {
                for (String projectileName : projectileDamages) {
                    CharacterDamageManager.ProjectileType projectileType = CharacterDamageManager.ProjectileType.matchProjectile(projectileName);
                    if (projectileType != null && section.isConfigurationSection(projectileName)) {
                        ConfigurationSection damage = section.getConfigurationSection(projectileName);
                        newClass.setProjectileDamage(projectileType, Scaling.get(newClass, damage));
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid projectile-damage type or value for (" + projectileName + ") defined in " + className);
                }
            }
        } else {
            bases = new EnumMap(CharacterDamageManager.ProjectileType.class);
            perLevels = new EnumMap(CharacterDamageManager.ProjectileType.class);
            section = config.getConfigurationSection("projectile-damage");
            if (section != null) {
                Set projectileDamages2 = section.getKeys(false);
                if (projectileDamages2.isEmpty()) {
                    Heroes.log(Level.WARNING, className + " has a projectile-damage section, but no projectile-damage values");
                } else {
                    for (String projectileName : projectileDamages2) {
                        CharacterDamageManager.ProjectileType type2 = CharacterDamageManager.ProjectileType.matchProjectile(projectileName);
                        if (type2 != null && section.get(projectileName) instanceof Number) {
                            bases.put((Object)type2, section.getDouble(projectileName));
                            continue;
                        }
                        Heroes.log(Level.WARNING, "Invalid projectile-damage type or value for (" + projectileName + ") defined in " + className);
                    }
                }
            }
            if ((section = config.getConfigurationSection("projectile-damage-level")) != null) {
                Set projectileDamages2 = section.getKeys(false);
                if (projectileDamages2.isEmpty()) {
                    Heroes.log(Level.WARNING, className + " has a projectile-damage-level section, but no projectile-damage-level values");
                } else {
                    Iterator iterator = projectileDamages2.iterator();
                    while (iterator.hasNext()) {
                        String projectileName = (String)iterator.next();
                        CharacterDamageManager.ProjectileType type = CharacterDamageManager.ProjectileType.matchProjectile(projectileName);
                        if (type != null && section.get(projectileName) instanceof Number) {
                            perLevels.put(type, section.getDouble(projectileName));
                            continue;
                        }
                        Heroes.log(Level.WARNING, "Invalid projectile-damage-level type or value for (" + projectileName + ") defined in " + className);
                    }
                }
            }
            for (Map.Entry entry : bases.entrySet()) {
                double perLevel = perLevels.containsKey(entry.getKey()) ? (Double)perLevels.get(entry.getKey()) : 0.0;
                newClass.setProjectileDamage((CharacterDamageManager.ProjectileType)((Object)entry.getKey()), new LevelScaling(newClass, (Double)entry.getValue(), perLevel));
            }
        }
        if ((section = config.getConfigurationSection("pve-projectile-damage-multiplier")) != null) {
            projectileDamages = section.getKeys(false);
            if (projectileDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has a pve-projectile-damage-multiplier section, but no pve-projectile-damage-multiplier values");
            } else {
                for (String projectileName : projectileDamages) {
                    CharacterDamageManager.ProjectileType projectileType = CharacterDamageManager.ProjectileType.matchProjectile(projectileName);
                    if (projectileType != null && section.get(projectileName) instanceof Number) {
                        double multiplier = section.getDouble(projectileName);
                        newClass.setPveProjDamageMultiplier(projectileType, multiplier);
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid pve-projectile-damage-multiplier type or value for (" + projectileName + ") defined in " + className);
                }
            }
        }
        if ((section = config.getConfigurationSection("pve-projectile-damage-multiplier-level")) != null) {
            projectileDamages = section.getKeys(false);
            if (projectileDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has a pve-projectile-damage-multiplier-level section, but no pve-projectile-damage-multiplier-level values");
            } else {
                for (String projectileName : projectileDamages) {
                    CharacterDamageManager.ProjectileType projectileType = CharacterDamageManager.ProjectileType.matchProjectile(projectileName);
                    if (projectileType != null && section.get(projectileName) instanceof Number) {
                        double multiplier = section.getDouble(projectileName);
                        newClass.setPveProjDamageMultiplierLevel(projectileType, multiplier);
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid pve-projectile-damage-multiplier-level type or value for (" + projectileName + ") defined in " + className);
                }
            }
        }
        if ((section = config.getConfigurationSection("pvp-projectile-damage-multiplier")) != null) {
            projectileDamages = section.getKeys(false);
            if (projectileDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has a pvp-projectile-damage-multiplier section, but no pvp-projectile-damage-multiplier values");
            } else {
                for (String projectileName : projectileDamages) {
                    CharacterDamageManager.ProjectileType projectileType = CharacterDamageManager.ProjectileType.matchProjectile(projectileName);
                    if (projectileType != null && section.get(projectileName) instanceof Number) {
                        double multiplier = section.getDouble(projectileName);
                        newClass.setPvpProjDamageMultiplier(projectileType, multiplier);
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid pvp-projectile-damage-multiplier type or value for (" + projectileName + ") defined in " + className);
                }
            }
        }
        if ((section = config.getConfigurationSection("pvp-projectile-damage-multiplier-level")) != null) {
            projectileDamages = section.getKeys(false);
            if (projectileDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has a pvp-projectile-damage-multiplier-level section, but no pvp-projectile-damage-multiplier-level values");
            } else {
                for (String projectileName : projectileDamages) {
                    CharacterDamageManager.ProjectileType projectileType = CharacterDamageManager.ProjectileType.matchProjectile(projectileName);
                    if (projectileType != null && section.get(projectileName) instanceof Number) {
                        double multiplier = section.getDouble(projectileName);
                        newClass.setPvpProjDamageMultiplierLevel(projectileType, multiplier);
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid pvp-projectile-damage-multiplier-level type or value for (" + projectileName + ") defined in " + className);
                }
            }
        }
    }

    private void loadMitigation(HeroClass newClass, ConfigurationSection section) {
        double maximumDamageReduction = Heroes.properties.maximumDamageReduction;
        double perArmorDamageReduction = Heroes.properties.perArmorDamageReduction;
        ArrayList<String> mitigationDamageCausesStrings = null;
        if (section != null) {
            maximumDamageReduction = section.getDouble("maximum-damage-reduction", Heroes.properties.maximumDamageReduction);
            perArmorDamageReduction = section.getDouble("per-armor-damage-reduction-percent", Heroes.properties.perArmorDamageReduction);
            mitigationDamageCausesStrings = section.getStringList("mitigation-damage-causes");
            if (Heroes.properties.mitigationEnabled && (mitigationDamageCausesStrings == null || mitigationDamageCausesStrings.isEmpty())) {
                Heroes.log(Level.WARNING, newClass.getName() + " has a mitigation section, but no mitigation-damage-causes values.");
            }
        }
        newClass.setMaxDamageReduction(maximumDamageReduction);
        newClass.setPerArmorDamageReductionPercent(perArmorDamageReduction);
        boolean usingDefaultDamageCauses = false;
        if (mitigationDamageCausesStrings == null) {
            mitigationDamageCausesStrings = new ArrayList<String>(Heroes.properties.mitigationDamageCauses);
            usingDefaultDamageCauses = true;
        }
        if (Heroes.properties.mitigationEnabled && !this.loadMitigationDamageCauses(newClass, mitigationDamageCausesStrings)) {
            if (!usingDefaultDamageCauses) {
                Heroes.log(Level.WARNING, "Invalid mitigation-damage-causes defined in " + newClass.getName() + ". Attempting to use global setting.");
                if (!this.loadMitigationDamageCauses(newClass, Heroes.properties.mitigationDamageCauses)) {
                    Heroes.log(Level.WARNING, "Invalid global mitigation-damage-causes.");
                }
            } else {
                Heroes.log(Level.WARNING, "Invalid global mitigation-damage-causes.");
            }
        }
    }

    private boolean loadMitigationDamageCauses(HeroClass newClass, List<String> mitigationDamageCausesStrings) {
        boolean anyValidDamageCauses = false;
        for (String damageCauseString : mitigationDamageCausesStrings) {
            try {
                EntityDamageEvent.DamageCause damageCause = EntityDamageEvent.DamageCause.valueOf((String)damageCauseString);
                newClass.addMitigationDamageCause(damageCause);
                anyValidDamageCauses = true;
            }
            catch (IllegalArgumentException e) {
                Heroes.log(Level.WARNING, "Invalid mitigation damage cause (" + damageCauseString + ") defined for " + newClass.getName());
            }
        }
        return anyValidDamageCauses;
    }

    private void loadWeapons(HeroClass newClass, List<String> items) {
        StringBuilder limits = new StringBuilder();
        String className = newClass.getName();
        if (items == null || items.isEmpty()) {
            Heroes.log(Level.WARNING, className + " has no permitted-weapon section");
            return;
        }
        HashSet<String> mainhandItems = new HashSet<String>(Util.weapons);
        if (Heroes.properties.useToolsInPermittedWeapons) {
            mainhandItems.addAll(Util.toolsNotAlreadyWeapons);
        }
        for (String itemString : items) {
            Pair<String, Integer> itemNameAndLevel = HeroClassManager.getItemNameAndLevel(itemString);
            if (itemNameAndLevel == null) {
                Heroes.log(Level.WARNING, "Invalid weapon type (" + itemString + ") defined for " + className);
                continue;
            }
            String item = itemNameAndLevel.getLeft();
            int itemLevel = itemNameAndLevel.getRight();
            boolean matched = false;
            for (String weapon : mainhandItems) {
                Material material;
                if (!weapon.contains(item.toUpperCase()) && !item.equals("*") && !item.equalsIgnoreCase("ALL") || weapon.contains("PICK") && !item.contains("PICK") && item.contains("AXE") || weapon.contains("CROSS") && !item.contains("CROSS") && item.contains("BOW") || (material = Material.matchMaterial((String)weapon)) == null) continue;
                newClass.addAllowedWeapon(material);
                newClass.addAllowedWeaponLevel(material, itemLevel);
                limits.append(" ").append(weapon);
                if (itemLevel > 1) {
                    limits.append(" (L").append(itemLevel).append(")");
                }
                matched = true;
            }
            if (item.equals("*") || item.equalsIgnoreCase("ALL")) {
                newClass.setAllowedAllWeapons(true);
                break;
            }
            if (matched) continue;
            Heroes.log(Level.WARNING, "Invalid weapon type (" + item + ") defined for " + className);
        }
        if (Heroes.properties.debug) {
            Heroes.debugLog(Level.INFO, "Allowed Weapons - " + limits.toString());
        }
    }

    private static Pair<String, Integer> getItemNameAndLevel(String itemString) {
        if (itemString.contains(":")) {
            String[] vals = itemString.split(":");
            if (vals.length > 1) {
                String item = vals[0];
                int itemLevel = Util.toInt(vals[1], 1);
                if (itemLevel < 1) {
                    itemLevel = 1;
                }
                return new Pair<String, Integer>(item, itemLevel);
            }
            return null;
        }
        return new Pair<String, Integer>(itemString, 1);
    }

    private void loadOffhand(HeroClass newClass, List<String> items) {
        StringBuilder limits = new StringBuilder();
        String className = newClass.getName();
        if (items == null || items.isEmpty()) {
            Heroes.log(Level.WARNING, className + " has no permitted-offhand section");
            return;
        }
        HashSet<String> offhandItems = new HashSet<String>(Util.weapons);
        offhandItems.addAll(Util.trinkets);
        if (Heroes.properties.useToolsInPermittedWeapons) {
            offhandItems.addAll(Util.toolsNotAlreadyWeapons);
        }
        for (String itemString : items) {
            Pair<String, Integer> itemNameAndLevel = HeroClassManager.getItemNameAndLevel(itemString);
            if (itemNameAndLevel == null) {
                Heroes.log(Level.WARNING, "Invalid offhand type (" + itemString + ") defined for " + className);
                continue;
            }
            String item = itemNameAndLevel.getLeft();
            int itemLevel = itemNameAndLevel.getRight();
            boolean matched = false;
            for (String offhand : offhandItems) {
                Material material;
                if (!offhand.contains(item.toUpperCase()) && !item.equals("*") && !item.equalsIgnoreCase("ALL") || offhand.contains("PICK") && !item.contains("PICK") && item.contains("AXE") || offhand.contains("CROSS") && !item.contains("CROSS") && item.contains("BOW") || (material = Material.matchMaterial((String)offhand)) == null) continue;
                newClass.addAllowedOffHand(material);
                newClass.addAllowedOffhandLevel(material, itemLevel);
                limits.append(" ").append(offhand);
                if (itemLevel > 1) {
                    limits.append(" (L").append(itemLevel).append(")");
                }
                matched = true;
            }
            if (item.equals("*") || item.equalsIgnoreCase("ALL")) {
                newClass.setAllowedAllOffhand(true);
                break;
            }
            if (matched) continue;
            Heroes.log(Level.WARNING, "Invalid offhand type (" + item + ") defined for " + className);
        }
        if (Heroes.properties.debug) {
            Heroes.debugLog(Level.INFO, "Allowed Offhand - " + limits.toString());
        }
    }

    private void checkClassHierarchy() {
        for (HeroClass unlinkedClass : this.classes) {
            Set<String> weak;
            Set<String> strong = this.strongParents.get(unlinkedClass);
            if (strong != null && !strong.isEmpty()) {
                for (String sp : strong) {
                    HeroClass parent = this.getClass(sp);
                    if (parent != null) {
                        try {
                            unlinkedClass.addStrongParent(parent);
                            parent.addSpecialization(unlinkedClass);
                        }
                        catch (HeroClass.CircularParentException e) {
                            Heroes.log(Level.SEVERE, "Cannot assign " + unlinkedClass.getName() + " as a parent class as " + sp + " is already a parent of that class.");
                        }
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Cannot assign " + unlinkedClass.getName() + " a parent class as " + sp + " does not exist.");
                }
            }
            if ((weak = this.weakParents.get(unlinkedClass)) == null || weak.isEmpty()) continue;
            for (String wp : weak) {
                HeroClass parent = this.getClass(wp);
                if (parent != null) {
                    try {
                        unlinkedClass.addWeakParent(parent);
                        parent.addSpecialization(unlinkedClass);
                    }
                    catch (HeroClass.CircularParentException e) {
                        Heroes.log(Level.SEVERE, "Cannot assign " + unlinkedClass.getName() + " as a parent class as " + wp + " is already a parent of that class.");
                    }
                    continue;
                }
                Heroes.log(Level.WARNING, "Cannot assign " + unlinkedClass.getName() + " a parent class as " + wp + " does not exist.");
            }
        }
        this.strongParents.clear();
        this.strongParents = null;
        this.weakParents.clear();
        this.weakParents = null;
    }

    private void loadArmor(HeroClass newClass, List<String> items) {
        StringBuilder limits = new StringBuilder();
        String className = newClass.getName();
        if (items == null || items.isEmpty()) {
            Heroes.log(Level.WARNING, className + " has no permitted-armor section");
            return;
        }
        for (String itemString : items) {
            Pair<String, Integer> itemNameAndLevel = HeroClassManager.getItemNameAndLevel(itemString);
            if (itemNameAndLevel == null) {
                Heroes.log(Level.WARNING, "Invalid armor type (" + itemString + ") defined for " + className);
                continue;
            }
            String item = itemNameAndLevel.getLeft();
            int itemLevel = itemNameAndLevel.getRight();
            boolean matched = false;
            for (String armor : Util.armors) {
                Material material;
                if (!armor.contains(item.toUpperCase()) && !item.equals("*") && !item.equalsIgnoreCase("ALL") || (material = Material.matchMaterial((String)armor)) == null) continue;
                newClass.addAllowedArmor(material);
                newClass.addAllowedArmorLevel(material, itemLevel);
                limits.append(" ").append(armor);
                if (itemLevel > 1) {
                    limits.append(" (L").append(itemLevel).append(")");
                }
                matched = true;
            }
            if (item.equals("*") || item.equalsIgnoreCase("ALL")) {
                newClass.setAllowedAllArmor(true);
                break;
            }
            if (matched) continue;
            Heroes.log(Level.WARNING, "Invalid armor type (" + item + ") defined for " + className);
        }
        if (Heroes.properties.debug) {
            Heroes.debugLog(Level.INFO, "Allowed Armor - " + limits.toString());
        }
    }

    private void loadExperienceTypes(HeroClass newClass, List<String> experienceNames) {
        String className = newClass.getName();
        EnumSet<HeroClass.ExperienceType> experienceSources = EnumSet.noneOf(HeroClass.ExperienceType.class);
        if (experienceNames == null || experienceNames.isEmpty()) {
            Heroes.log(Level.WARNING, className + " has no experience-sources section");
        } else {
            for (String experience : experienceNames) {
                try {
                    boolean added = experienceSources.add(HeroClass.ExperienceType.valueOf(experience.toUpperCase()));
                    if (added) continue;
                    Heroes.log(Level.WARNING, "Duplicate experience source (" + experience + ") defined for " + className + ".");
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid experience source (" + experience + ") defined for " + className + ". Skipping this source.");
                }
            }
        }
        newClass.setExperienceSources(experienceSources);
    }

    private void loadPermissionSkills(HeroClass newClass, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        String className = newClass.getName();
        Set permissionSkillNames = section.getKeys(false);
        if (!permissionSkillNames.isEmpty()) {
            for (String skillName : permissionSkillNames) {
                if (newClass.hasSkill(skillName)) {
                    Heroes.log(Level.WARNING, "Skill already assigned (" + skillName + ") for " + className + ". Skipping this skill");
                    continue;
                }
                try {
                    if (!this.plugin.getSkillManager().isLoaded(skillName) && !this.plugin.getSkillManager().loadOutsourcedSkill(skillName)) continue;
                    newClass.addSkill(skillName);
                    ConfigurationSection skillSettings = section.getConfigurationSection(skillName);
                    if (skillSettings == null) {
                        skillSettings = section.createSection(skillName);
                    }
                    this.plugin.getSkillConfigs().addClassSkillSettings(className, this.plugin.getSkillManager().getSkill(skillName).getName(), skillSettings);
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid permission skill (" + skillName + ") defined for " + className + ". Skipping this skill.");
                }
            }
        }
    }

    private void loadPotionSkills(HeroClass newClass, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        String className = newClass.getName();
        Set potionSkillNames = section.getKeys(false);
        if (!potionSkillNames.isEmpty()) {
            for (String skillName : potionSkillNames) {
                if (newClass.hasSkill(skillName)) {
                    Heroes.log(Level.WARNING, "Skill already assigned (" + skillName + ") for " + className + ". Skipping this skill");
                    continue;
                }
                try {
                    if (!this.plugin.getSkillManager().isLoaded(skillName) && !this.plugin.getSkillManager().loadPotionSkill(skillName)) continue;
                    newClass.addSkill(skillName);
                    ConfigurationSection skillSettings = section.getConfigurationSection(skillName);
                    if (skillSettings == null) {
                        skillSettings = section.createSection(skillName);
                    }
                    this.plugin.getSkillConfigs().addClassSkillSettings(className, this.plugin.getSkillManager().getSkill(skillName).getName(), skillSettings);
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid potion skill (" + skillName + ") defined for " + className + ". Skipping this skill.");
                }
            }
        }
    }

    private void loadPermittedSkills(HeroClass newClass, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        String className = newClass.getName();
        Set skillNames = section.getKeys(false);
        if (skillNames.isEmpty()) {
            Heroes.log(Level.WARNING, className + " has no permitted-skills section");
        } else {
            boolean allSkills = false;
            for (String skillName : skillNames) {
                if (skillName.equals("*") || skillName.toLowerCase().equals("all")) {
                    allSkills = true;
                    continue;
                }
                Skill skill = this.plugin.getSkillManager().getSkill(skillName);
                if (skill == null) {
                    Heroes.log(Level.WARNING, "Skill " + skillName + " defined for " + className + " not found.");
                    continue;
                }
                newClass.addSkill(skill);
                ConfigurationSection skillSettings = section.getConfigurationSection(skillName);
                if (skillSettings == null) {
                    skillSettings = section.createSection(skillName);
                }
                this.plugin.getSkillConfigs().addClassSkillSettings(className, skill.getName(), skillSettings);
            }
            if (allSkills) {
                this.plugin.getSkillManager().loadSkills();
                for (Skill skill : this.plugin.getSkillManager().getSkills()) {
                    if (newClass.hasSkill(skill.getName()) || skill instanceof OutsourcedSkill) continue;
                    newClass.addSkill(skill);
                    ConfigurationSection skillSettings = section.getConfigurationSection(skill.getName());
                    if (skillSettings == null) {
                        skillSettings = section.createSection(skill.getName());
                    }
                    this.plugin.getSkillConfigs().addClassSkillSettings(newClass.getName(), skill.getName(), skillSettings);
                }
            }
        }
    }
}

