/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.classes;

import com.google.common.collect.Lists;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.attributes.AttributeSet;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.characters.classes.ClassSkill;
import com.herocraftonline.heroes.characters.classes.scaling.LevelScaling;
import com.herocraftonline.heroes.characters.classes.scaling.Scaling;
import com.herocraftonline.heroes.characters.skill.Skill;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.Material;
import org.bukkit.event.entity.EntityDamageEvent;

public class HeroClass
implements Comparable<HeroClass> {
    private final String name;
    private String description;
    private final Set<HeroClass> strongParents = new HashSet<HeroClass>();
    private final Set<HeroClass> weakParents = new HashSet<HeroClass>();
    private Set<HeroClass> specializations = new LinkedHashSet<HeroClass>();
    private final Set<Material> allowedArmor = EnumSet.noneOf(Material.class);
    private final Set<Material> allowedWeapons = EnumSet.noneOf(Material.class);
    private final Set<Material> allowedOffhand = EnumSet.noneOf(Material.class);
    private boolean allowedAllArmor = false;
    private boolean allowedAllWeapons = false;
    private boolean allowedAllOffhand = false;
    private Set<ExperienceType> experienceSources = EnumSet.noneOf(ExperienceType.class);
    private boolean primary = true;
    private boolean secondary = false;
    private boolean race = false;
    private int tier = 1;
    private final AttributeSet baseAttributes = new AttributeSet();
    private final Map<Material, Scaling> itemDamage = new EnumMap<Material, Scaling>(Material.class);
    private final Map<Material, Double> pveItemDamageMultiplier = new EnumMap<Material, Double>(Material.class);
    private final Map<Material, Double> pveItemDamageMultiplierLevel = new EnumMap<Material, Double>(Material.class);
    private final Map<Material, Double> pvpItemDamageMultiplier = new EnumMap<Material, Double>(Material.class);
    private final Map<Material, Double> pvpItemDamageMultiplierLevel = new EnumMap<Material, Double>(Material.class);
    private final Map<CharacterDamageManager.ProjectileType, Scaling> projectileDamage = new EnumMap<CharacterDamageManager.ProjectileType, Scaling>(CharacterDamageManager.ProjectileType.class);
    private final Map<CharacterDamageManager.ProjectileType, Double> pveProjDamageMultiplier = new EnumMap<CharacterDamageManager.ProjectileType, Double>(CharacterDamageManager.ProjectileType.class);
    private final Map<CharacterDamageManager.ProjectileType, Double> pveProjDamageMultiplierLevel = new EnumMap<CharacterDamageManager.ProjectileType, Double>(CharacterDamageManager.ProjectileType.class);
    private final Map<CharacterDamageManager.ProjectileType, Double> pvpProjDamageMultiplier = new EnumMap<CharacterDamageManager.ProjectileType, Double>(CharacterDamageManager.ProjectileType.class);
    private final Map<CharacterDamageManager.ProjectileType, Double> pvpProjDamageMultiplierLevel = new EnumMap<CharacterDamageManager.ProjectileType, Double>(CharacterDamageManager.ProjectileType.class);
    private final Map<Material, Integer> allowedArmorLevels = new EnumMap<Material, Integer>(Material.class);
    private final Map<Material, Integer> allowedWeaponLevels = new EnumMap<Material, Integer>(Material.class);
    private final Map<Material, Integer> allowedOffhandLevels = new EnumMap<Material, Integer>(Material.class);
    private double maxDamageReduction;
    private double perArmorDamageReductionPercent;
    private final Set<EntityDamageEvent.DamageCause> mitigationDamageCauses = new HashSet<EntityDamageEvent.DamageCause>();
    private final Map<String, ClassSkill> skills = new LinkedHashMap<String, ClassSkill>();
    private int prepareSkillLimit = 0;
    private Scaling maxSkillPreparePoints;
    private double cost;
    private double expModifier;
    private double expLoss;
    private double pvpExpLoss;
    private int maxLevel;
    private int allocationPointsPerLevel;
    private Scaling maxHealth = null;
    private Scaling maxShield = null;
    private Scaling maxMana = null;
    private Scaling maxStamina = null;
    private Scaling scaledManaRegen = null;
    private Scaling scaledStaminaRegen = null;
    private Scaling scaledShieldRegen = null;
    private double baseMaxEquipmentWeight;
    private boolean wildcard = true;
    private final Heroes plugin;
    private boolean isUltimate;
    private UltimateInfo ultimateInfo;
    private ClassRunCommandsInfo onClassGainRunCommandsInfo = new ClassRunCommandsInfo();
    private ClassRunCommandsInfo onClassLossRunCommandsInfo = new ClassRunCommandsInfo();
    private ClassRunCommandsInfo onMasterRunCommandsInfo = new ClassRunCommandsInfo();
    private ClassRunCommandsInfo onFirstClassGainRunCommandsInfo = new ClassRunCommandsInfo();
    private ClassRunCommandsInfo onFirstMasterRunCommandsInfo = new ClassRunCommandsInfo();

    public static HeroClass getGlobalSkillset() {
        return Heroes.getInstance().getClassManager().getGlobalSkillset();
    }

    public static boolean hasGlobalSkillset() {
        return HeroClass.getGlobalSkillset() != null;
    }

    public HeroClass(String name, Heroes plugin) {
        this.name = name;
        this.plugin = plugin;
        this.description = "";
        this.expModifier = 1.0;
        this.maxLevel = 1;
        this.cost = 0.0;
    }

    public void initEmptyStats(int health, int mana, int stamina, int shield) {
        if (this.maxHealth == null) {
            this.maxHealth = new LevelScaling(this, health, 0.0);
        }
        if (this.maxStamina == null) {
            this.maxStamina = new LevelScaling(this, stamina, 0.0);
        }
        if (this.maxMana == null) {
            this.maxMana = new LevelScaling(this, mana, 0.0);
        }
        if (this.maxShield == null) {
            this.maxShield = new LevelScaling(this, shield, 0.0);
        }
        if (this.scaledManaRegen == null) {
            this.scaledManaRegen = new LevelScaling(this, (double)mana / 10.0, 0.0);
        }
        if (this.scaledStaminaRegen == null) {
            this.scaledStaminaRegen = new LevelScaling(this, (double)stamina / 10.0, 0.0);
        }
        if (this.scaledShieldRegen == null) {
            this.scaledShieldRegen = new LevelScaling(this, (double)shield / 10.0, 0.0);
        }
    }

    protected void setAllowedAllArmor(boolean allowedAllArmor) {
        this.allowedAllArmor = allowedAllArmor;
    }

    protected void setAllowedAllWeapons(boolean allowedAllWeapons) {
        this.allowedAllWeapons = allowedAllWeapons;
    }

    protected void setAllowedAllOffhand(boolean allowedAllOffhand) {
        this.allowedAllOffhand = allowedAllOffhand;
    }

    protected void addAllowedArmor(Material armor) {
        this.allowedArmor.add(armor);
    }

    protected void addAllowedWeapon(Material weapon) {
        this.allowedWeapons.add(weapon);
    }

    protected void addAllowedOffHand(Material weapon) {
        this.allowedOffhand.add(weapon);
    }

    protected void addAllowedArmorLevel(Material armor, int levelRequired) {
        if (levelRequired < 1) {
            levelRequired = 1;
        }
        this.allowedArmorLevels.put(armor, levelRequired);
    }

    protected void addAllowedWeaponLevel(Material weapon, int levelRequired) {
        if (levelRequired < 1) {
            levelRequired = 1;
        }
        this.allowedWeaponLevels.put(weapon, levelRequired);
    }

    protected void addAllowedOffhandLevel(Material weapon, int levelRequired) {
        if (levelRequired < 1) {
            levelRequired = 1;
        }
        this.allowedOffhandLevels.put(weapon, levelRequired);
    }

    protected void addSkill(Skill skill) {
        if (skill == null) {
            return;
        }
        String skillNameToLower = skill.getName().toLowerCase();
        if (this.skills.containsKey(skillNameToLower)) {
            return;
        }
        ClassSkill classSkill = new ClassSkill(this, skill);
        this.skills.put(skillNameToLower, classSkill);
    }

    protected void addSkill(String skillName) {
        if (skillName == null) {
            return;
        }
        this.addSkill(this.plugin.getSkillManager().getSkill(skillName));
    }

    public void addSpecialization(HeroClass heroClass) {
        this.specializations.add(heroClass);
    }

    public boolean hasNoParents() {
        return this.strongParents.isEmpty() && this.weakParents.isEmpty();
    }

    public void addStrongParent(HeroClass parent) throws CircularParentException {
        if (parent.equals(this)) {
            throw new CircularParentException();
        }
        List<HeroClass> parents = parent.getParents();
        for (HeroClass hc : parents) {
            if (hc.equals(this)) {
                throw new CircularParentException();
            }
            hc.checkCircular(this);
        }
        this.strongParents.add(parent);
    }

    public void addWeakParent(HeroClass parent) throws CircularParentException {
        if (parent.equals(this)) {
            throw new CircularParentException();
        }
        List<HeroClass> parents = parent.getParents();
        for (HeroClass hc : parents) {
            if (hc.equals(this)) {
                throw new CircularParentException();
            }
            hc.checkCircular(this);
        }
        this.weakParents.add(parent);
    }

    private void checkCircular(HeroClass heroClass) throws CircularParentException {
        List<HeroClass> parents = this.getParents();
        for (HeroClass hc : parents) {
            if (hc.equals(heroClass)) {
                throw new CircularParentException();
            }
            hc.checkCircular(heroClass);
        }
    }

    public Set<HeroClass> getAllParents() {
        HashSet<HeroClass> classes = new HashSet<HeroClass>();
        for (HeroClass hClass : this.getParents()) {
            classes.add(hClass);
            classes.addAll(hClass.getAllParents(new HashSet<HeroClass>(classes)));
        }
        return classes;
    }

    private Set<HeroClass> getAllParents(Set<HeroClass> parents) {
        for (HeroClass hClass : this.getParents()) {
            parents.addAll(hClass.getAllParents(new HashSet<HeroClass>(parents)));
        }
        return parents;
    }

    public int getCraftLevel(Object obj) {
        int level = -1;
        return level;
    }

    public boolean isDefault() {
        return this.plugin.getClassManager().getDefaultClass().equals(this);
    }

    public boolean isDefaultProf() {
        HeroClass defaultProfession = this.plugin.getClassManager().getDefaultProfession();
        return defaultProfession != null && defaultProfession.equals(this);
    }

    public boolean isDefaultRace() {
        HeroClass defaultRace = this.plugin.getClassManager().getDefaultRace();
        return defaultRace != null && defaultRace.equals(this);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    protected void setPrimary(boolean primary) {
        this.primary = primary;
        if (this.maxHealth == null) {
            this.maxHealth = new LevelScaling(this, 20.0, 0.0);
        }
    }

    public boolean isSecondary() {
        return this.secondary;
    }

    public boolean isRace() {
        return this.race;
    }

    protected void setSecondary(boolean secondary) {
        this.secondary = secondary;
    }

    protected void setRace(boolean race) {
        this.race = race;
    }

    public boolean isGlobal() {
        return this == HeroClass.getGlobalSkillset();
    }

    public int getTier() {
        return this.tier;
    }

    protected void setTier(int tier) {
        this.tier = tier;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HeroClass)) {
            return false;
        }
        HeroClass that = (HeroClass)other;
        return this.name.equalsIgnoreCase(that.name);
    }

    public boolean isAllowedAllArmor() {
        return this.allowedAllArmor;
    }

    public boolean isAllowedAllWeapons() {
        return this.allowedAllWeapons;
    }

    public boolean isAllowedAllOffhand() {
        return this.allowedAllOffhand;
    }

    public boolean isAllowedArmor(Material material) {
        return this.allowedArmor.contains(material);
    }

    public boolean isAllowedArmor(Material material, int classLevel) {
        return this.isAllowedArmor(material) && classLevel >= this.getAllowedArmorLevel(material);
    }

    public boolean isAllowedArmorLevelRestricted(Material material) {
        return this.isAllowedArmor(material) && this.getAllowedArmorLevel(material) > 1;
    }

    public Set<Material> getAllowedArmor() {
        return Collections.unmodifiableSet(this.allowedArmor);
    }

    public int getAllowedArmorLevel(Material material) {
        return this.allowedArmorLevels.getOrDefault(material, 1);
    }

    public boolean isAllowedWeapon(Material material) {
        return this.allowedWeapons.contains(material);
    }

    public boolean isAllowedWeapon(Material material, int classLevel) {
        return this.isAllowedWeapon(material) && classLevel >= this.getAllowedWeaponLevel(material);
    }

    public boolean isAllowedWeaponLevelRestricted(Material material) {
        return this.isAllowedWeapon(material) && this.getAllowedWeaponLevel(material) > 1;
    }

    public Set<Material> getAllowedWeapons() {
        return Collections.unmodifiableSet(this.allowedWeapons);
    }

    public int getAllowedWeaponLevel(Material material) {
        return this.allowedWeaponLevels.getOrDefault(material, 1);
    }

    public boolean isAllowedOffhand(Material material) {
        return this.allowedOffhand.contains(material);
    }

    public boolean isAllowedOffhand(Material material, int classLevel) {
        return this.isAllowedOffhand(material) && classLevel >= this.getAllowedOffhandLevel(material);
    }

    public boolean isAllowedOffhandLevelRestricted(Material material) {
        return this.isAllowedOffhand(material) && this.getAllowedOffhandLevel(material) > 1;
    }

    public Set<Material> getAllowedOffhand() {
        return Collections.unmodifiableSet(this.allowedOffhand);
    }

    public int getAllowedOffhandLevel(Material material) {
        return this.allowedOffhandLevels.getOrDefault(material, 1);
    }

    public Scaling getMaxHealth() {
        return this.maxHealth;
    }

    protected void setMaxHealth(Scaling maxHealth) {
        this.maxHealth = maxHealth;
    }

    public Scaling getMaxShield() {
        return this.maxShield;
    }

    protected void setMaxShield(Scaling maxShield) {
        this.maxShield = maxShield;
    }

    public Scaling getMaxMana() {
        return this.maxMana;
    }

    protected void setMaxMana(Scaling maxMana) {
        this.maxMana = maxMana;
    }

    public Scaling getMaxStamina() {
        return this.maxStamina;
    }

    public void setMaxStamina(Scaling maxStamina) {
        this.maxStamina = maxStamina;
    }

    public double getCost() {
        return this.cost;
    }

    protected void setCost(double cost) {
        this.cost = cost;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public Set<ExperienceType> getExperienceSources() {
        return Collections.unmodifiableSet(this.experienceSources);
    }

    protected void setExperienceSources(Set<ExperienceType> experienceSources) {
        this.experienceSources = experienceSources;
    }

    public boolean hasExperiencetype(ExperienceType type) {
        return this.experienceSources.contains((Object)type);
    }

    public double getExpLoss() {
        return this.expLoss;
    }

    protected void setExpLoss(double expLoss) {
        this.expLoss = expLoss;
    }

    public double getExpModifier() {
        return this.expModifier;
    }

    protected void setExpModifier(double modifier) {
        this.expModifier = modifier;
    }

    public int getBaseAttributeValue(String name) {
        return this.baseAttributes.getAttributeValue(name);
    }

    public int getBaseAttributeValue(AttributeType type) {
        return this.baseAttributes.getAttributeValue(type);
    }

    public AttributeSet getBaseAttributes() {
        return this.baseAttributes;
    }

    protected void setBaseAttributeValue(AttributeType type, int value) {
        this.baseAttributes.setAttributeValue(type, value);
    }

    public Scaling getItemDamage(Material material) {
        return this.itemDamage.get(material);
    }

    protected void setItemDamage(Material material, Scaling damage) {
        this.itemDamage.put(material, damage);
    }

    public double getPveItemDamageMultiplier(Material material) {
        return this.pveItemDamageMultiplier.containsKey(material) ? this.pveItemDamageMultiplier.get(material) : 1.0;
    }

    protected void setPveItemDamageMultiplier(Material material, double multiplier) {
        this.pveItemDamageMultiplier.put(material, multiplier);
    }

    public double getPveItemDamageMultiplierLevel(Material material) {
        return this.pveItemDamageMultiplierLevel.containsKey(material) ? this.pveItemDamageMultiplierLevel.get(material) : 0.0;
    }

    protected void setPveItemDamageMultiplierLevel(Material material, double multiplier) {
        this.pveItemDamageMultiplierLevel.put(material, multiplier);
    }

    public double getPvpItemDamageMultiplier(Material material) {
        return this.pvpItemDamageMultiplier.containsKey(material) ? this.pvpItemDamageMultiplier.get(material) : 1.0;
    }

    protected void setPvpItemDamageMultiplier(Material material, double multiplier) {
        this.pvpItemDamageMultiplier.put(material, multiplier);
    }

    public double getPvpItemDamageMultiplierLevel(Material material) {
        return this.pvpItemDamageMultiplierLevel.containsKey(material) ? this.pvpItemDamageMultiplierLevel.get(material) : 0.0;
    }

    protected void setPvpItemDamageMultiplierLevel(Material material, double multiplier) {
        this.pvpItemDamageMultiplierLevel.put(material, multiplier);
    }

    public double getMaxDamageReduction() {
        return this.maxDamageReduction;
    }

    protected void setMaxDamageReduction(double maxDamageReduction) {
        this.maxDamageReduction = maxDamageReduction;
    }

    public double getPerArmorDamageReductionPercent() {
        return this.perArmorDamageReductionPercent;
    }

    protected void setPerArmorDamageReductionPercent(double perArmorDamageReductionPercent) {
        this.perArmorDamageReductionPercent = perArmorDamageReductionPercent;
    }

    public Set<EntityDamageEvent.DamageCause> getMitigationDamageCauses() {
        return Collections.unmodifiableSet(this.mitigationDamageCauses);
    }

    public void addMitigationDamageCause(EntityDamageEvent.DamageCause mitigationDamageCause) {
        this.mitigationDamageCauses.add(mitigationDamageCause);
    }

    public void clearMitigationDamageCauses() {
        this.mitigationDamageCauses.clear();
    }

    public boolean hasMitigationDamageCause(EntityDamageEvent.DamageCause damageCause) {
        return damageCause != null && this.mitigationDamageCauses.contains(damageCause);
    }

    public int getAllocationPointsPerLevel() {
        return this.allocationPointsPerLevel;
    }

    protected void setAllocationPointsPerLevel(int allocationPointsPerLevel) {
        this.allocationPointsPerLevel = allocationPointsPerLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    protected void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public String getName() {
        return this.name;
    }

    public List<HeroClass> getParents() {
        ArrayList<HeroClass> parents = new ArrayList<HeroClass>(this.strongParents);
        parents.addAll(this.weakParents);
        return Collections.unmodifiableList(parents);
    }

    public Scaling getProjectileDamage(CharacterDamageManager.ProjectileType type) {
        return this.projectileDamage.get((Object)type);
    }

    protected void setProjectileDamage(CharacterDamageManager.ProjectileType type, Scaling damage) {
        this.projectileDamage.put(type, damage);
    }

    public double getPveProjDamageMultiplier(CharacterDamageManager.ProjectileType type) {
        return this.pveProjDamageMultiplier.containsKey((Object)type) ? this.pveProjDamageMultiplier.get((Object)type) : 1.0;
    }

    protected void setPveProjDamageMultiplier(CharacterDamageManager.ProjectileType type, double multiplier) {
        this.pveProjDamageMultiplier.put(type, multiplier);
    }

    public double getPveProjDamageMultiplierLevel(CharacterDamageManager.ProjectileType type) {
        return this.pveProjDamageMultiplierLevel.containsKey((Object)type) ? this.pveProjDamageMultiplierLevel.get((Object)type) : 0.0;
    }

    protected void setPveProjDamageMultiplierLevel(CharacterDamageManager.ProjectileType type, double multiplier) {
        this.pveProjDamageMultiplierLevel.put(type, multiplier);
    }

    public double getPvpProjDamageMultiplier(CharacterDamageManager.ProjectileType type) {
        return this.pvpProjDamageMultiplier.containsKey((Object)type) ? this.pvpProjDamageMultiplier.get((Object)type) : 1.0;
    }

    protected void setPvpProjDamageMultiplier(CharacterDamageManager.ProjectileType type, double multiplier) {
        this.pvpProjDamageMultiplier.put(type, multiplier);
    }

    public double getPvpProjDamageMultiplierLevel(CharacterDamageManager.ProjectileType type) {
        return this.pvpProjDamageMultiplierLevel.containsKey((Object)type) ? this.pvpProjDamageMultiplierLevel.get((Object)type) : 0.0;
    }

    protected void setPvpProjDamageMultiplierLevel(CharacterDamageManager.ProjectileType type, double multiplier) {
        this.pvpProjDamageMultiplierLevel.put(type, multiplier);
    }

    public Set<String> getSkillNames() {
        return new TreeSet<String>(this.skills.keySet());
    }

    public Collection<ClassSkill> getClassSkills() {
        return Collections.unmodifiableCollection(this.skills.values());
    }

    public ClassSkill getClassSkill(String skillName) {
        return this.skills.get(skillName.toLowerCase());
    }

    public ClassSkill getClassSkill(Skill skill) {
        if (skill == null) {
            return null;
        }
        return this.getClassSkill(skill.getName());
    }

    public int getPrepareSkillLimit() {
        return this.prepareSkillLimit;
    }

    public void setPrepareSkillLimit(int baseMaxPreparedSkills) {
        if (baseMaxPreparedSkills < 0) {
            baseMaxPreparedSkills = 0;
        }
        this.prepareSkillLimit = baseMaxPreparedSkills;
    }

    public Scaling getMaxSkillPreparePoints() {
        return this.maxSkillPreparePoints;
    }

    public void setMaxSkillPreparePoints(Scaling maxSkillPreparePoints) {
        this.maxSkillPreparePoints = maxSkillPreparePoints;
    }

    public Set<HeroClass> getSpecializations() {
        return Collections.unmodifiableSet(this.specializations);
    }

    public Set<HeroClass> getStrongParents() {
        return Collections.unmodifiableSet(this.strongParents);
    }

    public Set<HeroClass> getWeakParents() {
        return Collections.unmodifiableSet(this.weakParents);
    }

    public boolean hasSkill(String name) {
        return this.skills.containsKey(name.toLowerCase());
    }

    public double getPvpExpLoss() {
        return this.pvpExpLoss;
    }

    public void setPvpExpLoss(double pvpExpLoss) {
        this.pvpExpLoss = pvpExpLoss;
    }

    protected void setSpecializations(Set<HeroClass> specializations) {
        this.specializations = specializations;
    }

    public boolean isWildcardClass() {
        return this.wildcard;
    }

    protected void setWildcardClass(boolean wildcard) {
        this.wildcard = wildcard;
    }

    public Scaling getScaledShieldRegen() {
        return this.scaledShieldRegen;
    }

    protected void setScaledShieldRegen(Scaling scaledShieldRegen) {
        this.scaledShieldRegen = scaledShieldRegen;
    }

    public Scaling getScaledManaRegen() {
        return this.scaledManaRegen;
    }

    protected void setScaledManaRegen(Scaling scaledManaRegen) {
        this.scaledManaRegen = scaledManaRegen;
    }

    public Scaling getScaledStaminaRegen() {
        return this.scaledStaminaRegen;
    }

    protected void setScaledStaminaRegen(Scaling scaledStaminaRegen) {
        this.scaledStaminaRegen = scaledStaminaRegen;
    }

    public double getBaseMaxEquipmentWeight() {
        return this.baseMaxEquipmentWeight;
    }

    protected void setBaseMaxEquipmentWeight(double baseMaxEquipmentWeight) {
        this.baseMaxEquipmentWeight = baseMaxEquipmentWeight;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    @Override
    public int compareTo(HeroClass other) {
        return this.name.compareTo(other.name);
    }

    public void setIsUltimate(boolean isUltimate) {
        this.isUltimate = isUltimate;
    }

    public boolean isUltimate() {
        return this.isUltimate;
    }

    public void setUltimateInfo(int count, int min, int max) {
        this.ultimateInfo = new UltimateInfo(count, min, max);
    }

    public UltimateInfo getUltimateInfo() {
        return this.ultimateInfo;
    }

    @Deprecated
    public boolean runCommandAsConsole() {
        return this.onClassGainRunCommandsInfo.isRunCommandsAsConsole();
    }

    @Deprecated
    public List<String> getRunCommand() {
        return this.onClassGainRunCommandsInfo.getRunCommands();
    }

    @Deprecated
    public void setRunCommand(boolean asConsole, List<String> runCommands) {
        this.onClassGainRunCommandsInfo.setRunCommands(asConsole, runCommands);
    }

    public ClassRunCommandsInfo getOnClassGainRunCommandsInfo() {
        return this.onClassGainRunCommandsInfo;
    }

    @Deprecated
    public boolean onMasterRunCommandAsConsole() {
        return this.onMasterRunCommandsInfo.isRunCommandsAsConsole();
    }

    @Deprecated
    public List<String> getOnMasterRunCommands() {
        return this.onMasterRunCommandsInfo.getRunCommands();
    }

    @Deprecated
    public void setOnMasterRunCommands(boolean asConsole, List<String> runCommands) {
        this.onMasterRunCommandsInfo.setRunCommands(asConsole, runCommands);
    }

    public ClassRunCommandsInfo getOnMasterRunCommandsInfo() {
        return this.onMasterRunCommandsInfo;
    }

    public ClassRunCommandsInfo getOnClassLossRunCommandsInfo() {
        return this.onClassLossRunCommandsInfo;
    }

    public ClassRunCommandsInfo getOnFirstClassGainRunCommandsInfo() {
        return this.onFirstClassGainRunCommandsInfo;
    }

    public ClassRunCommandsInfo getOnFirstMasterRunCommandsInfo() {
        return this.onFirstMasterRunCommandsInfo;
    }

    public static enum ExperienceType {
        SKILL,
        KILLING,
        PVP,
        MINING,
        ENCHANTING,
        FARMING,
        CRAFTING,
        LOGGING,
        DEATH,
        ADMIN,
        EXTERNAL,
        FISHING,
        QUESTING,
        BUILDING,
        SHEARING,
        TAMING,
        BREEDING,
        BREWING,
        SMELTING,
        TRADE_PACK;

    }

    public static class ClassRunCommandsInfo {
        private boolean runCommandsAsConsole = false;
        private List<String> runCommands = null;
        private boolean override = false;
        private boolean ignoreDefault = true;

        private ClassRunCommandsInfo() {
        }

        public boolean isRunCommandsAsConsole() {
            return this.runCommandsAsConsole;
        }

        public List<String> getRunCommands() {
            return this.runCommands;
        }

        public boolean isOverride() {
            return this.override;
        }

        public boolean isIgnoreDefault() {
            return this.ignoreDefault;
        }

        public void setRunCommands(boolean asConsole, List<String> runCommands) {
            this.runCommandsAsConsole = asConsole;
            this.runCommands = runCommands == null ? Lists.newArrayList() : runCommands;
        }

        public void setOverride(boolean override) {
            this.override = override;
        }

        public void setIgnoreDefault(boolean ignoreDefault) {
            this.ignoreDefault = ignoreDefault;
        }
    }

    public class CircularParentException
    extends Exception {
    }

    public static class UltimateInfo {
        private int count;
        private int min;
        private int max;

        private UltimateInfo(int count, int min, int max) {
            this.count = count;
            this.min = min;
            this.max = max;
        }

        public int getCount() {
            return this.count;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }
    }
}

