/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.classes;

import com.google.common.base.Preconditions;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.util.Util;
import java.util.List;

public final class ClassSkill {
    public static final int MIN_SKILL_LEVEL = 1;
    public static final int MIN_PREPARE_COST = 0;
    private final HeroClass heroClass;
    private final Skill skill;
    private int useLevel;
    private int maxSkillLevel;
    private int[] prepareCosts;
    private boolean learnedUse;
    private boolean preparedUse;

    public ClassSkill(HeroClass heroClass, Skill skill) {
        this.heroClass = (HeroClass)Preconditions.checkNotNull((Object)heroClass);
        this.skill = (Skill)Preconditions.checkNotNull((Object)skill);
    }

    public HeroClass getHeroClass() {
        return this.heroClass;
    }

    public Skill getSkill() {
        return this.skill;
    }

    public int getUseLevel() {
        return this.useLevel;
    }

    public int getMaxSkillLevel() {
        return this.maxSkillLevel;
    }

    public int getPrepareCost(int skillLevel) {
        return this.prepareCosts[skillLevel - 1];
    }

    public boolean learnedUse() {
        return this.learnedUse;
    }

    public boolean preparedUse() {
        return this.preparedUse;
    }

    protected void reload() {
        this.useLevel = SkillConfigManager.getSetting(this.heroClass, this.skill, SkillSetting.LEVEL.node(), 1);
        this.maxSkillLevel = SkillConfigManager.getSetting(this.heroClass, this.skill, SkillSetting.MAX_SKILL_LEVEL.node(), 1);
        if (this.maxSkillLevel < 1) {
            this.maxSkillLevel = 1;
        }
        this.prepareCosts = new int[this.maxSkillLevel];
        List<String> prepareCostValues = SkillConfigManager.getSetting(this.heroClass, this.skill, SkillSetting.PREPARE_COST.node(), (List<String>)null);
        if (prepareCostValues != null) {
            int lastValue = 0;
            for (int i = 0; i < this.maxSkillLevel; ++i) {
                if (i < prepareCostValues.size() && (lastValue = Util.toInt(prepareCostValues.get(i), lastValue)) < 0) {
                    lastValue = 0;
                }
                this.prepareCosts[i] = lastValue;
            }
        } else {
            int singlePrepareCost = SkillConfigManager.getSetting(this.heroClass, this.skill, SkillSetting.PREPARE_COST.node(), 0);
            if (singlePrepareCost < 0) {
                singlePrepareCost = 0;
            }
            for (int i = 0; i < this.maxSkillLevel; ++i) {
                this.prepareCosts[i] = singlePrepareCost;
            }
        }
        this.learnedUse = SkillConfigManager.getSetting(this.heroClass, this.skill, SkillSetting.LEARNED_USE.node(), false);
        this.preparedUse = SkillConfigManager.getSetting(this.heroClass, this.skill, SkillSetting.PREPARED_USE.node(), false);
    }
}

