/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroRegainStaminaEvent;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.chat.ChatComponents;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

class StaminaUpdater
implements Runnable {
    private final CharacterManager manager;
    private final long updateInterval;
    private long lastTick;

    public StaminaUpdater(CharacterManager manager, long updateInterval) {
        this.manager = manager;
        this.updateInterval = updateInterval;
        this.lastTick = System.currentTimeMillis();
    }

    @Override
    public void run() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTick < this.updateInterval) {
            return;
        }
        this.lastTick = currentTime;
        for (Player player : Bukkit.getOnlinePlayers()) {
            Hero hero = this.manager.getHero(player);
            if (hero == null) continue;
            if (Heroes.properties.foodEnabled) {
                player.setSaturation(0.0f);
                player.setExhaustion(0.0f);
            }
            boolean skipLoop = hero.getEffects().stream().anyMatch(new Predicate<Effect>(){

                @Override
                public boolean test(Effect effect) {
                    return effect.isType(EffectType.STAMINA_FREEZING) || effect.isType(EffectType.STAMINA_REGEN_FREEZING);
                }
            });
            int stamina = hero.getStamina();
            int regen = hero.getStaminaRegen();
            if (stamina >= hero.getMaxStamina()) {
                if (!Heroes.properties.foodEnabled) continue;
                player.setFoodLevel(19);
                continue;
            }
            if (skipLoop) {
                hero.calculateFoodLevel();
                continue;
            }
            HeroRegainStaminaEvent event = new HeroRegainStaminaEvent(hero, regen, null);
            event.setSkipEffectCheck(true);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                if (!Heroes.properties.foodEnabled) continue;
                player.setFoodLevel(player.getFoodLevel());
                continue;
            }
            hero.setStamina(stamina + (Integer)event.getDelta());
            if (!hero.isVerboseStamina()) continue;
            player.sendMessage(ChatComponents.Bars.stamina(hero.getStamina(), hero.getMaxStamina(), true));
        }
    }
}

