/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.api.events.HeroRegainShieldEvent;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

class ShieldUpdater
implements Runnable {
    private final CharacterManager manager;
    private final long updateInterval;
    private final long delayAfterHit;
    private long lastUpdate = 0L;

    ShieldUpdater(CharacterManager manager, long updateInterval, long delayAfterHit) {
        this.manager = manager;
        this.updateInterval = updateInterval;
        this.delayAfterHit = delayAfterHit;
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        if (time < this.lastUpdate + this.updateInterval) {
            return;
        }
        this.lastUpdate = time;
        Collection<Hero> heroes = this.manager.getHeroes();
        for (Hero hero : heroes) {
            if (hero == null || !hero.getPlayer().isOnline() || time - hero.getLastDamageTaken() < this.delayAfterHit) continue;
            int regen = hero.getShieldRegen();
            float shield = hero.getShield();
            if (shield >= (float)hero.getMaxShield()) continue;
            HeroRegainShieldEvent event = new HeroRegainShieldEvent(hero, regen, null);
            event.setSkipEffectCheck(true);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            hero.setShield(shield + (float)((Integer)event.getDelta()).intValue());
        }
    }
}

