/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.annotation.NotThreadSafe;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.common.interfaces.Summon;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.nms.attribute.ICharacterAttribute;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Creature;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class Monster
extends CharacterTemplate {
    private final ICharacterAttribute attribDmg = NMSHandler.getInterface().createCharacterAttribute("Damage", (byte)-128);
    private final ICharacterAttribute attribExp = NMSHandler.getInterface().createCharacterAttribute("Experience", (byte)-127);
    private final ICharacterAttribute attribSpawnX = NMSHandler.getInterface().createCharacterAttribute("SpawnX", (byte)-126);
    private final ICharacterAttribute attribSpawnY = NMSHandler.getInterface().createCharacterAttribute("SpawnY", (byte)-125);
    private final ICharacterAttribute attribSpawnZ = NMSHandler.getInterface().createCharacterAttribute("SpawnZ", (byte)-124);
    private final ICharacterAttribute attribSpawnReason = NMSHandler.getInterface().createCharacterAttribute("FromSpawner", (byte)-123);
    private static final Vector centerOfMap = new Vector(0, 64, 0);
    public static final String SPAWNREASON_META_KEY = "Heroes: Spawn Reason";
    private double damage = 0.0;
    private int experience = -1;
    private CreatureSpawnEvent.SpawnReason spawnReason = null;
    private Location spawnPoint;

    public Monster(Heroes plugin, LivingEntity entity) {
        this(plugin, entity, null);
    }

    protected Monster(Heroes plugin, LivingEntity entity, @Nullable String name) {
        super(plugin, entity, name);
        double max;
        double damage;
        Location location = entity.getLocation();
        double spawnX = this.loadOrCreateAttrib(this.attribSpawnX, location.getX());
        double spawnY = this.loadOrCreateAttrib(this.attribSpawnY, location.getY());
        double spawnZ = this.loadOrCreateAttrib(this.attribSpawnZ, location.getZ());
        location = this.spawnPoint = new Location(location.getWorld(), spawnX, spawnY, spawnZ);
        double distance = Monster.getEffectiveDistance(location.toVector());
        this.damage = damage = plugin.getDamageManager().getEntityDamage(entity.getType());
        if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            switch (slime.getSize()) {
                case 1: {
                    if (slime instanceof MagmaCube) {
                        this.damage -= damage / 3.0;
                    } else {
                        this.damage = 0.0;
                        break;
                    }
                }
                case 2: {
                    this.damage -= damage / 3.0;
                    break;
                }
            }
        }
        Properties props = Heroes.properties;
        if (props.mobDamageDistanceModified) {
            double percent = 1.0 + props.mobDamageModifier / 100.0;
            double modifier = Math.pow(percent, distance / 100.0) + 0.0;
            this.damage = Math.ceil(damage * modifier);
            if (props.mobDamageDistanceModifiedUseMax && this.damage > props.mobDamageDistanceModifiedMax) {
                this.damage = props.mobDamageDistanceModifiedMax;
            }
        }
        this.damage = this.loadOrCreateAttrib(this.attribDmg, this.damage);
        if (props.mobExpDistanceModified) {
            Double exp = props.creatureKillingExp.get(entity.getType());
            this.experience = (int)Math.ceil(exp != null ? exp : 0.0);
            double percent = 1.0 + props.mobExpModifier / 100.0;
            double modifier = Math.pow(percent, distance / 100.0) + 0.0;
            this.experience = (int)Math.ceil((double)this.experience * modifier);
            if (props.mobExpDistanceModifiedUseMax && this.experience > props.mobExpDistanceModifiedMax) {
                this.experience = props.mobExpDistanceModifiedMax;
            }
            this.experience = (int)this.loadOrCreateAttrib(this.attribExp, this.experience);
        }
        if ((max = Monster.applyHealthChanges(entity)) > 0.0) {
            this.setMaxHealth(max);
        }
        this.spawnReason = entity.hasMetadata(SPAWNREASON_META_KEY) ? (CreatureSpawnEvent.SpawnReason)((MetadataValue)entity.getMetadata(SPAWNREASON_META_KEY).get(0)).value() : CreatureSpawnEvent.SpawnReason.DEFAULT;
        this.loadOrCreateAttrib(this.attribSpawnReason, this.spawnReason.ordinal());
    }

    public static double getEffectiveDistance(Vector position) {
        return position.distance(centerOfMap) - position.distance(centerOfMap) % 100.0;
    }

    public static double applyHealthChanges(LivingEntity entity) {
        if (entity.getHealth() != entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()) {
            return 0.0;
        }
        double defaultMaxHealth = Math.floor(Util.getDefaultMaxHealth(entity));
        if (Math.floor(entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()) == defaultMaxHealth || defaultMaxHealth == 0.0) {
            double maxHealth = Heroes.getInstance().getDamageManager().getEntityMaxHealth(entity);
            Properties props = Heroes.properties;
            if (props.mobHealthDistanceModified) {
                double percent = 1.0 + props.mobHealthModifier / 100.0;
                double modifier = Math.pow(percent, Monster.getEffectiveDistance(entity.getLocation().toVector()) / 100.0) + 0.0;
                maxHealth = Math.ceil(maxHealth * modifier);
                if (props.mobHealthDistanceModifiedUseMax && maxHealth > props.mobHealthDistanceModifiedMax) {
                    maxHealth = props.mobHealthDistanceModifiedMax;
                }
            }
            AttributeInstance maxHealthAttribute = entity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            maxHealthAttribute.setBaseValue(maxHealth);
            try {
                entity.setHealth(maxHealth);
            }
            catch (IllegalArgumentException e) {
                String endingString = props.mobHealthDistanceModified ? ", likely to account for increased mob health from Heroes's \"mob-health-distance-modified\" option." : ".";
                Heroes.log(Level.SEVERE, "Update spigot.yml config option \"settings.attribute.maxHealth.max\" to greater than " + maxHealth + endingString);
                throw e;
            }
            return maxHealth;
        }
        return 0.0;
    }

    public boolean isSummonedMob() {
        return this.hasEffectType(EffectType.SUMMON);
    }

    public Hero getSummoner() {
        for (Effect effect : this.getEffects()) {
            if (!effect.isType(EffectType.SUMMON) || !(effect instanceof Summon)) continue;
            return ((Summon)((Object)effect)).getSummoner();
        }
        return null;
    }

    @Override
    public boolean isAlliedTo(LivingEntity target) {
        if (target == null) {
            return false;
        }
        if (target.equals(this.getEntity())) {
            return true;
        }
        if (!this.isSummonedMob()) {
            return false;
        }
        Hero summoner = this.getSummoner();
        if (summoner == null) {
            return false;
        }
        return summoner.isAlliedTo(target);
    }

    public LivingEntity getCurrentTargetIfAble() {
        if (this.getEntity() instanceof Creature) {
            Creature mobSummon = (Creature)this.getEntity();
            return mobSummon.getTarget();
        }
        return null;
    }

    public void setTargetIfAble(LivingEntity newTarget) {
        this.setTargetIfAble(newTarget, true);
    }

    public void setTargetIfAble(LivingEntity newTarget, boolean anger) {
        if (this.lEntity instanceof Wolf) {
            Wolf wolf = (Wolf)this.lEntity;
            wolf.setAngry(false);
            if (anger) {
                wolf.setAngry(true);
            }
        } else if (this.lEntity instanceof PigZombie) {
            PigZombie pigZombie = (PigZombie)this.lEntity;
            pigZombie.setAngry(false);
            if (anger) {
                pigZombie.setAngry(true);
            }
        }
        if (this.lEntity instanceof Creature) {
            Creature mob = (Creature)this.lEntity;
            mob.setTarget(null);
            mob.setTarget(newTarget);
        }
    }

    @NotThreadSafe
    public boolean setMaxHealth(double health) {
        AttributeInstance maxHealthAttribute = this.lEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (this.lEntity.getHealth() != maxHealthAttribute.getValue() || health <= 0.0) {
            return false;
        }
        maxHealthAttribute.setBaseValue(health);
        this.lEntity.setHealth(health);
        return true;
    }

    @Deprecated
    @NotThreadSafe
    public boolean setMaxHealth(int health) {
        return this.setMaxHealth((double)health);
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double damage) {
        this.damage = damage;
        this.attribDmg.setValue(damage);
    }

    @Deprecated
    public void setDamage(int damage) {
        this.setDamage((double)damage);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LivingEntity) {
            return this.lEntity.equals(other);
        }
        if (other instanceof UUID) {
            return this.lEntity.getUniqueId().equals(other);
        }
        return other instanceof Monster && this.lEntity.getUniqueId().equals(((Monster)other).lEntity.getUniqueId());
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = experience;
        this.attribExp.setValue(experience);
    }

    public CreatureSpawnEvent.SpawnReason getSpawnReason() {
        return this.spawnReason == null ? CreatureSpawnEvent.SpawnReason.NATURAL : this.spawnReason;
    }

    public void setSpawnReason(CreatureSpawnEvent.SpawnReason reason) {
        this.spawnReason = reason;
        this.attribSpawnReason.setValue(reason.ordinal());
    }

    public Location getSpawnPoint() {
        return this.spawnPoint;
    }
}

