/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.HeroDamageCause;
import com.herocraftonline.heroes.api.annotation.NotThreadSafe;
import com.herocraftonline.heroes.api.annotation.ThreadSafe;
import com.herocraftonline.heroes.api.events.AttributeAllocationPointsChangeEvent;
import com.herocraftonline.heroes.api.events.CharacterRegainHealthEvent;
import com.herocraftonline.heroes.api.events.ExperienceChangeEvent;
import com.herocraftonline.heroes.api.events.HeroChangeLevelEvent;
import com.herocraftonline.heroes.api.events.HeroRegainHealthEvent;
import com.herocraftonline.heroes.api.events.HeroRegainManaEvent;
import com.herocraftonline.heroes.api.events.HeroRegainShieldEvent;
import com.herocraftonline.heroes.api.events.HeroRegainStaminaEvent;
import com.herocraftonline.heroes.api.events.ManaChangeEvent;
import com.herocraftonline.heroes.api.events.ShieldChangeEvent;
import com.herocraftonline.heroes.api.events.SkillPrepareEvent;
import com.herocraftonline.heroes.api.events.SkillUnprepareEvent;
import com.herocraftonline.heroes.api.events.StaminaChangeEvent;
import com.herocraftonline.heroes.attributes.AttributeSet;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.classes.ClassSkill;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.classes.scaling.Scaling;
import com.herocraftonline.heroes.characters.effects.CombatEffect;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.common.AttributeDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.AttributeIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.ManaRegenDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.ManaRegenIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.ManaRegenPercentDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.ManaRegenPercentIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxHealthDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxHealthIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxHealthPercentDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxHealthPercentIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxManaDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxManaIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxManaPercentDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxManaPercentIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxShieldDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxShieldIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxShieldPercentDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxShieldPercentIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxStaminaDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxStaminaIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxStaminaPercentDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.MaxStaminaPercentIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.ShieldRegenDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.ShieldRegenIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.ShieldRegenPercentDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.ShieldRegenPercentIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.StaminaRegenDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.StaminaRegenIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.StaminaRegenPercentDecreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.StaminaRegenPercentIncreaseEffect;
import com.herocraftonline.heroes.characters.effects.common.interfaces.WalkSpeedDecrease;
import com.herocraftonline.heroes.characters.effects.common.interfaces.WalkSpeedIncrease;
import com.herocraftonline.heroes.characters.effects.common.interfaces.WalkSpeedPercentDecrease;
import com.herocraftonline.heroes.characters.effects.common.interfaces.WalkSpeedPercentIncrease;
import com.herocraftonline.heroes.characters.equipment.EquipmentType;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.DelayedSkill;
import com.herocraftonline.heroes.characters.skill.HeroSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.CommandHandler;
import com.herocraftonline.heroes.feature.roll.ItemRollType;
import com.herocraftonline.heroes.feature.scoreboard.ScoreboardFeature;
import com.herocraftonline.heroes.items.attributes.AttributeAttribute;
import com.herocraftonline.heroes.items.attributes.HealthAttribute;
import com.herocraftonline.heroes.items.attributes.ManaAttribute;
import com.herocraftonline.heroes.items.attributes.ManaRegenAttribute;
import com.herocraftonline.heroes.items.attributes.StaminaAttribute;
import com.herocraftonline.heroes.items.attributes.StaminaRegenAttribute;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.storage.Storage;
import com.herocraftonline.heroes.ui.CooldownActionBarComponent;
import com.herocraftonline.heroes.ui.scoreboard.HeroInfoComponent;
import com.herocraftonline.heroes.ui.scoreboard.PartyComponent;
import com.herocraftonline.heroes.util.EquipmentUtil;
import com.herocraftonline.heroes.util.MaterialUtil;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.TextUtil;
import com.herocraftonline.heroes.util.Util;
import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.equipment.EquipmentManager;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.ItemManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import to.hc.common.bukkit.ui.ActionBar;
import to.hc.common.bukkit.ui.ManagedScoreboard;

public class Hero
extends CharacterTemplate {
    protected final AtomicInteger mana = new AtomicInteger(0);
    protected final AtomicInteger maxShield = new AtomicInteger(0);
    protected final AtomicInteger shieldRegen = new AtomicInteger(0);
    protected final AtomicInteger maxMana = new AtomicInteger(0);
    protected final AtomicInteger manaRegen = new AtomicInteger(0);
    protected final AtomicInteger stamina = new AtomicInteger(0);
    protected final AtomicInteger maxStamina = new AtomicInteger(0);
    protected final AtomicInteger staminaRegen = new AtomicInteger(0);
    protected volatile double maxEquipmentWeight = 0.0;
    protected final Map<String, AttributeSet> allocatedAttributes = new ConcurrentHashMap<String, AttributeSet>();
    protected final Map<String, AtomicInteger> allocationPoints = new ConcurrentHashMap<String, AtomicInteger>();
    protected final Map<String, Double> experience = new ConcurrentHashMap<String, Double>();
    protected final List<String> masteredClasses = new ArrayList<String>();
    protected final Map<String, Long> cooldowns = new ConcurrentHashMap<String, Long>();
    protected final Set<Monster> summons = new HashSet<Monster>();
    protected final Map<Material, String[]> binds = new ConcurrentHashMap<Material, String[]>();
    protected final Set<String> suppressedSkills = ConcurrentHashMap.newKeySet();
    protected final Map<String, ConfigurationSection> persistedSkillSettings = new ConcurrentHashMap<String, ConfigurationSection>();
    protected final Map<String, Map<String, HeroSkill>> heroSkills = new HashMap<String, Map<String, HeroSkill>>();
    protected final Set<String> preparedSkills = new HashSet<String>();
    protected int usedSkillPreparePoints = 0;
    protected boolean lazyRecalculateUsedSkillPreparePoints = false;
    protected final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final CombatEffect combat;
    protected final Map<String, Integer> manaMap = new ConcurrentHashMap<String, Integer>();
    protected final Map<String, Integer> staminaMap = new ConcurrentHashMap<String, Integer>();
    @Nullable
    public ItemRollType itemRollType = ItemRollType.NEED;
    @Nullable
    protected ManagedScoreboard scoreboard;
    protected ActionBar recordBar;
    protected HeroClass heroClass;
    protected HeroClass secondClass;
    protected HeroClass raceClass;
    protected HeroParty party = null;
    protected boolean verboseExp = true;
    protected boolean verboseMana = true;
    protected boolean verboseStamina = false;
    protected boolean verboseSkills = true;
    protected HeroDamageCause lastDamageCause = null;
    protected long lastDamageTaken = 0L;
    protected AttributeSet baseAttributeSet = new AttributeSet();
    protected AttributeSet lastItemSet = new AttributeSet();
    protected AttributeSet currAttributeSet = new AttributeSet();
    protected long itemUpdateTick = 0L;
    protected boolean syncPrimary = true;
    protected Integer tieredLevel;
    protected final PermissionAttachment transientPerms;
    protected DelayedSkill delayedSkill = null;
    protected LinkedList<Runnable> permissionTasks;
    protected boolean permissionUpdateScheduled;
    protected Storage storage;
    protected boolean initFlag;
    protected CharacterDamageManager.EquippedWeaponStats equippedWeapon = null;
    private Player player;
    private boolean disconnecting = false;
    private CharacterDamageManager damageManager;
    private int databaseID;

    public Hero(Heroes plugin, Player player, Storage storage, HeroClass heroClass, HeroClass secondClass, HeroClass raceClass) {
        this(plugin, player, storage, heroClass, secondClass, raceClass, 0);
    }

    public Hero(Heroes plugin, final Player player, Storage storage, HeroClass heroClass, HeroClass secondClass, HeroClass raceClass, int databaseID) {
        super(plugin, (LivingEntity)player, player.getName());
        this.player = player;
        this.storage = storage;
        this.heroClass = heroClass;
        this.secondClass = secondClass;
        this.raceClass = raceClass;
        this.databaseID = databaseID;
        this.initFlag = false;
        this.damageManager = plugin.getDamageManager();
        this.initializeAllocationPoints(heroClass);
        this.initializeClassAttributeAllocations(heroClass);
        this.combat = new CombatEffect(plugin);
        this.addEffect(this.combat);
        this.transientPerms = player.addAttachment((Plugin)plugin);
        this.permissionTasks = new LinkedList();
        this.permissionUpdateScheduled = false;
        ScoreboardFeature scoreboardFeature = this.plugin.getScoreboardFeature();
        if (scoreboardFeature != null) {
            this.scoreboard = scoreboardFeature.getScoreboard(this.player);
            this.scoreboard.addComponent(HeroInfoComponent.SELF);
            this.scoreboard.addComponent(PartyComponent.SELF);
        }
        this.recordBar = this.plugin.getUIManager().getActionBar(this.player);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                for (Runnable run : Hero.this.permissionTasks) {
                    run.run();
                }
                Hero.this.permissionTasks = null;
                player.recalculatePermissions();
            }
        }, 6L);
    }

    public UUID getUUID() {
        return this.player.getUniqueId();
    }

    public void postInit() {
        this.initFlag = true;
        this.recordBar.add(CooldownActionBarComponent.SELF);
        NMSHandler.getInterface().injectAbsorptionHeartWatcher(this.player);
        this.renderVisualComponents();
    }

    public int getDatabaseID() {
        return this.databaseID;
    }

    public void calculateEquippedItem() {
        ItemStack heldItem = this.player.getInventory().getItemInMainHand();
        if (this.equippedWeapon == null || !this.equippedWeapon.getWeapon().equals((Object)heldItem)) {
            this.equippedWeapon = this.damageManager.createWeaponStats(this, heldItem);
        }
    }

    public CharacterDamageManager.EquippedWeaponStats getCurrentEquippedWeapon() {
        return this.equippedWeapon;
    }

    public CharacterDamageManager.EquippedWeaponStats getEquippedWeaponStats() {
        this.calculateEquippedItem();
        return this.equippedWeapon;
    }

    @Nullable
    public ManagedScoreboard getScoreboard() {
        return this.scoreboard;
    }

    public ActionBar getRecordBar() {
        return this.recordBar;
    }

    public void renderVisualComponents() {
        float maxShield = this.getScaledMaxShield();
        if (maxShield > 0.0f) {
            NMSHandler.getInterface().sendAbsorptionHearts(this.player, maxShield);
        }
        if (this.scoreboard != null) {
            this.scoreboard.start();
            this.scoreboard.render();
        }
        if (this.initFlag) {
            this.recordBar.render();
        }
    }

    public void resetMaxHP() {
        double maxHealth = this.resolveMaxHealth();
        this.player.setHealthScaled(true);
        if (Heroes.properties.oneHealthBar) {
            this.player.setHealthScale(20.0);
        } else {
            double scale = maxHealth / Heroes.properties.healthPerBar * 20.0;
            int roundedScale = (int)Math.round(scale);
            if (roundedScale % 2 != 0) {
                ++roundedScale;
            }
            this.player.setHealthScale((double)roundedScale);
        }
    }

    @Override
    public void heal(double amount) {
        super.heal(amount);
        this.renderVisualComponents();
    }

    @Deprecated
    public void heal(int amount) {
        this.heal(Math.floor(amount));
    }

    @Override
    protected CharacterRegainHealthEvent getRegainHealthEvent(CharacterTemplate healer, double amount, Skill skill) {
        return new HeroRegainHealthEvent(this, amount, skill, healer);
    }

    public void resetMaxShield() {
        this.resolveMaxShield();
    }

    public void healShield(float amount) {
        float current = this.getShield();
        int max = this.getMaxShield();
        if (this.player.isDead() || this.player.getHealth() <= 0.0) {
            return;
        }
        if (current + amount > (float)max) {
            this.setShield(max);
        } else {
            this.setShield(current + amount);
        }
    }

    public boolean tryHealShield(Hero restorer, @Nullable Skill skill, int amount) {
        return this.tryHealShield(restorer, skill, amount, false);
    }

    public boolean tryHealShield(Hero restorer, @Nullable Skill skill, int amount, boolean sendShieldBar) {
        HeroRegainShieldEvent hrsEvent = new HeroRegainShieldEvent(restorer, amount, skill);
        this.plugin.getServer().getPluginManager().callEvent((Event)hrsEvent);
        if (hrsEvent.isCancelled()) {
            return false;
        }
        this.setShield((float)((Integer)hrsEvent.getDelta()).intValue() + this.getShield());
        if (sendShieldBar) {
            this.player.sendMessage(ChatComponents.Bars.shield(this.getShield(), this.getMaxShield(), false));
        }
        return true;
    }

    @Deprecated
    public boolean tryHealShield(@Nullable Skill skill, int amount) {
        return this.tryHealShield(this, skill, amount);
    }

    @Deprecated
    public boolean tryHealShield(@Nullable Skill skill, int amount, boolean sendShieldBar) {
        return this.tryHealShield(this, skill, amount, sendShieldBar);
    }

    public boolean tryRestoreMana(Hero restorer, @Nullable Skill skill, int amount) {
        return this.tryRestoreMana(restorer, skill, amount, true);
    }

    public boolean tryRestoreMana(Hero restorer, @Nullable Skill skill, int amount, boolean sendManaBar) {
        HeroRegainManaEvent hrmEvent = new HeroRegainManaEvent(restorer, amount, skill);
        this.plugin.getServer().getPluginManager().callEvent((Event)hrmEvent);
        if (hrmEvent.isCancelled()) {
            return false;
        }
        this.setMana((Integer)hrmEvent.getDelta() + this.getMana());
        if (sendManaBar && this.isVerboseMana()) {
            this.player.sendMessage(ChatComponents.Bars.mana(this.getMana(), this.getMaxMana(), false));
        }
        return true;
    }

    @Deprecated
    public boolean tryRestoreMana(@Nullable Skill skill, int amount) {
        return this.tryRestoreMana(this, skill, amount);
    }

    @Deprecated
    public boolean tryRestoreMana(@Nullable Skill skill, int amount, boolean sendManaBar) {
        return this.tryRestoreMana(this, skill, amount, sendManaBar);
    }

    public boolean tryRestoreStamina(Hero restorer, @Nullable Skill skill, int amount) {
        return this.tryRestoreStamina(restorer, skill, amount, true);
    }

    public boolean tryRestoreStamina(Hero restorer, @Nullable Skill skill, int amount, boolean sendStaminaBar) {
        HeroRegainStaminaEvent hrsEvent = new HeroRegainStaminaEvent(restorer, amount, skill);
        this.plugin.getServer().getPluginManager().callEvent((Event)hrsEvent);
        if (hrsEvent.isCancelled()) {
            return false;
        }
        this.setStamina((Integer)hrsEvent.getDelta() + this.getStamina());
        if (sendStaminaBar && this.isVerboseStamina()) {
            this.player.sendMessage(ChatComponents.Bars.stamina(this.getStamina(), this.getMaxStamina(), false));
        }
        return true;
    }

    @Deprecated
    public boolean tryRestoreStamina(@Nullable Skill skill, int amount) {
        return this.tryRestoreStamina(this, skill, amount);
    }

    @Deprecated
    public boolean tryRestoreStamina(@Nullable Skill skill, int amount, boolean sendStaminaBar) {
        return this.tryRestoreStamina(this, skill, amount, sendStaminaBar);
    }

    public void addPermission(final String permission) {
        if (this.permissionTasks != null) {
            this.permissionTasks.add(new Runnable(){

                @Override
                public void run() {
                    Hero.this.transientPerms.setPermission(permission, true);
                }
            });
        } else {
            this.transientPerms.setPermission(permission, true);
            if (!this.permissionUpdateScheduled) {
                this.permissionUpdateScheduled = true;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Hero.this.player.recalculatePermissions();
                        Hero.this.permissionUpdateScheduled = false;
                    }
                });
            }
        }
    }

    public void addPermission(final Permission permission) {
        if (this.permissionTasks != null) {
            this.permissionTasks.add(new Runnable(){

                @Override
                public void run() {
                    Hero.this.transientPerms.setPermission(permission.getName(), true);
                }
            });
        } else {
            this.transientPerms.setPermission(permission.getName(), true);
            if (!this.permissionUpdateScheduled) {
                this.permissionUpdateScheduled = true;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Hero.this.player.recalculatePermissions();
                        Hero.this.permissionUpdateScheduled = false;
                    }
                });
            }
        }
    }

    @NotThreadSafe
    public boolean hasExperienceType(HeroClass.ExperienceType type) {
        boolean val = false;
        try {
            this.rwl.readLock().lock();
            val = this.heroClass.hasExperiencetype(type) || this.secondClass != null && this.secondClass.hasExperiencetype(type);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public boolean canGain(HeroClass.ExperienceType type) {
        if (type == HeroClass.ExperienceType.ADMIN) {
            return true;
        }
        boolean prim = false;
        boolean prof = false;
        boolean race = false;
        try {
            this.rwl.readLock().lock();
            if (this.heroClass.hasExperiencetype(type)) {
                boolean bl = prim = !this.isMaster(this.heroClass) || Properties.padMaxLevel && this.getExperience(this.heroClass) < (double)(Properties.maxExp - 1);
            }
            if (this.secondClass != null && this.secondClass.hasExperiencetype(type)) {
                boolean bl = prof = !this.isMaster(this.secondClass) || Properties.padMaxLevel && this.getExperience(this.secondClass) < (double)(Properties.maxExp - 1);
            }
            if (this.raceClass != null && this.raceClass.hasExperiencetype(type)) {
                race = !this.isMaster(this.raceClass) || Properties.padMaxLevel && this.getExperience(this.raceClass) < (double)(Properties.maxExp - 1);
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return prim || prof || race;
    }

    @ThreadSafe
    public void bind(Material material, String[] skillName) {
        if (material == Material.AIR || material == null) {
            return;
        }
        this.storage.saveHeroBind(this, material, skillName);
        this.binds.put(material, skillName);
    }

    public void changeHeroClass(HeroClass heroClass, boolean secondary, boolean race) {
        this.silentClearEffects(false);
        this.clearSummons();
        this.clearBinds();
        this.setHeroClass(heroClass, secondary, race);
        if (Heroes.properties.prefixClassName) {
            this.player.setDisplayName("[" + this.getHeroClass().getName() + "]" + this.player.getName());
        }
        this.plugin.getCharacterManager().checkAllListeners(this);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Hero.this.plugin.getCharacterManager().performSkillChecks(Hero.this);
            }
        }, 4L);
    }

    @ThreadSafe
    public void clearBinds() {
        this.binds.clear();
        this.storage.clearHeroBinds(this);
    }

    @ThreadSafe
    public void clearCooldowns() {
        this.cooldowns.clear();
        this.storage.clearHeroCooldowns(this);
    }

    @ThreadSafe
    public void clearExperience() {
        for (Map.Entry<String, Double> entry : this.experience.entrySet()) {
            entry.setValue(0.0);
        }
        this.storage.resetHeroExperience(this);
    }

    public void clearMasteries() {
        this.masteredClasses.clear();
        this.storage.resetHeroMasteries(this);
    }

    public void clearSummons() {
        HashSet<Monster> clonedSummons = new HashSet<Monster>(this.summons);
        try {
            for (Monster summon : clonedSummons) {
                summon.clearEffects(true);
                if (summon.getEntity() == null) continue;
                summon.getEntity().remove();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.summons.clear();
        clonedSummons.clear();
    }

    public void clearClassAttributeAllocations() {
        AttributeSet currentAllocatedAttributes = this.allocatedAttributes.get(this.getHeroClass().getName());
        if (currentAllocatedAttributes != null) {
            currentAllocatedAttributes.reset();
        } else {
            this.allocatedAttributes.put(this.getHeroClass().getName(), new AttributeSet());
        }
        this.storage.resetHeroAttribute(this);
        this.rebuildAttributes();
    }

    public void clearAllClassAttributeAllocations() {
        for (Map.Entry<String, AttributeSet> entry : this.allocatedAttributes.entrySet()) {
            entry.getValue().reset();
        }
        this.storage.resetHeroAttribute(this);
        this.rebuildAttributes();
    }

    public void clearAllClassAllocationPoints() {
        for (Map.Entry<String, AtomicInteger> entry : this.allocationPoints.entrySet()) {
            entry.getValue().set(0);
        }
        this.storage.resetHeroAllocationPoint(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Hero that = (Hero)other;
        return !(this.player == null ? that.player != null : !this.name.equals(that.name));
    }

    public void addExp(double expChange, HeroClass hc, Location loc) {
        double currentExp = this.getExperience(hc);
        double exp = currentExp + expChange;
        if (exp < 0.0) {
            exp = 0.0;
        }
        int currentLevel = this.getHeroLevel(hc);
        this.setExperience(hc, exp);
        ExperienceChangeEvent expEvent = new ExperienceChangeEvent(this, hc, expChange, HeroClass.ExperienceType.ADMIN, loc);
        this.plugin.getServer().getPluginManager().callEvent((Event)expEvent);
        this.syncExperience();
        int newLevel = Properties.getLevel(exp);
        if (currentLevel != newLevel) {
            if (newLevel > hc.getMaxLevel()) {
                this.setExperience(hc, currentExp);
                this.syncExperience();
                return;
            }
            boolean isMastering = false;
            if (newLevel == hc.getMaxLevel()) {
                this.setExperience(hc, Properties.getTotalExp(hc.getMaxLevel()));
                if (!this.hasMastered(hc)) {
                    isMastering = true;
                    this.setMastered(hc);
                    this.plugin.getServer().broadcastMessage(this.player.getName() + ChatColor.GRAY + " has become a master " + ChatColor.DARK_AQUA + hc.getName() + ChatColor.GRAY + "!");
                    this.handleOnMasteryRunCommands(hc);
                }
            }
            if (newLevel > currentLevel) {
                this.player.sendMessage(ChatColor.GRAY + "You gained a level! (Lvl " + ChatColor.WHITE + newLevel + " " + hc.getName() + ChatColor.GRAY + ")");
                this.resetMaxHP();
                this.resetMaxShield();
                Properties prop = Heroes.properties;
                if (prop.onLevelUpRestoreHealth && this.player.getHealth() < this.getMaxHealth()) {
                    this.player.setHealth(this.getMaxHealth());
                }
                if (prop.onLevelUpRestoreShield && this.getShield() < (float)this.getMaxShield()) {
                    this.setShield(this.getMaxShield());
                }
                if (prop.onLevelUpRestoreStamina && this.getStamina() < this.getMaxStamina()) {
                    this.setStamina(this.getMaxStamina());
                }
                if (prop.onLevelUpRestoreMana && this.getMana() < this.getMaxMana()) {
                    this.setMana(this.getMaxMana());
                }
                this.getTieredLevel(true);
            } else {
                this.resetMaxHP();
                this.resetMaxShield();
                this.player.sendMessage(ChatColor.GRAY + "You lost a level! (Lvl " + ChatColor.WHITE + newLevel + " " + hc.getName() + ChatColor.GRAY + ")");
            }
            HeroChangeLevelEvent event = new HeroChangeLevelEvent(this, hc, currentLevel, newLevel, isMastering);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
        }
        this.syncExperience();
    }

    public void gainExp(double expChange, HeroClass.ExperienceType source, Location loc) {
        HeroClass[] classes;
        if (this.player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Properties prop = Heroes.properties;
        for (HeroClass hc : classes = new HeroClass[]{this.getHeroClass(), this.getSecondaryClass(), this.getRaceClass()}) {
            if (hc == null || source != HeroClass.ExperienceType.ADMIN && !hc.hasExperiencetype(source)) continue;
            double gainedExp = expChange;
            double exp = this.getExperience(hc);
            if (gainedExp > 0.0 && source != HeroClass.ExperienceType.ADMIN) {
                gainedExp *= hc.getExpModifier();
            } else if (!(source == HeroClass.ExperienceType.ADMIN || source == HeroClass.ExperienceType.ENCHANTING || !this.isMaster(hc) || prop.masteryLoss && prop.levelsViaExpLoss)) {
                return;
            }
            if (gainedExp > 0.0 && System.currentTimeMillis() < prop.expiration) {
                gainedExp *= prop.expBonus;
            }
            ExperienceChangeEvent expEvent = new ExperienceChangeEvent(this, hc, gainedExp, source, loc);
            this.plugin.getServer().getPluginManager().callEvent((Event)expEvent);
            if (expEvent.isCancelled()) continue;
            gainedExp = expEvent.getExpChange();
            int currentLevel = Properties.getLevel(exp);
            int newLevel = Properties.getLevel(exp + gainedExp);
            if (this.isMaster(hc) && source != HeroClass.ExperienceType.ADMIN && source != HeroClass.ExperienceType.ENCHANTING && !prop.masteryLoss && !Properties.padMaxLevel) {
                gainedExp = 0.0;
                continue;
            }
            if (currentLevel > 1 && currentLevel > newLevel && !prop.levelsViaExpLoss && source != HeroClass.ExperienceType.ADMIN && source != HeroClass.ExperienceType.ENCHANTING) {
                gainedExp = (double)Properties.getTotalExp(currentLevel) - (exp - 1.0);
            } else if (this.isMaster(hc) && newLevel > currentLevel) {
                gainedExp = 0.0;
                continue;
            }
            exp += gainedExp;
            if (exp < 0.0) {
                gainedExp = -exp;
                exp = 0.0;
            } else if (exp > (double)Properties.maxExp) {
                exp = Properties.maxExp;
            }
            newLevel = Properties.getLevel(exp);
            this.setExperience(hc, exp);
            if (gainedExp == 0.0) continue;
            if (this.isVerboseExp() && gainedExp > 0.0) {
                Messaging.send((CommandSender)this.player, "$1: Gained $2 Exp", hc.getName(), Util.decFormat.format(gainedExp));
            } else if (this.isVerboseExp() && gainedExp < 0.0) {
                Messaging.send((CommandSender)this.player, "$1: Lost $2 Exp", hc.getName(), Util.decFormat.format(-gainedExp));
            }
            if (newLevel != currentLevel && newLevel <= hc.getMaxLevel()) {
                boolean isMastering = false;
                if (newLevel == hc.getMaxLevel() && !this.hasMastered(hc)) {
                    isMastering = true;
                    this.setMastered(hc);
                    this.plugin.getServer().broadcastMessage(this.player.getName() + ChatColor.GRAY + " has become a master " + ChatColor.DARK_AQUA + hc.getName() + ChatColor.GRAY + "!");
                    this.handleOnMasteryRunCommands(hc);
                }
                HeroChangeLevelEvent hLEvent = new HeroChangeLevelEvent(this, hc, currentLevel, newLevel, isMastering);
                this.plugin.getServer().getPluginManager().callEvent((Event)hLEvent);
                if (newLevel > currentLevel) {
                    this.resetMaxHP();
                    Messaging.send((CommandSender)this.player, "You gained a level! (Lvl $1 $2)", String.valueOf(newLevel), hc.getName());
                    if (this.player.getHealth() > 0.0) {
                        this.resetMaxHP();
                        this.resetMaxShield();
                        if (prop.onLevelUpRestoreHealth && this.player.getHealth() < this.getMaxHealth()) {
                            this.player.setHealth(this.getMaxHealth());
                        }
                        if (prop.onLevelUpRestoreShield && this.getShield() < (float)this.getMaxShield()) {
                            this.setShield(this.getMaxShield());
                        }
                        if (prop.onLevelUpRestoreStamina && this.getStamina() < this.getMaxStamina()) {
                            this.setStamina(this.getMaxStamina());
                        }
                        if (prop.onLevelUpRestoreMana && this.getMana() < this.getMaxMana()) {
                            this.setMana(this.getMaxMana());
                        }
                    }
                    this.getTieredLevel(true);
                } else {
                    this.resetMaxHP();
                    this.resetMaxShield();
                    Messaging.send((CommandSender)this.player, "You lost a level! (Lvl $1 $2)", String.valueOf(newLevel), hc.getName());
                }
            }
            this.storage.saveHeroXP(this, hc);
        }
        this.syncExperience();
    }

    private void handleOnMasteryRunCommands(HeroClass hc) {
        boolean isPrimary = hc.isPrimary();
        boolean isSecondary = hc.isSecondary();
        boolean isRace = hc.isRace();
        boolean isDefaultClass = isPrimary && hc.isDefault() || isSecondary && hc.isDefaultProf() || isRace && hc.isDefaultRace();
        boolean ignoreDefaultAsFirstMastery = hc.getOnFirstMasterRunCommandsInfo().isIgnoreDefault();
        boolean firstMasteredClass = true;
        for (HeroClass heroClass : this.plugin.getClassManager().getClasses()) {
            if (heroClass.equals(hc) || ignoreDefaultAsFirstMastery && (isPrimary && heroClass.isDefault() || isSecondary && heroClass.isDefaultProf() || isRace && heroClass.isDefaultRace()) || !(isPrimary && heroClass.isPrimary() || isSecondary && heroClass.isSecondary()) && (!isRace || !heroClass.isRace()) || !this.isMaster(heroClass)) continue;
            firstMasteredClass = false;
            break;
        }
        if (isDefaultClass && ignoreDefaultAsFirstMastery || !firstMasteredClass) {
            this.handleRunCommands(hc.getOnMasterRunCommandsInfo());
        } else {
            HeroClass.ClassRunCommandsInfo onFirstMasterRunCommandsInfo = hc.getOnFirstMasterRunCommandsInfo();
            if (!onFirstMasterRunCommandsInfo.isOverride()) {
                this.handleRunCommands(hc.getOnMasterRunCommandsInfo());
            }
            this.handleRunCommands(onFirstMasterRunCommandsInfo);
        }
    }

    private void handleRunCommands(HeroClass.ClassRunCommandsInfo classRunCommandsInfo) {
        Player commandSource = classRunCommandsInfo.isRunCommandsAsConsole() ? this.plugin.getServer().getConsoleSender() : this.player;
        List<String> commands = classRunCommandsInfo.getRunCommands();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.lambda$handleRunCommands$0(commands, (CommandSender)commandSource), 5L);
    }

    public double currentXPToNextLevel(HeroClass hc) {
        return this.getExperience(hc) - (double)Properties.getTotalExp(this.getHeroLevel(hc));
    }

    protected double calculateXPLoss(double multiplier, HeroClass hc) {
        double expForNext = Properties.getExp(this.getHeroLevel(hc) + 1);
        double currentPercent = this.currentXPToNextLevel(hc) / expForNext;
        if (currentPercent >= multiplier) {
            return expForNext * multiplier;
        }
        double loss = expForNext * currentPercent;
        multiplier -= currentPercent;
        int i = 0;
        while (this.getHeroLevel(hc) - i > 1) {
            if (1.0 >= multiplier) {
                return loss + (double)Properties.getExp(this.getHeroLevel(hc) - i) * multiplier;
            }
            loss += (double)Properties.getExp(this.getHeroLevel(hc) - i);
            multiplier -= 1.0;
            ++i;
        }
        return loss;
    }

    public void loseExpFromDeath(double multiplier, boolean pvp) {
        if (this.player.getGameMode() == GameMode.CREATIVE || multiplier <= 0.0) {
            return;
        }
        Properties prop = Heroes.properties;
        HeroClass[] classes = new HeroClass[]{this.getHeroClass(), this.getSecondaryClass(), this.getRaceClass()};
        if (prop.resetOnDeath) {
            this.clearExperience();
            this.setHeroClass(this.plugin.getClassManager().getDefaultProfession(), true, false);
            this.setHeroClass(this.plugin.getClassManager().getDefaultClass(), false, false);
            Messaging.send((CommandSender)this.player, "You've lost all your experience and have been reset to $1 for dying!", this.plugin.getClassManager().getDefaultClass().getName());
            this.plugin.getCharacterManager().saveHero(this, false);
            this.syncExperience();
            return;
        }
        for (HeroClass hc : classes) {
            double newExp;
            if (hc == null) continue;
            double mult = multiplier;
            if (pvp && hc.getPvpExpLoss() != -1.0) {
                mult = hc.getPvpExpLoss();
            } else if (!pvp && hc.getExpLoss() != -1.0) {
                mult = hc.getExpLoss();
            }
            int currentLvl = this.getHeroLevel(hc);
            double currentExp = this.getExperience(hc);
            double currentLvlExp = Properties.getTotalExp(currentLvl);
            double gainedExp = -this.calculateXPLoss(mult, hc);
            if (gainedExp + currentExp < currentLvlExp && !prop.levelsViaExpLoss) {
                gainedExp = -(currentExp - currentLvlExp);
            }
            ExperienceChangeEvent expEvent = new ExperienceChangeEvent(this, hc, gainedExp, HeroClass.ExperienceType.DEATH, this.player.getLocation());
            this.plugin.getServer().getPluginManager().callEvent((Event)expEvent);
            if (expEvent.isCancelled()) continue;
            gainedExp = expEvent.getExpChange();
            int newLevel = Properties.getLevel(currentExp + gainedExp);
            if (this.isMaster(hc) && !prop.masteryLoss) continue;
            if (currentLvl > newLevel && !prop.levelsViaExpLoss) {
                gainedExp = currentLvlExp - (currentExp - 1.0);
            }
            if ((newExp = currentExp + gainedExp) < 0.0) {
                gainedExp = -currentExp;
                newExp = 0.0;
            }
            newLevel = Properties.getLevel(newExp);
            this.setExperience(hc, newExp);
            if (gainedExp == 0.0) continue;
            if (this.isVerboseExp() && gainedExp < 0.0) {
                Messaging.send((CommandSender)this.player, "$1: Lost $2 Exp", hc.getName(), Util.decFormat.format(-gainedExp));
            }
            if (newLevel == currentLvl) continue;
            HeroChangeLevelEvent hLEvent = new HeroChangeLevelEvent(this, hc, currentLvl, newLevel);
            this.plugin.getServer().getPluginManager().callEvent((Event)hLEvent);
            if (newLevel >= hc.getMaxLevel()) {
                this.setExperience(hc, Properties.getTotalExp(hc.getMaxLevel()));
                this.plugin.getServer().broadcastMessage(this.player.getName() + ChatColor.GRAY + " has become a master " + ChatColor.DARK_AQUA + hc.getName() + ChatColor.GRAY + "!");
            }
            this.resetMaxHP();
            this.resetMaxShield();
            Messaging.send((CommandSender)this.player, "You lost a level! (Lvl $1 $2)", String.valueOf(newLevel), hc.getName());
        }
        this.syncExperience();
    }

    @Override
    @ThreadSafe
    public String getName() {
        return this.name;
    }

    @ThreadSafe
    public String[] getBind(Material mat) {
        return this.binds.get(mat);
    }

    @ThreadSafe
    public Map<Material, String[]> getBinds() {
        return Collections.unmodifiableMap(this.binds);
    }

    @ThreadSafe
    public Long getCooldown(String name) {
        return this.cooldowns.get(name.toLowerCase());
    }

    @ThreadSafe
    public Map<String, Long> getCooldowns() {
        return Collections.unmodifiableMap(this.cooldowns);
    }

    @ThreadSafe
    public double getExperience(HeroClass heroClass) {
        if (heroClass == null) {
            return 0.0;
        }
        Double exp = this.experience.get(heroClass.getName());
        return exp == null ? 0.0 : exp;
    }

    @ThreadSafe
    public Map<String, Double> getExperienceMap() {
        return Collections.unmodifiableMap(this.experience);
    }

    public HeroClass getHeroClass() {
        this.rwl.readLock().lock();
        HeroClass hc = this.heroClass;
        this.rwl.readLock().unlock();
        return hc;
    }

    public HeroDamageCause getLastDamageCause() {
        return this.lastDamageCause;
    }

    public void setLastDamageCause(HeroDamageCause lastDamageCause) {
        this.lastDamageCause = lastDamageCause;
    }

    public long getLastDamageTaken() {
        return this.lastDamageTaken;
    }

    public void setLastDamageTaken(long lastDamageTaken) {
        this.lastDamageTaken = lastDamageTaken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public int getHeroLevel() {
        int race;
        int second;
        int primary;
        try {
            this.rwl.readLock().lock();
            primary = this.getHeroLevel(this.heroClass);
            second = 0;
            race = 0;
            if (this.secondClass != null) {
                second = this.getHeroLevel(this.secondClass);
            }
            if (this.raceClass != null) {
                race = this.getHeroLevel(this.raceClass);
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        int maxLevelOfSecondaryAndRace = second > race ? second : race;
        return primary > maxLevelOfSecondaryAndRace ? primary : maxLevelOfSecondaryAndRace;
    }

    @Deprecated
    @ThreadSafe
    public int getLevel() {
        return this.getHeroLevel();
    }

    public int getHeroLevel(Skill skill) {
        HeroClass raceClass;
        HeroClass secondClass;
        int level = -1;
        int secondLevel = -1;
        int raceLevel = -1;
        HeroClass heroClass = this.getHeroClass();
        if (heroClass.hasSkill(skill.getName()) || HeroClass.hasGlobalSkillset() && HeroClass.getGlobalSkillset().hasSkill(skill.getName())) {
            int requiredLevel = SkillConfigManager.getSetting(heroClass, skill, SkillSetting.LEVEL.node(), 1);
            level = this.getHeroLevel(heroClass);
            if (level < requiredLevel) {
                level = -1;
            }
        }
        if ((secondClass = this.getSecondaryClass()) != null && secondClass.hasSkill(skill.getName())) {
            int requiredLevel = SkillConfigManager.getSetting(secondClass, skill, SkillSetting.LEVEL.node(), 1);
            secondLevel = this.getHeroLevel(secondClass);
            if (secondLevel < requiredLevel) {
                secondLevel = -1;
            }
        }
        if ((raceClass = this.getRaceClass()) != null && raceClass.hasSkill(skill.getName())) {
            int requiredLevel = SkillConfigManager.getSetting(raceClass, skill, SkillSetting.LEVEL.node(), 1);
            raceLevel = this.getHeroLevel(raceClass);
            if (raceLevel < requiredLevel) {
                raceLevel = -1;
            }
        }
        int maxLevelOfSecondaryAndRace = secondLevel > raceLevel ? secondLevel : raceLevel;
        return maxLevelOfSecondaryAndRace > level ? maxLevelOfSecondaryAndRace : level;
    }

    @Deprecated
    public int getSkillLevel(Skill skill) {
        return this.getHeroLevel(skill);
    }

    @ThreadSafe
    public int getHeroLevel(HeroClass heroClass) {
        return Properties.getLevel(this.getExperience(heroClass));
    }

    @Deprecated
    @ThreadSafe
    public int getLevel(HeroClass heroClass) {
        return this.getHeroLevel(heroClass);
    }

    public int getTieredLevel(boolean recache) {
        int rc;
        int sc;
        int hc;
        if (this.tieredLevel != null && !recache) {
            return this.tieredLevel;
        }
        HeroClass heroClass = this.getHeroClass();
        HeroClass secondClass = this.getSecondaryClass();
        this.tieredLevel = secondClass == null ? Integer.valueOf(this.getTieredLevel(heroClass)) : Integer.valueOf((hc = this.getTieredLevel(heroClass)) > (sc = this.getTieredLevel(secondClass)) ? hc : sc);
        HeroClass raceClass = this.getRaceClass();
        if (raceClass != null && (rc = this.getTieredLevel(raceClass)) > this.tieredLevel) {
            this.tieredLevel = rc;
        }
        return this.tieredLevel;
    }

    public int getTieredLevel(HeroClass heroClass) {
        if (heroClass.hasNoParents()) {
            return this.getHeroLevel(heroClass);
        }
        HashSet<HeroClass> classes = new HashSet<HeroClass>();
        for (HeroClass hClass : heroClass.getParents()) {
            if (!this.isMaster(hClass)) continue;
            classes.addAll(this.getTieredLevel(hClass, new HashSet<HeroClass>(classes)));
            classes.add(hClass);
        }
        int level = this.getHeroLevel(heroClass);
        for (HeroClass hClass : classes) {
            if (hClass.getTier() == 0) continue;
            level += this.getHeroLevel(hClass);
        }
        return level;
    }

    private Set<HeroClass> getTieredLevel(HeroClass heroClass, Set<HeroClass> classes) {
        for (HeroClass hClass : heroClass.getParents()) {
            if (!this.isMaster(hClass)) continue;
            classes.addAll(this.getTieredLevel(hClass, new HashSet<HeroClass>(classes)));
            classes.add(hClass);
        }
        return classes;
    }

    public HeroClass getSecondaryClass() {
        this.rwl.readLock().lock();
        HeroClass sc = this.secondClass;
        this.rwl.readLock().unlock();
        return sc;
    }

    @Deprecated
    public HeroClass getSecondClass() {
        return this.getSecondaryClass();
    }

    public HeroClass getRaceClass() {
        this.rwl.readLock().lock();
        HeroClass rc = this.raceClass;
        this.rwl.readLock().unlock();
        return rc;
    }

    public float getShield() {
        float shield = NMSHandler.getInterface().getAbsorptionHearts(this.player);
        if (Heroes.properties.oneHealthBar) {
            shield = (float)((double)shield / Heroes.properties.healthPerBar * this.getMaxHealth());
        }
        return shield;
    }

    public void setShield(float value) {
        int maxShield = this.getMaxShield();
        if (value > (float)maxShield) {
            value = maxShield;
        } else if (value < 0.0f) {
            value = 0.0f;
        }
        float currShield = this.getShield();
        if (currShield != value) {
            ShieldChangeEvent event = new ShieldChangeEvent(this, currShield, value);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            float shield = event.getFinalShield();
            if (Heroes.properties.oneHealthBar) {
                shield = (float)((double)shield / this.getMaxHealth() * Heroes.properties.healthPerBar);
            }
            NMSHandler.getInterface().setAbsorptionHearts(this.player, shield);
        }
    }

    public int getShieldRegen() {
        return this.shieldRegen.get();
    }

    private void setShieldRegen(int value) {
        if (value < 1) {
            value = 1;
        }
        if (this.shieldRegen.get() != value) {
            this.shieldRegen.set(value);
        } else {
            this.manaRegen.getAndSet(value);
        }
    }

    public int getMana() {
        return this.mana.get();
    }

    public void setMana(int value) {
        int maxMana = this.getMaxMana();
        if (value > maxMana) {
            value = maxMana;
        } else if (value < 0) {
            value = 0;
        }
        if (this.mana.get() != value) {
            ManaChangeEvent event = new ManaChangeEvent(this, this.mana.get(), value);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.mana.set(event.getFinalMana());
        } else {
            this.mana.getAndSet(value);
        }
    }

    public int getStaminaRegen() {
        return this.staminaRegen.get();
    }

    private void setStaminaRegen(int value) {
        if (value < 1) {
            value = 1;
        }
        if (this.staminaRegen.get() != value) {
            this.staminaRegen.set(value);
        } else {
            this.staminaRegen.getAndSet(value);
        }
    }

    public double getCurrentEquipmentWeight() {
        Double weight;
        if (!Heroes.properties.checkEquipmentWeight || Heroes.properties.equipmentWeightMap == null) {
            return 0.0;
        }
        PlayerInventory inv = this.player.getInventory();
        double currentEquipmentWeight = 0.0;
        ItemStack helmet = inv.getHelmet();
        ItemStack chestplate = inv.getChestplate();
        ItemStack leggings = inv.getLeggings();
        ItemStack boots = inv.getBoots();
        if (helmet != null && (weight = Heroes.properties.equipmentWeightMap.get(helmet.getType())) != null) {
            currentEquipmentWeight += weight.doubleValue();
        }
        if (chestplate != null && (weight = Heroes.properties.equipmentWeightMap.get(chestplate.getType())) != null) {
            currentEquipmentWeight += weight.doubleValue();
        }
        if (leggings != null && (weight = Heroes.properties.equipmentWeightMap.get(leggings.getType())) != null) {
            currentEquipmentWeight += weight.doubleValue();
        }
        if (boots != null && (weight = Heroes.properties.equipmentWeightMap.get(boots.getType())) != null) {
            currentEquipmentWeight += weight.doubleValue();
        }
        return currentEquipmentWeight;
    }

    public double getMaxEquipmentWeight() {
        return this.maxEquipmentWeight;
    }

    private synchronized void setMaxEquipmentWeight(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        this.maxEquipmentWeight = value;
    }

    public Map<String, AtomicInteger> getAllocationPointsMap() {
        return Collections.unmodifiableMap(this.allocationPoints);
    }

    public int getAllocationPoints() {
        return this.getAllocationPoints(this.getHeroClass());
    }

    public int getAllocationPoints(HeroClass heroClass) {
        if (heroClass == null || !heroClass.isPrimary()) {
            return 0;
        }
        AtomicInteger atomicPoints = this.allocationPoints.get(heroClass.getName());
        return atomicPoints == null ? 0 : atomicPoints.get();
    }

    public int getAttributeAllocationCost(HeroClass heroClass, AttributeType attribute, int increaseValue) {
        return this.getAttributeAllocationCost(heroClass, attribute, this.getAllocatedAttributeValue(attribute), increaseValue);
    }

    public int getAttributeAllocationCost(HeroClass heroClass, AttributeType attribute, int allocatedValue, int increaseValue) {
        if (attribute == null || heroClass == null || !heroClass.isPrimary()) {
            return 0;
        }
        double classAttributeLevel = heroClass.getBaseAttributeValue(attribute) + this.getRaceClass().getBaseAttributeValue(attribute);
        double currentTotalLevel = classAttributeLevel + (double)allocatedValue;
        double allocationCost = 0.0;
        for (int i = 1; i <= increaseValue; ++i) {
            double absoluteTotalAttributeLevel = Math.abs(currentTotalLevel + (double)i);
            double incriment = Math.ceil(Heroes.properties.attributeAllocationCostPerLevel * absoluteTotalAttributeLevel);
            if (incriment < 1.0) {
                incriment = 1.0;
            }
            allocationCost += incriment;
        }
        if (allocationCost > 2.147483647E9) {
            allocationCost = 2.147483647E9;
        } else if (allocationCost < 0.0) {
            allocationCost = 0.0;
        }
        return (int)allocationCost;
    }

    @ThreadSafe
    public Map<String, AttributeSet> getAllocatedAttributesMap() {
        return Collections.unmodifiableMap(this.allocatedAttributes);
    }

    public AttributeSet getAttributes() {
        this.updateItemAttributes();
        return this.currAttributeSet;
    }

    public void updateItemAttributes() {
        long tick = this.player.getWorld().getTime();
        if (tick != this.itemUpdateTick) {
            this.itemUpdateTick = tick;
            AttributeSet items = this.getItemAttributes();
            if (!items.equals(this.lastItemSet)) {
                boolean recalcHealth = items.getConstitutionValue() != this.lastItemSet.getConstitutionValue();
                boolean recalcEndurance = items.getEnduranceValue() != this.lastItemSet.getEnduranceValue();
                boolean recalcMovement = items.getDexterityValue() != this.lastItemSet.getDexterityValue();
                boolean recalcMaxMana = items.getIntellectValue() != this.lastItemSet.getIntellectValue();
                boolean recalcManaRegen = items.getWisdomValue() != this.lastItemSet.getWisdomValue();
                this.lastItemSet = items;
                this.currAttributeSet = this.baseAttributeSet.sum(items);
                if (recalcHealth) {
                    this.resolveMaxHealth();
                    this.resolveMaxShield();
                }
                if (recalcEndurance) {
                    this.resolveShieldRegen();
                    this.resolveStaminaRegen();
                    this.resolveMaxEquipmentWeight();
                    this.resolveMaxStamina();
                }
                if (recalcMovement) {
                    this.resolveMovementSpeed();
                }
                if (recalcMaxMana) {
                    this.resolveMaxMana();
                }
                if (recalcManaRegen) {
                    this.resolveManaRegen();
                }
            }
        }
    }

    public AttributeSet getAllocatedAttributes() {
        return this.getAllocatedAttributes(this.heroClass);
    }

    @ThreadSafe
    public AttributeSet getAllocatedAttributes(HeroClass heroClass) {
        if (heroClass == null || !heroClass.isPrimary()) {
            return null;
        }
        String heroClassName = heroClass.getName();
        if (this.allocatedAttributes.containsKey(heroClassName)) {
            return this.allocatedAttributes.get(heroClassName);
        }
        this.allocatedAttributes.put(heroClassName, new AttributeSet());
        return this.allocatedAttributes.get(heroClassName);
    }

    public int getAttributeValue(AttributeType type) {
        if (this.heroClass == null) {
            return 0;
        }
        this.updateItemAttributes();
        return this.currAttributeSet.getAttributeValue(type);
    }

    public int getAllocatedAttributeValue(AttributeType type) {
        return this.getAllocatedAttributeValue(this.heroClass, type);
    }

    public int getAllocatedAttributeValue(HeroClass heroClass, AttributeType type) {
        if (heroClass == null || !heroClass.isPrimary()) {
            return 0;
        }
        String heroClassName = heroClass.getName();
        if (this.allocatedAttributes.containsKey(heroClassName)) {
            for (Map.Entry<String, AttributeSet> entry : this.allocatedAttributes.entrySet()) {
                if (!entry.getKey().equals(heroClassName)) continue;
                return entry.getValue().getAttributeValue(type);
            }
        }
        Heroes.log(Level.WARNING, "Unable to acquire allocated attribute value for hero (" + this.getName() + ") and HeroClass (" + heroClassName + ")");
        return 0;
    }

    private void initializeAllocationPoints(HeroClass heroClass) {
        if (heroClass == null || !heroClass.isPrimary()) {
            return;
        }
        String heroClassName = heroClass.getName();
        if (!this.allocationPoints.containsKey(heroClassName)) {
            int numAllocationPoints = heroClass.getAllocationPointsPerLevel() * this.getHeroLevel(heroClass);
            this.allocationPoints.put(heroClassName, new AtomicInteger(numAllocationPoints));
        }
    }

    private void initializeClassAttributeAllocations(HeroClass heroClass) {
        if (heroClass == null || !heroClass.isPrimary()) {
            return;
        }
        String heroClassName = heroClass.getName();
        if (!this.allocatedAttributes.containsKey(heroClassName)) {
            this.allocatedAttributes.put(heroClassName, new AttributeSet());
        }
    }

    public AttributeSet getItemAttributes() {
        PlayerInventory pInv = this.player.getInventory();
        AttributeSet attributeSet = new AttributeSet();
        ItemPlugin items = Heroes.getInstance().getItemPlugin();
        if (items != null && items.isEnabled()) {
            ItemManager itemManager = items.getItemManager();
            EquipmentManager equipManager = items.getEquipmentManager();
            for (ItemStack itemStack : pInv.getContents()) {
                Optional<Item> item = itemManager.getItem(itemStack);
                if (!item.isPresent() || !equipManager.isEquipped(this.player, item.get())) continue;
                item.get().forEachDeep(AttributeAttribute.class, attribute -> attributeSet.setAttributeValue(attribute.getAttributeType(), attributeSet.getAttributeValue(attribute.getAttributeType()) + attribute.getAttributeValue()));
            }
        }
        return attributeSet;
    }

    public AttributeSet getTotalAttributeSet() {
        return this.getHeroClass().getBaseAttributes().sum(this.getRaceClass().getBaseAttributes().sum(this.getAllocatedAttributes()));
    }

    public void rebuildAttributes() {
        AttributeSet allocatedAttributes = this.getAllocatedAttributes();
        int nullCount = 0;
        if (this.heroClass.getBaseAttributes() == null) {
            nullCount = 1;
            Heroes.log(Level.SEVERE, "The Base Class Attributes were null during an Attribute rebuild for the Hero (" + this.getName() + ")'s Heroclass (" + this.heroClass.getName() + ").");
        }
        if (allocatedAttributes == null) {
            this.initializeClassAttributeAllocations(this.heroClass);
            allocatedAttributes = this.getAllocatedAttributes();
        }
        if (nullCount > 0 || allocatedAttributes == null) {
            Heroes.log(Level.SEVERE, "One or more problems were encountered when attempting to rebuild the attributes for the Hero (" + this.getName() + ")'s Heroclass (" + this.heroClass.getName() + "). Attributes will NOT be rebuilt.");
            return;
        }
        AttributeSet totalAttributes = this.getTotalAttributeSet();
        int strength = totalAttributes.getStrengthValue();
        int constitution = totalAttributes.getConstitutionValue();
        int endurance = totalAttributes.getEnduranceValue();
        int dexterity = totalAttributes.getDexterityValue();
        int intellect = totalAttributes.getIntellectValue();
        int wisdom = totalAttributes.getWisdomValue();
        int charisma = totalAttributes.getCharismaValue();
        for (Effect effect : this.getEffects()) {
            AttributeType type;
            if (effect.isType(EffectType.ATTRIBUTE_INCREASING) && effect instanceof AttributeIncreaseEffect) {
                type = ((AttributeIncreaseEffect)effect).getAttributeType();
                int increaseValue = (Integer)((AttributeIncreaseEffect)effect).getDelta();
                switch (type) {
                    case STRENGTH: {
                        strength += increaseValue;
                        break;
                    }
                    case CONSTITUTION: {
                        constitution += increaseValue;
                        break;
                    }
                    case ENDURANCE: {
                        endurance += increaseValue;
                        break;
                    }
                    case DEXTERITY: {
                        dexterity += increaseValue;
                        break;
                    }
                    case INTELLECT: {
                        intellect += increaseValue;
                        break;
                    }
                    case WISDOM: {
                        wisdom += increaseValue;
                        break;
                    }
                    case CHARISMA: {
                        charisma += increaseValue;
                        break;
                    }
                }
            }
            if (!effect.isType(EffectType.ATTRIBUTE_DECREASING) || !(effect instanceof AttributeDecreaseEffect)) continue;
            type = ((AttributeDecreaseEffect)effect).getAttributeType();
            int decreaseValue = (Integer)((AttributeDecreaseEffect)effect).getDelta();
            switch (type) {
                case STRENGTH: {
                    strength -= decreaseValue;
                    break;
                }
                case CONSTITUTION: {
                    constitution -= decreaseValue;
                    break;
                }
                case ENDURANCE: {
                    endurance -= decreaseValue;
                    break;
                }
                case DEXTERITY: {
                    dexterity -= decreaseValue;
                    break;
                }
                case INTELLECT: {
                    intellect -= decreaseValue;
                    break;
                }
                case WISDOM: {
                    wisdom -= decreaseValue;
                    break;
                }
                case CHARISMA: {
                    charisma -= decreaseValue;
                    break;
                }
            }
        }
        if (this.baseAttributeSet != null) {
            this.baseAttributeSet.setStrengthValue(strength);
            this.baseAttributeSet.setConstitutionValue(constitution);
            this.baseAttributeSet.setEnduranceValue(endurance);
            this.baseAttributeSet.setDexterityValue(dexterity);
            this.baseAttributeSet.setIntellectValue(intellect);
            this.baseAttributeSet.setWisdomValue(wisdom);
            this.baseAttributeSet.setCharismaValue(charisma);
        } else {
            this.baseAttributeSet = new AttributeSet(strength, constitution, endurance, dexterity, intellect, wisdom, charisma);
        }
        this.currAttributeSet = this.baseAttributeSet.sum(this.getItemAttributes());
        this.itemUpdateTick = this.player.getWorld().getTime();
        this.resolveMaxHealth();
        this.resolveMaxShield();
        this.resolveShieldRegen();
        this.resolveStaminaRegen();
        this.resolveMaxEquipmentWeight();
        this.resolveMaxStamina();
        this.resolveMovementSpeed();
        this.resolveMaxMana();
        this.resolveManaRegen();
    }

    public void rebuildAttribute(AttributeType type) {
        int value = 0;
        try {
            int baseAttributeValue = this.heroClass.getBaseAttributes().getAttributeValue(type) + this.raceClass.getBaseAttributeValue(type);
            int allocatedAttributeValue = this.getAllocatedAttributes().getAttributeValue(type);
            int effectAttributeValue = 0;
            for (Effect effect : this.getEffects()) {
                if (effect instanceof AttributeIncreaseEffect) {
                    if (!((AttributeIncreaseEffect)effect).getAttributeType().equals((Object)type)) continue;
                    effectAttributeValue += ((Integer)((AttributeIncreaseEffect)effect).getDelta()).intValue();
                    continue;
                }
                if (!(effect instanceof AttributeDecreaseEffect) || !((AttributeDecreaseEffect)effect).getAttributeType().equals((Object)type)) continue;
                effectAttributeValue -= ((Integer)((AttributeDecreaseEffect)effect).getDelta()).intValue();
            }
            value = baseAttributeValue + allocatedAttributeValue + effectAttributeValue;
        }
        catch (NullPointerException ex) {
            Heroes.log(Level.SEVERE, "One or more problems were encountered when attempting to rebuild the Attribute (" + type.toString() + ") for the Hero (" + this.getName() + ")'s Heroclass (" + this.heroClass.getName() + "). Attribute will NOT be rebuilt.");
            Heroes.debugLog(Level.SEVERE, TextUtil.formatStackTrace(ex));
            return;
        }
        if (this.baseAttributeSet == null) {
            this.baseAttributeSet = new AttributeSet();
        }
        if (this.currAttributeSet == null) {
            this.currAttributeSet = new AttributeSet();
        }
        this.baseAttributeSet.setAttributeValue(type, value);
        this.currAttributeSet.setAttributeValue(type, value + this.lastItemSet.getAttributeValue(type));
        switch (type) {
            case CONSTITUTION: {
                this.resolveMaxHealth();
                this.resolveMaxShield();
                break;
            }
            case ENDURANCE: {
                this.resolveShieldRegen();
                this.resolveStaminaRegen();
                this.resolveMaxEquipmentWeight();
                this.resolveMaxStamina();
                break;
            }
            case DEXTERITY: {
                this.resolveMovementSpeed();
                break;
            }
            case INTELLECT: {
                this.resolveMaxMana();
                break;
            }
            case WISDOM: {
                this.resolveManaRegen();
                break;
            }
        }
    }

    public double getValidStatScaling(Scaling primary, Scaling race, int defaultVal) {
        double total = defaultVal;
        if (primary != null) {
            total = race != null ? Math.max(primary.getScaled(this), race.getScaled(this)) : primary.getScaled(this);
        } else if (race != null) {
            total = race.getScaled(this);
        }
        return total;
    }

    public double resolveMaxHealth() {
        double maxHP;
        double currentHP = this.player.getHealth();
        double ratio = currentHP / (maxHP = this.getMaxHealth());
        if (ratio > 1.0) {
            ratio = 1.0;
        }
        HeroClass heroClass = this.getHeroClass();
        HeroClass raceClass = this.getRaceClass();
        double baseMaxHealth = this.getValidStatScaling(heroClass.getMaxHealth(), raceClass == null ? null : raceClass.getMaxHealth(), 20);
        int constitutionValue = this.getAttributeValue(AttributeType.CONSTITUTION);
        double newMaxHealth = baseMaxHealth + (double)constitutionValue * Heroes.properties.healthPerConstitution;
        PlayerInventory pInv = this.player.getInventory();
        ItemPlugin items = Heroes.getInstance().getItemPlugin();
        if (items != null && items.isEnabled()) {
            ItemManager itemManager = items.getItemManager();
            EquipmentManager equipManager = items.getEquipmentManager();
            for (ItemStack itemStack : pInv.getContents()) {
                Optional<Item> item = itemManager.getItem(itemStack);
                if (!item.isPresent() || !equipManager.isEquipped(this.player, item.get())) continue;
                for (HealthAttribute attribute : item.get().getAttributesDeep(HealthAttribute.class)) {
                    newMaxHealth += attribute.getAppliedHealth();
                }
            }
        }
        double maxHealthPercentChange = 0.0;
        for (Effect effect : this.getEffects()) {
            if (effect instanceof MaxHealthIncreaseEffect) {
                newMaxHealth += (double)((Integer)((MaxHealthIncreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof MaxHealthDecreaseEffect) {
                newMaxHealth -= (double)((Integer)((MaxHealthDecreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof MaxHealthPercentIncreaseEffect) {
                maxHealthPercentChange += ((Double)((MaxHealthPercentIncreaseEffect)effect).getDelta()).doubleValue();
                continue;
            }
            if (!(effect instanceof MaxHealthPercentDecreaseEffect)) continue;
            maxHealthPercentChange -= ((Double)((MaxHealthPercentDecreaseEffect)effect).getDelta()).doubleValue();
        }
        if ((newMaxHealth *= 1.0 + maxHealthPercentChange) < 1.0) {
            newMaxHealth = 1.0;
        }
        try {
            this.setMaxHealth(newMaxHealth);
        }
        catch (IllegalArgumentException e) {
            Heroes.getInstance().getLogger().warning("healthDebug: baseMaxHealth[" + baseMaxHealth + "], constitutionValue[" + constitutionValue + "], healthPerConstitution[" + Heroes.properties.healthPerConstitution + "]: newMaxHealth[" + newMaxHealth + "]");
            throw e;
        }
        if (ratio > 0.0 && this.player.getHealth() > 0.0 && !this.player.isDead()) {
            this.player.setHealth(ratio * this.getMaxHealth());
        }
        return this.getMaxHealth();
    }

    public void setMaxHealth(double health) {
        this.player.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(health);
    }

    public int resolveMaxShield() {
        float ratio;
        float currentShield = this.getShield();
        int maxShield = this.getMaxShield();
        float f = ratio = maxShield > 0 ? currentShield / (float)maxShield : 1.0f;
        if (ratio > 1.0f) {
            ratio = 1.0f;
        }
        double baseMaxShield = this.getValidStatScaling(this.heroClass.getMaxShield(), this.raceClass == null ? null : this.raceClass.getMaxShield(), 0);
        int constitutionValue = this.getAttributeValue(AttributeType.CONSTITUTION);
        int newMaxShield = (int)(baseMaxShield + (double)constitutionValue * Heroes.properties.shieldPerConstitution);
        double maxShieldPercentChange = 0.0;
        for (Effect effect : this.getEffects()) {
            if (effect instanceof MaxShieldIncreaseEffect) {
                newMaxShield += ((Integer)((MaxShieldIncreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof MaxShieldDecreaseEffect) {
                newMaxShield -= ((Integer)((MaxShieldDecreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof MaxShieldPercentIncreaseEffect) {
                maxShieldPercentChange += ((Double)((MaxShieldPercentIncreaseEffect)effect).getDelta()).doubleValue();
                continue;
            }
            if (!(effect instanceof MaxShieldPercentDecreaseEffect)) continue;
            maxShieldPercentChange -= ((Double)((MaxShieldPercentDecreaseEffect)effect).getDelta()).doubleValue();
        }
        if ((newMaxShield = (int)Math.floor((double)newMaxShield * (1.0 + maxShieldPercentChange))) < 0) {
            newMaxShield = 0;
        }
        this.maxShield.set(newMaxShield);
        if (ratio > 0.0f && this.getShield() > 0.0f && !this.player.isDead()) {
            this.setShield(ratio * (float)this.getMaxShield());
        }
        return this.getMaxShield();
    }

    public int resolveShieldRegen() {
        double baseShieldRegen = this.getValidStatScaling(this.heroClass.getScaledShieldRegen(), this.raceClass == null ? null : this.raceClass.getScaledShieldRegen(), 0);
        int newShieldRegen = (int)(baseShieldRegen + (double)(this.getAttributeValue(AttributeType.ENDURANCE) * Heroes.properties.shieldRegenerationPerEndurance));
        double shieldRegenPercentIncrease = 0.0;
        for (Effect effect : this.getEffects()) {
            if (effect instanceof ShieldRegenIncreaseEffect) {
                newShieldRegen += ((Integer)((ShieldRegenIncreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof ShieldRegenDecreaseEffect) {
                newShieldRegen -= ((Integer)((ShieldRegenDecreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof ShieldRegenPercentIncreaseEffect) {
                shieldRegenPercentIncrease += ((Double)((ShieldRegenPercentIncreaseEffect)effect).getDelta()).doubleValue();
                continue;
            }
            if (!(effect instanceof ShieldRegenPercentDecreaseEffect)) continue;
            shieldRegenPercentIncrease -= ((Double)((ShieldRegenPercentDecreaseEffect)effect).getDelta()).doubleValue();
        }
        if ((newShieldRegen = (int)Math.floor((double)newShieldRegen * (1.0 + shieldRegenPercentIncrease))) < 1) {
            newShieldRegen = 1;
        }
        this.setShieldRegen(newShieldRegen);
        return this.shieldRegen.get();
    }

    public int resolveMaxMana() {
        double baseMaxMana = this.getValidStatScaling(this.heroClass.getMaxMana(), this.raceClass == null ? null : this.raceClass.getMaxMana(), 500);
        int newMaxMana = (int)(baseMaxMana + Math.floor(this.getAttributeValue(AttributeType.INTELLECT) * Heroes.properties.manaPerIntellect));
        newMaxMana += this.manaMap.values().stream().mapToInt(mana -> mana).sum();
        PlayerInventory pInv = this.player.getInventory();
        ItemPlugin items = Heroes.getInstance().getItemPlugin();
        if (items != null && items.isEnabled()) {
            ItemManager itemManager = items.getItemManager();
            EquipmentManager equipManager = items.getEquipmentManager();
            for (ItemStack itemStack : pInv.getContents()) {
                Optional<Item> item = itemManager.getItem(itemStack);
                if (!item.isPresent() || !equipManager.isEquipped(this.player, item.get())) continue;
                for (ManaAttribute attribute : item.get().getAttributesDeep(ManaAttribute.class)) {
                    newMaxMana += attribute.getAppliedMana();
                }
            }
        }
        double maxManaPercentChange = 0.0;
        for (Effect effect : this.getEffects()) {
            if (effect instanceof MaxManaIncreaseEffect) {
                newMaxMana += ((Integer)((MaxManaIncreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof MaxManaDecreaseEffect) {
                newMaxMana -= ((Integer)((MaxManaDecreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof MaxManaPercentIncreaseEffect) {
                maxManaPercentChange += ((Double)((MaxManaPercentIncreaseEffect)effect).getDelta()).doubleValue();
                continue;
            }
            if (!(effect instanceof MaxManaPercentDecreaseEffect)) continue;
            maxManaPercentChange -= ((Double)((MaxManaPercentDecreaseEffect)effect).getDelta()).doubleValue();
        }
        if ((newMaxMana = (int)Math.floor((double)newMaxMana * (1.0 + maxManaPercentChange))) < 0) {
            newMaxMana = 0;
        }
        this.setMaxMana(newMaxMana);
        return this.maxMana.get();
    }

    public int resolveMaxStamina() {
        double baseMaxStamina = this.getValidStatScaling(this.heroClass.getMaxStamina(), this.raceClass == null ? null : this.raceClass.getMaxStamina(), 500);
        int newMaxStamina = (int)(baseMaxStamina + Math.floor(this.getAttributeValue(AttributeType.ENDURANCE) * Heroes.properties.staminaPerEndurance));
        newMaxStamina += this.staminaMap.values().stream().mapToInt(stamina -> stamina).sum();
        PlayerInventory pInv = this.player.getInventory();
        ItemPlugin items = Heroes.getInstance().getItemPlugin();
        if (items != null && items.isEnabled()) {
            ItemManager itemManager = items.getItemManager();
            EquipmentManager equipManager = items.getEquipmentManager();
            for (ItemStack itemStack : pInv.getContents()) {
                Optional<Item> item = itemManager.getItem(itemStack);
                if (!item.isPresent() || !equipManager.isEquipped(this.player, item.get())) continue;
                for (StaminaAttribute attribute : item.get().getAttributesDeep(StaminaAttribute.class)) {
                    newMaxStamina += attribute.getAppliedStamina();
                }
            }
        }
        double maxStaminaPercentChange = 0.0;
        for (Effect effect : this.getEffects()) {
            if (effect instanceof MaxStaminaIncreaseEffect) {
                newMaxStamina += ((Integer)((MaxStaminaIncreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof MaxStaminaDecreaseEffect) {
                newMaxStamina -= ((Integer)((MaxStaminaDecreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof MaxStaminaPercentIncreaseEffect) {
                maxStaminaPercentChange += ((Double)((MaxStaminaPercentIncreaseEffect)effect).getDelta()).doubleValue();
                continue;
            }
            if (!(effect instanceof MaxStaminaPercentDecreaseEffect)) continue;
            maxStaminaPercentChange -= ((Double)((MaxStaminaPercentDecreaseEffect)effect).getDelta()).doubleValue();
        }
        if ((newMaxStamina = (int)Math.floor((double)newMaxStamina * (1.0 + maxStaminaPercentChange))) < 0) {
            newMaxStamina = 0;
        }
        this.setMaxStamina(newMaxStamina);
        return this.maxStamina.get();
    }

    public int resolveManaRegen() {
        double baseManaRegen = this.getValidStatScaling(this.heroClass.getScaledManaRegen(), this.raceClass == null ? null : this.raceClass.getScaledManaRegen(), 0);
        int newManaRegen = (int)(baseManaRegen + (double)(this.getAttributeValue(AttributeType.WISDOM) * Heroes.properties.manaRegenerationPerWisdom));
        PlayerInventory pInv = this.player.getInventory();
        ItemPlugin items = Heroes.getInstance().getItemPlugin();
        if (items != null && items.isEnabled()) {
            ItemManager itemManager = items.getItemManager();
            EquipmentManager equipManager = items.getEquipmentManager();
            for (ItemStack itemStack : pInv.getContents()) {
                Optional<Item> item = itemManager.getItem(itemStack);
                if (!item.isPresent() || !equipManager.isEquipped(this.player, item.get())) continue;
                for (ManaRegenAttribute attribute : item.get().getAttributesDeep(ManaRegenAttribute.class)) {
                    newManaRegen += attribute.getAppliedManaRegen();
                }
            }
        }
        double manaRegenPercentageChange = 0.0;
        for (Effect effect : this.getEffects()) {
            if (effect instanceof ManaRegenIncreaseEffect) {
                newManaRegen += ((Integer)((ManaRegenIncreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof ManaRegenDecreaseEffect) {
                newManaRegen -= ((Integer)((ManaRegenDecreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof ManaRegenPercentIncreaseEffect) {
                manaRegenPercentageChange += ((Double)((ManaRegenPercentIncreaseEffect)effect).getDelta()).doubleValue();
                continue;
            }
            if (!(effect instanceof ManaRegenPercentDecreaseEffect)) continue;
            manaRegenPercentageChange -= ((Double)((ManaRegenPercentDecreaseEffect)effect).getDelta()).doubleValue();
        }
        if ((newManaRegen = (int)Math.floor((double)newManaRegen * (1.0 + manaRegenPercentageChange))) < 1) {
            newManaRegen = 1;
        }
        this.setManaRegen(newManaRegen);
        return this.manaRegen.get();
    }

    public int resolveStaminaRegen() {
        double baseStaminaRegen = this.getValidStatScaling(this.heroClass.getScaledStaminaRegen(), this.raceClass == null ? null : this.raceClass.getScaledStaminaRegen(), 0);
        int newStaminaRegen = (int)(baseStaminaRegen + (double)(this.getAttributeValue(AttributeType.ENDURANCE) * Heroes.properties.staminaRegenerationPerEndurance));
        PlayerInventory pInv = this.player.getInventory();
        ItemPlugin items = Heroes.getInstance().getItemPlugin();
        if (items != null && items.isEnabled()) {
            ItemManager itemManager = items.getItemManager();
            EquipmentManager equipManager = items.getEquipmentManager();
            for (ItemStack itemStack : pInv.getContents()) {
                Optional<Item> item = itemManager.getItem(itemStack);
                if (!item.isPresent() || !equipManager.isEquipped(this.player, item.get())) continue;
                for (StaminaRegenAttribute attribute : item.get().getAttributesDeep(StaminaRegenAttribute.class)) {
                    newStaminaRegen += attribute.getAppliedStaminaRegen();
                }
            }
        }
        double staminaRegenPercentIncrease = 0.0;
        for (Effect effect : this.getEffects()) {
            if (effect instanceof StaminaRegenIncreaseEffect) {
                newStaminaRegen += ((Integer)((StaminaRegenIncreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof StaminaRegenDecreaseEffect) {
                newStaminaRegen -= ((Integer)((StaminaRegenDecreaseEffect)effect).getDelta()).intValue();
                continue;
            }
            if (effect instanceof StaminaRegenPercentIncreaseEffect) {
                staminaRegenPercentIncrease += ((Double)((StaminaRegenPercentIncreaseEffect)effect).getDelta()).doubleValue();
                continue;
            }
            if (!(effect instanceof StaminaRegenPercentDecreaseEffect)) continue;
            staminaRegenPercentIncrease -= ((Double)((StaminaRegenPercentDecreaseEffect)effect).getDelta()).doubleValue();
        }
        if ((newStaminaRegen = (int)Math.floor((double)newStaminaRegen * (1.0 + staminaRegenPercentIncrease))) < 1) {
            newStaminaRegen = 1;
        }
        this.setStaminaRegen(newStaminaRegen);
        return this.staminaRegen.get();
    }

    public double resolveMaxEquipmentWeight() {
        HeroClass heroClass = this.getHeroClass();
        double newMaxEquipmentWeight = heroClass.getBaseMaxEquipmentWeight();
        if (Heroes.properties.enableCarryWeightPerEndurance) {
            newMaxEquipmentWeight += (double)this.getAttributeValue(AttributeType.ENDURANCE) * Heroes.properties.carryWeightPerEndurance;
        }
        this.setMaxEquipmentWeight(newMaxEquipmentWeight);
        this.resolveCurrentEquipment();
        return this.maxEquipmentWeight;
    }

    public double resolveMovementSpeed() {
        double movementSpeedIncrease = (double)this.getAttributes().getDexterityValue() * Heroes.properties.speedIncreasePerDexterity;
        for (Effect effect : this.getEffects()) {
            if (effect instanceof WalkSpeedPercentIncrease) {
                movementSpeedIncrease += (double)Util.convertPercentageToPlayerMovementSpeedValue((Double)((WalkSpeedPercentIncrease)((Object)effect)).getDelta());
                continue;
            }
            if (effect instanceof WalkSpeedIncrease) {
                movementSpeedIncrease += ((Double)((WalkSpeedIncrease)((Object)effect)).getDelta()).doubleValue();
                continue;
            }
            if (effect instanceof WalkSpeedPercentDecrease) {
                movementSpeedIncrease -= (double)Util.convertPercentageToPlayerMovementSpeedValue((Double)((WalkSpeedPercentDecrease)((Object)effect)).getDelta());
                continue;
            }
            if (!(effect instanceof WalkSpeedDecrease)) continue;
            movementSpeedIncrease -= ((Double)((WalkSpeedDecrease)((Object)effect)).getDelta()).doubleValue();
        }
        float newMovementSpeed = 0.2f + (float)movementSpeedIncrease;
        if (newMovementSpeed < 0.0f) {
            newMovementSpeed = 0.0f;
        } else if (newMovementSpeed > 1.0f) {
            newMovementSpeed = 1.0f;
        }
        this.player.setWalkSpeed(newMovementSpeed);
        return this.player.getWalkSpeed();
    }

    public int getMaxShield() {
        return this.maxShield.get();
    }

    public float getScaledMaxShield() {
        float maxShield = this.getMaxShield();
        if (Heroes.properties.oneHealthBar) {
            maxShield = (float)((double)maxShield / this.getMaxHealth() * Heroes.properties.healthPerBar);
        }
        return maxShield;
    }

    public int getStamina() {
        return this.stamina.get();
    }

    public void setStamina(int value) {
        int maxStamina = this.getMaxStamina();
        if (value > maxStamina) {
            value = maxStamina;
        } else if (value < 0) {
            value = 0;
        }
        if (this.stamina.get() != value) {
            StaminaChangeEvent event = new StaminaChangeEvent(this, this.stamina.get(), value);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.stamina.set(event.getFinalStamina());
            this.stamina.set(value);
        } else {
            this.stamina.getAndSet(value);
        }
        this.calculateFoodLevel();
    }

    public int getMaxMana() {
        return this.maxMana.get();
    }

    private void setMaxMana(int value) {
        int currentMana = this.mana.get();
        int currentMaxMana = this.maxMana.get();
        double ratio = 0.0;
        if (currentMaxMana > 0 && (ratio = (double)currentMana / (double)currentMaxMana) > 1.0) {
            ratio = 1.0;
        }
        if (value < 1) {
            value = 1;
        }
        if (this.maxMana.get() != value) {
            this.maxMana.set(value);
        } else {
            this.maxMana.getAndSet(value);
        }
        int newCurrentMana = (int)(ratio * (double)this.maxMana.get());
        ManaChangeEvent event = new ManaChangeEvent(this, this.mana.get(), newCurrentMana);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.setMana(event.getFinalMana());
        }
    }

    public int getManaRegen() {
        return this.manaRegen.get();
    }

    private void setManaRegen(int value) {
        if (value < 1) {
            value = 1;
        }
        if (this.manaRegen.get() != value) {
            this.manaRegen.set(value);
        } else {
            this.manaRegen.getAndSet(value);
        }
    }

    public int getMaxStamina() {
        return this.maxStamina.get();
    }

    public void setMaxStamina(int value) {
        int currentStamina = this.stamina.get();
        int currentMaxStamina = this.maxStamina.get();
        double ratio = 0.0;
        if (currentMaxStamina > 0 && (ratio = (double)currentStamina / (double)currentMaxStamina) > 1.0) {
            ratio = 1.0;
        }
        if (value < 1) {
            value = 1;
        }
        if (this.maxStamina.get() != value) {
            this.maxStamina.set(value);
        } else {
            this.maxStamina.getAndSet(value);
        }
        int newCurrentStamina = (int)(ratio * (double)this.maxStamina.get());
        StaminaChangeEvent event = new StaminaChangeEvent(this, this.stamina.get(), newCurrentStamina);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.setStamina(event.getFinalStamina());
        }
    }

    public boolean addMaxStamina(String key, int value) {
        if (this.staminaMap.containsKey(key)) {
            return false;
        }
        this.staminaMap.put(key, value);
        this.setMaxStamina(this.getMaxStamina() + value);
        return true;
    }

    public boolean removeMaxStamina(String key) {
        Integer val = this.staminaMap.remove(key);
        if (val == null) {
            return false;
        }
        this.setMaxStamina(this.getMaxStamina() - val);
        return true;
    }

    public void clearMaxStamina() {
        int staminaToClear = 0;
        Iterator<Map.Entry<String, Integer>> iter = this.staminaMap.entrySet().iterator();
        while (iter.hasNext()) {
            Integer val = iter.next().getValue();
            iter.remove();
            staminaToClear += val.intValue();
        }
        this.setMaxStamina(this.getMaxStamina() - staminaToClear);
    }

    public boolean addMaxMana(String key, int value) {
        if (this.manaMap.containsKey(key)) {
            return false;
        }
        this.manaMap.put(key, value);
        this.setMaxMana(this.getMaxMana() + value);
        return true;
    }

    public boolean removeMaxMana(String key) {
        Integer val = this.manaMap.remove(key);
        if (val == null) {
            return false;
        }
        this.setMaxMana(this.getMaxMana() - val);
        return true;
    }

    public void clearMaxMana() {
        int manaToClear = 0;
        Iterator<Map.Entry<String, Integer>> iter = this.manaMap.entrySet().iterator();
        while (iter.hasNext()) {
            Integer val = iter.next().getValue();
            iter.remove();
            manaToClear += val.intValue();
        }
        this.setMaxMana(this.getMaxMana() - manaToClear);
    }

    public double getMovementSpeed() {
        float speedIncrease = this.player.getWalkSpeed() - 0.2f;
        return (1.0 + (double)(speedIncrease / 0.2f)) * 100.0;
    }

    public double getMagicResistsValue() {
        double resistValue = (double)this.getAttributeValue(AttributeType.CONSTITUTION) * Heroes.properties.magicResistPerConstitution;
        if (resistValue > 0.75) {
            resistValue = 0.75;
        }
        return resistValue;
    }

    @NotThreadSafe
    public HeroParty getParty() {
        return this.party;
    }

    public void setParty(HeroParty party) {
        this.party = party;
        if (party != null) {
            boolean contained = this.scoreboard != null && this.scoreboard.removeComponent(HeroInfoComponent.SELF);
            this.renderVisualComponents();
            if (contained) {
                this.scoreboard.addComponent(HeroInfoComponent.SELF);
                this.renderVisualComponents();
            }
        }
    }

    @NotThreadSafe
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public Set<Monster> getSummons() {
        return this.summons;
    }

    @Deprecated
    public boolean isOwnedSummon(LivingEntity possible) {
        CharacterTemplate possibleCT = this.plugin.getCharacterManager().getCharacter(possible);
        if (!(possibleCT instanceof Monster)) {
            return false;
        }
        return this.isOwnerOfCreature((Monster)possibleCT);
    }

    public boolean isOwnerOfCreature(Monster mob) {
        if (mob == null) {
            return false;
        }
        for (Monster monster : this.summons) {
            if (!monster.equals(mob)) continue;
            return true;
        }
        return false;
    }

    public boolean isAlliedToCreature(Monster mob) {
        if (mob == null) {
            return false;
        }
        if (this.isOwnerOfCreature(mob)) {
            return true;
        }
        HeroParty party = this.getParty();
        if (party != null && party.isNoPvp().booleanValue()) {
            for (Hero partyHero : party.getMembers()) {
                if (!partyHero.isOwnerOfCreature(mob)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAlliedTo(LivingEntity target) {
        if (target == null) {
            return false;
        }
        if (this.getEntity().equals(target)) {
            return true;
        }
        if (target instanceof Player) {
            Hero targetHero = this.plugin.getCharacterManager().getHero((Player)target);
            HeroParty party = this.getParty();
            return party != null && party.isNoPvp() != false && party.isPartyMember(targetHero);
        }
        Monster targetMonster = this.plugin.getCharacterManager().getMonster(target);
        return this.isAlliedToCreature(targetMonster);
    }

    public Set<String> getSuppressedSkills() {
        return this.suppressedSkills;
    }

    public void setSuppressedSkills(Collection<String> skills) {
        this.suppressedSkills.addAll(skills);
    }

    public boolean hasBind(Material mat) {
        return this.binds.containsKey(mat);
    }

    @Override
    public int hashCode() {
        return this.player == null ? 0 : this.name.hashCode();
    }

    @NotThreadSafe
    public boolean hasParty() {
        return this.party != null;
    }

    public Map<String, ConfigurationSection> getSkillSettings() {
        return Collections.unmodifiableMap(this.persistedSkillSettings);
    }

    @NotThreadSafe
    @ThreadSafe
    public ConfigurationSection getSkillSettings(Skill skill) {
        return skill == null ? null : this.getSkillSettings(skill.getName());
    }

    public ConfigurationSection getSkillSettings(String skillName) {
        HeroClass secondClass = this.getSecondaryClass();
        if (!(this.getHeroClass().hasSkill(skillName) || secondClass != null && secondClass.hasSkill(skillName) || HeroClass.hasGlobalSkillset())) {
            return null;
        }
        HeroClass raceClass = this.getRaceClass();
        if (!(this.getHeroClass().hasSkill(skillName) || raceClass != null && raceClass.hasSkill(skillName) || HeroClass.hasGlobalSkillset())) {
            return null;
        }
        return this.persistedSkillSettings.get(skillName.toLowerCase());
    }

    public void setSkillSetting(Skill skill, String node, Object val) {
        this.setSkillSetting(skill.getName(), node, val);
    }

    public void setSkillSetting(String skill, String node, Object val) {
        ConfigurationSection section = this.persistedSkillSettings.get(skill.toLowerCase());
        if (section == null) {
            section = new MemoryConfiguration();
            this.persistedSkillSettings.put(skill.toLowerCase(), section);
        }
        this.storage.saveHeroSkillSettings(this, skill, node, val);
        section.set(node, val);
    }

    @NotThreadSafe
    public boolean canUseSkill(Skill skill, boolean ignorePreparedUse, boolean ignoreLearnedUse, boolean ignoreUseLevel) {
        return skill != null && this.canUseSkill(skill.getName(), ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel);
    }

    @NotThreadSafe
    public boolean canUseSkill(Skill skill, boolean ignorePreparedUse, boolean ignoreLearnedUse) {
        return this.canUseSkill(skill, ignorePreparedUse, ignoreLearnedUse, false);
    }

    @NotThreadSafe
    public boolean canUseSkill(Skill skill, boolean ignorePreparedUse) {
        return this.canUseSkill(skill, ignorePreparedUse, false, false);
    }

    @NotThreadSafe
    public boolean canUseSkill(Skill skill) {
        return this.canUseSkill(skill, false, false, false);
    }

    public boolean canUseSkill(String skillName, boolean ignorePreparedUse, boolean ignoreLearnedUse, boolean ignoreUseLevel) {
        return this.canPrimaryUseSkill(skillName, ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel) || this.canSecondaryUseSkill(skillName, ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel) || this.canRaceUseSkill(skillName, ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel) || this.canGlobalUseSkill(skillName, ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel);
    }

    public boolean canUseSkill(String skillName, boolean ignorePreparedUse, boolean ignoreLearnedUse) {
        return this.canUseSkill(skillName, ignorePreparedUse, ignoreLearnedUse, false);
    }

    public boolean canUseSkill(String skillName, boolean ignorePreparedUse) {
        return this.canUseSkill(skillName, ignorePreparedUse, false, false);
    }

    public boolean canUseSkill(String skillName) {
        return this.canUseSkill(skillName, false, false, false);
    }

    @NotThreadSafe
    public boolean canPrimaryUseSkill(Skill skill, boolean ignorePreparedUse, boolean ignoreLearnedUse, boolean ignoreUseLevel) {
        return skill != null && this.canPrimaryUseSkill(skill.getName(), ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel);
    }

    @NotThreadSafe
    public boolean canPrimaryUseSkill(Skill skill, boolean ignorePreparedUse, boolean ignoreLearnedUse) {
        return this.canPrimaryUseSkill(skill, ignorePreparedUse, ignoreLearnedUse, false);
    }

    @NotThreadSafe
    public boolean canPrimaryUseSkill(Skill skill, boolean ignorePreparedUse) {
        return this.canPrimaryUseSkill(skill, ignorePreparedUse, false, false);
    }

    @NotThreadSafe
    public boolean canPrimaryUseSkill(Skill skill) {
        return this.canPrimaryUseSkill(skill, false, false, false);
    }

    @NotThreadSafe
    public boolean canPrimaryUseSkill(String skillName, boolean ignorePreparedUse, boolean ignoreLearnedUse, boolean ignoreUseLevel) {
        return this.canUseHeroSkill(this.getHeroSkillForPrimary(skillName), ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel);
    }

    @NotThreadSafe
    public boolean canPrimaryUseSkill(String skillName, boolean ignorePreparedUse, boolean ignoreLearnedUse) {
        return this.canPrimaryUseSkill(skillName, ignorePreparedUse, ignoreLearnedUse, false);
    }

    @NotThreadSafe
    public boolean canPrimaryUseSkill(String skillName, boolean ignorePreparedUse) {
        return this.canPrimaryUseSkill(skillName, ignorePreparedUse, false, false);
    }

    @NotThreadSafe
    public boolean canPrimaryUseSkill(String skillName) {
        return this.canPrimaryUseSkill(skillName, false, false, false);
    }

    @NotThreadSafe
    public boolean canSecondaryUseSkill(Skill skill, boolean ignorePreparedUse, boolean ignoreLearnedUse, boolean ignoreUseLevel) {
        return skill != null && this.canSecondaryUseSkill(skill.getName(), ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel);
    }

    @NotThreadSafe
    public boolean canSecondaryUseSkill(Skill skill, boolean ignorePreparedUse, boolean ignoreLearnedUse) {
        return this.canSecondaryUseSkill(skill, ignorePreparedUse, ignoreLearnedUse, false);
    }

    @NotThreadSafe
    public boolean canSecondaryUseSkill(Skill skill, boolean ignorePreparedUse) {
        return this.canSecondaryUseSkill(skill, ignorePreparedUse, false, false);
    }

    @NotThreadSafe
    public boolean canSecondaryUseSkill(Skill skill) {
        return this.canSecondaryUseSkill(skill, false, false, false);
    }

    @Deprecated
    @NotThreadSafe
    public boolean canSecondUseSkill(Skill skill) {
        return this.canSecondaryUseSkill(skill);
    }

    @NotThreadSafe
    public boolean canSecondaryUseSkill(String skillName, boolean ignorePreparedUse, boolean ignoreLearnedUse, boolean ignoreUseLevel) {
        return this.canUseHeroSkill(this.getHeroSkillForSecondary(skillName), ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel);
    }

    @NotThreadSafe
    public boolean canSecondaryUseSkill(String skillName, boolean ignorePreparedUse, boolean ignoreLearnedUse) {
        return this.canSecondaryUseSkill(skillName, ignorePreparedUse, ignoreLearnedUse, false);
    }

    @NotThreadSafe
    public boolean canSecondaryUseSkill(String skillName, boolean ignorePreparedUse) {
        return this.canSecondaryUseSkill(skillName, ignorePreparedUse, false, false);
    }

    @NotThreadSafe
    public boolean canSecondaryUseSkill(String skillName) {
        return this.canSecondaryUseSkill(skillName, false, false, false);
    }

    @NotThreadSafe
    public boolean canRaceUseSkill(String skillName) {
        return this.canRaceUseSkill(skillName, false, false, false);
    }

    @NotThreadSafe
    public boolean canRaceUseSkill(String skillName, boolean ignorePreparedUse) {
        return this.canRaceUseSkill(skillName, ignorePreparedUse, false, false);
    }

    @NotThreadSafe
    public boolean canRaceUseSkill(String skillName, boolean ignorePreparedUse, boolean ignoreLearnedUse) {
        return this.canRaceUseSkill(skillName, ignorePreparedUse, ignoreLearnedUse, false);
    }

    @NotThreadSafe
    public boolean canRaceUseSkill(String skillName, boolean ignorePreparedUse, boolean ignoreLearnedUse, boolean ignoreUseLevel) {
        return this.canUseHeroSkill(this.getHeroSkillForRace(skillName), ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel);
    }

    @NotThreadSafe
    public boolean canRaceUseSkill(Skill skill) {
        return this.canRaceUseSkill(skill, false, false, false);
    }

    @NotThreadSafe
    public boolean canRaceUseSkill(Skill skill, boolean ignorePreparedUse) {
        return this.canRaceUseSkill(skill, ignorePreparedUse, false, false);
    }

    @NotThreadSafe
    public boolean canRaceUseSkill(Skill skill, boolean ignorePreparedUse, boolean ignoreLearnedUse) {
        return this.canRaceUseSkill(skill, ignorePreparedUse, ignoreLearnedUse, false);
    }

    @NotThreadSafe
    public boolean canRaceUseSkill(Skill skill, boolean ignorePreparedUse, boolean ignoreLearnedUse, boolean ignoreUseLevel) {
        return skill != null && this.canRaceUseSkill(skill.getName(), ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel);
    }

    @NotThreadSafe
    public boolean canGlobalUseSkill(Skill skill, boolean ignorePreparedUse, boolean ignoreLearnedUse, boolean ignoreUseLevel) {
        return skill != null && this.canGlobalUseSkill(skill.getName(), ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel);
    }

    @NotThreadSafe
    public boolean canGlobalUseSkill(Skill skill, boolean ignorePreparedUse, boolean ignoreLearnedUse) {
        return this.canGlobalUseSkill(skill, ignorePreparedUse, ignoreLearnedUse, false);
    }

    @NotThreadSafe
    public boolean canGlobalUseSkill(Skill skill, boolean ignorePreparedUse) {
        return this.canGlobalUseSkill(skill, ignorePreparedUse, false, false);
    }

    @NotThreadSafe
    public boolean canGlobalUseSkill(Skill skill) {
        return this.canGlobalUseSkill(skill, false, false, false);
    }

    @NotThreadSafe
    public boolean canGlobalUseSkill(String skillName, boolean ignorePreparedUse, boolean ignoreLearnedUse, boolean ignoreUseLevel) {
        return this.canUseHeroSkill(this.getHeroSkillForGlobal(skillName), ignorePreparedUse, ignoreLearnedUse, ignoreUseLevel);
    }

    @NotThreadSafe
    public boolean canGlobalUseSkill(String skillName, boolean ignorePreparedUse, boolean ignoreLearnedUse) {
        return this.canGlobalUseSkill(skillName, ignorePreparedUse, ignoreLearnedUse, false);
    }

    @NotThreadSafe
    public boolean canGlobalUseSkill(String skillName, boolean ignorePreparedUse) {
        return this.canGlobalUseSkill(skillName, ignorePreparedUse, false, false);
    }

    @NotThreadSafe
    public boolean canGlobalUseSkill(String skillName) {
        return this.canGlobalUseSkill(skillName, false, false, false);
    }

    private boolean canUseHeroSkill(HeroSkill heroSkill, boolean ignorePreparedUse, boolean ignoreLearnedUse, boolean ignoreUseLevel) {
        if (heroSkill == null) {
            return false;
        }
        ClassSkill classSkill = heroSkill.getClassSkill();
        if (!ignoreUseLevel && (classSkill.getHeroClass().isGlobal() ? this.getHeroLevel(this.getHeroClass()) < classSkill.getUseLevel() : this.getHeroLevel(heroSkill.getHeroClass()) < classSkill.getUseLevel())) {
            return false;
        }
        if (!ignoreLearnedUse && classSkill.learnedUse() && !heroSkill.isLearned()) {
            return false;
        }
        return ignorePreparedUse || !classSkill.preparedUse() || this.isSkillPrepared(classSkill.getSkill().getName());
    }

    public boolean hasAccessToSkill(Skill skill) {
        return skill != null && this.hasAccessToSkill(skill.getName());
    }

    public boolean hasAccessToSkill(String name) {
        HeroClass secondClass = this.getSecondaryClass();
        return this.getHeroClass().hasSkill(name) || secondClass != null && secondClass.hasSkill(name) || this.raceClass != null && this.raceClass.hasSkill(name) || HeroClass.hasGlobalSkillset() && HeroClass.getGlobalSkillset().hasSkill(name);
    }

    public HeroSkill getHeroSkillForClass(HeroClass heroClass, Skill skill) {
        if (heroClass == null) {
            return null;
        }
        if (skill == null) {
            return null;
        }
        return this.getHeroSkillForClass(heroClass.getName(), skill.getName());
    }

    public HeroSkill getHeroSkillForClass(String className, Skill skill) {
        if (skill == null) {
            return null;
        }
        return this.getHeroSkillForClass(className, skill.getName());
    }

    public HeroSkill getHeroSkillForClass(HeroClass heroClass, String skillName) {
        if (heroClass == null) {
            return null;
        }
        return this.getHeroSkillForClass(heroClass.getName(), skillName);
    }

    public HeroSkill getHeroSkillForClass(String className, String skillName) {
        HeroSkill heroSkill;
        if (className == null) {
            return null;
        }
        if (skillName == null) {
            return null;
        }
        String classNameToLower = className.toLowerCase();
        String skillNameToLower = skillName.toLowerCase();
        Map<String, HeroSkill> innerMap = this.heroSkills.get(classNameToLower);
        if (innerMap != null && (heroSkill = innerMap.get(skillNameToLower)) != null) {
            return heroSkill;
        }
        HeroClass heroClass = this.plugin.getClassManager().getClass(className);
        if (heroClass == null) {
            return null;
        }
        ClassSkill classSkill = heroClass.getClassSkill(skillName);
        if (classSkill == null) {
            return null;
        }
        HeroSkill heroSkill2 = new HeroSkill(this, classSkill);
        if (innerMap == null) {
            innerMap = new HashMap<String, HeroSkill>();
            this.heroSkills.put(classNameToLower, innerMap);
        }
        innerMap.put(skillNameToLower, heroSkill2);
        return heroSkill2;
    }

    public HeroSkill getHeroSkillForPrimary(Skill skill) {
        if (skill == null) {
            return null;
        }
        return this.getHeroSkillForPrimary(skill.getName());
    }

    public HeroSkill getHeroSkillForPrimary(String skillName) {
        return this.getHeroSkillForClass(this.getHeroClass(), skillName);
    }

    public HeroSkill getHeroSkillForSecondary(Skill skill) {
        if (skill == null) {
            return null;
        }
        return this.getHeroSkillForSecondary(skill.getName());
    }

    public HeroSkill getHeroSkillForRace(Skill skill) {
        if (skill == null) {
            return null;
        }
        return this.getHeroSkillForRace(skill.getName());
    }

    public HeroSkill getHeroSkillForSecondary(String skillName) {
        return this.getHeroSkillForClass(this.getSecondaryClass(), skillName);
    }

    public HeroSkill getHeroSkillForRace(String skillName) {
        return this.getHeroSkillForClass(this.getRaceClass(), skillName);
    }

    public HeroSkill getHeroSkillForGlobal(Skill skill) {
        if (skill == null) {
            return null;
        }
        return this.getHeroSkillForGlobal(skill.getName());
    }

    public HeroSkill getHeroSkillForGlobal(String skillName) {
        return this.getHeroSkillForClass(HeroClass.getGlobalSkillset(), skillName);
    }

    public HeroSkill getHeroSkill(ClassSkill classSkill) {
        return classSkill != null ? this.getHeroSkillForClass(classSkill.getHeroClass(), classSkill.getSkill()) : null;
    }

    public OptionalInt getHeroSkillLevel(Skill skill) {
        if (skill == null) {
            return OptionalInt.empty();
        }
        return this.getHeroSkillLevel(skill.getName());
    }

    public OptionalInt getHeroSkillLevel(String skillName) {
        if (skillName == null) {
            return OptionalInt.empty();
        }
        HeroSkill primary = this.getHeroSkillForPrimary(skillName);
        HeroSkill secondary = this.getHeroSkillForSecondary(skillName);
        HeroSkill race = this.getHeroSkillForRace(skillName);
        HeroSkill global = this.getHeroSkillForGlobal(skillName);
        int level = 0;
        boolean hasLevel = false;
        if (this.canUseHeroSkill(primary, false, false, false) && primary.getLevel() > level) {
            level = primary.getLevel();
            hasLevel = true;
        }
        if (this.canUseHeroSkill(secondary, false, false, false) && secondary.getLevel() > level) {
            level = secondary.getLevel();
            hasLevel = true;
        }
        if (this.canUseHeroSkill(race, false, false, false) && race.getLevel() > level) {
            level = race.getLevel();
            hasLevel = true;
        }
        if (this.canUseHeroSkill(global, false, false, false) && global.getLevel() > level) {
            level = global.getLevel();
            hasLevel = true;
        }
        return hasLevel ? OptionalInt.of(level) : OptionalInt.empty();
    }

    public boolean isSkillLearned(Skill skill) {
        return skill != null && this.isSkillLearned(skill.getName());
    }

    public boolean isSkillLearned(String skillName) {
        if (skillName == null) {
            return false;
        }
        HeroSkill primary = this.getHeroSkillForPrimary(skillName);
        HeroSkill secondary = this.getHeroSkillForSecondary(skillName);
        HeroSkill race = this.getHeroSkillForRace(skillName);
        HeroSkill global = this.getHeroSkillForGlobal(skillName);
        if (primary != null && primary.isLearned()) {
            return true;
        }
        if (secondary != null && secondary.isLearned()) {
            return true;
        }
        if (race != null && race.isLearned()) {
            return true;
        }
        return global != null && global.isLearned();
    }

    public Boolean isLearningRequiredForSkillUse(String skillName) {
        if (skillName == null) {
            return null;
        }
        HeroSkill primary = this.getHeroSkillForPrimary(skillName);
        HeroSkill secondary = this.getHeroSkillForSecondary(skillName);
        HeroSkill race = this.getHeroSkillForRace(skillName);
        HeroSkill global = this.getHeroSkillForGlobal(skillName);
        if (primary == null && secondary == null && race == null && global == null) {
            return null;
        }
        boolean learnRequired = true;
        if (primary != null && !primary.getClassSkill().learnedUse()) {
            learnRequired = false;
        }
        if (secondary != null && !secondary.getClassSkill().learnedUse()) {
            learnRequired = false;
        }
        if (race != null && !race.getClassSkill().learnedUse()) {
            learnRequired = false;
        }
        if (global != null && !global.getClassSkill().learnedUse()) {
            learnRequired = false;
        }
        return learnRequired;
    }

    public Boolean isLearningRequiredForSkillUse(Skill skill) {
        if (skill == null) {
            return null;
        }
        return this.isLearningRequiredForSkillUse(skill.getName());
    }

    public boolean isSkillPrepared(Skill skill) {
        return skill != null && this.isSkillPrepared(skill.getName());
    }

    public boolean isSkillPrepared(String skillName) {
        if (skillName == null) {
            return false;
        }
        return this.preparedSkills.contains(skillName.toLowerCase()) && this.getRemainingSkillPreparePoints() >= 0;
    }

    public Boolean isPreparationRequiredForSkillUse(String skillName) {
        if (skillName == null) {
            return null;
        }
        HeroSkill primary = this.getHeroSkillForPrimary(skillName);
        HeroSkill secondary = this.getHeroSkillForSecondary(skillName);
        HeroSkill race = this.getHeroSkillForRace(skillName);
        HeroSkill global = this.getHeroSkillForGlobal(skillName);
        if (primary == null && secondary == null && global == null) {
            return null;
        }
        boolean prepareRequired = true;
        if (primary != null && !primary.getClassSkill().preparedUse()) {
            prepareRequired = false;
        }
        if (secondary != null && !secondary.getClassSkill().preparedUse()) {
            prepareRequired = false;
        }
        if (race != null && !race.getClassSkill().preparedUse()) {
            prepareRequired = false;
        }
        if (global != null && !global.getClassSkill().preparedUse()) {
            prepareRequired = false;
        }
        return prepareRequired;
    }

    public Boolean isPrepareRequiredForSkillUse(Skill skill) {
        if (skill == null) {
            return null;
        }
        return this.isPreparationRequiredForSkillUse(skill.getName());
    }

    public boolean canPrepareSkill(Skill skill) {
        return skill != null && this.canPrepareSkill(skill.getName());
    }

    public boolean canPrepareSkill(String skillName) {
        if (skillName == null) {
            return false;
        }
        if (this.preparedSkills.size() >= this.getPreparedSkillLimit()) {
            return false;
        }
        if (this.preparedSkills.contains(skillName.toLowerCase())) {
            return false;
        }
        if (!this.hasAccessToSkill(skillName)) {
            return false;
        }
        OptionalInt prepareCost = this.getSkillPrepareCost(skillName);
        if (!prepareCost.isPresent()) {
            return false;
        }
        return prepareCost.getAsInt() <= this.getRemainingSkillPreparePoints();
    }

    public boolean prepareSkill(Skill skill) {
        return this.prepareSkill(skill, false);
    }

    public boolean adminPrepareSkill(Skill skill) {
        return this.prepareSkill(skill, true);
    }

    private boolean prepareSkill(Skill skill, boolean adminCommand) {
        if (!this.canPrepareSkill(skill)) {
            return false;
        }
        SkillPrepareEvent event = new SkillPrepareEvent(this, skill, adminCommand);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.preparedSkills.add(skill.getName().toLowerCase());
        this.recalculateUsedSkillPreparePoints();
        this.storage.addHeroPreparedSkill(this, skill);
        return true;
    }

    public boolean prepareSkill(String skillName) {
        return this.prepareSkill(this.plugin.getSkillManager().getSkill(skillName));
    }

    public boolean unprepareSkill(Skill skill) {
        if (skill == null) {
            return false;
        }
        if (!this.preparedSkills.contains(skill.getName().toLowerCase())) {
            return false;
        }
        this.preparedSkills.remove(skill.getName().toLowerCase());
        this.lazyRecalculateUsedSkillPreparePoints();
        this.storage.removeHeroPreparedSkill(this, skill);
        Bukkit.getPluginManager().callEvent((Event)new SkillUnprepareEvent(this, skill));
        return true;
    }

    public boolean unprepareSkill(String skillName) {
        return this.unprepareSkill(this.plugin.getSkillManager().getSkill(skillName));
    }

    public boolean setSkillPrepared(Skill skill, boolean prepared) {
        if (prepared) {
            return this.prepareSkill(skill);
        }
        return this.unprepareSkill(skill);
    }

    public boolean setSkillPrepared(String skillName, boolean prepared) {
        return this.setSkillPrepared(this.plugin.getSkillManager().getSkill(skillName), prepared);
    }

    public TreeSet<String> getPreparedSkills() {
        return new TreeSet<String>(this.preparedSkills);
    }

    public void clearPreparedSkills() {
        for (String skillName : new ArrayList<String>(this.preparedSkills)) {
            this.unprepareSkill(skillName);
        }
    }

    public int getPreparedSkillCount() {
        return this.preparedSkills.size();
    }

    public int getPreparedSkillLimit() {
        return this.getHeroClass().getPrepareSkillLimit();
    }

    public int getTotalSkillPreparePoints() {
        return (int)this.getHeroClass().getMaxSkillPreparePoints().getScaled(this);
    }

    public int getUsedSkillPreparePoints() {
        if (this.lazyRecalculateUsedSkillPreparePoints) {
            this.recalculateUsedSkillPreparePoints();
        }
        return this.usedSkillPreparePoints;
    }

    public int getRemainingSkillPreparePoints() {
        return this.getTotalSkillPreparePoints() - this.getUsedSkillPreparePoints();
    }

    public boolean hasSkillPreparePointsRemaining(int skillPreparePoints) {
        if (skillPreparePoints < 0) {
            skillPreparePoints = 0;
        }
        return skillPreparePoints <= this.getRemainingSkillPreparePoints();
    }

    public boolean hasSkillPreparePointsRemaining() {
        return this.getRemainingSkillPreparePoints() > 0;
    }

    @Deprecated
    public boolean isSpentSkillPreparePointsOverLimit() {
        return this.getRemainingSkillPreparePoints() < 0;
    }

    public OptionalInt getSkillPrepareCost(Skill skill) {
        if (skill == null) {
            return OptionalInt.empty();
        }
        return this.getSkillPrepareCost(skill.getName());
    }

    public OptionalInt getSkillPrepareCost(String skillName) {
        HeroSkill primary = this.getHeroSkillForPrimary(skillName);
        HeroSkill secondary = this.getHeroSkillForSecondary(skillName);
        HeroSkill race = this.getHeroSkillForRace(skillName);
        HeroSkill global = this.getHeroSkillForGlobal(skillName);
        int prepareCost = Integer.MAX_VALUE;
        boolean canPrepare = false;
        if (this.canUseHeroSkill(primary, true, false, false) && primary.getClassSkill().preparedUse() && primary.getPrepareCost() <= prepareCost) {
            prepareCost = primary.getPrepareCost();
            canPrepare = true;
        }
        if (this.canUseHeroSkill(secondary, true, false, false) && secondary.getClassSkill().preparedUse() && secondary.getPrepareCost() <= prepareCost) {
            prepareCost = secondary.getPrepareCost();
            canPrepare = true;
        }
        if (this.canUseHeroSkill(race, true, false, false) && race.getClassSkill().preparedUse() && race.getPrepareCost() <= prepareCost) {
            prepareCost = race.getPrepareCost();
            canPrepare = true;
        }
        if (this.canUseHeroSkill(global, true, false, false) && global.getClassSkill().preparedUse() && global.getPrepareCost() <= prepareCost) {
            prepareCost = global.getPrepareCost();
            canPrepare = true;
        }
        return canPrepare ? OptionalInt.of(prepareCost) : OptionalInt.empty();
    }

    public void recalculateUsedSkillPreparePoints() {
        this.usedSkillPreparePoints = 0;
        for (String skillName : this.preparedSkills) {
            this.usedSkillPreparePoints += this.getSkillPrepareCost(skillName).orElse(0);
        }
    }

    public void recalculateUsedSkillPreparePoints(boolean lazy) {
        if (lazy) {
            this.lazyRecalculateUsedSkillPreparePoints = true;
        } else {
            this.recalculateUsedSkillPreparePoints();
        }
    }

    public void lazyRecalculateUsedSkillPreparePoints() {
        this.recalculateUsedSkillPreparePoints(true);
    }

    @ThreadSafe
    public boolean isMaster(HeroClass heroClass) {
        return this.getHeroLevel(heroClass) >= heroClass.getMaxLevel();
    }

    public boolean isSuppressing(Skill skill) {
        return this.suppressedSkills.contains(skill.getName());
    }

    public boolean isVerboseExp() {
        return this.verboseExp;
    }

    public void setVerboseExp(boolean verbose) {
        this.verboseExp = verbose;
        this.storage.setHeroVerboseExp(this, verbose);
    }

    public boolean isVerboseMana() {
        return this.verboseMana;
    }

    public void setVerboseMana(boolean verbose) {
        this.verboseMana = verbose;
        this.storage.setHeroVerboseMana(this, verbose);
    }

    public boolean isVerboseStamina() {
        return this.verboseStamina;
    }

    public void setVerboseStamina(boolean verbose) {
        this.verboseStamina = verbose;
        this.storage.setHeroVerboseStamina(this, verbose);
    }

    public boolean isVerboseSkills() {
        return this.verboseSkills;
    }

    public void setVerboseSkills(boolean verbose) {
        this.verboseSkills = verbose;
        this.storage.setHeroVerboseSkills(this, verbose);
    }

    public DelayedSkill getDelayedSkill() {
        return this.delayedSkill;
    }

    public void setDelayedSkill(DelayedSkill wSkill) {
        this.delayedSkill = wSkill;
    }

    public boolean interruptDelayedSkill() {
        return this.cancelDelayedSkill(true);
    }

    public boolean interruptDelayedSkill(long forcedCooldown) {
        return this.cancelDelayedSkill(true, forcedCooldown);
    }

    public boolean cancelDelayedSkill() {
        return this.cancelDelayedSkill(false);
    }

    public boolean cancelDelayedSkill(boolean interrupt) {
        return this.cancelDelayedSkill(interrupt, null);
    }

    public boolean cancelDelayedSkill(boolean interrupt, Long interruptCooldown) {
        if (this.delayedSkill == null) {
            return false;
        }
        Skill skill = this.delayedSkill.getSkill();
        if (interrupt && skill.isType(SkillType.UNINTERRUPTIBLE)) {
            return false;
        }
        this.plugin.getCharacterManager().cancelDelayedSkill(this.delayedSkill);
        this.delayedSkill = null;
        if (!skill.isType(SkillType.ABILITY_PROPERTY_SONG)) {
            ActiveSkill.removeCastingEffect(this);
        }
        long appliedGlobalCooldown = Heroes.properties.globalCooldown;
        if (interrupt) {
            appliedGlobalCooldown *= 2L;
        }
        if (interrupt && skill instanceof ActiveSkill) {
            ((ActiveSkill)skill).applyInterruptCost(this, interruptCooldown);
        }
        this.setCooldown("global", appliedGlobalCooldown + System.currentTimeMillis());
        if (skill instanceof ActiveSkill) {
            ActiveSkill aSkill = (ActiveSkill)skill;
            String interruptText = aSkill.getInterruptText();
            if (interruptText != null && !interruptText.isEmpty()) {
                if (this.hasEffectType(EffectType.SILENT_ACTIONS)) {
                    Messaging.send((CommandSender)this.player, "    " + interruptText, this.player.getName(), skill.getName());
                } else {
                    skill.broadcast(this.player.getLocation(), "    " + interruptText, this.player.getName(), skill.getName());
                }
            }
        } else {
            String defaultInterruptText = ChatComponents.GENERIC_SKILL + "$1 stopped using $2!";
            if (this.hasEffectType(EffectType.SILENT_ACTIONS)) {
                Messaging.send((CommandSender)this.player, "    " + defaultInterruptText, this.player.getName(), skill.getName());
            } else {
                skill.broadcast(this.player.getLocation(), "    " + defaultInterruptText, this.player.getName(), skill.getName());
            }
        }
        return true;
    }

    public void removeCooldown(String name) {
        this.cooldowns.remove(name.toLowerCase());
        this.storage.removeHeroCooldown(this, name);
        if (this.initFlag) {
            this.recordBar.render();
        }
    }

    public void removePermission(final String permission) {
        if (this.permissionTasks != null) {
            this.permissionTasks.add(new Runnable(){

                @Override
                public void run() {
                    Hero.this.transientPerms.unsetPermission(permission);
                }
            });
        } else {
            this.transientPerms.unsetPermission(permission);
            if (!this.permissionUpdateScheduled) {
                this.permissionUpdateScheduled = true;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Hero.this.player.recalculatePermissions();
                        Hero.this.permissionUpdateScheduled = false;
                    }
                });
            }
        }
    }

    public void removePermission(Permission permission) {
        this.removePermission(permission.getName());
    }

    public void setCooldown(String name, long cooldown) {
        this.cooldowns.put(name.toLowerCase(), cooldown);
        this.storage.saveHeroCooldown(this, name, cooldown);
        if (this.initFlag) {
            this.recordBar.render();
        }
    }

    public void setExperience(HeroClass heroClass, double experience) {
        this.experience.put(heroClass.getName(), experience);
        this.storage.saveHeroXP(this, heroClass);
    }

    public void setHeroClass(HeroClass heroClass, boolean secondary) {
        this.setHeroClass(heroClass, secondary, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeroClass(HeroClass heroClass, boolean secondary, boolean race) {
        this.clearPreparedSkills();
        try {
            this.rwl.writeLock().lock();
            if (secondary) {
                this.secondClass = heroClass;
            } else if (race) {
                this.raceClass = heroClass;
            } else {
                if (this.heroClass == null || this.heroClass != heroClass) {
                    // empty if block
                }
                this.heroClass = heroClass;
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        this.storage.saveHeroClass(this, heroClass, secondary, race);
        if (!secondary && !race) {
            this.storage.resetHeroAttribute(this);
            this.initializeClassAttributeAllocations(heroClass);
            this.initializeAllocationPoints(heroClass);
            this.rebuildAttributes();
            if (this.player.getHealth() > 0.0) {
                double currentHP = this.player.getHealth();
                double maxHP = this.getMaxHealth();
                this.resetMaxHP();
                double ratio = currentHP / maxHP;
                this.player.setHealth(ratio * this.getMaxHealth());
                float currentShield = this.getShield();
                int maxShield = this.getMaxShield();
                this.resetMaxShield();
                this.setShield(maxShield > 0 ? currentShield / (float)maxShield * (float)this.getMaxShield() : 0.0f);
            }
        }
        this.getTieredLevel(true);
        this.resolveCurrentEquipment();
    }

    public HashSet<Skill> getAvailableSkills() {
        HashSet<Skill> skills = new HashSet<Skill>();
        SkillManager manager = Heroes.getInstance().getSkillManager();
        HashSet<String> skillNames = new HashSet<String>(this.heroClass.getSkillNames());
        if (this.secondClass != null) {
            skillNames.addAll(this.secondClass.getSkillNames());
        }
        if (this.raceClass != null) {
            skillNames.addAll(this.raceClass.getSkillNames());
        }
        if (HeroClass.hasGlobalSkillset()) {
            skillNames.addAll(HeroClass.getGlobalSkillset().getSkillNames());
        }
        for (String string : skillNames) {
            Skill skill = manager.getSkill(string);
            if (skill == null) continue;
            skills.add(skill);
        }
        return skills;
    }

    public void setMastered(HeroClass heroClass) {
        this.masteredClasses.add(heroClass.getName());
        this.storage.setHeroClassMastered(this, heroClass);
    }

    public List<String> getMasteredClasses() {
        return this.masteredClasses;
    }

    public boolean hasMastered(HeroClass heroClass) {
        return this.masteredClasses.contains(heroClass.getName());
    }

    public boolean hasMitigationDamageCause(EntityDamageEvent.DamageCause damageCause) {
        return this.hasMitigationDamageCause(this.getHeroClass(), damageCause) || this.hasMitigationDamageCause(this.getSecondaryClass(), damageCause) || this.hasMitigationDamageCause(this.getRaceClass(), damageCause);
    }

    public boolean hasMitigationDamageCause(HeroClass heroClass, EntityDamageEvent.DamageCause damageCause) {
        return heroClass != null && heroClass.hasMitigationDamageCause(damageCause);
    }

    public double getMaxDamageReduction() {
        return Math.max(this.getMaxDamageReduction(this.getHeroClass()), Math.max(this.getMaxDamageReduction(this.getSecondaryClass()), this.getMaxDamageReduction(this.getRaceClass())));
    }

    public double getMaxDamageReduction(HeroClass heroClass) {
        return heroClass != null ? heroClass.getMaxDamageReduction() : 0.0;
    }

    public double getPerArmorDamageReduction() {
        return Math.max(this.getPerArmorDamageReductionPercent(this.getHeroClass()), Math.max(this.getPerArmorDamageReductionPercent(this.getSecondaryClass()), this.getPerArmorDamageReductionPercent(this.getRaceClass())));
    }

    public double getPerArmorDamageReductionPercent(HeroClass heroClass) {
        return heroClass != null ? heroClass.getPerArmorDamageReductionPercent() : 0.0;
    }

    public void calculateFoodLevel() {
        double percent = (double)this.getStamina() / (double)this.getMaxStamina();
        int calculatedFoodLevel = (int)(20.0 * percent);
        if (calculatedFoodLevel > 19) {
            calculatedFoodLevel = 19;
        }
        if (Heroes.properties.foodEnabled) {
            this.player.setFoodLevel(calculatedFoodLevel);
        }
    }

    public boolean modifyAttribute(AttributeType attributeType, int attributeModifier, int allocationPointsModifier) {
        return this.modifyAttribute(this.getHeroClass(), attributeType, attributeModifier, allocationPointsModifier);
    }

    public boolean modifyAttribute(HeroClass heroClass, AttributeType attributeType, int attributeModifier, int allocationPointsModifier) {
        if (heroClass == null || !heroClass.isPrimary()) {
            return false;
        }
        String heroClassName = heroClass.getName();
        if (this.allocatedAttributes.containsKey(heroClassName)) {
            for (Map.Entry<String, AttributeSet> entry : this.allocatedAttributes.entrySet()) {
                if (!entry.getKey().equals(heroClassName) || !this.setAllocationPoints(heroClass, this.getAllocationPoints(heroClass) + allocationPointsModifier)) continue;
                AttributeSet tempAttributeSet = entry.getValue();
                int curValue = tempAttributeSet.getAttributeValue(attributeType);
                this.setAllocatedAttribute(heroClass, attributeType, curValue + attributeModifier);
                return true;
            }
        } else {
            this.initializeClassAttributeAllocations(heroClass);
            if (this.allocatedAttributes.containsKey(heroClassName)) {
                return this.modifyAttribute(heroClass, attributeType, attributeModifier, allocationPointsModifier);
            }
            Heroes.log(Level.SEVERE, "Unable to modify attributes for hero (" + this.getName() + ") and HeroClass (" + heroClassName + ")");
        }
        return false;
    }

    public void setAllocatedAttribute(AttributeType attributeType, int value) {
        this.setAllocatedAttribute(this.getHeroClass(), attributeType, value);
    }

    public void setAllocatedAttribute(HeroClass heroClass, AttributeType attributeType, int value) {
        if (heroClass == null || !heroClass.isPrimary()) {
            return;
        }
        String heroClassName = heroClass.getName();
        if (this.allocatedAttributes.containsKey(heroClassName)) {
            for (Map.Entry<String, AttributeSet> entry : this.allocatedAttributes.entrySet()) {
                if (!entry.getKey().equals(heroClassName)) continue;
                entry.getValue().setAttributeValue(attributeType, value);
                this.storage.saveHeroAttribute(this, heroClass, attributeType, value);
                if (this.getHeroClass().equals(heroClass)) {
                    this.rebuildAttribute(attributeType);
                }
                return;
            }
        } else {
            this.initializeClassAttributeAllocations(heroClass);
            if (this.allocatedAttributes.containsKey(heroClassName)) {
                this.setAllocatedAttribute(heroClass, attributeType, value);
                return;
            }
            Heroes.log(Level.SEVERE, "Unable to set attribute allocation value for hero (" + this.getName() + ") and HeroClass (" + heroClassName + ")");
        }
    }

    public boolean setAllocationPoints(int value) {
        return this.setAllocationPoints(this.getHeroClass(), value);
    }

    public boolean setAllocationPoints(HeroClass heroClass, int value) {
        if (heroClass == null || !heroClass.isPrimary()) {
            return false;
        }
        if (value < 0) {
            value = 0;
        } else if (value > Integer.MAX_VALUE) {
            value = Integer.MAX_VALUE;
        }
        String className = heroClass.getName();
        if (this.allocationPoints.containsKey(className)) {
            AtomicInteger currentAllocationPoints = this.allocationPoints.get(className);
            if (currentAllocationPoints.get() != value) {
                AttributeAllocationPointsChangeEvent event = new AttributeAllocationPointsChangeEvent(this, heroClass, value);
                Bukkit.getPluginManager().callEvent((Event)event);
                currentAllocationPoints.set(event.getAllocationPointChangeValue());
            } else {
                currentAllocationPoints.getAndSet(value);
            }
        } else {
            this.allocationPoints.put(className, new AtomicInteger(value));
        }
        this.storage.saveHeroAllocationPoint(this, heroClass, value);
        return true;
    }

    public void recalculateAttributesAndAllocationPoints() {
        HeroClass heroClass = this.getHeroClass();
        this.recalculateAttributesAndAllocationPoints(heroClass, this.getHeroLevel(heroClass));
    }

    public void recalculateAttributesAndAllocationPoints(HeroClass heroClass, int level) {
        if (!heroClass.isPrimary() || heroClass != this.heroClass) {
            return;
        }
        if (level > 1) {
            double totalSpentAllocationPoints = this.getTotalSpentAllocationPoints(heroClass);
            --level;
            double totalPossibleAllocationPoints = heroClass.getAllocationPointsPerLevel() * level;
            if (totalSpentAllocationPoints > totalPossibleAllocationPoints) {
                this.player.sendMessage(ChatColor.YELLOW + "You have spent more allocation points than normally allowed for the " + ChatColor.WHITE + heroClass + ChatColor.YELLOW + " class, and have had the allocated attributes reset for that class!");
                this.getAllocatedAttributes(heroClass).reset();
                this.storage.resetHeroAttribute(this);
                if (totalPossibleAllocationPoints > 2.147483647E9) {
                    totalPossibleAllocationPoints = 2.147483647E9;
                }
                this.setAllocationPoints(heroClass, (int)totalPossibleAllocationPoints);
                this.rebuildAttributes();
            } else {
                double calculatedPointsAvailable = totalPossibleAllocationPoints - totalSpentAllocationPoints;
                if (Double.compare(calculatedPointsAvailable, this.getAllocationPoints()) != 0) {
                    if (calculatedPointsAvailable > 2.147483647E9) {
                        calculatedPointsAvailable = 2.147483647E9;
                    }
                    this.setAllocationPoints((int)calculatedPointsAvailable);
                    this.rebuildAttributes();
                    if (this.getHeroClass().equals(heroClass)) {
                        this.player.sendMessage(ChatColor.GREEN + "Your attribute allocation points have changed. " + ChatColor.GRAY + "New balance: " + ChatColor.GREEN + this.getAllocationPoints(heroClass));
                        ChatComponents.Pairs.ATTRIBUTE_ADJUST.send((CommandSender)this.player);
                    }
                }
            }
        }
    }

    public double getTotalSpentAllocationPoints(HeroClass heroClass) {
        double totalSpentAllocationPoints = 0.0;
        totalSpentAllocationPoints += (double)this.getAttributeAllocationCost(heroClass, AttributeType.DEXTERITY, 0, this.getAllocatedAttributeValue(AttributeType.DEXTERITY));
        totalSpentAllocationPoints += (double)this.getAttributeAllocationCost(heroClass, AttributeType.CHARISMA, 0, this.getAllocatedAttributeValue(AttributeType.CHARISMA));
        totalSpentAllocationPoints += (double)this.getAttributeAllocationCost(heroClass, AttributeType.CONSTITUTION, 0, this.getAllocatedAttributeValue(AttributeType.CONSTITUTION));
        totalSpentAllocationPoints += (double)this.getAttributeAllocationCost(heroClass, AttributeType.ENDURANCE, 0, this.getAllocatedAttributeValue(AttributeType.ENDURANCE));
        totalSpentAllocationPoints += (double)this.getAttributeAllocationCost(heroClass, AttributeType.INTELLECT, 0, this.getAllocatedAttributeValue(AttributeType.INTELLECT));
        totalSpentAllocationPoints += (double)this.getAttributeAllocationCost(heroClass, AttributeType.STRENGTH, 0, this.getAllocatedAttributeValue(AttributeType.STRENGTH));
        return totalSpentAllocationPoints += (double)this.getAttributeAllocationCost(heroClass, AttributeType.WISDOM, 0, this.getAllocatedAttributeValue(AttributeType.WISDOM));
    }

    public void setSuppressed(Skill skill, boolean suppressed) {
        if (suppressed) {
            this.suppressedSkills.add(skill.getName());
            this.storage.addHeroSuppressedSkill(this, skill);
        } else {
            this.suppressedSkills.remove(skill.getName());
            this.storage.removeHeroSuppressedSkill(this, skill);
        }
    }

    public HeroClass getEnchantingClass() {
        HeroClass heroClass = this.getHeroClass();
        HeroClass secondClass = this.getSecondaryClass();
        HeroClass raceClass = this.getRaceClass();
        HeroClass highestLevelEnchanter = null;
        int level = 0;
        if (heroClass.hasExperiencetype(HeroClass.ExperienceType.ENCHANTING)) {
            level = this.getHeroLevel(heroClass);
            highestLevelEnchanter = heroClass;
        }
        if (secondClass != null && secondClass.hasExperiencetype(HeroClass.ExperienceType.ENCHANTING) && this.getHeroLevel(secondClass) > level) {
            level = this.getHeroLevel(secondClass);
            highestLevelEnchanter = secondClass;
        }
        if (raceClass != null && raceClass.hasExperiencetype(HeroClass.ExperienceType.ENCHANTING) && this.getHeroLevel(raceClass) > level) {
            highestLevelEnchanter = raceClass;
        }
        return highestLevelEnchanter;
    }

    public void syncExperience() {
        HeroClass secondClass = this.getSecondaryClass();
        if (secondClass != null && !this.syncPrimary) {
            this.syncExperience(secondClass);
        } else {
            this.syncExperience(this.getHeroClass());
        }
    }

    public void syncExperience(HeroClass hc) {
        int level = this.getHeroLevel(hc);
        int currentLevelXP = Properties.getTotalExp(level);
        double maxLevelXP = Properties.getTotalExp(level + 1) - currentLevelXP;
        double currentXP = this.getExperience(hc) - (double)currentLevelXP;
        float syncedPercent = (float)(currentXP / maxLevelXP);
        this.player.setTotalExperience(Util.getMCExperience(level));
        this.player.setExp(syncedPercent);
        this.player.setLevel(level);
    }

    public void unbind(Material material) {
        this.binds.remove(material);
        this.storage.destroyHeroBind(this, material);
    }

    public void resolveCurrentEquipment() {
        if (this.player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ArrayList<Boolean> resolutions = new ArrayList<Boolean>();
        resolutions.add(this.resolveWeapon());
        resolutions.add(this.resolveChestplate());
        resolutions.add(this.resolveOffhand());
        resolutions.add(this.resolveLeggings());
        resolutions.add(this.resolveHelmet());
        resolutions.add(this.resolveBoots());
        if (resolutions.stream().anyMatch(keptItemEquipped -> keptItemEquipped == false)) {
            Util.syncInventory(this.player, this.plugin);
        }
    }

    public boolean resolveWeapon() {
        int slot = this.player.getInventory().getHeldItemSlot();
        ItemStack itemStack = this.player.getInventory().getItem(slot);
        if (this.isEmptyItem(itemStack)) {
            return true;
        }
        Material itemType = itemStack.getType();
        if (!Util.isWeapon(itemType)) {
            return true;
        }
        if (!this.canUseAsWeapon(itemType)) {
            Util.moveItem(this, slot, itemStack);
            return false;
        }
        return true;
    }

    public ItemStack getCurrentWeapon() {
        int slot = this.player.getInventory().getHeldItemSlot();
        ItemStack itemStack = this.player.getInventory().getItem(slot);
        if (this.isEmptyItem(itemStack) || !Util.isWeapon(itemStack.getType())) {
            return null;
        }
        return itemStack;
    }

    public boolean canUseAsWeapon(Material itemType) {
        HeroClass heroClass = this.getHeroClass();
        HeroClass secondClass = this.getSecondaryClass();
        HeroClass raceClass = this.getRaceClass();
        if (this.isEmptyItemType(itemType)) {
            return true;
        }
        if (heroClass.isAllowedAllWeapons() || secondClass.isAllowedAllWeapons() || raceClass.isAllowedAllWeapons()) {
            return true;
        }
        return this.isAllowedWeapon(heroClass, itemType) || this.isAllowedWeapon(secondClass, itemType) || this.isAllowedWeapon(raceClass, itemType) || !Heroes.properties.useToolsInPermittedWeapons && Util.toolsNotAlreadyWeapons.contains(itemType.name());
    }

    public boolean isAllowedWeapon(@Nullable HeroClass heroClass, Material itemType) {
        return heroClass != null && heroClass.isAllowedWeapon(itemType, this.getHeroLevel(heroClass));
    }

    public boolean isAllowedWeaponLevelRestricted(Material itemType) {
        return this.isAllowedWeaponLevelRestricted(this.getHeroClass(), itemType) || this.isAllowedWeaponLevelRestricted(this.getSecondaryClass(), itemType) || this.isAllowedWeaponLevelRestricted(this.getRaceClass(), itemType);
    }

    public boolean isAllowedWeaponLevelRestricted(@Nullable HeroClass heroClass, Material itemType) {
        return heroClass != null && heroClass.isAllowedWeaponLevelRestricted(itemType);
    }

    public int getMaxAllowedWeaponLevel(Material itemType) {
        int primaryLevelRequired = this.getAllowedWeaponLevel(this.getHeroClass(), itemType);
        int secondaryLevelRequired = this.getAllowedWeaponLevel(this.getSecondaryClass(), itemType);
        int raceLevelRequired = this.getAllowedWeaponLevel(this.getRaceClass(), itemType);
        return Math.max(Math.max(primaryLevelRequired, secondaryLevelRequired), raceLevelRequired);
    }

    public int getMaxRequiredAllowedWeaponLevel(Material itemType) {
        List<EquipmentUtil.RequiredClassLevel> requiredClassLevels = EquipmentUtil.getItemRequiredClassLevels(this, itemType, false, false);
        int maxLevelRequired = 1;
        for (EquipmentUtil.RequiredClassLevel requiredClassLevel : requiredClassLevels) {
            if (requiredClassLevel.getLevel() <= maxLevelRequired) continue;
            maxLevelRequired = requiredClassLevel.getLevel();
        }
        return maxLevelRequired;
    }

    public int getAllowedWeaponLevel(@Nullable HeroClass heroClass, Material itemType) {
        return heroClass != null ? heroClass.getAllowedWeaponLevel(itemType) : 1;
    }

    public boolean resolveHelmet() {
        ItemStack itemStack = this.player.getInventory().getHelmet();
        if (this.isEmptyItem(itemStack)) {
            return true;
        }
        PlayerInventory inventory = this.player.getInventory();
        Material itemType = itemStack.getType();
        if (this.isCurrentlyOverweight() || !this.canUseAsHelmet(itemType)) {
            Util.moveItem(this, -1, itemStack);
            inventory.setHelmet(null);
            return false;
        }
        return true;
    }

    public boolean canUseAsHat(Material itemType) {
        HeroClass heroClass = this.getHeroClass();
        HeroClass secondClass = this.getSecondaryClass();
        if (this.isEmptyItemType(itemType)) {
            return true;
        }
        int hatsLevel = Heroes.properties.hatsLevel;
        return !EquipmentType.isRecognizedType(itemType) && Heroes.properties.allowHats && (this.getHeroLevel(heroClass) >= hatsLevel || secondClass != null && this.getHeroLevel(secondClass) >= hatsLevel);
    }

    public boolean canUseAsHelmet(Material itemType) {
        if (this.isEmptyItemType(itemType)) {
            return true;
        }
        return this.canUseAsHat(itemType) || this.canUseAsArmor(itemType);
    }

    public boolean resolveChestplate() {
        ItemStack itemStack = this.player.getInventory().getChestplate();
        if (this.isEmptyItem(itemStack)) {
            return true;
        }
        PlayerInventory inventory = this.player.getInventory();
        Material itemType = itemStack.getType();
        if (this.isCurrentlyOverweight() || !this.canUseAsArmor(itemType)) {
            Util.moveItem(this, -1, itemStack);
            inventory.setChestplate(null);
            return false;
        }
        return true;
    }

    public boolean resolveLeggings() {
        ItemStack itemStack = this.player.getInventory().getLeggings();
        if (this.isEmptyItem(itemStack)) {
            return true;
        }
        PlayerInventory inventory = this.player.getInventory();
        Material itemType = itemStack.getType();
        if (this.isCurrentlyOverweight() || !this.canUseAsArmor(itemType)) {
            Util.moveItem(this, -1, itemStack);
            inventory.setLeggings(null);
            return false;
        }
        return true;
    }

    public boolean resolveBoots() {
        ItemStack itemStack = this.player.getInventory().getBoots();
        if (this.isEmptyItem(itemStack)) {
            return true;
        }
        PlayerInventory inventory = this.player.getInventory();
        Material itemType = itemStack.getType();
        if (this.isCurrentlyOverweight() || !this.canUseAsArmor(itemType)) {
            Util.moveItem(this, -1, itemStack);
            inventory.setBoots(null);
            return false;
        }
        return true;
    }

    public boolean canUseAsArmor(Material itemType) {
        HeroClass heroClass = this.getHeroClass();
        HeroClass secondClass = this.getSecondaryClass();
        HeroClass raceClass = this.getRaceClass();
        if (this.isEmptyItemType(itemType)) {
            return true;
        }
        if (heroClass.isAllowedAllArmor() || secondClass.isAllowedAllArmor() || raceClass.isAllowedAllArmor()) {
            return true;
        }
        return this.isAllowedArmor(heroClass, itemType) || this.isAllowedArmor(secondClass, itemType) || this.isAllowedArmor(raceClass, itemType);
    }

    public boolean isAllowedArmor(@Nullable HeroClass heroClass, Material itemType) {
        return heroClass != null && heroClass.isAllowedArmor(itemType, this.getHeroLevel(heroClass));
    }

    public boolean resolveOffhand() {
        ItemStack item = this.getCurrentOffhandItem();
        if (item != null && (!this.canUseAsOffhand(item.getType()) || this.isCurrentlyOverweight())) {
            this.unequipItemFromOffhand(item);
            return false;
        }
        return true;
    }

    @Nullable
    public ItemStack getCurrentOffhandItem() {
        return NMSHandler.getInterface().getItemInOffHand(this.player.getInventory());
    }

    public boolean canUseAsOffhand(Material itemType) {
        HeroClass heroClass = this.getHeroClass();
        HeroClass secondClass = this.getSecondaryClass();
        HeroClass raceClass = this.getRaceClass();
        if (this.isEmptyItemType(itemType)) {
            return true;
        }
        if (!Util.isWeapon(itemType) && !Util.isTrinket(itemType)) {
            return true;
        }
        if (heroClass.isAllowedAllOffhand() || secondClass.isAllowedAllOffhand() || raceClass.isAllowedAllOffhand()) {
            return true;
        }
        return this.isAllowedOffhand(heroClass, itemType) || this.isAllowedOffhand(secondClass, itemType) || this.isAllowedOffhand(raceClass, itemType);
    }

    public boolean isAllowedOffhand(@Nullable HeroClass heroClass, Material itemType) {
        return heroClass != null && heroClass.isAllowedOffhand(itemType, this.getHeroLevel(heroClass));
    }

    public boolean isAllowedOffhandLevelRestricted(Material itemType) {
        return this.isAllowedOffhandLevelRestricted(this.getHeroClass(), itemType) || this.isAllowedOffhandLevelRestricted(this.getSecondaryClass(), itemType) || this.isAllowedOffhandLevelRestricted(this.getRaceClass(), itemType);
    }

    public boolean isAllowedOffhandLevelRestricted(@Nullable HeroClass heroClass, Material itemType) {
        return heroClass != null && heroClass.isAllowedOffhandLevelRestricted(itemType);
    }

    public int getMaxAllowedOffhandLevel(Material itemType) {
        int primaryLevelRequired = this.getAllowedOffhandLevel(this.getHeroClass(), itemType);
        int secondaryLevelRequired = this.getAllowedOffhandLevel(this.getSecondaryClass(), itemType);
        int raceLevelRequired = this.getAllowedOffhandLevel(this.getRaceClass(), itemType);
        return Math.max(Math.max(primaryLevelRequired, secondaryLevelRequired), raceLevelRequired);
    }

    public int getMaxRequiredAllowedOffhandLevel(Material itemType) {
        List<EquipmentUtil.RequiredClassLevel> requiredClassLevels = EquipmentUtil.getItemRequiredClassLevels(this, itemType, false, true);
        int maxLevelRequired = 1;
        for (EquipmentUtil.RequiredClassLevel requiredClassLevel : requiredClassLevels) {
            if (requiredClassLevel.getLevel() <= maxLevelRequired) continue;
            maxLevelRequired = requiredClassLevel.getLevel();
        }
        return maxLevelRequired;
    }

    public int getAllowedOffhandLevel(@Nullable HeroClass heroClass, Material itemType) {
        return heroClass != null ? heroClass.getAllowedOffhandLevel(itemType) : 1;
    }

    public void unequipItemFromOffhand(ItemStack item) {
        Util.moveItem(this, -1, item);
        PlayerInventory inventory = this.player.getInventory();
        Util.safelySetItemInOffhand(inventory, null);
    }

    public boolean isCurrentlyOverweight() {
        return Heroes.properties.checkEquipmentWeight && this.getCurrentEquipmentWeight() > this.getMaxEquipmentWeight();
    }

    public boolean wouldBecomeOverweight(ItemStack oldArmorPiece, ItemStack newArmorPiece) {
        Double oldPieceWeight = oldArmorPiece == null ? 0.0 : Heroes.properties.equipmentWeightMap.getOrDefault(oldArmorPiece.getType(), 0.0);
        Double newItemWeight = newArmorPiece == null ? 0.0 : Heroes.properties.equipmentWeightMap.getOrDefault(newArmorPiece.getType(), 0.0);
        Double currentEquipWeight = this.getCurrentEquipmentWeight();
        Double newEquipWeight = currentEquipWeight - oldPieceWeight + newItemWeight;
        return newEquipWeight > this.getMaxEquipmentWeight();
    }

    private boolean isEmptyItemType(Material itemType) {
        return itemType == null || itemType == Material.AIR;
    }

    private boolean isEmptyItem(ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }

    public void sendOverweightMessage(Material material) {
        if (!Heroes.properties.checkEquipmentWeight) {
            return;
        }
        this.player.sendMessage(ChatColor.GRAY + "You do not have enough equipment weight to wear that " + ChatColor.WHITE + MaterialUtil.getFriendlyName(material) + ChatColor.GRAY + "Use " + ChatColor.WHITE + "/stats" + ChatColor.GRAY + "or " + ChatColor.WHITE + "/hero armor " + ChatColor.GRAY + " to show your equipment weight");
    }

    public void sendEquipmentWeightChangedMessage() {
        if (!Heroes.properties.checkEquipmentWeight) {
            return;
        }
        this.player.sendMessage(ChatColor.GRAY + "Your current equipment weight is: " + ChatColor.WHITE + Util.decFormat.format(this.getCurrentEquipmentWeight()) + ChatColor.GRAY + "/" + ChatColor.WHITE + Util.decFormat.format(this.getMaxEquipmentWeight()));
    }

    public boolean isAllowedArmorLevelRestricted(Material itemType) {
        return this.isAllowedArmorLevelRestricted(this.getHeroClass(), itemType) || this.isAllowedArmorLevelRestricted(this.getSecondaryClass(), itemType) || this.isAllowedArmorLevelRestricted(this.getRaceClass(), itemType);
    }

    public boolean isAllowedArmorLevelRestricted(@Nullable HeroClass heroClass, Material itemType) {
        return heroClass != null && heroClass.isAllowedArmorLevelRestricted(itemType);
    }

    public int getMaxAllowedArmorLevel(Material itemType) {
        int primaryLevelRequired = this.getAllowedArmorLevel(this.getHeroClass(), itemType);
        int secondaryLevelRequired = this.getAllowedArmorLevel(this.getSecondaryClass(), itemType);
        int raceLevelRequired = this.getAllowedArmorLevel(this.getRaceClass(), itemType);
        return Math.max(Math.max(primaryLevelRequired, secondaryLevelRequired), raceLevelRequired);
    }

    public int getMaxRequiredAllowedArmorLevel(Material itemType) {
        List<EquipmentUtil.RequiredClassLevel> requiredClassLevels = EquipmentUtil.getItemRequiredClassLevels(this, itemType, true, false);
        int maxLevelRequired = 1;
        for (EquipmentUtil.RequiredClassLevel requiredClassLevel : requiredClassLevels) {
            if (requiredClassLevel.getLevel() <= maxLevelRequired) continue;
            maxLevelRequired = requiredClassLevel.getLevel();
        }
        return maxLevelRequired;
    }

    public int getAllowedArmorLevel(@Nullable HeroClass heroClass, Material itemType) {
        return heroClass != null ? heroClass.getAllowedArmorLevel(itemType) : 1;
    }

    public boolean canCraft(Object object) {
        HeroClass heroClass;
        int level;
        if (object instanceof ItemStack && ((ItemStack)object).getType() == Material.MAP) {
            object = Material.MAP;
        }
        if ((level = (heroClass = this.getHeroClass()).getCraftLevel(object)) != -1 && level <= this.getHeroLevel(heroClass)) {
            return true;
        }
        HeroClass secondClass = this.getSecondaryClass();
        if (secondClass != null && (level = secondClass.getCraftLevel(object)) != -1 && level <= this.getHeroLevel(secondClass)) {
            return true;
        }
        HeroClass raceClass = this.getRaceClass();
        return raceClass != null && (level = raceClass.getCraftLevel(object)) != -1 && level <= this.getHeroLevel(raceClass);
    }

    public boolean isSyncPrimary() {
        return this.syncPrimary;
    }

    public void setSyncPrimary(boolean syncPrimary) {
        this.syncPrimary = syncPrimary || this.getSecondaryClass() == null;
        this.syncExperience();
    }

    public void resetCombatEffect() {
        this.addEffect(this.combat);
    }

    public boolean isInCombat() {
        return this.combat.isInCombat();
    }

    public void recheckCombat() {
        if (this.combat.getTimeLeft() == 0L) {
            this.combat.clearCombatants();
        } else {
            ArrayList<LivingEntity> combatants = new ArrayList<LivingEntity>(this.combat.getCombatants().keySet());
            for (LivingEntity entity : combatants) {
                if (!entity.isDead() && entity.isValid()) continue;
                this.combat.leaveCombatWith(this, entity, CombatEffect.LeaveCombatReason.ERROR);
            }
        }
    }

    public boolean isInCombatWith(LivingEntity target) {
        return this.combat.isInCombatWith(target);
    }

    public boolean enterCombatWith(LivingEntity entity, CombatEffect.CombatReason reason) {
        boolean start = !this.combat.isInCombat();
        this.combat.enterCombatWith(entity, reason);
        if (start && Heroes.properties.combatEnterMessage != null && !Heroes.properties.combatEnterMessage.isEmpty()) {
            this.getPlayer().sendMessage(ChatColor.GRAY + Heroes.properties.combatEnterMessage);
        }
        return start;
    }

    public void refreshCombat() {
        this.combat.reset();
    }

    public CombatEffect getCombatEffect() {
        return this.combat;
    }

    public boolean leaveCombatWith(LivingEntity entity, CombatEffect.LeaveCombatReason reason) {
        this.combat.leaveCombatWith(this, entity, reason);
        if (!this.combat.isInCombat() && Heroes.properties.combatExitMessage != null && !Heroes.properties.combatExitMessage.isEmpty()) {
            this.getPlayer().sendMessage(ChatColor.DARK_GRAY + Heroes.properties.combatExitMessage);
        }
        return !this.combat.isInCombat();
    }

    public void leaveCombat(CombatEffect.LeaveCombatReason reason) {
        switch (reason) {
            case LOGOUT: {
                this.combat.leaveCombatFromLogout(this);
                break;
            }
            case DEATH: {
                this.combat.leaveCombatFromDeath(this);
                break;
            }
            case SUICIDE: {
                this.combat.leaveCombatFromSuicide(this);
                break;
            }
        }
    }

    public Map<LivingEntity, CombatEffect.CombatReason> getCombatants() {
        return this.combat.getCombatants();
    }

    public Location getViewingLocation(double distance) {
        Location location = this.getPlayer().getLocation();
        location.add(location.getDirection().normalize().multiply(distance));
        return location;
    }

    public double getExpPercent(HeroClass heroClass) {
        int exp = (int)this.getExperience(heroClass);
        int level = Properties.getLevel(exp);
        int current = Properties.getTotalExp(level);
        int next = Properties.getTotalExp(level + 1);
        return (double)(exp - current) / (double)(next - current) * 100.0;
    }

    public boolean isDisconnecting() {
        return this.disconnecting;
    }

    public void setDisconnecting(boolean disconnecting) {
        this.disconnecting = disconnecting;
    }

    public Map<String, Boolean> getPerms() {
        return this.transientPerms.getPermissions();
    }

    public boolean checkDuplicate(Player p) {
        return !this.getPlayer().getUniqueId().equals(p.getUniqueId());
    }

    public String getDuplicateMessage() {
        return "Hero with duplicate player object detected and reloaded, you have a plugin causing duplicate player objects!";
    }

    public void checkClasses() {
        if (!CommandHandler.hasPermission((CommandSender)this.player, "heroes.classes." + this.heroClass.getName().toLowerCase())) {
            this.setHeroClass(this.plugin.getClassManager().getDefaultClass(), false, false);
        }
        if (this.secondClass != null && !CommandHandler.hasPermission((CommandSender)this.player, "heroes.classes." + this.secondClass.getName().toLowerCase())) {
            this.setHeroClass(null, true, false);
        }
        if (!(this.raceClass == null || CommandHandler.hasPermission((CommandSender)this.player, "heroes.classes." + this.raceClass.getName().toLowerCase()) && CommandHandler.hasPermission((CommandSender)this.player, "heroes.races." + this.raceClass.getName().toLowerCase()))) {
            this.setHeroClass(null, false, true);
        }
    }

    public Storage getStorage() {
        return this.storage;
    }

    public String toString() {
        return this.player.toString();
    }

    private /* synthetic */ void lambda$handleRunCommands$0(List commands, CommandSender commandSource) {
        for (String command : commands) {
            this.plugin.getServer().dispatchCommand(commandSource, command.replace("{PLAYER_NAME}", this.player.getName()).replace("{player_name}", this.player.getName()));
        }
    }
}

