/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CustomNameManager {
    private static final String KEY_ORIGINAL_CUSTOM_NAME = "Heroes$OriginalCustomName";
    private static final String KEY_CUSTOM_NAME_TAINTED = "Heroes$CustomNameTainted";
    private static final FixedMetadataValue TAINTED = new FixedMetadataValue((Plugin)Heroes.getInstance(), (Object)true);
    public static final String HEALTH_IDENTIFIER = " " + ChatColor.BLACK.toString() + ChatColor.GREEN.toString();

    public static String getCustomName(LivingEntity entity) {
        String name = entity.hasMetadata(KEY_ORIGINAL_CUSTOM_NAME) ? ((MetadataValue)entity.getMetadata(KEY_ORIGINAL_CUSTOM_NAME).get(0)).asString() : CustomNameManager.getName((Entity)entity);
        return CustomNameManager.stripHeroes(name);
    }

    public static void storeCustomName(LivingEntity entity) {
        boolean hasMeta;
        String customName = entity.getCustomName();
        boolean bl = hasMeta = entity.hasMetadata(KEY_ORIGINAL_CUSTOM_NAME) || entity.hasMetadata(KEY_CUSTOM_NAME_TAINTED);
        if (customName != null && !customName.isEmpty() && !hasMeta) {
            entity.setMetadata(KEY_ORIGINAL_CUSTOM_NAME, (MetadataValue)new FixedMetadataValue((Plugin)Heroes.getInstance(), (Object)customName));
        } else if (!hasMeta) {
            entity.setMetadata(KEY_CUSTOM_NAME_TAINTED, (MetadataValue)TAINTED);
        }
    }

    public static void restoreOriginalName(LivingEntity entity) {
        String currentDisplayName = entity.getCustomName();
        if (currentDisplayName != null && currentDisplayName.contains(HEALTH_IDENTIFIER)) {
            entity.setCustomName(CustomNameManager.stripHeroes(currentDisplayName));
            entity.removeMetadata(KEY_CUSTOM_NAME_TAINTED, (Plugin)Heroes.getInstance());
        }
        if (entity.hasMetadata(KEY_ORIGINAL_CUSTOM_NAME)) {
            entity.setCustomName(((MetadataValue)entity.getMetadata(KEY_ORIGINAL_CUSTOM_NAME).get(0)).asString());
        } else if (entity.hasMetadata(KEY_CUSTOM_NAME_TAINTED)) {
            entity.setCustomName(null);
            entity.setCustomNameVisible(false);
            entity.removeMetadata(KEY_CUSTOM_NAME_TAINTED, (Plugin)Heroes.getInstance());
        }
    }

    private static String stripHeroes(String name) {
        if (name.contains(HEALTH_IDENTIFIER)) {
            return name.split(HEALTH_IDENTIFIER)[0];
        }
        return name;
    }

    public static String getName(CharacterTemplate character) {
        return CustomNameManager.getName((Entity)character.getEntity());
    }

    public static String getName(Entity entity) {
        if (entity instanceof Player) {
            return entity.getName();
        }
        if (entity instanceof LivingEntity && entity.getCustomName() != null) {
            return entity.getCustomName().replaceAll(" \u00a7.\\d+/\\d+", "");
        }
        return entity.getClass().getSimpleName().substring(5);
    }
}

