/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.annotation.ThreadSafe;
import com.herocraftonline.heroes.api.events.CharacterRegainHealthEvent;
import com.herocraftonline.heroes.api.events.EffectAddEvent;
import com.herocraftonline.heroes.api.events.EffectRemoveEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.Expirable;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.effects.ManagedStack;
import com.herocraftonline.heroes.characters.effects.Periodic;
import com.herocraftonline.heroes.characters.effects.PeriodicDamageEffect;
import com.herocraftonline.heroes.characters.effects.common.interfaces.Burning;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.nms.attribute.ICharacterAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;

public abstract class CharacterTemplate {
    private final Map<String, Effect> effects = new HashMap<String, Effect>();
    protected final Heroes plugin;
    protected final LivingEntity lEntity;
    protected Map<String, Double> healthMap = new ConcurrentHashMap<String, Double>();
    protected final String name;

    public CharacterTemplate(Heroes plugin, LivingEntity entity, @Nullable String name) {
        this.plugin = plugin;
        this.lEntity = entity;
        this.name = name != null ? name : entity.getType().getName();
    }

    public String getName() {
        return this.name;
    }

    public double getMaxHealth() {
        return this.lEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
    }

    @Nullable
    public Effect getEffect(String name) {
        return this.effects.get(name.toLowerCase());
    }

    public Set<Effect> getEffects() {
        return new HashSet<Effect>(this.effects.values());
    }

    public void addEffect(Effect effect) {
        Effect previousEffect = this.getEffect(effect.getName());
        if (previousEffect != null) {
            if (!this.isEffectMorePowerful(effect, previousEffect)) {
                return;
            }
            previousEffect.setRemoveText(null);
            this.removeEffect(previousEffect);
        }
        EffectAddEvent event = new EffectAddEvent(this, effect);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        this.plugin.getEffectManager().manageEffect(this, effect);
        this.effects.put(effect.getName().toLowerCase(), effect);
        effect.apply(this);
    }

    public long getRemainingEffectDuration(String name) {
        Effect effect = this.getEffect(name.toLowerCase());
        return effect instanceof Expirable ? ((Expirable)((Object)effect)).getRemainingTime() : 0L;
    }

    public <T extends Effect> Effect setEffectDuration(String name, Skill skill, Player applier, Function<Long, Long> durationFunction, Supplier<T> effectBuilder) {
        Effect effect = this.getEffect(name.toLowerCase());
        if (effect == null) {
            if (effectBuilder != null) {
                effect = (Effect)effectBuilder.get();
                this.addEffect(effect);
            }
        } else if (effect instanceof Expirable) {
            Expirable expirable = (Expirable)((Object)effect);
            long newDuration = durationFunction.apply(expirable.getRemainingTime());
            if (newDuration != expirable.getRemainingTime()) {
                if (newDuration > 0L) {
                    if (newDuration < expirable.getRemainingTime()) {
                        skill = effect.getSkill();
                        applier = effect.getApplier();
                    }
                    expirable.setDuration(newDuration);
                    effect.setSkill(skill);
                    effect.setApplier(applier);
                } else {
                    this.removeEffect(effect);
                }
            }
        } else {
            throw new IllegalStateException("Can not set the duration of non expirable effect `" + name + "`!");
        }
        return effect;
    }

    public Effect setEffectDuration(String name, Skill skill, Player applier, Function<Long, Long> durationFunction) {
        return this.setEffectDuration(name, skill, applier, durationFunction, null);
    }

    public <T extends Effect> Effect setEffectDuration(String name, Skill skill, Player applier, long duration, boolean keepLongerDuration, Supplier<T> effectBuilder) {
        return this.setEffectDuration(name, skill, applier, currentRemaining -> keepLongerDuration && currentRemaining > duration ? currentRemaining : duration, effectBuilder);
    }

    public <T extends Effect> Effect setEffectDuration(String name, Skill skill, Player applier, long duration, Supplier<T> effectBuilder) {
        return this.setEffectDuration(name, skill, applier, duration, false, effectBuilder);
    }

    public <T extends Effect> Effect addEffectDuration(String name, Skill skill, Player applier, long amount, Supplier<T> effectBuilder) {
        if (amount <= 0L) {
            return this.getEffect(name);
        }
        return this.setEffectDuration(name, skill, applier, currentRemaining -> currentRemaining + amount, effectBuilder);
    }

    public Effect subtractEffectDuration(String name, Skill skill, Player applier, long amount) {
        if (amount <= 0L) {
            return this.getEffect(name);
        }
        return this.setEffectDuration(name, skill, applier, currentRemaining -> currentRemaining - amount, null);
    }

    public Effect setEffectDuration(String name, Skill skill, Player applier, long duration, boolean keepLongerDuration) {
        return this.setEffectDuration(name, skill, applier, currentRemaining -> keepLongerDuration && currentRemaining > duration ? currentRemaining : duration, null);
    }

    public Effect setEffectDuration(String name, Skill skill, Player applier, long duration) {
        return this.setEffectDuration(name, skill, applier, duration, false, null);
    }

    public Effect addEffectDuration(String name, Skill skill, Player applier, long amount) {
        if (amount <= 0L) {
            return this.getEffect(name);
        }
        return this.setEffectDuration(name, skill, applier, currentRemaining -> currentRemaining + amount, null);
    }

    public int getEffectStackCount(String name) {
        Effect effect = this.getEffect(name.toLowerCase());
        return effect instanceof ManagedStack ? ((ManagedStack)((Object)effect)).getStackCount() : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends Effect> int addEffectStacks(String name, Skill skill, Player applier, long duration, int amount, Supplier<T> effectBuilder) {
        ManagedStack stackingEffect;
        Effect effect = this.getEffect(name.toLowerCase());
        if (effect == null) {
            if (effectBuilder == null) return 0;
            Effect createdEffect = (Effect)effectBuilder.get();
            stackingEffect = (ManagedStack)((Object)createdEffect);
            this.addEffect(createdEffect);
            return stackingEffect.addStacks(skill, applier, duration, amount);
        } else {
            if (!(effect instanceof ManagedStack)) throw new IllegalStateException("Can not apply effect stacks to non stacking effect `" + name + "`!");
            stackingEffect = (ManagedStack)((Object)effect);
        }
        return stackingEffect.addStacks(skill, applier, duration, amount);
    }

    public <T extends Effect> boolean addEffectStack(String name, Skill skill, Player applier, long duration, Supplier<T> effectBuilder) {
        return this.addEffectStacks(name, skill, applier, duration, 1, effectBuilder) == 1;
    }

    public int addEffectStacks(String name, Skill skill, Player applier, long duration, int amount) {
        return this.addEffectStacks(name, skill, applier, duration, amount, null);
    }

    public boolean addEffectStack(String name, Skill skill, Player applier, long duration) {
        return this.addEffectStack(name, skill, applier, duration, null);
    }

    public boolean removeEffectStack(String name) {
        return this.removeEffectStacks(name, 1) == 1;
    }

    public int removeEffectStacks(String name, int amount) {
        Effect effect = this.getEffect(name.toLowerCase());
        return effect instanceof ManagedStack ? ((ManagedStack)((Object)effect)).removeStacks(amount) : 0;
    }

    public int removeAllEffectStacks(String name) {
        Effect effect = this.getEffect(name.toLowerCase());
        return effect instanceof ManagedStack ? ((ManagedStack)((Object)effect)).removeAllStacks() : 0;
    }

    private boolean isEffectMorePowerful(Effect effect, Effect previousEffect) {
        boolean newEffectMorePowerful = false;
        if (effect instanceof ManagedStack && previousEffect instanceof ManagedStack) {
            actualEffect = (ManagedStack)((Object)effect);
            previousActualEffect = (ManagedStack)((Object)previousEffect);
            if (previousActualEffect.getStackCount() <= actualEffect.getStackCount()) {
                newEffectMorePowerful = true;
            }
        } else if (effect instanceof PeriodicDamageEffect && previousEffect instanceof PeriodicDamageEffect) {
            actualEffect = (PeriodicDamageEffect)effect;
            previousActualEffect = (PeriodicDamageEffect)previousEffect;
            if (((PeriodicDamageEffect)previousActualEffect).getTickDamage() <= ((PeriodicDamageEffect)actualEffect).getTickDamage()) {
                newEffectMorePowerful = true;
            } else if (((ExpirableEffect)previousActualEffect).getRemainingTime() <= ((ExpirableEffect)previousActualEffect).getDuration()) {
                newEffectMorePowerful = true;
            }
        } else if (effect instanceof Burning && previousEffect instanceof Burning) {
            actualEffect = (Burning)((Object)effect);
            previousActualEffect = (Burning)((Object)previousEffect);
            if (previousActualEffect.getDamageMultiplier() < previousActualEffect.getDamageMultiplier()) {
                newEffectMorePowerful = true;
            } else {
                previousActualEffect.addDuration(actualEffect.getDuration());
            }
        } else if (effect instanceof ExpirableEffect && previousEffect instanceof ExpirableEffect) {
            actualEffect = (ExpirableEffect)effect;
            previousActualEffect = (ExpirableEffect)previousEffect;
            if (((ExpirableEffect)previousActualEffect).getRemainingTime() <= ((ExpirableEffect)previousActualEffect).getDuration()) {
                newEffectMorePowerful = true;
            }
        }
        if (!newEffectMorePowerful) {
            Set<PotionEffect> previousPotionEffects = previousEffect.getPotionEffects();
            Set<PotionEffect> newPotionEffects = effect.getPotionEffects();
            if (previousPotionEffects != null && previousPotionEffects.size() > 0 && newPotionEffects != null && newPotionEffects.size() > 0) {
                for (PotionEffect previousPotionEffect : previousPotionEffects) {
                    for (PotionEffect newPotionEffect : newPotionEffects) {
                        if (previousPotionEffect.getType() != newPotionEffect.getType() || previousPotionEffect.getAmplifier() >= newPotionEffect.getAmplifier()) continue;
                        newEffectMorePowerful = true;
                        break;
                    }
                    if (!newEffectMorePowerful) continue;
                    break;
                }
            }
        }
        return newEffectMorePowerful;
    }

    public boolean isEntityValid() {
        return this.lEntity.isValid();
    }

    public abstract boolean isAlliedTo(LivingEntity var1);

    public boolean hasEffect(String name) {
        return this.effects.containsKey(name.toLowerCase());
    }

    public boolean hasEffectType(EffectType type) {
        for (Effect effect : this.effects.values()) {
            if (!effect.isType(type)) continue;
            return true;
        }
        return false;
    }

    public void removeEffect(Effect effect) {
        if (effect != null) {
            EffectRemoveEvent event = new EffectRemoveEvent(this, effect);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (effect instanceof Expirable || effect instanceof Periodic || effect instanceof ManagedStack) {
                this.plugin.getEffectManager().queueForRemoval(this, effect);
            }
            effect.remove(this);
            this.effects.remove(effect.getName().toLowerCase());
        }
    }

    public void manualRemoveEffect(Effect effect) {
        if (effect != null) {
            EffectRemoveEvent event = new EffectRemoveEvent(this, effect);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (effect instanceof Expirable || effect instanceof Periodic || effect instanceof ManagedStack) {
                this.plugin.getEffectManager().queueForRemoval(this, effect);
            }
            effect.removePotionEffects(this);
            this.effects.remove(effect.getName().toLowerCase());
        }
    }

    public void clearEffects(boolean skipInternal) {
        for (Effect effect : this.getEffects()) {
            if (skipInternal && effect.isType(EffectType.INTERNAL)) continue;
            this.removeEffect(effect);
        }
    }

    public void silentClearEffects(boolean skipInternal) {
        for (Effect effect : this.getEffects()) {
            if (skipInternal && effect.isType(EffectType.INTERNAL)) continue;
            this.manualRemoveEffect(effect);
        }
    }

    public LivingEntity getEntity() {
        return this.lEntity;
    }

    public boolean addMaxHealth(String key, double health) {
        if (this.lEntity.getHealth() < 1.0) {
            return false;
        }
        if (this.healthMap.containsKey(key)) {
            return false;
        }
        this.healthMap.put(key, health);
        AttributeInstance maxHealth = this.lEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        maxHealth.setBaseValue(maxHealth.getBaseValue() + health);
        this.lEntity.setHealth(health + this.lEntity.getHealth());
        return true;
    }

    @Deprecated
    public boolean addMaxHealth(String key, int health) {
        return this.addMaxHealth(key, (double)health);
    }

    @ThreadSafe
    public boolean removeMaxHealth(String key) {
        Double old = this.healthMap.remove(key);
        if (old != null) {
            double currentHealth = this.lEntity.getHealth();
            double newHealth = this.lEntity.getHealth() - old;
            if (!(currentHealth <= 0.0) && newHealth < 1.0) {
                newHealth = 1.0;
            }
            if (this.lEntity.getHealth() != 0.0) {
                this.lEntity.setHealth(newHealth);
            }
            AttributeInstance maxHealth = this.lEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            maxHealth.setBaseValue(maxHealth.getBaseValue() - old);
            return true;
        }
        return false;
    }

    @ThreadSafe
    public void clearHealthBonuses() {
        double current = this.lEntity.getHealth();
        int minus = 0;
        Iterator<Map.Entry<String, Double>> iter = this.healthMap.entrySet().iterator();
        while (iter.hasNext()) {
            Double value = iter.next().getValue();
            iter.remove();
            current -= value.doubleValue();
            minus = (int)((double)minus + value);
        }
        if (this.lEntity.getHealth() != 0.0) {
            this.lEntity.setHealth(current < 0.0 ? 0.0 : current);
        }
        AttributeInstance maxHealth = this.lEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        maxHealth.setBaseValue(maxHealth.getBaseValue() - (double)minus);
    }

    public void heal(double amount) {
        double current = this.lEntity.getHealth();
        double max = this.lEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        if (this.lEntity.isDead() || current <= 0.0) {
            return;
        }
        if (current + amount > max) {
            this.lEntity.setHealth(max);
        } else {
            this.lEntity.setHealth(current + amount);
        }
    }

    public boolean tryHeal(double amount) {
        return this.tryHeal(this, null, amount);
    }

    public boolean tryHeal(Skill skill, double amount) {
        return this.tryHeal(this, skill, amount);
    }

    public boolean tryHeal(CharacterTemplate healer, Skill skill, double amount) {
        CharacterRegainHealthEvent event = this.getRegainHealthEvent(healer, amount, skill);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            if (healer instanceof Hero) {
                healer.getEntity().sendMessage("    " + ChatComponents.GENERIC_SKILL + "Your target had their healing prevented!");
            }
            return false;
        }
        this.heal((Double)event.getDelta());
        return true;
    }

    protected CharacterRegainHealthEvent getRegainHealthEvent(CharacterTemplate healer, double amount, Skill skill) {
        return new CharacterRegainHealthEvent(this, amount, skill, healer);
    }

    public int hashCode() {
        return this.lEntity.getUniqueId().hashCode();
    }

    public boolean equals(Object other) {
        return other == this || other instanceof CharacterTemplate && ((CharacterTemplate)other).lEntity.getUniqueId().equals(this.lEntity.getUniqueId());
    }

    public double loadOrCreateAttrib(ICharacterAttribute attribute, double val) {
        return attribute.loadOrCreate(this.lEntity, val);
    }
}

