/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroLeavePartyEvent;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.ManaUpdater;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.ShieldUpdater;
import com.herocraftonline.heroes.characters.StaminaUpdater;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.DelayedSkill;
import com.herocraftonline.heroes.characters.skill.Listenable;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.Passive;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.CommandHandler;
import com.herocraftonline.heroes.integrations.citizens.CitizensHero;
import com.herocraftonline.heroes.integrations.citizens.CitizensTraitStorage;
import com.herocraftonline.heroes.storage.Storage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.logging.Level;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CharacterManager {
    private static final int manaInterval = 5;
    private static final int warmupInterval = 5;
    private static final long QUICK_REAPER_DELAY = 400L;
    private final Heroes plugin;
    private final Map<UUID, Hero> heroes;
    private final Map<UUID, Monster> monsters;
    private final BukkitTask taskId;
    private final DelayQueue<DelayedSkill> delayedSkillQueue;
    private final Map<UUID, Hero> citizenHeroes;
    private final Map<Skill, List<UUID>> skillListeners;
    private Storage storage;
    private Storage citizensStorage;

    public CharacterManager(Heroes plugin) {
        this.plugin = plugin;
        this.heroes = new ConcurrentHashMap<UUID, Hero>();
        this.monsters = new ConcurrentHashMap<UUID, Monster>();
        this.taskId = plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, (Runnable)new EntityReaper(), 100L, 6000L);
        this.storage = plugin.getStorageManager().getStorage();
        if (Heroes.useCitizens) {
            this.citizensStorage = new CitizensTraitStorage(plugin);
            this.citizenHeroes = new HashMap<UUID, Hero>();
        } else {
            this.citizensStorage = null;
            this.citizenHeroes = null;
        }
        this.skillListeners = new HashMap<Skill, List<UUID>>();
        long shieldRegenInterval = Heroes.properties.shieldRegenInterval;
        long shieldDelayAfterHit = (long)Heroes.properties.shieldDelayAfterHit * 1000L;
        ShieldUpdater shieldTimer = new ShieldUpdater(this, shieldRegenInterval * 1000L, shieldDelayAfterHit);
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, (Runnable)shieldTimer, shieldRegenInterval, shieldRegenInterval);
        long regenInterval = (long)Heroes.properties.manaRegenInterval * 1000L;
        ManaUpdater manaTimer = new ManaUpdater(this, regenInterval);
        plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)manaTimer, 0L, 5L);
        long staminaRegenInterval = Heroes.properties.staminaRegenInterval;
        StaminaUpdater staminaTimer = new StaminaUpdater(this, staminaRegenInterval * 1000L);
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, (Runnable)staminaTimer, staminaRegenInterval, staminaRegenInterval);
        this.delayedSkillQueue = new DelayQueue();
        DelayedSkillExecuter delayedExecuter = new DelayedSkillExecuter();
        plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)delayedExecuter, 0L, 5L);
    }

    public CharacterTemplate getCharacter(LivingEntity entity) {
        if (entity instanceof Player) {
            return this.getHero((Player)entity);
        }
        return this.getMonster(entity);
    }

    public Monster getMonster(LivingEntity entity) {
        if (entity == null) {
            return null;
        }
        UUID uniqueId = entity.getUniqueId();
        if (this.monsters.containsKey(uniqueId)) {
            return this.monsters.get(uniqueId);
        }
        Monster monster = new Monster(this.plugin, entity);
        this.monsters.put(uniqueId, monster);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new EntityQuickReaper(monster), 400L);
        return monster;
    }

    public Monster getMonster(UUID uniqueId) {
        return this.monsters.get(uniqueId);
    }

    protected Hero addHero(Hero hero) {
        this.heroes.put(hero.getPlayer().getUniqueId(), hero);
        return hero;
    }

    public boolean containsHero(Player player) {
        return player != null && this.heroes.containsKey(player.getUniqueId());
    }

    public Hero getHero(Player player) {
        UUID id = player.getUniqueId();
        Hero hero = this.heroes.get(id);
        if (hero == null) {
            if (Heroes.useCitizens && CitizensAPI.getNPCRegistry().isNPC((Entity)player)) {
                return this.getCitizenHero(player);
            }
            hero = this.storage.loadHero(player);
            if (hero == null && Heroes.properties.loadFromLegacyConfiguration && (hero = this.storage.loadLegacyHero(player)) != null) {
                this.saveHero(hero, true);
            }
            if (hero == null) {
                hero = this.storage.createNewHero(player);
            }
            if (hero != null) {
                this.addHero(hero);
                this.performSkillChecks(hero);
                hero.postInit();
            }
        }
        return hero;
    }

    @Deprecated
    public Hero refreshHero(Player player) {
        return this.getHero(player);
    }

    private Hero getCitizenHero(Player player) {
        Hero hero = this.citizenHeroes.get(player.getUniqueId());
        if (hero == null) {
            hero = this.citizensStorage.loadHero(player);
            this.addCitizenHero((CitizensHero)hero);
            this.performSkillChecks(hero);
            hero.postInit();
        }
        return hero;
    }

    private void addCitizenHero(CitizensHero hero) {
        this.citizenHeroes.put(hero.getUUID(), hero);
    }

    public void checkClasses(Hero hero) {
        Player player = hero.getPlayer();
        HeroClass playerClass = hero.getHeroClass();
        HeroClass secondClass = hero.getSecondaryClass();
        HeroClass raceClass = hero.getRaceClass();
        if (!CommandHandler.hasPermission((CommandSender)player, "heroes.classes." + playerClass.getName().toLowerCase())) {
            Heroes.log(Level.SEVERE, "Player: " + player.getName() + " failed permissions check removing class: " + playerClass.getName());
            hero.setHeroClass(this.plugin.getClassManager().getDefaultClass(), false, false);
        }
        if (secondClass != null && !CommandHandler.hasPermission((CommandSender)player, "heroes.classes." + secondClass.getName().toLowerCase())) {
            Heroes.log(Level.SEVERE, "Player: " + player.getName() + " failed permissions check removing class: " + secondClass.getName());
            hero.setHeroClass(this.plugin.getClassManager().getDefaultProfession(), true, false);
        }
        if (raceClass != null && !CommandHandler.hasPermission((CommandSender)player, "heroes.classes." + raceClass.getName().toLowerCase())) {
            Heroes.log(Level.SEVERE, "Player: " + player.getName() + " failed permissions check removing class: " + raceClass.getName());
            hero.setHeroClass(this.plugin.getClassManager().getDefaultRace(), false, true);
        }
    }

    public Collection<Hero> getHeroes() {
        return Collections.unmodifiableCollection(this.heroes.values());
    }

    public void performSkillChecks(Hero hero) {
        HashSet<Skill> skills = hero.getAvailableSkills();
        for (Skill skill : skills) {
            if (skill instanceof Listenable) {
                this.performIndividualSkillCheck(hero, skill);
            }
            if (skill instanceof OutsourcedSkill) {
                ((OutsourcedSkill)skill).tryLearningSkill(hero);
                continue;
            }
            if (!(skill instanceof Passive)) continue;
            ((Passive)((Object)skill)).tryApplying(hero);
        }
    }

    public void performIndividualSkillCheck(Hero hero, Skill skill) {
        Listenable listenable = (Listenable)((Object)skill);
        List<UUID> list = this.skillListeners.get(skill);
        if (list != null) {
            if (hero.canUseSkill(skill)) {
                list.add(hero.getUUID());
            } else {
                list.remove(hero.getUUID());
            }
            if (list.isEmpty()) {
                HandlerList.unregisterAll((Listener)listenable.getListener());
                this.skillListeners.remove(skill);
            }
        } else if (hero.canUseSkill(skill)) {
            list = new LinkedList<UUID>();
            list.add(hero.getUUID());
            this.skillListeners.put(skill, list);
            Bukkit.getPluginManager().registerEvents(listenable.getListener(), (Plugin)this.plugin);
        }
    }

    public void checkAllListeners(Hero hero) {
        HashSet<Skill> keys = new HashSet<Skill>(this.skillListeners.keySet());
        for (Skill key : keys) {
            List<UUID> actualList = this.skillListeners.get(key);
            if (!actualList.contains(hero.getUUID()) || hero.canUseSkill(key)) continue;
            actualList.remove(hero.getUUID());
            if (!actualList.isEmpty()) continue;
            Listenable listenable = (Listenable)((Object)key);
            HandlerList.unregisterAll((Listener)listenable.getListener());
            this.skillListeners.remove(key);
        }
    }

    public void removeHero(Hero hero) {
        if (hero != null) {
            hero.getAvailableSkills().forEach(skill -> {
                if (skill instanceof Listenable) {
                    Listenable listenable = (Listenable)((Object)skill);
                    List<UUID> list = this.skillListeners.get(skill);
                    if (list != null) {
                        list.remove(hero.getUUID());
                        if (list.isEmpty()) {
                            HandlerList.unregisterAll((Listener)listenable.getListener());
                            this.skillListeners.remove(skill);
                        }
                    }
                }
            });
            if (hero.hasParty()) {
                HeroParty party = hero.getParty();
                HeroLeavePartyEvent event = new HeroLeavePartyEvent(hero, party, HeroLeavePartyEvent.LeavePartyReason.DISCONNECT);
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
                party.removeMember(hero);
                if (party.getMembers().size() == 0) {
                    this.plugin.getPartyManager().removeParty(party);
                }
            }
            if (hero.getDelayedSkill() != null) {
                this.delayedSkillQueue.remove(hero.getDelayedSkill());
                hero.setDelayedSkill(null);
            }
            if (Heroes.useCitizens && CitizensAPI.getNPCRegistry().isNPC((Entity)hero.getPlayer())) {
                this.citizenHeroes.remove(hero.getUUID());
            } else {
                this.heroes.remove(hero.getUUID());
            }
        }
    }

    public void saveHero(Hero hero, boolean now) {
        if (Heroes.useCitizens && CitizensAPI.getNPCRegistry().isNPC((Entity)hero.getPlayer())) {
            this.citizensStorage.saveHero(hero, now);
        } else {
            this.storage.saveHero(hero, now);
            Heroes.debugLog(Level.INFO, "Saved Hero: " + hero.getPlayer().getName());
        }
    }

    public void saveHero(Player player, boolean now) {
        this.saveHero(this.getHero(player), now);
    }

    public void stopTimers() {
        this.plugin.getServer().getScheduler().cancelTasks((Plugin)this.plugin);
    }

    public void queueDelayedSkill(DelayedSkill skill) {
        Hero hero = skill.getHero();
        this.delayedSkillQueue.add(skill);
        hero.setDelayedSkill(skill);
    }

    public void cancelDelayedSkill(DelayedSkill skill) {
        Hero hero = skill.getHero();
        this.delayedSkillQueue.remove(skill);
        hero.setDelayedSkill(null);
    }

    public void shutdown() {
        this.storage.shutdown();
        this.taskId.cancel();
    }

    @Deprecated
    public Storage getStorage() {
        return this.storage;
    }

    @Deprecated
    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public void removeMonster(LivingEntity lEntity) {
        if (!this.monsters.containsKey(lEntity.getUniqueId())) {
            return;
        }
        Monster monster = this.monsters.remove(lEntity.getUniqueId());
        monster.clearEffects(false);
    }

    private class EntityReaper
    implements Runnable {
        private Set<UUID> toRemove = new HashSet<UUID>();

        private EntityReaper() {
        }

        @Override
        public void run() {
            for (Map.Entry<UUID, Monster> entry : CharacterManager.this.monsters.entrySet()) {
                if (entry.getValue().isEntityValid()) continue;
                this.toRemove.add(entry.getKey());
            }
            for (UUID uniqueId : this.toRemove) {
                CharacterManager.this.monsters.remove(uniqueId);
            }
            this.toRemove.clear();
        }
    }

    private class DelayedSkillExecuter
    implements Runnable {
        private DelayedSkillExecuter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DelayedSkill skill;
            while ((skill = (DelayedSkill)CharacterManager.this.delayedSkillQueue.poll()) != null) {
                Hero hero = skill.getHero();
                try {
                    skill.getSkill().execute((CommandSender)skill.getPlayer(), skill.getIdentifier(), skill.getArgs());
                }
                catch (Exception e) {
                    Heroes.log(Level.SEVERE, "There was an error executing: " + skill.getSkill().getName() + " for " + hero.getPlayer().getName());
                    e.printStackTrace();
                }
                finally {
                    ActiveSkill.removeCastingEffect(hero);
                    hero.setDelayedSkill(null);
                }
            }
        }
    }

    private class EntityQuickReaper
    implements Runnable {
        private Monster monster;

        public EntityQuickReaper(Monster monster) {
            this.monster = monster;
        }

        @Override
        public void run() {
            if (!this.monster.isEntityValid()) {
                CharacterManager.this.removeMonster(this.monster.getEntity());
            }
        }
    }
}

