/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.google.common.collect.Multimap;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillUseInfo;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.classes.scaling.Scaling;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.items.WeaponConfig;
import com.herocraftonline.heroes.util.Util;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Trident;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CharacterDamageManager {
    private Map<Material, Double> itemDamage;
    private Map<ProjectileType, Double> projectileDamage;
    private Map<EntityType, Double> creatureHealth;
    private Map<EntityType, Double> creatureDamage;
    private Map<EntityDamageEvent.DamageCause, Double> environmentalDamage;
    private Map<Enchantment, Double> enchantmentDamage;
    private Map<Enchantment, Double> enchantmentProtection;
    private final Map<Integer, SkillUseInfo> spellTargs = new HashMap<Integer, SkillUseInfo>();
    private boolean overrideCreeperDamage = true;

    public CharacterDamageManager(Heroes plugin) {
    }

    public boolean isCreeperDamageOverridden() {
        return this.overrideCreeperDamage;
    }

    public boolean isSpellTarget(Entity target) {
        return this.spellTargs.containsKey(target.getEntityId());
    }

    public void addSpellTarget(Entity target, CharacterTemplate spellCaster, Skill skill) {
        this.spellTargs.put(target.getEntityId(), new SkillUseInfo(spellCaster, skill));
    }

    public SkillUseInfo removeSpellTarget(Entity target) {
        return this.spellTargs.remove(target.getEntityId());
    }

    public SkillUseInfo getSpellTargetInfo(Entity target) {
        return this.spellTargs.get(target.getEntityId());
    }

    protected double getEntityDamage(EntityType type) {
        return this.creatureDamage.containsKey(type) ? this.creatureDamage.get(type) : 1.0;
    }

    protected double getEntityMaxHealth(LivingEntity entity) {
        return this.creatureHealth.containsKey(entity.getType()) ? this.creatureHealth.get(entity.getType()).doubleValue() : entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
    }

    public Double getItemDamage(Material item) {
        if (item == null) {
            return null;
        }
        return this.itemDamage.get(item);
    }

    public Double getEnvironmentalDamage(EntityDamageEvent.DamageCause cause) {
        return this.environmentalDamage.get(cause);
    }

    public Double getEnchantmentDamage(Enchantment enchantment) {
        return this.enchantmentDamage.get(enchantment);
    }

    public Double getEnchantmentProtection(Enchantment enchantment) {
        return this.enchantmentProtection.get(enchantment);
    }

    public EquippedWeaponStats createWeaponStats(Hero hero, ItemStack item) {
        return new EquippedWeaponStats(hero, item);
    }

    @Deprecated
    public Double getHeldItemDamage(Hero hero) {
        Player player = hero.getPlayer();
        ItemStack mainhand = player.getInventory().getItemInMainHand();
        Material mainhandType = mainhand.getType();
        ItemMeta weaponMeta = mainhand.getItemMeta();
        Double additiveMain = 0.0;
        Double percentileMain = 0.0;
        Double multiplicativeMain = 1.0;
        if (mainhandType != Material.AIR && mainhand.hasItemMeta() && weaponMeta.hasAttributeModifiers()) {
            try {
                Multimap attributes = weaponMeta.getAttributeModifiers();
                for (AttributeModifier modifier : attributes.get((Object)Attribute.GENERIC_ATTACK_DAMAGE)) {
                    if (modifier.getSlot() != EquipmentSlot.HAND) continue;
                    switch (modifier.getOperation()) {
                        case ADD_NUMBER: {
                            additiveMain = additiveMain + modifier.getAmount();
                            break;
                        }
                        case ADD_SCALAR: {
                            percentileMain = percentileMain + modifier.getAmount();
                            break;
                        }
                        case MULTIPLY_SCALAR_1: {
                            multiplicativeMain = multiplicativeMain * modifier.getAmount();
                        }
                    }
                }
            }
            catch (Exception e) {
                Heroes.debugLog(Level.WARNING, "Mainhand item has no attack damage. Exception below\n" + e.getMessage());
            }
        }
        ItemStack offhand = player.getInventory().getItemInOffHand();
        Material offhandType = offhand.getType();
        ItemMeta offhandMeta = offhand.getItemMeta();
        Double additiveOff = 0.0;
        Double percentileOff = 0.0;
        Double multiplicativeOff = 1.0;
        if (offhandType != Material.AIR && offhand.hasItemMeta() && offhandMeta.hasAttributeModifiers()) {
            try {
                Multimap attributes = offhandMeta.getAttributeModifiers();
                for (AttributeModifier modifier : attributes.get((Object)Attribute.GENERIC_ATTACK_DAMAGE)) {
                    if (modifier.getSlot() != EquipmentSlot.OFF_HAND) continue;
                    switch (modifier.getOperation()) {
                        case ADD_NUMBER: {
                            additiveOff = additiveOff + modifier.getAmount();
                            break;
                        }
                        case ADD_SCALAR: {
                            percentileOff = percentileOff + modifier.getAmount();
                            break;
                        }
                        case MULTIPLY_SCALAR_1: {
                            multiplicativeOff = multiplicativeOff * modifier.getAmount();
                        }
                    }
                }
            }
            catch (Exception e) {
                Heroes.debugLog(Level.WARNING, "Offhand item has no attack damage. Exception below\n" + e.getMessage());
            }
        }
        if (additiveMain != 0.0 || percentileMain != 0.0 || multiplicativeMain != 1.0) {
            if (additiveMain == 0.0) {
                additiveMain = 1.0;
            }
        } else {
            Scaling classScaling = hero.getHeroClass().getItemDamage(mainhandType);
            if (classScaling != null) {
                additiveMain = classScaling.getScaled(hero);
            } else {
                Double defaultItemDamage = this.getItemDamage(mainhandType);
                if (defaultItemDamage == null) {
                    additiveMain = 0.0;
                    additiveOff = 0.0;
                } else {
                    additiveMain = defaultItemDamage;
                }
            }
        }
        return (additiveMain + additiveOff + (additiveMain + additiveOff) * (percentileMain + percentileOff)) * multiplicativeMain * multiplicativeOff;
    }

    public Double getItemStackDamage(Hero hero, ItemStack item, EquipmentSlot slot) {
        double additive = 0.0;
        double percentile = 0.0;
        double multiplicative = 0.0;
        try {
            Multimap attributes = item.getItemMeta().getAttributeModifiers();
            for (AttributeModifier modifier : attributes.get((Object)Attribute.GENERIC_ATTACK_DAMAGE)) {
                if (modifier.getSlot() != slot) continue;
                switch (modifier.getOperation()) {
                    case ADD_NUMBER: {
                        additive += modifier.getAmount();
                        break;
                    }
                    case ADD_SCALAR: {
                        percentile += modifier.getAmount();
                        break;
                    }
                    case MULTIPLY_SCALAR_1: {
                        multiplicative *= modifier.getAmount();
                    }
                }
            }
        }
        catch (Exception e) {
            Heroes.debugLog(Level.WARNING, "Offhand item has no attack damage. Exception below\n" + e.getMessage());
        }
        if (additive != 0.0 || percentile != 0.0 || multiplicative != 1.0) {
            if (additive == 0.0) {
                additive = 1.0;
            }
        } else {
            Double defaultItemDamage;
            Material type = item.getType();
            Scaling classScaling = hero.getHeroClass().getItemDamage(type);
            additive = classScaling != null ? classScaling.getScaled(hero) : ((defaultItemDamage = this.getItemDamage(type)) == null ? 0.0 : defaultItemDamage);
        }
        return (additive + additive * percentile) * multiplicative;
    }

    public Double getFlatItemDamage(Hero hero) {
        if (hero == null) {
            return null;
        }
        Player player = hero.getPlayer();
        ItemStack mainhand = player.getInventory().getItemInMainHand();
        Material type = mainhand.getType();
        Double baseItemDamage = player.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getValue();
        Scaling classScaling = hero.getHeroClass().getItemDamage(type);
        Double defaultItemDamage = this.getItemDamage(type);
        if (defaultItemDamage == null && classScaling == null) {
            baseItemDamage = 1.0;
        } else {
            if (type == Material.AIR || !mainhand.getItemMeta().hasAttributeModifiers()) {
                double heroesItemBase = classScaling != null ? classScaling.getScaled(hero) : defaultItemDamage.doubleValue();
                baseItemDamage = baseItemDamage - Util.getDefaultDamage(type) + heroesItemBase;
            }
            baseItemDamage = baseItemDamage + Heroes.properties.attackDamagePerStrength * (double)hero.getAttributes().getStrengthValue();
        }
        return baseItemDamage;
    }

    @Deprecated
    public Double getFlatItemDamage(Hero hero, Material item) {
        return this.getFlatItemDamage(hero);
    }

    @Deprecated
    public Double getHighestItemDamage(Hero hero, Material item) {
        return this.getFlatItemDamage(hero, item);
    }

    @Deprecated
    public Double getHighestItemDamage(Hero hero, Material item, boolean pve, double enchantDamage) {
        return this.getHighestItemDamage(hero, enchantDamage);
    }

    @Deprecated
    public Double getHighestItemDamage(Hero hero, double enchantDamage) {
        if (hero == null) {
            return null;
        }
        Double baseItemDamage = this.getHeldItemDamage(hero);
        if (baseItemDamage == 0.0) {
            baseItemDamage = 1.0;
        } else {
            baseItemDamage = baseItemDamage + Heroes.properties.attackDamagePerStrength * (double)hero.getAttributes().getStrengthValue();
            baseItemDamage = baseItemDamage + enchantDamage;
        }
        return baseItemDamage;
    }

    public Double getHighestMultiplier(Hero hero, boolean pve) {
        double raceMulti;
        double secondMulti;
        double classMulti;
        HeroClass heroClass = hero.getHeroClass();
        HeroClass secondClass = hero.getSecondaryClass();
        HeroClass raceClass = hero.getRaceClass();
        Material item = hero.getPlayer().getInventory().getItemInMainHand().getType();
        if (pve) {
            classMulti = heroClass.getPveItemDamageMultiplier(item) + heroClass.getPveItemDamageMultiplierLevel(item) * (double)(hero.getHeroLevel(heroClass) - 1);
            secondMulti = secondClass.getPveItemDamageMultiplier(item) + secondClass.getPveItemDamageMultiplierLevel(item) * (double)(hero.getHeroLevel(secondClass) - 1);
            raceMulti = raceClass.getPveItemDamageMultiplier(item) + raceClass.getPveItemDamageMultiplierLevel(item) * (double)(hero.getHeroLevel(raceClass) - 1);
        } else {
            classMulti = heroClass.getPvpItemDamageMultiplier(item) + heroClass.getPvpItemDamageMultiplierLevel(item) * (double)(hero.getHeroLevel(heroClass) - 1);
            secondMulti = secondClass.getPvpItemDamageMultiplier(item) + secondClass.getPvpItemDamageMultiplierLevel(item) * (double)(hero.getHeroLevel(secondClass) - 1);
            raceMulti = raceClass.getPvpItemDamageMultiplier(item) + raceClass.getPvpItemDamageMultiplierLevel(item) * (double)(hero.getHeroLevel(raceClass) - 1);
        }
        return Math.max(Math.max(classMulti, secondMulti), raceMulti);
    }

    public Double getHighestProjMultiplier(Hero hero, ProjectileType type, boolean pve) {
        double raceMulti;
        double secondMulti;
        double classMulti;
        HeroClass heroClass = hero.getHeroClass();
        HeroClass secondClass = hero.getSecondaryClass();
        HeroClass raceClass = hero.getRaceClass();
        if (pve) {
            classMulti = heroClass.getPveProjDamageMultiplier(type) + heroClass.getPveProjDamageMultiplierLevel(type) * (double)(hero.getHeroLevel(heroClass) - 1);
            secondMulti = secondClass.getPveProjDamageMultiplier(type) + secondClass.getPveProjDamageMultiplierLevel(type) * (double)(hero.getHeroLevel(secondClass) - 1);
            raceMulti = raceClass.getPveProjDamageMultiplier(type) + raceClass.getPveProjDamageMultiplierLevel(type) * (double)(hero.getHeroLevel(raceClass) - 1);
        } else {
            classMulti = heroClass.getPvpProjDamageMultiplier(type) + heroClass.getPvpProjDamageMultiplierLevel(type) * (double)(hero.getHeroLevel(heroClass) - 1);
            secondMulti = secondClass.getPvpProjDamageMultiplier(type) + secondClass.getPvpProjDamageMultiplierLevel(type) * (double)(hero.getHeroLevel(secondClass) - 1);
            raceMulti = raceClass.getPvpProjDamageMultiplier(type) + raceClass.getPvpProjDamageMultiplierLevel(type) * (double)(hero.getHeroLevel(raceClass) - 1);
        }
        return Math.max(Math.max(classMulti, secondMulti), raceMulti);
    }

    public Double getDefaultClassDamage(Hero hero, HeroClass heroClass, Material item) {
        Double damage;
        Scaling scaling = heroClass.getItemDamage(item);
        if (scaling != null) {
            damage = scaling.getScaled(hero);
        } else {
            damage = this.getItemDamage(item);
            if (damage == null) {
                damage = 1.0;
            }
        }
        return damage;
    }

    public Double getDefaultClassDamage(Hero hero, Material item) {
        HeroClass heroClass = hero.getHeroClass();
        HeroClass secondClass = hero.getSecondaryClass();
        HeroClass raceClass = hero.getRaceClass();
        Double classDamage = this.getDefaultClassDamage(hero, heroClass, item);
        Double secondDamage = this.getDefaultClassDamage(hero, secondClass, item);
        Double raceDamage = this.getDefaultClassDamage(hero, raceClass, item);
        Double maxClassOrSecondDamage = classDamage > secondDamage ? classDamage : secondDamage;
        return maxClassOrSecondDamage > raceDamage ? maxClassOrSecondDamage : raceDamage;
    }

    public Double getProjectileDamage(ProjectileType type) {
        if (type == null) {
            return null;
        }
        return this.projectileDamage.get((Object)type);
    }

    public Double getHighestProjectileDamage(Hero hero, ProjectileType type, boolean pve, double originalDamage) {
        if (hero == null || type == null) {
            return null;
        }
        HeroClass heroClass = hero.getHeroClass();
        Double baseProjDamage = originalDamage;
        Scaling classScaling = heroClass.getProjectileDamage(type);
        Double defaultProjDamage = this.getProjectileDamage(type);
        if (defaultProjDamage != null || classScaling != null) {
            baseProjDamage = classScaling != null ? Double.valueOf(classScaling.getScaled(hero)) : defaultProjDamage;
        }
        if (baseProjDamage == 0.0) {
            baseProjDamage = type.damage;
        }
        baseProjDamage = baseProjDamage + Heroes.properties.projectileDamagePerDexterity * (double)hero.getAttributes().getDexterityValue();
        baseProjDamage = baseProjDamage * this.getHighestProjMultiplier(hero, type, pve);
        return baseProjDamage;
    }

    public Double getHighestProjectileDamage(Hero hero, ProjectileType type) {
        return this.getHighestProjectileDamage(hero, type, false, 0.0);
    }

    public Double getHighestProjectileDamage(Hero hero, HeroClass heroClass, ProjectileType type, boolean pve, double extraDamage) {
        ProjectileType bowProjectileType;
        Double bowDamage;
        if (hero == null || heroClass == null || type == null) {
            return null;
        }
        Scaling classScaling = heroClass.getProjectileDamage(type);
        Double classDamage = null;
        if (classScaling != null) {
            classDamage = classScaling.getScaled(hero);
            double attributeDamage = Heroes.properties.projectileDamagePerDexterity * (double)hero.getAttributes().getDexterityValue();
            classDamage = classDamage + attributeDamage;
            classDamage = classDamage + extraDamage;
            classDamage = pve ? Double.valueOf(classDamage * (heroClass.getPveProjDamageMultiplier(type) + heroClass.getPveProjDamageMultiplierLevel(type) * (double)(hero.getHeroLevel(heroClass) - 1))) : Double.valueOf(classDamage * (heroClass.getPvpProjDamageMultiplier(type) + heroClass.getPvpProjDamageMultiplierLevel(type) * (double)(hero.getHeroLevel(heroClass) - 1)));
        }
        if (classDamage != null) {
            return classDamage;
        }
        if ((type == ProjectileType.CROSSBOW_ARROW || type == ProjectileType.CROSSBOW_FIREWORK_ROCKET) && (bowDamage = this.getHighestProjectileDamage(hero, heroClass, bowProjectileType = type == ProjectileType.CROSSBOW_ARROW ? ProjectileType.ARROW : ProjectileType.FIREWORK_ROCKET, pve, extraDamage)) != null) {
            Double crossbowDamage = this.projectileDamage.get((Object)type);
            return crossbowDamage == null || bowDamage >= crossbowDamage ? bowDamage : crossbowDamage;
        }
        return this.projectileDamage.get((Object)type);
    }

    public Double getHighestProjectileDamage(Hero hero, HeroClass heroClass, ProjectileType type) {
        return this.getHighestProjectileDamage(hero, heroClass, type, false, 0.0);
    }

    public void load(Configuration config) {
        EntityType type;
        Set keys;
        Heroes.properties.potHealthPerTier = config.getDouble("potions.health-per-tier", 0.1);
        this.overrideCreeperDamage = config.getBoolean("override-creeper-damage", true);
        this.creatureHealth = new EnumMap<EntityType, Double>(EntityType.class);
        ConfigurationSection section = config.getConfigurationSection("creature-health");
        boolean errored = false;
        if (section != null && !(keys = section.getKeys(false)).isEmpty()) {
            for (String key : keys) {
                try {
                    type = EntityType.valueOf((String)key.toUpperCase(Locale.ENGLISH));
                    double health = section.getDouble(key, 20.0);
                    if (health <= 0.0) {
                        health = 20.0;
                    }
                    this.creatureHealth.put(type, health);
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid creature type (" + key + ") found in damages.yml.");
                    errored = true;
                }
            }
        }
        this.creatureDamage = new EnumMap<EntityType, Double>(EntityType.class);
        section = config.getConfigurationSection("creature-damage");
        if (section != null && !(keys = section.getKeys(false)).isEmpty()) {
            for (String key : keys) {
                try {
                    type = EntityType.valueOf((String)key.toUpperCase(Locale.ENGLISH));
                    this.creatureDamage.put(type, section.getDouble(key, 10.0));
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid creature type (" + key + ") found in damages.yml.");
                    errored = true;
                }
            }
        }
        if (errored) {
            Heroes.log(Level.WARNING, "Remember, creature-names are case-sensitive, and must be exactly the same as found in the defaults!");
        }
        this.itemDamage = new EnumMap<Material, Double>(Material.class);
        section = config.getConfigurationSection("item-damage");
        if (section != null && !(keys = section.getKeys(false)).isEmpty()) {
            for (String key : keys) {
                try {
                    Material item = Material.matchMaterial((String)key);
                    if (item == null) {
                        throw new IllegalArgumentException();
                    }
                    this.itemDamage.put(item, section.getDouble(key, 1.0));
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid item type (" + key + ") found in damages.yml.");
                }
            }
        }
        Util.DefaultItemTypes[] types = Util.DefaultItemTypes.values();
        for (Util.DefaultItemTypes t : types) {
            Material item = t.getMaterial();
            if (item == null || this.itemDamage.containsKey(item)) continue;
            this.itemDamage.put(item, t.getDamage());
        }
        this.environmentalDamage = new EnumMap<EntityDamageEvent.DamageCause, Double>(EntityDamageEvent.DamageCause.class);
        section = config.getConfigurationSection("environmental-damage");
        if (section != null && !(keys = section.getKeys(false)).isEmpty()) {
            for (String key : keys) {
                try {
                    EntityDamageEvent.DamageCause cause = EntityDamageEvent.DamageCause.valueOf((String)key.toUpperCase());
                    double damage = section.getDouble(key, 0.0);
                    this.environmentalDamage.put(cause, damage);
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid environmental damage type (" + key + ") found in damages.yml");
                }
            }
        }
        this.projectileDamage = new EnumMap<ProjectileType, Double>(ProjectileType.class);
        section = config.getConfigurationSection("projectile-damage");
        if (section != null && !(keys = section.getKeys(false)).isEmpty()) {
            for (String key : keys) {
                ProjectileType type2;
                try {
                    type2 = ProjectileType.valueOf(key.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                this.projectileDamage.put(type2, section.getDouble(key, 0.0));
            }
        }
        this.enchantmentDamage = new HashMap<Enchantment, Double>();
        section = config.getConfigurationSection("enchantment-damage");
        if (section != null && !(keys = section.getKeys(false)).isEmpty()) {
            for (String key : keys) {
                Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)key.toLowerCase()));
                Enchantment oldEnchantment = Enchantment.getByName((String)key);
                if (enchantment == null && oldEnchantment == null) continue;
                if (enchantment == null) {
                    enchantment = oldEnchantment;
                }
                this.enchantmentDamage.put(enchantment, section.getDouble(key, 0.0));
            }
        }
        this.enchantmentProtection = new HashMap<Enchantment, Double>();
        section = config.getConfigurationSection("enchantment-protection");
        if (section != null && !(keys = section.getKeys(false)).isEmpty()) {
            for (String key : keys) {
                Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)key.toLowerCase()));
                Enchantment oldEnchantment = Enchantment.getByName((String)key);
                if (enchantment == null && oldEnchantment == null) continue;
                if (enchantment == null) {
                    enchantment = oldEnchantment;
                }
                this.enchantmentProtection.put(enchantment, section.getDouble(key, 0.0));
            }
        }
    }

    public double calculateFireTickDamage(LivingEntity entity) {
        return this.calculateFireTickDamage(entity, 1.0);
    }

    public double calculateFireTickDamage(LivingEntity entity, double tickDamageMultiplier) {
        return this.calculateFireTickDamage(entity.getFireTicks() < 0 ? 0 : entity.getFireTicks(), tickDamageMultiplier);
    }

    public double calculateFireTickDamage(int totalFireTicks, double tickDamageMultiplier) {
        int numFireProcs = totalFireTicks / 20;
        double fireTickDamage = this.getEnvironmentalDamage(EntityDamageEvent.DamageCause.FIRE_TICK);
        return (double)numFireProcs * (fireTickDamage * tickDamageMultiplier);
    }

    public class EquippedWeaponStats {
        private final Hero hero;
        private final ItemStack weapon;
        private final float knockback;
        private final float penetration;
        private final float reach;

        public EquippedWeaponStats(Hero player, ItemStack item) {
            this.hero = player;
            this.weapon = item;
            WeaponConfig weaponConfig = Heroes.properties.getWeaponConfigMatch(item);
            if (weaponConfig != null) {
                this.knockback = weaponConfig.getKnockback();
                this.penetration = weaponConfig.getPenetration();
                this.reach = weaponConfig.getReach();
            } else {
                this.knockback = Heroes.properties.defaultKnockback;
                this.penetration = 0.0f;
                this.reach = 3.0f;
            }
        }

        public double getFinalDamage() {
            return CharacterDamageManager.this.getFlatItemDamage(this.hero);
        }

        public ItemStack getWeapon() {
            return this.weapon;
        }

        public float getKnockback() {
            return this.knockback;
        }

        public float getPenetration() {
            return this.penetration;
        }

        public float getReach() {
            return this.reach;
        }
    }

    public static enum ProjectileType {
        ARROW(6.0),
        EGG(0.0),
        SNOWBALL(0.0),
        TRIDENT(8.0),
        FIREWORK_ROCKET(2.5),
        CROSSBOW_ARROW(9.0),
        CROSSBOW_FIREWORK_ROCKET(14.5);

        private final double damage;

        private ProjectileType(double damage) {
            this.damage = damage;
        }

        public static ProjectileType matchProjectile(String name) {
            if (name.equalsIgnoreCase("crossbow_arrow")) {
                return CROSSBOW_ARROW;
            }
            if (name.equalsIgnoreCase("crossbow_firework_rocket")) {
                return CROSSBOW_FIREWORK_ROCKET;
            }
            if (name.equalsIgnoreCase("arrow")) {
                return ARROW;
            }
            if (name.equalsIgnoreCase("snowball")) {
                return SNOWBALL;
            }
            if (name.equalsIgnoreCase("egg")) {
                return EGG;
            }
            if (name.equalsIgnoreCase("trident")) {
                return TRIDENT;
            }
            if (name.equalsIgnoreCase("firework_rocket")) {
                return FIREWORK_ROCKET;
            }
            return null;
        }

        public static ProjectileType valueOf(Entity entity) {
            return ProjectileType.valueOf(entity, false);
        }

        public static ProjectileType valueOf(Entity entity, boolean fromCrossbow) {
            if (entity instanceof Trident) {
                return TRIDENT;
            }
            if (entity instanceof Arrow) {
                return fromCrossbow ? CROSSBOW_ARROW : ARROW;
            }
            if (entity instanceof Snowball) {
                return SNOWBALL;
            }
            if (entity instanceof Egg) {
                return EGG;
            }
            if (entity instanceof Firework) {
                return fromCrossbow ? CROSSBOW_FIREWORK_ROCKET : FIREWORK_ROCKET;
            }
            return null;
        }
    }
}

