/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.attributes.menu.menus;

import com.herocraftonline.heroes.attributes.menu.events.ItemClickEvent;
import com.herocraftonline.heroes.attributes.menu.items.MenuItem;
import com.herocraftonline.heroes.attributes.menu.menus.Menu;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ItemMenu
implements Listener,
Menu {
    private String name;
    private int size;
    private Plugin plugin;
    private MenuItem[] menuItems;
    private Menu parent;
    private static final ItemStack EMPTY_SLOT = new ItemStack(Material.WHITE_STAINED_GLASS_PANE, 1, (short)DyeColor.GRAY.getWoolData());

    public ItemMenu(String name, int size, Plugin plugin, Menu parent) {
        this.name = name;
        this.size = size;
        this.plugin = plugin;
        this.menuItems = new MenuItem[size];
        this.parent = parent;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    public ItemMenu(String name, int size, Plugin plugin) {
        this(name, size, plugin, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public Menu getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Menu parent) {
        this.parent = parent;
    }

    public ItemMenu setItem(int position, MenuItem menuItem) {
        this.menuItems[position] = menuItem;
        return this;
    }

    @Override
    public void open(Player player) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)this.size, (String)this.name);
        for (int i = 0; i < this.menuItems.length; ++i) {
            if (this.menuItems[i] == null) {
                inventory.setItem(i, EMPTY_SLOT);
                continue;
            }
            inventory.setItem(i, this.menuItems[i].getFinalIcon(player));
        }
        player.openInventory(inventory);
    }

    @Override
    public void update(Player player) {
        InventoryView openInventoryView;
        if (player.getOpenInventory() != null && (openInventoryView = player.getOpenInventory()).getTitle().equals(this.name)) {
            Inventory inventory = openInventoryView.getTopInventory();
            for (int i = 0; i < this.menuItems.length; ++i) {
                if (this.menuItems[i] == null) {
                    inventory.setItem(i, EMPTY_SLOT);
                    continue;
                }
                inventory.setItem(i, this.menuItems[i].getFinalIcon(player));
            }
            player.updateInventory();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClick(InventoryClickEvent event) {
        String playerName;
        if (!event.getView().getTitle().equals(this.name)) {
            return;
        }
        event.setCancelled(true);
        if (event.getClick() != ClickType.LEFT) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot < 0 || slot >= this.size || this.menuItems[slot] == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemClickEvent itemClickEvent = new ItemClickEvent(player);
        this.menuItems[slot].onItemClick(itemClickEvent);
        if (itemClickEvent.willUpdate()) {
            this.update(player);
            return;
        }
        player.updateInventory();
        if (itemClickEvent.willClose() || itemClickEvent.willGoBack()) {
            playerName = player.getName();
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                @Override
                public void run() {
                    Player p = Bukkit.getPlayerExact((String)playerName);
                    if (p != null) {
                        p.closeInventory();
                    }
                }
            }, 1L);
        }
        if (itemClickEvent.willGoBack() && this.hasParent()) {
            playerName = player.getName();
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                @Override
                public void run() {
                    Player p = Bukkit.getPlayerExact((String)playerName);
                    if (p != null) {
                        ItemMenu.this.parent.open(p);
                    }
                }
            }, 3L);
        }
    }

    @Override
    public void destroy() {
        HandlerList.unregisterAll((Listener)this);
        this.plugin = null;
        this.menuItems = null;
    }

    static {
        ItemMeta meta = EMPTY_SLOT.getItemMeta();
        meta.setDisplayName(" ");
        EMPTY_SLOT.setItemMeta(meta);
    }
}

