/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.attributes.menu.menus;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.attributes.AttributeSet;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.attributes.menu.items.AttributeAddItem;
import com.herocraftonline.heroes.attributes.menu.items.AttributeCancelItem;
import com.herocraftonline.heroes.attributes.menu.items.AttributeConfirmItem;
import com.herocraftonline.heroes.attributes.menu.items.AttributeItem;
import com.herocraftonline.heroes.attributes.menu.items.AttributeRemoveItem;
import com.herocraftonline.heroes.attributes.menu.items.AttributeResetItem;
import com.herocraftonline.heroes.attributes.menu.items.AttributeWarningItem;
import com.herocraftonline.heroes.attributes.menu.menus.ItemMenu;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AttributeMenu
extends ItemMenu {
    private Heroes heroes;
    private Map<UUID, PendingAllocation> pendingAllocation;

    public AttributeMenu(Heroes heroes) {
        super(ChatColor.DARK_BLUE + "Attribute Allocation!", 45, (Plugin)heroes);
        this.heroes = heroes;
        this.pendingAllocation = new HashMap<UUID, PendingAllocation>();
        this.setItem(18, new AttributeWarningItem());
        this.setItem(4, new AttributeConfirmItem(this));
        this.setItem(40, new AttributeCancelItem(this));
        this.setItem(26, new AttributeResetItem());
        this.setItem(19, new AttributeItem(this, AttributeType.STRENGTH, new ItemStack(Material.DIAMOND_SWORD), "Increases damage with", "melee weapons and physical", "based abilities."));
        this.setItem(10, new AttributeAddItem(this, AttributeType.STRENGTH));
        this.setItem(28, new AttributeRemoveItem(this, AttributeType.STRENGTH));
        this.setItem(20, new AttributeItem(this, AttributeType.CONSTITUTION, new ItemStack(Material.BEEF), "Increases your maximum", "health and provides slight", "resistances to magic."));
        this.setItem(11, new AttributeAddItem(this, AttributeType.CONSTITUTION));
        this.setItem(29, new AttributeRemoveItem(this, AttributeType.CONSTITUTION));
        this.setItem(21, new AttributeItem(this, AttributeType.DEXTERITY, new ItemStack(Material.BOW), "Increases damage with", "projectile weapons, base", "movement speed and velocity", "based movement skills."));
        this.setItem(12, new AttributeAddItem(this, AttributeType.DEXTERITY));
        this.setItem(30, new AttributeRemoveItem(this, AttributeType.DEXTERITY));
        this.setItem(22, new AttributeItem(this, AttributeType.ENDURANCE, new ItemStack(Material.GOLDEN_BOOTS), "Increases base stamina", "regeneration"));
        this.setItem(13, new AttributeAddItem(this, AttributeType.ENDURANCE));
        this.setItem(31, new AttributeRemoveItem(this, AttributeType.ENDURANCE));
        this.setItem(23, new AttributeItem(this, AttributeType.INTELLECT, new ItemStack(Material.ENCHANTING_TABLE), "Increases maximum mana", "pool and damage dealt", "by magical abilities."));
        this.setItem(14, new AttributeAddItem(this, AttributeType.INTELLECT));
        this.setItem(32, new AttributeRemoveItem(this, AttributeType.INTELLECT));
        this.setItem(24, new AttributeItem(this, AttributeType.WISDOM, new ItemStack(Material.BOOK), "Increases base mana", "regen and effectiveness", "of healing abilities."));
        this.setItem(15, new AttributeAddItem(this, AttributeType.WISDOM));
        this.setItem(33, new AttributeRemoveItem(this, AttributeType.WISDOM));
        this.setItem(25, new AttributeItem(this, AttributeType.CHARISMA, new ItemStack(Material.DIAMOND), "Increases the potency", "and duration of songs", "and effectiveness of", "disabling abilities."));
        this.setItem(16, new AttributeAddItem(this, AttributeType.CHARISMA));
        this.setItem(34, new AttributeRemoveItem(this, AttributeType.CHARISMA));
    }

    @Override
    public void open(Player player) {
        this.pendingAllocation.put(player.getUniqueId(), new PendingAllocation(player));
        super.open(player);
    }

    public PendingAllocation getPendingAllocation(Player player) {
        return this.pendingAllocation.get(player.getUniqueId());
    }

    public boolean confirmPendingAllocation(Player player) {
        return this.pendingAllocation.remove(player.getUniqueId()).confirmPending();
    }

    public void cancelPendingAllocation(Player player) {
        this.pendingAllocation.remove(player.getUniqueId());
    }

    public class PendingAllocation {
        private UUID playerId;
        private AttributeSet current;
        private int allocationPoints;
        private AttributeSet pending;
        private AttributeSet pendingCost;
        private AttributeSet nextIncrease;
        private int totalCost;

        public PendingAllocation(Player player) {
            this.playerId = player.getUniqueId();
            Hero hero = AttributeMenu.this.heroes.getCharacterManager().getHero(player);
            this.current = hero.getTotalAttributeSet();
            this.allocationPoints = hero.getAllocationPoints();
            this.pending = new AttributeSet();
            this.pendingCost = new AttributeSet();
            this.nextIncrease = new AttributeSet();
            this.totalCost = 0;
            this.updateCosts();
        }

        public AttributeSet getCurrent() {
            return this.current;
        }

        public int getCurrent(AttributeType attribute) {
            return this.current.getAttributeValue(attribute);
        }

        public int getAllocationPoints() {
            return this.allocationPoints;
        }

        public AttributeSet getPending() {
            return this.pending;
        }

        public int getPending(AttributeType attribute) {
            return this.pending.getAttributeValue(attribute);
        }

        public boolean canIncreasePending(AttributeType attribute) {
            int remaining = this.allocationPoints - this.totalCost;
            return remaining >= this.nextIncrease.getAttributeValue(attribute);
        }

        public boolean increasePending(AttributeType attribute) {
            if (this.canIncreasePending(attribute)) {
                this.pending.setAttributeValue(attribute, this.pending.getAttributeValue(attribute) + 1);
                this.updateCosts();
                return true;
            }
            return false;
        }

        public boolean canDecreasePending(AttributeType attribute) {
            return this.pending.getAttributeValue(attribute) > 0;
        }

        public boolean decreasePending(AttributeType attribute) {
            if (this.canDecreasePending(attribute)) {
                this.pending.setAttributeValue(attribute, this.pending.getAttributeValue(attribute) - 1);
                this.updateCosts();
                return true;
            }
            return false;
        }

        public AttributeSet getPendingCost() {
            return this.pendingCost;
        }

        public AttributeSet getNextIncrease() {
            return this.nextIncrease;
        }

        public int getTotalCost() {
            return this.totalCost;
        }

        public void updateCosts() {
            Hero hero = AttributeMenu.this.heroes.getCharacterManager().getHero(Bukkit.getPlayer((UUID)this.playerId));
            HeroClass heroClass = hero.getHeroClass();
            this.totalCost = 0;
            for (AttributeType attribute : AttributeType.values()) {
                int increaseValue = this.pending.getAttributeValue(attribute);
                int pending = hero.getAttributeAllocationCost(heroClass, attribute, increaseValue);
                this.pendingCost.setAttributeValue(attribute, pending);
                int next = hero.getAttributeAllocationCost(heroClass, attribute, increaseValue + 1);
                this.nextIncrease.setAttributeValue(attribute, next - pending);
                this.totalCost += pending;
            }
        }

        protected boolean confirmPending() {
            Hero hero = AttributeMenu.this.heroes.getCharacterManager().getHero(Bukkit.getPlayer((UUID)this.playerId));
            HeroClass heroClass = hero.getHeroClass();
            this.allocationPoints = hero.getAllocationPoints();
            this.updateCosts();
            if (this.allocationPoints >= this.totalCost) {
                for (AttributeType attribute : AttributeType.values()) {
                    if (this.pending.getAttributeValue(attribute) <= 0) continue;
                    hero.modifyAttribute(attribute, this.pending.getAttributeValue(attribute), -this.pendingCost.getAttributeValue(attribute));
                }
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)AttributeMenu.this.heroes, () -> hero.recalculateAttributesAndAllocationPoints(heroClass, hero.getHeroLevel(heroClass)), 2L);
                return true;
            }
            return false;
        }
    }
}

