/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.attributes.menu.items;

import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.attributes.menu.items.MenuItem;
import com.herocraftonline.heroes.attributes.menu.menus.AttributeMenu;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AttributeItem
extends MenuItem {
    private final AttributeMenu menu;
    private final AttributeType attribute;
    private final String[] lore;

    public AttributeItem(AttributeMenu menu, AttributeType attribute, ItemStack icon, String ... lore) {
        super(ChatColor.WHITE + ChatColor.BOLD + "\u276f\u276f\u276f " + ChatColor.DARK_PURPLE + attribute.name() + ChatColor.WHITE + ChatColor.BOLD + " \u276e\u276e\u276e", icon, new String[0]);
        this.menu = menu;
        this.attribute = attribute;
        this.lore = new String[lore.length + 2];
        System.arraycopy(lore, 0, this.lore, 0, lore.length);
    }

    @Override
    public ItemStack getFinalIcon(Player player) {
        ItemStack finalIcon = super.getFinalIcon(player);
        AttributeMenu.PendingAllocation allocation = this.menu.getPendingAllocation(player);
        finalIcon.setAmount(Math.max(1, allocation.getCurrent(this.attribute) + allocation.getPending(this.attribute)));
        ItemMeta meta = finalIcon.getItemMeta();
        this.lore[this.lore.length - 2] = ChatColor.GOLD + "Current Points: " + ChatColor.WHITE + allocation.getCurrent(this.attribute);
        this.lore[this.lore.length - 1] = ChatColor.AQUA + "Pending: " + ChatColor.WHITE + allocation.getPending(this.attribute);
        meta.setLore(Arrays.asList(this.lore));
        finalIcon.setItemMeta(meta);
        return finalIcon;
    }
}

