/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.attributes.menu.items;

import com.herocraftonline.heroes.attributes.menu.events.ItemClickEvent;
import com.herocraftonline.heroes.attributes.menu.items.MenuItem;
import com.herocraftonline.heroes.attributes.menu.menus.AttributeMenu;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AttributeConfirmItem
extends MenuItem {
    private final AttributeMenu menu;

    public AttributeConfirmItem(AttributeMenu menu) {
        super(ChatColor.GREEN + "CONFIRM POINTS", new ItemStack(Material.EMERALD_BLOCK), "This action cannot", "be undone without", "resetting your", "attributes.", "", "");
        this.menu = menu;
    }

    @Override
    public ItemStack getFinalIcon(Player player) {
        ItemStack finalIcon = super.getFinalIcon(player);
        AttributeMenu.PendingAllocation allocation = this.menu.getPendingAllocation(player);
        int available = allocation.getAllocationPoints();
        int remaining = available - allocation.getTotalCost();
        ItemMeta meta = finalIcon.getItemMeta();
        String[] lore = this.getLore();
        lore[lore.length - 2] = ChatColor.GOLD + "Total Available: " + ChatColor.WHITE + available;
        lore[lore.length - 1] = ChatColor.AQUA + "Left to Spend: " + ChatColor.WHITE + remaining;
        meta.setLore(Arrays.asList(lore));
        finalIcon.setItemMeta(meta);
        return finalIcon;
    }

    @Override
    public void onItemClick(ItemClickEvent event) {
        Player player = event.getPlayer();
        if (this.menu.confirmPendingAllocation(player)) {
            player.sendMessage(ChatColor.GREEN + "Your selected attribute points have been successfully allocated!");
        } else {
            player.sendMessage(ChatColor.RED + "There was an error when attempting to complete your attribute allocations.");
        }
        event.setWillClose(true);
    }
}

