/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.attributes.menu.items;

import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.attributes.menu.events.ItemClickEvent;
import com.herocraftonline.heroes.attributes.menu.items.MenuItem;
import com.herocraftonline.heroes.attributes.menu.menus.AttributeMenu;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AttributeAddItem
extends MenuItem {
    private final AttributeMenu menu;
    private final AttributeType attribute;
    private final ItemStack grayIcon;

    public AttributeAddItem(AttributeMenu menu, AttributeType attribute) {
        super(ChatColor.GREEN + "ADD POINTS", new ItemStack(Material.LIME_WOOL, 1), "Increases the below", "stat by one point.");
        this.menu = menu;
        this.attribute = attribute;
        this.grayIcon = new ItemStack(Material.GRAY_WOOL, 1);
        ItemMeta meta = this.grayIcon.getItemMeta();
        meta.setDisplayName(this.getDisplayName());
        meta.setLore(Arrays.asList(this.getLore()));
        this.grayIcon.setItemMeta(meta);
    }

    @Override
    public ItemStack getFinalIcon(Player player) {
        return this.menu.getPendingAllocation(player).canIncreasePending(this.attribute) ? super.getFinalIcon(player) : this.grayIcon;
    }

    @Override
    public void onItemClick(ItemClickEvent event) {
        if (this.menu.getPendingAllocation(event.getPlayer()).increasePending(this.attribute)) {
            event.setWillUpdate(true);
        }
    }
}

