/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.attributes;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public enum AttributeType {
    STRENGTH,
    CONSTITUTION,
    ENDURANCE,
    DEXTERITY,
    INTELLECT,
    WISDOM,
    CHARISMA;

    private static final Map<String, AttributeType> BY_NAME;

    public static AttributeType getAttribute(String name) {
        return BY_NAME.get(name);
    }

    public static AttributeType matchAttribute(String name) {
        Validate.notNull((Object)name, (String)"Attribute Name cannot be null");
        String filtered = name.toUpperCase();
        filtered = filtered.replaceAll("\\s+", "_").replaceAll("\\W", "");
        return BY_NAME.get(filtered);
    }

    static {
        BY_NAME = new HashMap<String, AttributeType>();
        for (AttributeType attribute : AttributeType.values()) {
            BY_NAME.put(attribute.name(), attribute);
            BY_NAME.put(attribute.name().subSequence(0, 3).toString(), attribute);
        }
    }
}

