/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.attributes;

import com.herocraftonline.heroes.attributes.Attribute;
import com.herocraftonline.heroes.attributes.AttributeType;

public class AttributeSet {
    private Attribute strength;
    private Attribute constitution;
    private Attribute endurance;
    private Attribute dexterity;
    private Attribute intellect;
    private Attribute wisdom;
    private Attribute charisma;

    public AttributeSet(Attribute strength, Attribute constitution, Attribute endurance, Attribute dexterity, Attribute intellect, Attribute wisdom, Attribute charisma) {
        this.strength = strength;
        this.constitution = constitution;
        this.endurance = endurance;
        this.dexterity = dexterity;
        this.intellect = intellect;
        this.wisdom = wisdom;
        this.charisma = charisma;
    }

    public AttributeSet(int strength, int constitution, int endurance, int dexterity, int intellect, int wisdom, int charisma) {
        this.strength = new Attribute(AttributeType.STRENGTH, strength);
        this.constitution = new Attribute(AttributeType.CONSTITUTION, constitution);
        this.endurance = new Attribute(AttributeType.ENDURANCE, endurance);
        this.dexterity = new Attribute(AttributeType.DEXTERITY, dexterity);
        this.intellect = new Attribute(AttributeType.INTELLECT, intellect);
        this.wisdom = new Attribute(AttributeType.WISDOM, wisdom);
        this.charisma = new Attribute(AttributeType.CHARISMA, charisma);
    }

    public AttributeSet() {
        this.strength = new Attribute(AttributeType.STRENGTH, 0);
        this.constitution = new Attribute(AttributeType.CONSTITUTION, 0);
        this.endurance = new Attribute(AttributeType.ENDURANCE, 0);
        this.dexterity = new Attribute(AttributeType.DEXTERITY, 0);
        this.intellect = new Attribute(AttributeType.INTELLECT, 0);
        this.wisdom = new Attribute(AttributeType.WISDOM, 0);
        this.charisma = new Attribute(AttributeType.CHARISMA, 0);
    }

    public void reset() {
        this.strength.value.set(0);
        this.constitution.value.set(0);
        this.endurance.value.set(0);
        this.dexterity.value.set(0);
        this.intellect.value.set(0);
        this.wisdom.value.set(0);
        this.charisma.value.set(0);
    }

    public void setStrengthValue(int value) {
        this.setAttributeValue(this.strength, value);
    }

    public int getStrengthValue() {
        return this.strength.value.get();
    }

    public void setConstitutionValue(int value) {
        this.setAttributeValue(this.constitution, value);
    }

    public int getConstitutionValue() {
        return this.constitution.value.get();
    }

    public void setEnduranceValue(int value) {
        this.setAttributeValue(this.endurance, value);
    }

    public int getEnduranceValue() {
        return this.endurance.value.get();
    }

    public void setDexterityValue(int value) {
        this.setAttributeValue(this.dexterity, value);
    }

    public int getDexterityValue() {
        return this.dexterity.value.get();
    }

    public void setIntellectValue(int value) {
        this.setAttributeValue(this.intellect, value);
    }

    public int getIntellectValue() {
        return this.intellect.value.get();
    }

    public void setWisdomValue(int value) {
        this.setAttributeValue(this.wisdom, value);
    }

    public int getWisdomValue() {
        return this.wisdom.value.get();
    }

    public void setCharismaValue(int value) {
        this.setAttributeValue(this.charisma, value);
    }

    public int getCharismaValue() {
        return this.charisma.value.get();
    }

    public Attribute getAttribute(String attributeTypeName) {
        AttributeType attributeType = AttributeType.matchAttribute(attributeTypeName);
        if (attributeType != null) {
            return this.getAttribute(attributeType);
        }
        return null;
    }

    public Attribute getAttribute(AttributeType attributeType) {
        switch (attributeType) {
            case STRENGTH: {
                return this.strength;
            }
            case CONSTITUTION: {
                return this.constitution;
            }
            case ENDURANCE: {
                return this.endurance;
            }
            case DEXTERITY: {
                return this.dexterity;
            }
            case INTELLECT: {
                return this.intellect;
            }
            case WISDOM: {
                return this.wisdom;
            }
            case CHARISMA: {
                return this.charisma;
            }
        }
        return null;
    }

    public int getAttributeValue(String attributeTypeName) {
        AttributeType attributeType = AttributeType.matchAttribute(attributeTypeName);
        if (attributeType != null) {
            return this.getAttributeValue(attributeType);
        }
        return 0;
    }

    public int getAttributeValue(AttributeType attributeType) {
        switch (attributeType) {
            case STRENGTH: {
                return this.getStrengthValue();
            }
            case CONSTITUTION: {
                return this.getConstitutionValue();
            }
            case ENDURANCE: {
                return this.getEnduranceValue();
            }
            case DEXTERITY: {
                return this.getDexterityValue();
            }
            case INTELLECT: {
                return this.getIntellectValue();
            }
            case WISDOM: {
                return this.getWisdomValue();
            }
            case CHARISMA: {
                return this.getCharismaValue();
            }
        }
        return 0;
    }

    public void setAttributeValue(AttributeType attributeType, int value) {
        if (attributeType != null) {
            switch (attributeType) {
                case STRENGTH: {
                    this.setStrengthValue(value);
                    break;
                }
                case CONSTITUTION: {
                    this.setConstitutionValue(value);
                    break;
                }
                case ENDURANCE: {
                    this.setEnduranceValue(value);
                    break;
                }
                case DEXTERITY: {
                    this.setDexterityValue(value);
                    break;
                }
                case INTELLECT: {
                    this.setIntellectValue(value);
                    break;
                }
                case WISDOM: {
                    this.setWisdomValue(value);
                    break;
                }
                case CHARISMA: {
                    this.setCharismaValue(value);
                    break;
                }
            }
        }
    }

    private void setAttributeValue(Attribute attribute, int value) {
        if (attribute.value.get() != value) {
            attribute.value.set(value);
        } else {
            attribute.value.getAndSet(value);
        }
    }

    public boolean hasAny() {
        return this.getStrengthValue() > 0 || this.getConstitutionValue() > 0 || this.getEnduranceValue() > 0 || this.getDexterityValue() > 0 || this.getIntellectValue() > 0 || this.getWisdomValue() > 0 || this.getCharismaValue() > 0;
    }

    public AttributeSet sum(AttributeSet set) {
        return new AttributeSet(this.getStrengthValue() + set.getStrengthValue(), this.getConstitutionValue() + set.getConstitutionValue(), this.getEnduranceValue() + set.getEnduranceValue(), this.getDexterityValue() + set.getDexterityValue(), this.getIntellectValue() + set.getIntellectValue(), this.getWisdomValue() + set.getWisdomValue(), this.getCharismaValue() + set.getCharismaValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeSet that = (AttributeSet)o;
        if (this.dexterity == null && that.dexterity != null || !this.dexterity.equals(that.dexterity)) {
            return false;
        }
        if (this.charisma == null && that.charisma != null || !this.charisma.equals(that.charisma)) {
            return false;
        }
        if (this.constitution == null && that.constitution != null || !this.constitution.equals(that.constitution)) {
            return false;
        }
        if (this.endurance == null && that.endurance != null || !this.endurance.equals(that.endurance)) {
            return false;
        }
        if (this.intellect == null && that.intellect != null || !this.intellect.equals(that.intellect)) {
            return false;
        }
        if (this.strength == null && that.strength != null || !this.strength.equals(that.strength)) {
            return false;
        }
        return (this.wisdom != null || that.wisdom == null) && this.wisdom.equals(that.wisdom);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dexterity == null ? 0 : this.dexterity.hashCode());
        result = 31 * result + (this.charisma == null ? 0 : this.charisma.hashCode());
        result = 31 * result + (this.constitution == null ? 0 : this.constitution.hashCode());
        result = 31 * result + (this.endurance == null ? 0 : this.endurance.hashCode());
        result = 31 * result + (this.intellect == null ? 0 : this.intellect.hashCode());
        result = 31 * result + (this.strength == null ? 0 : this.strength.hashCode());
        result = 31 * result + (this.wisdom == null ? 0 : this.wisdom.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AttributeSet [strength=").append(this.strength).append(", constitution=").append(this.constitution).append(", endurance=").append(this.endurance).append(", dexterity=").append(this.dexterity).append(", intellect=").append(this.intellect).append(", wisdom=").append(this.wisdom).append(", charisma=").append(this.charisma).append("]");
        return builder.toString();
    }
}

