/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.api.events;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.ClassSkill;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.HeroSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class SkillChangeLevelEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled;
    private HeroSkill heroSkill;
    private int from;
    private int to;
    private boolean adminCommand;

    public SkillChangeLevelEvent(HeroSkill heroSkill, int from, int to, boolean adminCommand) {
        this.heroSkill = heroSkill;
        this.from = from;
        this.to = to;
        this.adminCommand = adminCommand;
    }

    public Hero getHero() {
        return this.heroSkill.getHero();
    }

    public HeroSkill getHeroSkill() {
        return this.heroSkill;
    }

    public ClassSkill getClassSkill() {
        return this.heroSkill.getClassSkill();
    }

    public HeroClass getHeroClass() {
        return this.heroSkill.getHeroClass();
    }

    public Skill getSkill() {
        return this.heroSkill.getSkill();
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public boolean isMastering() {
        return this.to == this.heroSkill.getClassSkill().getMaxSkillLevel();
    }

    public boolean isAdminCommand() {
        return this.adminCommand;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        if (this.adminCommand) {
            Heroes.getInstance().getLogger().warning("Skill levels changed by admin command can not be canceled.");
            return;
        }
        this.cancelled = cancel;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

