/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.api.events;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class HeroLeavePartyEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled;
    private final Hero hero;
    private final HeroParty party;
    private final LeavePartyReason reason;

    public HeroLeavePartyEvent(Hero hero, HeroParty heroParty, LeavePartyReason reason) {
        this.hero = hero;
        this.party = heroParty;
        this.reason = reason;
    }

    public Hero getHero() {
        return this.hero;
    }

    public HeroParty getParty() {
        return this.party;
    }

    public LeavePartyReason getReason() {
        return this.reason;
    }

    public boolean isCancellable() {
        return this.reason != LeavePartyReason.DISCONNECT && this.reason != LeavePartyReason.SYSTEM;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled && this.isCancellable();
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public static enum LeavePartyReason {
        COMMAND,
        DISCONNECT,
        KICK,
        SYSTEM;

    }
}

