/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes;

import com.dthielke.herochat.Herochat;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.classes.HeroClassManager;
import com.herocraftonline.heroes.characters.effects.EffectManager;
import com.herocraftonline.heroes.characters.equipment.EquipmentListener;
import com.herocraftonline.heroes.characters.party.PartyChannelManager;
import com.herocraftonline.heroes.characters.party.PartyManager;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillManager;
import com.herocraftonline.heroes.characters.skill.skills.SkillBaseWeaponImbue;
import com.herocraftonline.heroes.command.CommandHandler;
import com.herocraftonline.heroes.command.commands.AdminAllocationPointsCommand;
import com.herocraftonline.heroes.command.commands.AdminAttributeResetCommand;
import com.herocraftonline.heroes.command.commands.AdminAttributeSetCommand;
import com.herocraftonline.heroes.command.commands.AdminBindSkillCommand;
import com.herocraftonline.heroes.command.commands.AdminBonusCommand;
import com.herocraftonline.heroes.command.commands.AdminClassCommand;
import com.herocraftonline.heroes.command.commands.AdminCooldownCommand;
import com.herocraftonline.heroes.command.commands.AdminExpBoostCommand;
import com.herocraftonline.heroes.command.commands.AdminExpBoostInfoCommand;
import com.herocraftonline.heroes.command.commands.AdminExpBoostReloadCommand;
import com.herocraftonline.heroes.command.commands.AdminExpCommand;
import com.herocraftonline.heroes.command.commands.AdminHealCommand;
import com.herocraftonline.heroes.command.commands.AdminHealthCommand;
import com.herocraftonline.heroes.command.commands.AdminLevelCommand;
import com.herocraftonline.heroes.command.commands.AdminManaCommand;
import com.herocraftonline.heroes.command.commands.AdminNPCCommand;
import com.herocraftonline.heroes.command.commands.AdminProfCommand;
import com.herocraftonline.heroes.command.commands.AdminProgressInfoCommand;
import com.herocraftonline.heroes.command.commands.AdminRaceCommand;
import com.herocraftonline.heroes.command.commands.AdminResetRaceCommand;
import com.herocraftonline.heroes.command.commands.AdminShieldCommand;
import com.herocraftonline.heroes.command.commands.AdminSkillLearnCommand;
import com.herocraftonline.heroes.command.commands.AdminSkillLevelCommand;
import com.herocraftonline.heroes.command.commands.AdminSkillPrepareCommand;
import com.herocraftonline.heroes.command.commands.AdminSkillVersionCommand;
import com.herocraftonline.heroes.command.commands.AdminStaminaCommand;
import com.herocraftonline.heroes.command.commands.AdminStatsInfoCommand;
import com.herocraftonline.heroes.command.commands.AdminUltimateCheckClassesCommand;
import com.herocraftonline.heroes.command.commands.AdminUltimateRequiredClassesCommand;
import com.herocraftonline.heroes.command.commands.ArmorAllowedCommand;
import com.herocraftonline.heroes.command.commands.ArmorWeightCommand;
import com.herocraftonline.heroes.command.commands.AttributeAddCommand;
import com.herocraftonline.heroes.command.commands.AttributeInfoCommand;
import com.herocraftonline.heroes.command.commands.AttributeResetCommand;
import com.herocraftonline.heroes.command.commands.AttributesCommand;
import com.herocraftonline.heroes.command.commands.BindSkillCommand;
import com.herocraftonline.heroes.command.commands.BoostCommand;
import com.herocraftonline.heroes.command.commands.ChooseCommand;
import com.herocraftonline.heroes.command.commands.ConfigReloadCommand;
import com.herocraftonline.heroes.command.commands.CooldownCommand;
import com.herocraftonline.heroes.command.commands.HealthCommand;
import com.herocraftonline.heroes.command.commands.HelpCommand;
import com.herocraftonline.heroes.command.commands.InfoBarCommand;
import com.herocraftonline.heroes.command.commands.InfoCommand;
import com.herocraftonline.heroes.command.commands.LeaderboardCommand;
import com.herocraftonline.heroes.command.commands.LevelInformationCommand;
import com.herocraftonline.heroes.command.commands.ManaCommand;
import com.herocraftonline.heroes.command.commands.NPCCommand;
import com.herocraftonline.heroes.command.commands.NPCInfoCommand;
import com.herocraftonline.heroes.command.commands.PartyAcceptCommand;
import com.herocraftonline.heroes.command.commands.PartyChatCommand;
import com.herocraftonline.heroes.command.commands.PartyHelpCommand;
import com.herocraftonline.heroes.command.commands.PartyHeroChatCommand;
import com.herocraftonline.heroes.command.commands.PartyInviteCommand;
import com.herocraftonline.heroes.command.commands.PartyKickCommand;
import com.herocraftonline.heroes.command.commands.PartyLeadCommand;
import com.herocraftonline.heroes.command.commands.PartyLeaveCommand;
import com.herocraftonline.heroes.command.commands.PartyModeCommand;
import com.herocraftonline.heroes.command.commands.PartyWhoCommand;
import com.herocraftonline.heroes.command.commands.PathsCommand;
import com.herocraftonline.heroes.command.commands.ProfessionCommand;
import com.herocraftonline.heroes.command.commands.ProgressInfoCommand;
import com.herocraftonline.heroes.command.commands.RaceCommand;
import com.herocraftonline.heroes.command.commands.RacesCommand;
import com.herocraftonline.heroes.command.commands.ResetCommand;
import com.herocraftonline.heroes.command.commands.ResetRaceCommand;
import com.herocraftonline.heroes.command.commands.ShieldCommand;
import com.herocraftonline.heroes.command.commands.SkillListCommand;
import com.herocraftonline.heroes.command.commands.SkillPrepareCommand;
import com.herocraftonline.heroes.command.commands.SkillUnprepareCommand;
import com.herocraftonline.heroes.command.commands.SpawnParticleCommand;
import com.herocraftonline.heroes.command.commands.SpecsCommand;
import com.herocraftonline.heroes.command.commands.StaminaCommand;
import com.herocraftonline.heroes.command.commands.StatsInfoCommand;
import com.herocraftonline.heroes.command.commands.SuppressCommand;
import com.herocraftonline.heroes.command.commands.ToolsCommand;
import com.herocraftonline.heroes.command.commands.VerboseCommand;
import com.herocraftonline.heroes.command.commands.WhoCommand;
import com.herocraftonline.heroes.command.commands.WhoisCommand;
import com.herocraftonline.heroes.feature.roll.BukkitItemRoll;
import com.herocraftonline.heroes.feature.roll.EcoCreatureItemRoll;
import com.herocraftonline.heroes.feature.roll.HeroRollCommand;
import com.herocraftonline.heroes.feature.roll.ItemRollManager;
import com.herocraftonline.heroes.feature.roll.MythicMobsItemRoll;
import com.herocraftonline.heroes.feature.scoreboard.ScoreboardFeature;
import com.herocraftonline.heroes.integrations.citizens.CitizensNPCListener;
import com.herocraftonline.heroes.integrations.citizens.HeroesNPCTrait;
import com.herocraftonline.heroes.items.HeroAttributeTypes;
import com.herocraftonline.heroes.listeners.CustomDurabilityManager;
import com.herocraftonline.heroes.listeners.ExpBoostListener;
import com.herocraftonline.heroes.listeners.HBlockListener;
import com.herocraftonline.heroes.listeners.HDamageListener;
import com.herocraftonline.heroes.listeners.HEntityListener;
import com.herocraftonline.heroes.listeners.HEventListener;
import com.herocraftonline.heroes.listeners.HInventoryListener;
import com.herocraftonline.heroes.listeners.HItemListener;
import com.herocraftonline.heroes.listeners.HPlayerListener;
import com.herocraftonline.heroes.listeners.HPluginListener;
import com.herocraftonline.heroes.listeners.HStaminaListener;
import com.herocraftonline.heroes.listeners.InternalSkillListener;
import com.herocraftonline.heroes.listeners.wg.HDamageWGListener;
import com.herocraftonline.heroes.storage.StorageManager;
import com.herocraftonline.heroes.ui.EntityHealthDisplay;
import com.herocraftonline.heroes.ui.HeroUIComponent;
import com.herocraftonline.heroes.util.ConfigManager;
import com.herocraftonline.heroes.util.DebugLog;
import com.herocraftonline.heroes.util.FireBlockManager;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.item.ItemManager;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttributeType;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.TraitInfo;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import to.hc.common.bukkit.callback.CallbackCommand;
import to.hc.common.bukkit.ui.UIManager;
import to.hc.common.bukkit.util.NMSHacks;
import to.hc.common.core.util.LazyLoad;

public class Heroes
extends JavaPlugin
implements PluginMessageListener {
    public static final String BUNGEE_CORD_CHANNEL = "BungeeCord";
    public static final File dataFolder = new File("plugins" + File.separator + "Heroes");
    public static DebugLog debugLog;
    public static Properties properties;
    public static Economy econ;
    public static Permission perms;
    public static Herochat herochat;
    @Deprecated
    public static boolean useSMS;
    public static boolean useCitizens;
    private static Logger log;
    private static Heroes instance;
    private final CommandHandler commandHandler = new CommandHandler(this);
    private ConfigManager configManager;
    private HeroClassManager heroClassManager;
    private CharacterManager characterManager;
    private CharacterDamageManager damageManager;
    private CustomDurabilityManager customDurabilityManager;
    private FireBlockManager fireBlockManager;
    private PartyManager partyManager;
    private PartyChannelManager partyChannelManager;
    private SkillManager skillManager;
    private SkillConfigManager skillConfigs;
    private ItemPlugin itemPlugin;
    private EffectManager effectManager;
    private StorageManager storageManager;
    private String serverName;
    private Collection<String> serverNames;
    private final LazyLoad<UIManager> uiManager = new LazyLoad<UIManager>(){

        @Override
        protected UIManager load() {
            UIManager manager = new UIManager();
            Heroes.this.getServer().getPluginManager().registerEvents((Listener)manager, (Plugin)Heroes.this);
            return manager;
        }
    };
    @Nullable
    private ScoreboardFeature scoreboardFeature;

    public static Heroes getInstance() {
        return instance;
    }

    public static void log(Level level, String msg) {
        log.log(level, msg);
        if (Heroes.properties.debug && debugLog != null) {
            debugLog.log(level, "[Heroes] " + msg);
        }
    }

    public static void debugLog(Level level, String msg) {
        if (Heroes.properties.debug && debugLog != null) {
            debugLog.log(level, "[Debug] " + msg);
        }
    }

    public static void debugThrow(String sourceClass, String sourceMethod, Throwable thrown) {
        if (Heroes.properties.debug && debugLog != null) {
            debugLog.throwing(sourceClass, sourceMethod, thrown);
        }
    }

    public void onLoad() {
        dataFolder.mkdirs();
    }

    public void onEnable() {
        NMSHacks.init();
        instance = this;
        log = this.getLogger();
        try {
            new Properties();
        }
        catch (Exception e) {
            log.severe("You're attempting to run Heroes on an incompatible version of CraftBukkit or Minecraft!");
            log.severe("This version of Heroes is compatible with Spigot " + Properties.MC_VERSIONS);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        properties.load(this);
        if (Heroes.properties.debug) {
            debugLog = new DebugLog("Heroes", dataFolder + File.separator + "debug");
        }
        if (this.getServer().getPluginManager().getPlugin("Vault") == null || !this.setupPermissions()) {
            log.warning("Heroes requires Vault! Please install it to use Heroes!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.setupEconomy();
        this.setupHerochat();
        this.setupItems();
        this.setupCitizens();
        this.setupBungee();
        this.configManager = new ConfigManager(this);
        try {
            this.configManager.load();
        }
        catch (Exception e) {
            e.printStackTrace();
            Heroes.log(Level.SEVERE, "Critical error encountered while loading. Disabling...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.storageManager = new StorageManager(this);
        this.characterManager = new CharacterManager(this);
        this.fireBlockManager = new FireBlockManager(this);
        HeroUIComponent.manager = this.characterManager;
        this.effectManager = new EffectManager(this);
        this.partyManager = new PartyManager(this);
        this.damageManager = new CharacterDamageManager(this);
        this.skillManager = new SkillManager(this);
        if (herochat != null) {
            this.partyChannelManager = new PartyChannelManager(this, this.partyManager);
        }
        if (!this.configManager.loadManagers()) {
            this.getPluginLoader().disablePlugin((Plugin)this);
            Heroes.log(Level.SEVERE, "Critical error encountered while loading. Disabling Heroes!");
            return;
        }
        this.registerEvents();
        this.registerFeatures();
        this.registerCommands();
        Heroes.log(Level.INFO, "version " + this.getDescription().getVersion() + " is enabled!");
        for (Player player : this.getServer().getOnlinePlayers()) {
            Hero hero = this.characterManager.getHero(player);
            HeroClass heroClass = hero.getHeroClass();
            HeroClass heroProf = hero.getSecondaryClass();
            HeroClass heroRace = hero.getRaceClass();
            if (heroClass != this.heroClassManager.getDefaultClass() && !perms.has(player, "heroes.classes." + heroClass.getName().toLowerCase())) {
                hero.setHeroClass(this.heroClassManager.getDefaultClass(), false, false);
            }
            if (heroProf != this.heroClassManager.getDefaultProfession() && !perms.has(player, "heroes.classes." + heroClass.getName().toLowerCase())) {
                hero.setHeroClass(this.heroClassManager.getDefaultProfession(), true, false);
            }
            if (heroRace != this.heroClassManager.getDefaultRace() && !perms.has(player, "heroes.races." + heroClass.getName().toLowerCase())) {
                hero.setHeroClass(this.heroClassManager.getDefaultRace(), false, true);
            }
            for (Skill skill : this.skillManager.getSkills()) {
                if (!(skill instanceof OutsourcedSkill)) continue;
                ((OutsourcedSkill)skill).tryLearningSkill(hero);
            }
            this.characterManager.getHero(player).resolveCurrentEquipment();
        }
    }

    public void onDisable() {
        if (this.characterManager != null) {
            this.characterManager.shutdown();
            this.characterManager.stopTimers();
        }
        econ = null;
        log.info(" Heroes version " + this.getDescription().getVersion() + " is disabled!");
        if (Heroes.properties.debug) {
            debugLog.close();
        }
        if (this.uiManager.isLoaded()) {
            this.uiManager.get().disable();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return this.commandHandler.dispatch(sender, command.getName(), label, args);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        return this.commandHandler.tabComplete(sender, command.getName(), label, args);
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        String subChannel;
        if (!BUNGEE_CORD_CHANNEL.equals(channel)) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        switch (subChannel = in.readUTF()) {
            case "GetServer": {
                this.serverName = in.readUTF();
                break;
            }
            case "GetServers": {
                this.serverNames = Sets.newHashSet((Object[])in.readUTF().split(", "));
                break;
            }
        }
    }

    public HeroClassManager getClassManager() {
        return this.heroClassManager;
    }

    public void setClassManager(HeroClassManager heroClassManager) {
        this.heroClassManager = heroClassManager;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Nullable
    public CustomDurabilityManager getCustomDurabilityManager() {
        return this.customDurabilityManager;
    }

    public FireBlockManager getFireBlockManager() {
        return this.fireBlockManager;
    }

    public CharacterDamageManager getDamageManager() {
        return this.damageManager;
    }

    public CharacterManager getCharacterManager() {
        return this.characterManager;
    }

    public PartyManager getPartyManager() {
        return this.partyManager;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Collection<String> getServerNames() {
        return this.serverNames;
    }

    public SkillManager getSkillManager() {
        return this.skillManager;
    }

    public ItemPlugin getItemPlugin() {
        return this.itemPlugin;
    }

    public EffectManager getEffectManager() {
        return this.effectManager;
    }

    public SkillConfigManager getSkillConfigs() {
        return this.skillConfigs;
    }

    public void setSkillConfigs(SkillConfigManager config) {
        this.skillConfigs = config;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public PartyChannelManager getPartyChannelManager() {
        return herochat != null ? this.partyChannelManager : null;
    }

    private void setupHerochat() {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("Herochat");
        if (plugin != null) {
            herochat = Herochat.getPlugin();
        }
    }

    private void setupCitizens() {
        if (this.getServer().getPluginManager().getPlugin("Citizens") == null || !this.getServer().getPluginManager().getPlugin("Citizens").isEnabled()) {
            this.getLogger().log(Level.INFO, "Citizens 2.0 not found or not enabled - integration is disabled");
        } else {
            useCitizens = true;
            try {
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(HeroesNPCTrait.class).withName("HeroesNPC"));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.WARNING, "Heroes's Citizens trait already registered, not continuing in registering it.");
            }
        }
    }

    public void setupItems() {
        this.getServer().getPluginManager().registerEvents((Listener)new EquipmentListener(this), (Plugin)this);
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("Relics");
        if (plugin instanceof ItemPlugin) {
            this.itemPlugin = (ItemPlugin)plugin;
            HashSet attributes = new HashSet();
            attributes.add(HeroAttributeTypes.ATTRIBUTE);
            attributes.add(HeroAttributeTypes.CLASS_REQUIREMENT);
            attributes.add(HeroAttributeTypes.DAMAGE);
            attributes.add(HeroAttributeTypes.HEALTH);
            attributes.add(HeroAttributeTypes.MANA);
            attributes.add(HeroAttributeTypes.MANA_REGEN);
            attributes.add(HeroAttributeTypes.STAMINA);
            attributes.add(HeroAttributeTypes.STAMINA_COST);
            attributes.add(HeroAttributeTypes.STAMINA_REGEN);
            ItemManager itemManager = this.itemPlugin.getItemManager();
            for (BaseAttributeType baseAttributeType : attributes) {
                baseAttributeType.loadFactory(this.itemPlugin);
                itemManager.registerAttributeType(baseAttributeType, plugin);
            }
            this.registerListener(new HItemListener(this));
        }
    }

    private void setupBungee() {
        this.serverName = "";
        this.serverNames = Collections.emptyList();
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, BUNGEE_CORD_CHANNEL);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, BUNGEE_CORD_CHANNEL, (PluginMessageListener)this);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Player player = Bukkit.getOnlinePlayers().stream().findFirst().orElse(null);
                if (player != null) {
                    if (StringUtils.isEmpty((String)Heroes.this.serverName)) {
                        ByteArrayDataOutput getServer = ByteStreams.newDataOutput();
                        getServer.writeUTF("GetServer");
                        player.sendPluginMessage((Plugin)instance, Heroes.BUNGEE_CORD_CHANNEL, getServer.toByteArray());
                    }
                    ByteArrayDataOutput getServers = ByteStreams.newDataOutput();
                    getServers.writeUTF("GetServers");
                    player.sendPluginMessage((Plugin)instance, Heroes.BUNGEE_CORD_CHANNEL, getServers.toByteArray());
                }
            }
        }, 20L, 20L);
    }

    public boolean setupEconomy() {
        RegisteredServiceProvider provider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (provider != null) {
            econ = (Economy)provider.getProvider();
        }
        return econ != null;
    }

    public boolean setupPermissions() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider provider = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (provider != null) {
            perms = (Permission)provider.getProvider();
        }
        return perms != null;
    }

    private void registerCommands() {
        this.getCommand("callback").setExecutor((CommandExecutor)new CallbackCommand());
        this.commandHandler.addCommand(new PathsCommand(this));
        this.commandHandler.addCommand(new SpecsCommand(this));
        this.commandHandler.addCommand(new RacesCommand(this));
        this.commandHandler.addCommand(new ChooseCommand(this));
        this.commandHandler.addCommand(new ProfessionCommand(this));
        this.commandHandler.addCommand(new RaceCommand(this));
        this.commandHandler.addCommand(new LevelInformationCommand(this));
        this.commandHandler.addCommand(new AttributesCommand(this));
        this.commandHandler.addCommand(new AttributeAddCommand(this));
        this.commandHandler.addCommand(new AttributeResetCommand(this));
        this.commandHandler.addCommand(new AttributeInfoCommand(this));
        this.commandHandler.addCommand(new StatsInfoCommand(this));
        this.commandHandler.addCommand(new ProgressInfoCommand(this));
        this.commandHandler.addCommand(new SkillListCommand(this));
        this.commandHandler.addCommand(new BindSkillCommand(this));
        if (Heroes.properties.checkEquipmentWeight) {
            this.commandHandler.addCommand(new ArmorWeightCommand(this));
        } else {
            this.commandHandler.addCommand(new ArmorAllowedCommand(this));
        }
        this.commandHandler.addCommand(new ToolsCommand(this));
        this.commandHandler.addCommand(new ManaCommand(this));
        this.commandHandler.addCommand(new StaminaCommand(this));
        this.commandHandler.addCommand(new CooldownCommand(this));
        this.commandHandler.addCommand(new VerboseCommand(this));
        this.commandHandler.addCommand(new SuppressCommand(this));
        this.commandHandler.addCommand(new WhoCommand(this));
        this.commandHandler.addCommand(new WhoisCommand(this));
        this.commandHandler.addCommand(new BoostCommand(this));
        this.commandHandler.addCommand(new PartyHelpCommand(this));
        this.commandHandler.addCommand(new PartyAcceptCommand(this));
        this.commandHandler.addCommand(new PartyInviteCommand(this));
        this.commandHandler.addCommand(new PartyWhoCommand(this));
        this.commandHandler.addCommand(new PartyLeaveCommand(this));
        this.commandHandler.addCommand(new PartyModeCommand(this));
        this.commandHandler.addCommand(new HeroRollCommand(this));
        if (herochat != null) {
            this.commandHandler.addCommand(new PartyHeroChatCommand(this));
        } else {
            this.commandHandler.addCommand(new PartyChatCommand(this));
        }
        this.commandHandler.addCommand(new PartyLeadCommand(this));
        this.commandHandler.addCommand(new PartyKickCommand(this));
        this.commandHandler.addCommand(new ConfigReloadCommand(this));
        this.commandHandler.addCommand(new HelpCommand(this));
        this.commandHandler.addCommand(new InfoCommand(this));
        this.commandHandler.addCommand(new AdminExpCommand(this));
        this.commandHandler.addCommand(new AdminLevelCommand(this));
        this.commandHandler.addCommand(new AdminClassCommand(this));
        this.commandHandler.addCommand(new AdminProfCommand(this));
        this.commandHandler.addCommand(new AdminRaceCommand(this));
        this.commandHandler.addCommand(new AdminResetRaceCommand(this));
        this.commandHandler.addCommand(new AdminHealthCommand(this));
        this.commandHandler.addCommand(new AdminManaCommand(this));
        this.commandHandler.addCommand(new AdminHealCommand(this));
        this.commandHandler.addCommand(new AdminStaminaCommand(this));
        this.commandHandler.addCommand(new AdminShieldCommand(this));
        this.commandHandler.addCommand(new AdminStatsInfoCommand(this));
        this.commandHandler.addCommand(new AdminAllocationPointsCommand(this));
        this.commandHandler.addCommand(new AdminAttributeResetCommand(this));
        this.commandHandler.addCommand(new AdminUltimateRequiredClassesCommand(this));
        this.commandHandler.addCommand(new AdminUltimateCheckClassesCommand(this));
        this.commandHandler.addCommand(new AdminAttributeSetCommand(this));
        this.commandHandler.addCommand(new AdminStatsInfoCommand(this));
        this.commandHandler.addCommand(new AdminProgressInfoCommand(this));
        this.commandHandler.addCommand(new AdminBonusCommand(this));
        this.commandHandler.addCommand(new AdminCooldownCommand(this));
        this.commandHandler.addCommand(new HealthCommand(this));
        this.commandHandler.addCommand(new ShieldCommand(this));
        this.commandHandler.addCommand(new LeaderboardCommand(this));
        this.commandHandler.addCommand(new ResetCommand(this));
        this.commandHandler.addCommand(new ResetRaceCommand(this));
        this.commandHandler.addCommand(new InfoBarCommand(this));
        this.commandHandler.addCommand(new AdminExpBoostReloadCommand(this));
        this.commandHandler.addCommand(new AdminExpBoostCommand(this));
        this.commandHandler.addCommand(new AdminExpBoostInfoCommand(this));
        this.commandHandler.addCommand(new AdminBindSkillCommand(this));
        this.commandHandler.addCommand(new AdminSkillLearnCommand(this));
        this.commandHandler.addCommand(new AdminSkillPrepareCommand(this));
        this.commandHandler.addCommand(new AdminSkillLevelCommand(this));
        this.commandHandler.addCommand(new SkillPrepareCommand(this));
        this.commandHandler.addCommand(new SkillUnprepareCommand(this));
        this.commandHandler.addCommand(new AdminSkillVersionCommand(this));
        this.commandHandler.addCommand(new SpawnParticleCommand(this));
        if (useCitizens) {
            this.commandHandler.addCommand(new NPCCommand(this));
            this.commandHandler.addCommand(new AdminNPCCommand(this));
            this.commandHandler.addCommand(new NPCInfoCommand(this));
        }
    }

    private void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new HPlayerListener(this), (Plugin)this);
        pm.registerEvents((Listener)new HPluginListener(this), (Plugin)this);
        pm.registerEvents((Listener)new HEntityListener(this), (Plugin)this);
        pm.registerEvents((Listener)new HBlockListener(this), (Plugin)this);
        pm.registerEvents((Listener)new HEventListener(this), (Plugin)this);
        pm.registerEvents((Listener)new HStaminaListener(this), (Plugin)this);
        pm.registerEvents((Listener)new InternalSkillListener(this), (Plugin)this);
        if (Heroes.properties.customDurabilityEnabled) {
            this.customDurabilityManager = new CustomDurabilityManager(this);
            pm.registerEvents((Listener)this.customDurabilityManager, (Plugin)this);
        }
        pm.registerEvents((Listener)new HDamageListener(this), (Plugin)this);
        Plugin worldGuard = pm.getPlugin("WorldGuard");
        if (worldGuard != null && worldGuard.isEnabled()) {
            pm.registerEvents((Listener)new HDamageWGListener(this), (Plugin)this);
        }
        pm.registerEvents((Listener)new HInventoryListener(this), (Plugin)this);
        pm.registerEvents((Listener)new EntityHealthDisplay(), (Plugin)this);
        pm.registerEvents((Listener)new ExpBoostListener(this), (Plugin)this);
        pm.registerEvents((Listener)new SkillBaseWeaponImbue.WeaponSkillListener(this), (Plugin)this);
        if (useCitizens) {
            Bukkit.getPluginManager().registerEvents((Listener)new CitizensNPCListener(this), (Plugin)this);
        }
    }

    private void registerFeatures() {
        if (Heroes.properties.itemRollEnabled) {
            this.registerListener(ItemRollManager.get());
            this.registerListener(new BukkitItemRoll());
            if (this.getServer().getPluginManager().getPlugin("ecoCreature") != null) {
                this.registerListener(new EcoCreatureItemRoll());
            }
            if (this.getServer().getPluginManager().getPlugin("MythicMobs") != null) {
                this.registerListener(new MythicMobsItemRoll());
            }
        }
        if (Heroes.properties.scoreboardEnabled) {
            this.scoreboardFeature = new ScoreboardFeature(this);
            this.registerListener(this.scoreboardFeature);
        }
    }

    private void registerListener(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public UIManager getUIManager() {
        return this.uiManager.get();
    }

    @Nullable
    public ScoreboardFeature getScoreboardFeature() {
        return this.scoreboardFeature;
    }

    static {
        useSMS = false;
        useCitizens = false;
    }
}

