/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.utils;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.RandomTeleport;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.listeners.ResidencePlayerListener;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RandomTp {
    static int miny = 63;
    private Residence plugin;

    public RandomTp(Residence plugin) {
        this.plugin = plugin;
    }

    public boolean isDefinedRnadomTp(World world) {
        for (RandomTeleport one : this.plugin.getConfigManager().getRandomTeleport()) {
            if (!one.getCenter().getWorld().equals(world)) continue;
            return true;
        }
        return false;
    }

    public Location getRandomlocation(World world) {
        if (world == null) {
            return null;
        }
        Random randomX = new Random(System.currentTimeMillis());
        Random randomZ = new Random(System.nanoTime());
        boolean ok = false;
        double x = 0.0;
        double z = 0.0;
        int tries = 0;
        RandomTeleport rtloc = null;
        for (RandomTeleport one : this.plugin.getConfigManager().getRandomTeleport()) {
            if (!one.getCenter().getWorld().equals(world)) continue;
            rtloc = one;
            break;
        }
        if (rtloc == null) {
            return null;
        }
        int inerrange = rtloc.getMinCord();
        int outerrange = rtloc.getMaxCord();
        if (outerrange < 1) {
            outerrange = 1;
        }
        int maxtries = this.plugin.getConfigManager().getrtMaxTries();
        int centerX = rtloc.getCenter().getBlockX();
        int centerY = rtloc.getCenter().getBlockZ();
        Location loc = null;
        block1: while (!ok) {
            ClaimedResidence res;
            if (++tries > maxtries) {
                return null;
            }
            x = (double)(randomX.nextInt(outerrange * 2) - outerrange) + 0.5 + (double)centerX;
            if (x > (double)(inerrange * -1) && x < (double)inerrange || (z = (double)(randomZ.nextInt(outerrange * 2) - outerrange) + 0.5 + (double)centerY) > (double)(inerrange * -1) && z < (double)inerrange) continue;
            loc = new Location(world, x, (double)world.getMaxHeight(), z);
            int max = loc.getWorld().getMaxHeight();
            int i = max = loc.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) ? 100 : world.getHighestBlockAt(loc).getY() + 1;
            while (i > 0) {
                loc.setY((double)i);
                Block block = loc.getBlock();
                Block block2 = loc.clone().add(0.0, 1.0, 0.0).getBlock();
                Block block3 = loc.clone().add(0.0, -1.0, 0.0).getBlock();
                if (!ResidencePlayerListener.isEmptyBlock(block3) && ResidencePlayerListener.isEmptyBlock(block) && ResidencePlayerListener.isEmptyBlock(block2)) break;
                if (i <= 3) {
                    loc = null;
                    continue block1;
                }
                --i;
            }
            if (!ResidencePlayerListener.isEmptyBlock(loc.getBlock()) || loc.clone().add(0.0, -1.0, 0.0).getBlock().getType().equals((Object)Material.LAVA) || loc.clone().add(0.0, -1.0, 0.0).getBlock().getType().equals((Object)Material.WATER) || (res = this.plugin.getResidenceManager().getByLoc(loc)) != null) continue;
            loc.setY(loc.getY() + 2.0);
            break;
        }
        if (loc != null) {
            int dir = randomZ.nextInt(359);
            loc.setYaw((float)dir);
        }
        return loc;
    }

    public void performDelaydTp(final Location loc, final Player targetPlayer) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!RandomTp.this.plugin.getTeleportDelayMap().contains(targetPlayer.getName()) && RandomTp.this.plugin.getConfigManager().getTeleportDelay() > 0) {
                    return;
                }
                if (RandomTp.this.plugin.getTeleportDelayMap().contains(targetPlayer.getName())) {
                    RandomTp.this.plugin.getTeleportDelayMap().remove(targetPlayer.getName());
                }
                targetPlayer.closeInventory();
                targetPlayer.teleport(loc);
                RandomTp.this.plugin.msg((CommandSender)targetPlayer, lm.RandomTeleport_TeleportSuccess, loc.getX(), loc.getY(), loc.getZ());
            }
        }, (long)this.plugin.getConfigManager().getTeleportDelay() * 20L);
    }

    public void performInstantTp(Location loc, Player targetPlayer) {
        targetPlayer.closeInventory();
        targetPlayer.teleport(loc);
        this.plugin.msg((CommandSender)targetPlayer, lm.RandomTeleport_TeleportSuccess, loc.getX(), loc.getY(), loc.getZ());
    }
}

