/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.utils;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.vaultinterface.ResidenceVaultAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class FileCleanUp {
    private Residence plugin;

    public FileCleanUp(Residence plugin) {
        this.plugin = plugin;
    }

    public void cleanFiles() {
        HashMap<String, ClaimedResidence> resNameList = new HashMap<String, ClaimedResidence>(this.plugin.getResidenceManager().getResidences());
        int i = 0;
        OfflinePlayer[] offplayer = Bukkit.getOfflinePlayers();
        HashMap<UUID, OfflinePlayer> playerMapUUID = new HashMap<UUID, OfflinePlayer>();
        HashMap<String, OfflinePlayer> playerMapNane = new HashMap<String, OfflinePlayer>();
        OfflinePlayer[] offlinePlayerArray = offplayer;
        int n = offplayer.length;
        int n2 = 0;
        while (n2 < n) {
            OfflinePlayer one = offlinePlayerArray[n2];
            playerMapUUID.put(one.getUniqueId(), one);
            playerMapNane.put(one.getName(), one);
            ++n2;
        }
        int interval = this.plugin.getConfigManager().getResidenceFileCleanDays();
        long time = System.currentTimeMillis();
        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Starting auto CleanUp (" + playerMapUUID.size() + "/" + resNameList.size() + ")!");
        for (Map.Entry oneName : resNameList.entrySet()) {
            long lastPlayed;
            int dif;
            ClaimedResidence res = (ClaimedResidence)oneName.getValue();
            if (res == null) continue;
            OfflinePlayer player = (OfflinePlayer)playerMapUUID.get(res.getOwnerUUID());
            if (player == null) {
                player = (OfflinePlayer)playerMapNane.get(res.getOwner());
            }
            if (player == null || !this.plugin.getConfigManager().getCleanWorlds().contains(res.getWorld()) || res.getOwner().equalsIgnoreCase("server land") || res.getOwner().equalsIgnoreCase(this.plugin.getServerLandName()) || (dif = (int)((time - (lastPlayed = player.getLastPlayed())) / 1000L / 60L / 60L / 24L)) < interval || ResidenceVaultAdapter.hasPermission(player, PermissionManager.ResPerm.cleanbypass.getPermission(), res.getWorld())) continue;
            ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player.getUniqueId());
            this.plugin.getResidenceManager().removeResidence(rPlayer, (ClaimedResidence)oneName.getValue(), true, this.plugin.getConfigManager().isAutoCleanUpRegenerate());
            ++i;
        }
        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Auto CleanUp deleted " + i + " residences!");
    }
}

