/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.text.help;

public class PageInfo {
    private int totalEntries = 0;
    private int totalPages = 0;
    private int start = 0;
    private int end = 0;
    private int currentPage = 0;
    private int currentEntry = 0;
    private int perPage = 6;

    public PageInfo(int perPage, int totalEntries, int currentPage) {
        this.perPage = perPage;
        this.totalEntries = totalEntries;
        this.currentPage = currentPage;
        this.calculate();
    }

    public int getPositionForOutput() {
        return this.currentEntry;
    }

    public int getPositionForOutput(int place) {
        return this.start + place + 1;
    }

    private void calculate() {
        this.start = (this.currentPage - 1) * this.perPage;
        this.end = this.start + this.perPage - 1;
        if (this.end + 1 > this.totalEntries) {
            this.end = this.totalEntries - 1;
        }
        this.totalPages = (int)Math.ceil((double)this.totalEntries / (double)this.perPage);
    }

    public boolean isInRange(int place) {
        return place >= this.start && place <= this.end;
    }

    public boolean isContinue() {
        return !this.isEntryOk();
    }

    public boolean isEntryOk() {
        ++this.currentEntry;
        return this.currentEntry - 1 >= this.start && this.currentEntry - 1 <= this.end;
    }

    public boolean isBreak() {
        return this.currentEntry - 1 > this.end;
    }

    public boolean isPageOk() {
        return this.isPageOk(this.currentPage);
    }

    public boolean isPageOk(int page) {
        if (this.totalPages < page) {
            return false;
        }
        return page >= 1;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalEntries() {
        return this.totalEntries;
    }
}

