/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.text.help;

import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.text.help.PageInfo;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class InformationPager {
    Residence plugin;

    public InformationPager(Residence plugin) {
        this.plugin = plugin;
    }

    public void printInfo(CommandSender sender, String command2, String title, String[] lines, int page) {
        this.printInfo(sender, command2, title, Arrays.asList(lines), page);
    }

    public void printInfo(CommandSender sender, String command2, String title, List<String> lines, int page) {
        PageInfo pi = new PageInfo(6, lines.size(), page);
        if (!pi.isPageOk()) {
            sender.sendMessage(ChatColor.RED + this.plugin.msg(lm.Invalid_Page, new Object[0]));
            return;
        }
        this.plugin.msg(sender, lm.InformationPage_TopLine, title);
        this.plugin.msg(sender, lm.InformationPage_Page, this.plugin.msg(lm.General_GenericPages, String.format("%d", page), pi.getTotalPages(), lines.size()));
        int i = pi.getStart();
        while (i <= pi.getEnd()) {
            if (lines.size() > i) {
                sender.sendMessage(ChatColor.GREEN + lines.get(i));
            }
            ++i;
        }
        this.plugin.getInfoPageManager().ShowPagination(sender, pi, command2);
    }

    public void printListInfo(CommandSender sender, String targetPlayer, TreeMap<String, ClaimedResidence> ownedResidences, int page, boolean resadmin2) {
        int perPage = 20;
        if (sender instanceof Player) {
            perPage = 6;
        }
        if (ownedResidences.isEmpty()) {
            this.plugin.msg(sender, lm.Residence_DontOwn, targetPlayer);
            return;
        }
        PageInfo pi = new PageInfo(perPage, ownedResidences.size(), page);
        int pagecount = pi.getTotalPages();
        if (!(sender instanceof Player) && page == -1) {
            this.printListWithDelay(sender, ownedResidences, 0, resadmin2);
            return;
        }
        if (!(sender instanceof Player) && page == -2) {
            this.printListToFile(ownedResidences, resadmin2);
            return;
        }
        if (!pi.isPageOk()) {
            sender.sendMessage(ChatColor.RED + this.plugin.msg(lm.Invalid_Page, new Object[0]));
            return;
        }
        if (targetPlayer != null) {
            this.plugin.msg(sender, lm.InformationPage_TopLine, String.valueOf(this.plugin.msg(lm.General_Residences, new Object[0])) + " - " + targetPlayer);
        }
        this.plugin.msg(sender, lm.InformationPage_Page, this.plugin.msg(lm.General_GenericPages, String.format("%d", page), pagecount, ownedResidences.size()));
        String cmd2 = "res";
        if (resadmin2) {
            cmd2 = "resadmin";
        }
        int y = -1;
        for (Map.Entry<String, ClaimedResidence> resT : ownedResidences.entrySet()) {
            if (++y > pi.getEnd()) break;
            if (!pi.isInRange(y)) continue;
            ClaimedResidence res = resT.getValue();
            StringBuilder StringB = new StringBuilder();
            StringB.append(" " + this.plugin.msg(lm.General_Owner, res.getOwner()));
            if (res.getAreaArray().length > 0 && (res.getPermissions().has(Flags.hidden, FlagPermissions.FlagCombo.FalseOrNone) && res.getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.TrueOrNone) || resadmin2)) {
                CuboidArea area2 = res.getAreaArray()[0];
                String cord1 = this.plugin.msg(lm.General_CoordsTop, area2.getHighLoc().getBlockX(), area2.getHighLoc().getBlockY(), area2.getHighLoc().getBlockZ());
                String cord2 = this.plugin.msg(lm.General_CoordsBottom, area2.getLowLoc().getBlockX(), area2.getLowLoc().getBlockY(), area2.getLowLoc().getBlockZ());
                String worldInfo = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.msg(lm.General_CoordsLiner, cord1, cord2));
                StringB.append("\n" + worldInfo);
            }
            StringB.append("\n " + this.plugin.msg(lm.General_CreatedOn, GetTime.getTime(res.getCreateTime())));
            String ExtraString = "";
            if (res.isForRent()) {
                if (res.isRented()) {
                    ExtraString = " " + this.plugin.msg(lm.Residence_IsRented, new Object[0]);
                    StringB.append("\n " + this.plugin.msg(lm.Residence_RentedBy, res.getRentedLand().player));
                } else {
                    ExtraString = " " + this.plugin.msg(lm.Residence_IsForRent, new Object[0]);
                }
                RentableLand rentable = res.getRentable();
                StringB.append("\n " + this.plugin.msg(lm.General_Cost, rentable.cost, rentable.days));
                StringB.append("\n " + this.plugin.msg(lm.Rentable_AllowRenewing, rentable.AllowRenewing));
                StringB.append("\n " + this.plugin.msg(lm.Rentable_StayInMarket, rentable.StayInMarket));
                StringB.append("\n " + this.plugin.msg(lm.Rentable_AllowAutoPay, rentable.AllowAutoPay));
            }
            if (res.isForSell()) {
                ExtraString = " " + this.plugin.msg(lm.Residence_IsForSale, new Object[0]);
                StringB.append("\n " + this.plugin.msg(lm.Economy_LandForSale, new Object[0]) + " " + res.getSellPrice());
            }
            String tpFlag = "";
            String moveFlag = "";
            if (sender instanceof Player && !res.isOwner(sender)) {
                tpFlag = res.getPermissions().playerHas((Player)sender, Flags.tp, true) ? this.plugin.msg(lm.General_AllowedTeleportIcon, new Object[0]) : this.plugin.msg(lm.General_BlockedTeleportIcon, new Object[0]);
                moveFlag = res.getPermissions().playerHas(sender.getName(), Flags.move, true) ? this.plugin.msg(lm.General_AllowedMovementIcon, new Object[0]) : this.plugin.msg(lm.General_BlockedMovementIcon, new Object[0]);
            }
            String msg = this.plugin.msg(lm.Residence_ResList, y + 1, res.getName(), res.getWorld(), String.valueOf(tpFlag) + moveFlag, ExtraString);
            RawMessage rm = new RawMessage();
            if (sender instanceof Player) {
                rm.add(msg, StringB.toString(), String.valueOf(cmd2) + " tp " + res.getName());
            } else {
                rm.add(String.valueOf(msg) + " " + StringB.toString().replace("\n", ""));
            }
            rm.show(sender);
        }
        if (targetPlayer != null) {
            this.ShowPagination(sender, pi, String.valueOf(cmd2) + " list " + targetPlayer);
        } else {
            this.ShowPagination(sender, pi, String.valueOf(cmd2) + " listall");
        }
    }

    private void printListWithDelay(final CommandSender sender, final TreeMap<String, ClaimedResidence> ownedResidences, final int start, final boolean resadmin2) {
        int i = start;
        int y = 0;
        for (Map.Entry<String, ClaimedResidence> resT : ownedResidences.entrySet()) {
            if (++y < i) continue;
            if (++i >= start + 100 || ownedResidences.size() < i) break;
            ClaimedResidence res = resT.getValue();
            StringBuilder StringB = new StringBuilder();
            StringB.append(" " + this.plugin.msg(lm.General_Owner, res.getOwner()));
            if (res.getAreaArray().length > 0 && (res.getPermissions().has(Flags.hidden, FlagPermissions.FlagCombo.FalseOrNone) && res.getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.TrueOrNone) || resadmin2)) {
                CuboidArea area2 = res.getAreaArray()[0];
                String cord1 = this.plugin.msg(lm.General_CoordsTop, area2.getHighLoc().getBlockX(), area2.getHighLoc().getBlockY(), area2.getHighLoc().getBlockZ());
                String cord2 = this.plugin.msg(lm.General_CoordsBottom, area2.getLowLoc().getBlockX(), area2.getLowLoc().getBlockY(), area2.getLowLoc().getBlockZ());
                String worldInfo = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.msg(lm.General_CoordsLiner, cord1, cord2));
                StringB.append("\n" + worldInfo);
            }
            StringB.append("\n " + this.plugin.msg(lm.General_CreatedOn, GetTime.getTime(res.getCreateTime())));
            String ExtraString = "";
            if (res.isForRent()) {
                if (res.isRented()) {
                    ExtraString = " " + this.plugin.msg(lm.Residence_IsRented, new Object[0]);
                    StringB.append("\n " + this.plugin.msg(lm.Residence_RentedBy, res.getRentedLand().player));
                } else {
                    ExtraString = " " + this.plugin.msg(lm.Residence_IsForRent, new Object[0]);
                }
                RentableLand rentable = res.getRentable();
                StringB.append("\n " + this.plugin.msg(lm.General_Cost, rentable.cost, rentable.days));
                StringB.append("\n " + this.plugin.msg(lm.Rentable_AllowRenewing, rentable.AllowRenewing));
                StringB.append("\n " + this.plugin.msg(lm.Rentable_StayInMarket, rentable.StayInMarket));
                StringB.append("\n " + this.plugin.msg(lm.Rentable_AllowAutoPay, rentable.AllowAutoPay));
            }
            if (res.isForSell()) {
                ExtraString = " " + this.plugin.msg(lm.Residence_IsForSale, new Object[0]);
                StringB.append("\n " + this.plugin.msg(lm.Economy_LandForSale, new Object[0]) + " " + res.getSellPrice());
            }
            String msg = this.plugin.msg(lm.Residence_ResList, i, res.getName(), res.getWorld(), "", ExtraString);
            msg = ChatColor.stripColor((String)(String.valueOf(msg) + " " + StringB.toString().replace("\n", "")));
            msg = msg.replaceAll("\\s{2}", " ");
            sender.sendMessage(msg);
        }
        if (ownedResidences.isEmpty()) {
            return;
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                InformationPager.this.printListWithDelay(sender, ownedResidences, start + 100, resadmin2);
            }
        }, 5L);
    }

    private void printListToFile(final TreeMap<String, ClaimedResidence> ownedResidences, final boolean resadmin2) {
        Bukkit.getConsoleSender().sendMessage("Saving");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                int y = 0;
                StringBuilder sb = new StringBuilder();
                for (Map.Entry resT : ownedResidences.entrySet()) {
                    if (ownedResidences.size() < ++y) break;
                    ClaimedResidence res = (ClaimedResidence)resT.getValue();
                    StringBuilder StringB = new StringBuilder();
                    StringB.append(" " + InformationPager.this.plugin.msg(lm.General_Owner, res.getOwner()));
                    if (res.getAreaArray().length > 0 && (res.getPermissions().has(Flags.hidden, FlagPermissions.FlagCombo.FalseOrNone) && res.getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.TrueOrNone) || resadmin2)) {
                        CuboidArea area2 = res.getAreaArray()[0];
                        String cord1 = InformationPager.this.plugin.msg(lm.General_CoordsTop, area2.getHighLoc().getBlockX(), area2.getHighLoc().getBlockY(), area2.getHighLoc().getBlockZ());
                        String cord2 = InformationPager.this.plugin.msg(lm.General_CoordsBottom, area2.getLowLoc().getBlockX(), area2.getLowLoc().getBlockY(), area2.getLowLoc().getBlockZ());
                        String worldInfo = ChatColor.translateAlternateColorCodes((char)'&', (String)InformationPager.this.plugin.msg(lm.General_CoordsLiner, cord1, cord2));
                        StringB.append("\n" + worldInfo);
                    }
                    StringB.append("\n " + InformationPager.this.plugin.msg(lm.General_CreatedOn, GetTime.getTime(res.getCreateTime())));
                    String ExtraString = "";
                    if (res.isForRent()) {
                        if (res.isRented()) {
                            ExtraString = " " + InformationPager.this.plugin.msg(lm.Residence_IsRented, new Object[0]);
                            StringB.append("\n " + InformationPager.this.plugin.msg(lm.Residence_RentedBy, res.getRentedLand().player));
                        } else {
                            ExtraString = " " + InformationPager.this.plugin.msg(lm.Residence_IsForRent, new Object[0]);
                        }
                        RentableLand rentable = res.getRentable();
                        StringB.append("\n " + InformationPager.this.plugin.msg(lm.General_Cost, rentable.cost, rentable.days));
                        StringB.append("\n " + InformationPager.this.plugin.msg(lm.Rentable_AllowRenewing, rentable.AllowRenewing));
                        StringB.append("\n " + InformationPager.this.plugin.msg(lm.Rentable_StayInMarket, rentable.StayInMarket));
                        StringB.append("\n " + InformationPager.this.plugin.msg(lm.Rentable_AllowAutoPay, rentable.AllowAutoPay));
                    }
                    if (res.isForSell()) {
                        ExtraString = " " + InformationPager.this.plugin.msg(lm.Residence_IsForSale, new Object[0]);
                        StringB.append("\n " + InformationPager.this.plugin.msg(lm.Economy_LandForSale, new Object[0]) + " " + res.getSellPrice());
                    }
                    String msg = InformationPager.this.plugin.msg(lm.Residence_ResList, y, res.getName(), res.getWorld(), "", ExtraString);
                    msg = ChatColor.stripColor((String)(String.valueOf(msg) + " " + StringB.toString().replace("\n", "")));
                    msg = msg.replaceAll("\\s{2}", " ");
                    sb.append(msg);
                    sb.append(" \n");
                }
                File BackupDir = new File(Residence.getInstance().getDataLocation(), "FullLists");
                if (!BackupDir.isDirectory()) {
                    BackupDir.mkdir();
                }
                Date date = new Date();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
                File file = new File(BackupDir, String.valueOf(dateFormat.format(date)) + ".txt");
                try {
                    FileUtils.writeStringToFile((File)file, (String)sb.toString(), (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Bukkit.getConsoleSender().sendMessage("Saved file to FullLists folder with " + file.getName() + " name");
            }
        });
    }

    public void ShowPagination(CommandSender sender, PageInfo pi, String cmd2) {
        this.ShowPagination(sender, pi, cmd2, null);
    }

    public void ShowPagination(CommandSender sender, PageInfo pi, Object cmd2, String pagePref) {
        this.ShowPagination(sender, pi.getTotalPages(), pi.getCurrentPage(), pi.getTotalEntries(), String.valueOf(this.plugin.getCommandManager().getLabel()) + " " + cmd2.getClass().getSimpleName(), pagePref);
    }

    public void ShowPagination(CommandSender sender, PageInfo pi, String cmd2, String pagePref) {
        this.ShowPagination(sender, pi.getTotalPages(), pi.getCurrentPage(), pi.getTotalEntries(), cmd2, pagePref);
    }

    public void ShowPagination(CommandSender sender, int pageCount, int CurrentPage, int totalEntries, String cmd2, String pagePref) {
        if (!(sender instanceof Player)) {
            return;
        }
        if (!cmd2.startsWith("/")) {
            cmd2 = "/" + cmd2;
        }
        if (pageCount == 1) {
            return;
        }
        String pagePrefix = pagePref == null ? "" : pagePref;
        int NextPage = CurrentPage + 1;
        NextPage = CurrentPage < pageCount ? NextPage : CurrentPage;
        int Prevpage = CurrentPage - 1;
        Prevpage = CurrentPage > 1 ? Prevpage : CurrentPage;
        RawMessage rm = new RawMessage();
        rm.add(CurrentPage > 1 ? this.plugin.msg(lm.General_prevPage, new Object[0]) : this.plugin.msg(lm.General_prevPageOff, new Object[0]), CurrentPage > 1 ? this.plugin.msg(lm.General_prevPageHover, new Object[0]) : this.plugin.msg(lm.General_lastPageHover, new Object[0]), CurrentPage > 1 ? String.valueOf(cmd2) + " " + pagePrefix + Prevpage : String.valueOf(cmd2) + " " + pagePrefix + pageCount);
        rm.add(this.plugin.msg(lm.General_pageCount, CurrentPage, pageCount), this.plugin.msg(lm.General_pageCountHover, totalEntries));
        rm.add(this.plugin.msg(pageCount > CurrentPage ? lm.General_nextPage : lm.General_nextPageOff, new Object[0]), pageCount > CurrentPage ? this.plugin.msg(lm.General_nextPageHover, new Object[0]) : this.plugin.msg(lm.General_firstPageHover, new Object[0]), pageCount > CurrentPage ? String.valueOf(cmd2) + " " + pagePrefix + NextPage : String.valueOf(cmd2) + " " + pagePrefix + 1);
        if (pageCount != 0) {
            rm.show(sender);
        }
    }
}

