/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.text.help;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.cmiLib.VersionChecker;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.ResidenceCommandListener;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.HelpLines;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.text.help.PageInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class HelpEntry {
    protected String name;
    protected String desc;
    protected String[] lines;
    protected List<HelpEntry> subentrys;
    protected static int linesPerPage = 8;
    File langFile = new File(new File(Residence.getInstance().getDataLocation(), "Language"), "English.yml");

    public HelpEntry(String entryname) {
        this.name = entryname;
        this.subentrys = new ArrayList<HelpEntry>();
        this.lines = new String[0];
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String inname) {
        this.name = inname;
    }

    public void setDescription(String description) {
        this.desc = description;
    }

    public String getDescription() {
        if (this.desc == null) {
            return "";
        }
        return this.desc;
    }

    public void printHelp(CommandSender sender, int page, boolean resadmin2, String path) {
        List<HelpLines> helplines = this.getHelpData(sender, resadmin2);
        path = "/" + path.replace(".", " ") + " ";
        PageInfo pi = new PageInfo(linesPerPage, helplines.size(), page);
        if (!pi.isPageOk()) {
            Residence.getInstance().msg(sender, lm.Invalid_Help, new Object[0]);
            return;
        }
        int i = pi.getStart();
        while (i <= pi.getEnd()) {
            if (helplines.get(i).getCommand() != null) {
                HelpEntry sub = this.getSubEntry(helplines.get(i).getCommand());
                String desc = "&6";
                int y = 0;
                String[] stringArray = sub.lines;
                int n = sub.lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String one = stringArray[n2];
                    desc = String.valueOf(desc) + one;
                    if (++y < sub.lines.length) {
                        desc = String.valueOf(desc) + "\n";
                    }
                    ++n2;
                }
                if (resadmin2) {
                    path = path.replace("/res ", "/resadmin ");
                }
                RawMessage rm = new RawMessage();
                rm.add(CMIChatColor.translateAlternateColorCodes("&6" + helplines.get(i).getDesc()), desc, null, String.valueOf(path) + helplines.get(i).getCommand());
                rm.show(sender);
            } else {
                sender.sendMessage(CMIChatColor.translateAlternateColorCodes("&6" + helplines.get(i).getDesc()));
            }
            ++i;
        }
        String baseCmd = resadmin2 ? "resadmin" : "res";
        String cmd2 = !this.name.equalsIgnoreCase("res") ? "/" + baseCmd + " " + this.name + " ? " : "/" + baseCmd + " ? ";
        Residence.getInstance().getInfoPageManager().ShowPagination(sender, pi, cmd2);
    }

    public void printHelp(CommandSender sender, int page, String path, boolean resadmin2) {
        HelpEntry subEntry = this.getSubEntry(path);
        if (subEntry != null) {
            subEntry.printHelp(sender, page, resadmin2, path);
        } else {
            Residence.getInstance().msg(sender, lm.Invalid_Help, new Object[0]);
        }
    }

    private List<HelpLines> getHelpData(CommandSender sender, boolean resadmin2) {
        ArrayList<HelpLines> helplines = new ArrayList<HelpLines>();
        String[] stringArray = this.lines;
        int n = this.lines.length;
        int n2 = 0;
        while (n2 < n) {
            String one = stringArray[n2];
            helplines.add(new HelpLines(null, one));
            ++n2;
        }
        FlagPermissions GlobalFlags = Residence.getInstance().getPermissionManager().getAllFlags();
        Map<String, String> unsortMap = new HashMap<String, String>();
        for (HelpEntry helpEntry : this.subentrys) {
            block17: {
                block16: {
                    if (this.name.equalsIgnoreCase("flags")) break block16;
                    if (ResidenceCommandListener.getAdminCommands().contains(helpEntry.getName().toLowerCase()) && !resadmin2 || !ResidenceCommandListener.getAdminCommands().contains(helpEntry.getName().toLowerCase()) && resadmin2) {
                        continue;
                    }
                    break block17;
                }
                if (!GlobalFlags.getFlags().containsKey(helpEntry.getName().toLowerCase())) break block17;
                Boolean state = GlobalFlags.getFlags().get(helpEntry.getName().toLowerCase());
                if (!state.booleanValue() && !resadmin2 && !PermissionManager.ResPerm.flag_$1.hasPermission(sender, helpEntry.getName().toLowerCase())) continue;
                String flagName = helpEntry.getName();
                Flags flag = Flags.getFlag(helpEntry.getName());
                if (flag != null) {
                    flagName = flag.getName();
                }
                String desc = helpEntry.getDescription();
                switch (helpEntry.getName().toLowerCase()) {
                    case "wspeed1": {
                        desc = desc.replace("%1", "" + Residence.getInstance().getConfigManager().getWalkSpeed1());
                        break;
                    }
                    case "wspeed2": {
                        desc = desc.replace("%1", "" + Residence.getInstance().getConfigManager().getWalkSpeed2());
                    }
                }
                unsortMap.put(helpEntry.getName(), Residence.getInstance().msg(lm.InformationPage_FlagsList, flagName, desc));
                continue;
            }
            helplines.add(new HelpLines(helpEntry.getName(), Residence.getInstance().msg(lm.InformationPage_GeneralList, helpEntry.getName(), helpEntry.getDescription())));
        }
        if (!unsortMap.isEmpty()) {
            unsortMap = Residence.getInstance().getSortingManager().sortStringByKeyASC(unsortMap);
            for (Map.Entry entry : unsortMap.entrySet()) {
                helplines.add(new HelpLines((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return helplines;
    }

    public boolean containesEntry(String name) {
        return this.getSubEntry(name) != null;
    }

    public HelpEntry getSubEntry(String name) {
        String[] split = name.split("\\.");
        HelpEntry entry = this;
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String entryname = stringArray[n2];
            if ((entry = entry.findSubEntry(entryname)) == null) {
                return null;
            }
            ++n2;
        }
        return entry;
    }

    private HelpEntry findSubEntry(String name) {
        for (HelpEntry entry : this.subentrys) {
            if (!entry.getName().equalsIgnoreCase(name)) continue;
            return entry;
        }
        return null;
    }

    public void addSubEntry(HelpEntry entry) {
        if (!this.subentrys.contains(entry)) {
            this.subentrys.add(entry);
        }
    }

    public void removeSubEntry(HelpEntry entry) {
        if (this.subentrys.contains(entry)) {
            this.subentrys.remove(entry);
        }
    }

    public int getSubEntryCount() {
        return this.subentrys.size();
    }

    public static HelpEntry parseHelp(FileConfiguration node, String key) {
        String[] split = key.split("\\.");
        String thisname = split[split.length - 1];
        HelpEntry entry = new HelpEntry(thisname);
        ConfigurationSection keysnode = node.getConfigurationSection(key);
        Set keys = null;
        if (keysnode != null) {
            keys = keysnode.getKeys(false);
        }
        if (keys != null) {
            List stringList;
            if (keys.contains("Info") && (stringList = node.getStringList(String.valueOf(key) + ".Info")) != null) {
                entry.lines = new String[stringList.size()];
                int i = 0;
                while (i < stringList.size()) {
                    entry.lines[i] = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)stringList.get(i)));
                    ++i;
                }
            }
            if (keys.contains("Description")) {
                entry.desc = node.getString(String.valueOf(key) + ".Description");
            }
            if (keys.contains("SubCommands")) {
                Set subcommandkeys = node.getConfigurationSection(String.valueOf(key) + ".SubCommands").getKeys(false);
                if (key.equalsIgnoreCase("CommandHelp.SubCommands.res")) {
                    subcommandkeys.clear();
                    for (String one : Residence.getInstance().getCommandFiller().getCommands()) {
                        subcommandkeys.add(one);
                    }
                }
                for (String subkey : subcommandkeys) {
                    entry.subentrys.add(HelpEntry.parseHelp(node, String.valueOf(key) + ".SubCommands." + subkey));
                }
            }
        }
        return entry;
    }

    public Set<String> getSubCommands(CommandSender sender, String[] args) {
        block57: {
            boolean subCommand;
            ConfigurationSection tempmeinPath;
            HashSet<String> subCommands;
            block58: {
                subCommands = new HashSet<String>();
                if (!this.langFile.isFile()) break block57;
                YamlConfiguration node = new YamlConfiguration();
                try {
                    node.load(this.langFile);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvalidConfigurationException e) {
                    e.printStackTrace();
                }
                ConfigurationSection meinPath = node.getConfigurationSection("CommandHelp.SubCommands.res.SubCommands");
                tempmeinPath = node.getConfigurationSection("CommandHelp.SubCommands.res.SubCommands");
                if (args.length == 1) {
                    return meinPath.getKeys(false);
                }
                boolean ok = true;
                int i = 0;
                while (ok) {
                    if (i >= args.length) break;
                    if (args[i].equalsIgnoreCase("")) {
                        return tempmeinPath.getKeys(false);
                    }
                    if (!tempmeinPath.isConfigurationSection(String.valueOf(args[i]) + ".SubCommands")) break;
                    tempmeinPath = tempmeinPath.getConfigurationSection(String.valueOf(args[i]) + ".SubCommands");
                    ++i;
                }
                int neededArgPlace = args.length - 2 - i;
                subCommand = true;
                if (i < args.length && tempmeinPath.isConfigurationSection(args[i])) {
                    subCommand = false;
                    tempmeinPath = tempmeinPath.getConfigurationSection(args[i]);
                }
                List<Object> ArgsList = new ArrayList();
                int ii = 0;
                for (Map.Entry<List<String>, List<String>> one : Residence.getInstance().getLocaleManager().CommandTab.entrySet()) {
                    List<String> list2 = one.getKey();
                    if (list2.size() > ii && args.length > ii && list2.get(ii).equalsIgnoreCase(args[ii])) {
                        ArgsList = one.getValue();
                    }
                    ++i;
                }
                String NeededArg = null;
                if (neededArgPlace < ArgsList.size() && neededArgPlace >= 0) {
                    NeededArg = (String)ArgsList.get(neededArgPlace);
                }
                Player playerSender = null;
                if (sender instanceof Player) {
                    playerSender = (Player)sender;
                }
                if (NeededArg == null) break block58;
                ArrayList<String> list2 = new ArrayList<String>();
                if (NeededArg.contains("%%")) {
                    list2.addAll(Arrays.asList(NeededArg.split("%%")));
                } else {
                    list2.add(NeededArg);
                }
                Iterator iterator = list2.iterator();
                block26: while (iterator.hasNext()) {
                    String oneArg;
                    switch (oneArg = (String)iterator.next()) {
                        case "[playername]": {
                            for (Player player : Bukkit.getOnlinePlayers()) {
                                if (playerSender != null && !player.canSee(playerSender)) continue;
                                subCommands.add(player.getName());
                            }
                            continue block26;
                        }
                        case "[residence]": {
                            if (sender instanceof Player) {
                                String resName;
                                ClaimedResidence claimedResidence = Residence.getInstance().getResidenceManager().getByLoc(((Player)sender).getLocation());
                                if (claimedResidence != null && (resName = claimedResidence.getName()) != null) {
                                    subCommands.add(resName);
                                }
                                List<ClaimedResidence> resList = Residence.getInstance().getPlayerManager().getResidencePlayer((Player)sender).getResList();
                                for (ClaimedResidence oneRes : resList) {
                                    subCommands.add(oneRes.getName());
                                }
                                continue block26;
                            }
                            ArrayList<String> arrayList = Residence.getInstance().getResidenceManager().getResidenceList(Residence.getInstance().getServerLandName(), true, false, false);
                            if (arrayList.size() <= 0) continue block26;
                            subCommands.addAll(arrayList);
                            break;
                        }
                        case "[cresidence]": {
                            String resName;
                            ClaimedResidence claimedResidence;
                            if (!(sender instanceof Player) || (claimedResidence = Residence.getInstance().getResidenceManager().getByLoc(((Player)sender).getLocation())) == null || (resName = claimedResidence.getName()) == null) continue block26;
                            subCommands.add(resName);
                            break;
                        }
                        case "[residenceshop]": {
                            for (ClaimedResidence claimedResidence : Residence.getInstance().getResidenceManager().getShops()) {
                                subCommands.add(claimedResidence.getName());
                            }
                            continue block26;
                        }
                        case "[flag]": {
                            for (String string : FlagPermissions.getAllPosibleFlags()) {
                                Flags f = Flags.getFlag(string);
                                if (f != null) {
                                    if (!f.isGlobalyEnabled()) continue;
                                    subCommands.add(f.getName());
                                }
                                subCommands.add(string);
                            }
                            for (String string : FlagPermissions.getPosibleAreaFlags()) {
                                Flags f = Flags.getFlag(string);
                                if (f != null) {
                                    if (!f.isGlobalyEnabled()) continue;
                                    subCommands.add(f.getName());
                                }
                                subCommands.add(string);
                            }
                            continue block26;
                        }
                        case "[material]": {
                            Object object = Material.values();
                            int n = ((Material[])object).length;
                            int n2 = 0;
                            while (n2 < n) {
                                Material material2 = object[n2];
                                subCommands.add(material2.name().toLowerCase());
                                ++n2;
                            }
                            continue block26;
                        }
                        case "[materialId]": {
                            if (!VersionChecker.Version.isCurrentEqualOrLower(VersionChecker.Version.v1_13_R2)) continue block26;
                            Object object = Material.values();
                            int n = ((Material[])object).length;
                            int n3 = 0;
                            while (n3 < n) {
                                Material material3 = object[n3];
                                subCommands.add(String.valueOf(material3.getId()));
                                ++n3;
                            }
                            continue block26;
                        }
                        case "[worldname]": {
                            for (World world : Bukkit.getWorlds()) {
                                subCommands.add(world.getName());
                            }
                            continue block26;
                        }
                        default: {
                            subCommands.add(oneArg);
                        }
                    }
                }
            }
            if (subCommands.size() > 0) {
                return subCommands;
            }
            if (subCommand) {
                return tempmeinPath.getKeys(false);
            }
        }
        return new HashSet<String>(Arrays.asList("?"));
    }
}

