/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.selection.SelectionManager;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.limit.PermissiveSelectorLimits;
import com.sk89q.worldedit.regions.selector.limit.SelectorLimits;
import com.sk89q.worldedit.world.World;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class WorldEdit7SelectionManager
extends SelectionManager {
    public WorldEdit7SelectionManager(Server serv, Residence plugin) {
        super(serv, plugin);
    }

    @Override
    public boolean worldEdit(Player player) {
        block5: {
            WorldEditPlugin wep = (WorldEditPlugin)this.server.getPluginManager().getPlugin("WorldEdit");
            Region sel = null;
            try {
                World w = wep.getSession(player).getSelectionWorld();
                if (w != null) {
                    sel = wep.getSession(player).getSelection(w);
                }
                if (sel == null) break block5;
                try {
                    Location pos1 = new Location(player.getWorld(), (double)sel.getMinimumPoint().getX(), (double)sel.getMinimumPoint().getY(), (double)sel.getMinimumPoint().getZ());
                    Location pos2 = new Location(player.getWorld(), (double)sel.getMaximumPoint().getX(), (double)sel.getMaximumPoint().getY(), (double)sel.getMaximumPoint().getZ());
                    this.updateLocations(player, pos1, pos2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            catch (IncompleteRegionException e1) {
                e1.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean worldEditUpdate(Player player) {
        if (!this.hasPlacedBoth(player)) {
            return false;
        }
        World w = BukkitAdapter.adapt((org.bukkit.World)player.getWorld());
        try {
            this.plugin.getWorldEdit().getSession(player).getRegionSelector(w).selectPrimary(BlockVector3.at((int)this.getPlayerLoc1(player).getBlockX(), (int)this.getPlayerLoc1(player).getBlockY(), (int)this.getPlayerLoc1(player).getBlockZ()), (SelectorLimits)PermissiveSelectorLimits.getInstance());
            this.plugin.getWorldEdit().getSession(player).getRegionSelector(w).selectSecondary(BlockVector3.at((int)this.getPlayerLoc2(player).getBlockX(), (int)this.getPlayerLoc2(player).getBlockY(), (int)this.getPlayerLoc2(player).getBlockZ()), (SelectorLimits)PermissiveSelectorLimits.getInstance());
        }
        catch (Error | Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void placeLoc1(Player player, Location loc, boolean show2) {
        super.placeLoc1(player, loc, show2);
        this.worldEditUpdate(player);
    }

    @Override
    public void placeLoc2(Player player, Location loc, boolean show2) {
        super.placeLoc2(player, loc, show2);
        this.worldEditUpdate(player);
    }

    @Override
    public void sky(Player player, boolean resadmin2) {
        super.sky(player, resadmin2);
        this.worldEditUpdate(player);
    }

    @Override
    public void bedrock(Player player, boolean resadmin2) {
        super.bedrock(player, resadmin2);
        this.worldEditUpdate(player);
    }

    @Override
    public void modify(Player player, boolean shift, double amount) {
        super.modify(player, shift, amount);
        this.worldEditUpdate(player);
    }

    @Override
    public void selectChunk(Player player) {
        super.selectChunk(player);
        this.worldEditUpdate(player);
    }

    @Override
    public void showSelectionInfo(Player player) {
        super.showSelectionInfo(player);
        this.worldEditUpdate(player);
    }

    @Override
    public void regenerate(CuboidArea area2) {
        CuboidRegionSelector sellection = new CuboidRegionSelector(BukkitAdapter.adapt((org.bukkit.World)area2.getWorld()));
        try {
            sellection.selectPrimary(BlockVector3.at((int)area2.getLowLoc().getBlockX(), (int)area2.getLowLoc().getBlockY(), (int)area2.getLowLoc().getBlockZ()), (SelectorLimits)PermissiveSelectorLimits.getInstance());
            sellection.selectSecondary(BlockVector3.at((int)area2.getHighLoc().getBlockX(), (int)area2.getHighLoc().getBlockY(), (int)area2.getHighLoc().getBlockZ()), (SelectorLimits)PermissiveSelectorLimits.getInstance());
        }
        catch (Error | Exception e) {
            return;
        }
        CuboidRegion cuboid = sellection.getIncompleteRegion();
        cuboid.getWorld().regenerate((Region)cuboid, WorldEdit.getInstance().getEditSessionFactory().getEditSession(cuboid.getWorld(), -1));
    }
}

