/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.cmiLib.ActionBarTitleMessages;
import com.bekvon.bukkit.cmiLib.CMIEffect;
import com.bekvon.bukkit.cmiLib.CMIEffectManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.SelectionSides;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public class SelectionManager {
    protected Map<UUID, Selection> selections;
    protected Server server;
    protected Residence plugin;
    private HashMap<UUID, Visualizer> vMap = new HashMap();
    public static final int MIN_HEIGHT = 0;
    Permission ignoreyPermission = new Permission(PermissionManager.ResPerm.bypass_ignorey.getPermission(), PermissionDefault.FALSE);
    Permission ignoreyinsubzonePermission = new Permission(PermissionManager.ResPerm.bypass_ignoreyinsubzone.getPermission(), PermissionDefault.FALSE);

    private int getMaxWorldHeight(World world) {
        if (world == null) {
            return 255;
        }
        switch (world.getEnvironment()) {
            case NETHER: {
                return 128;
            }
            case NORMAL: 
            case THE_END: {
                return 255;
            }
        }
        return 255;
    }

    public SelectionManager(Server server2, Residence plugin) {
        this.plugin = plugin;
        this.server = server2;
        this.selections = Collections.synchronizedMap(new HashMap());
    }

    public Selection getSelection(Player player) {
        Selection s = this.selections.get(player.getUniqueId());
        if (s == null) {
            s = new Selection(player);
            this.selections.put(player.getUniqueId(), s);
        }
        return s;
    }

    public void updateLocations(Player player) {
        Selection s = this.selections.get(player.getUniqueId());
        if (s != null) {
            this.updateLocations(player, this.getSelection(player).getBaseLoc1(), this.getSelection(player).getBaseLoc2(), true);
        }
    }

    public void updateLocations(Player player, Location loc1, Location loc2) {
        this.updateLocations(player, loc1, loc2, false);
    }

    public void updateLocations(Player player, Location loc1, Location loc2, boolean force) {
        Selection selection = this.getSelection(player);
        if (loc1 != null) {
            selection.setBaseLoc1(loc1);
        }
        if (loc2 != null) {
            selection.setBaseLoc2(loc2);
        }
        this.afterSelectionUpdate(player, force);
    }

    public void placeLoc1(Player player, Location loc) {
        this.placeLoc1(player, loc, false);
    }

    public void placeLoc1(Player player, Location loc, boolean show2) {
        if (loc != null) {
            this.getSelection(player).setBaseLoc1(loc);
            if (show2) {
                this.afterSelectionUpdate(player);
            }
        }
    }

    public void placeLoc2(Player player, Location loc) {
        this.placeLoc2(player, loc, false);
    }

    public void placeLoc2(Player player, Location loc, boolean show2) {
        if (loc != null) {
            this.getSelection(player).setBaseLoc2(loc);
            if (show2) {
                this.afterSelectionUpdate(player);
            }
        }
    }

    public void afterSelectionUpdate(Player player) {
        this.afterSelectionUpdate(player, false);
    }

    public void afterSelectionUpdate(Player player, boolean force) {
        if (!this.hasPlacedBoth(player)) {
            return;
        }
        Visualizer v = this.vMap.get(player.getUniqueId());
        if (v == null) {
            v = new Visualizer(player);
            this.vMap.put(player.getUniqueId(), v);
        }
        v.setStart(System.currentTimeMillis());
        v.cancelAll();
        if (force) {
            v.setLoc(null);
        }
        v.setAreas(this.getSelectionCuboid(player));
        v.setOnce(false);
        this.showBounds(player, v);
    }

    public Location getPlayerLoc1(Player player) {
        if (player == null) {
            return null;
        }
        Selection sel = this.getSelection(player);
        if (sel == null) {
            return null;
        }
        CuboidArea area2 = sel.getResizedArea();
        if (area2 == null) {
            return null;
        }
        return area2.getLowLoc();
    }

    @Deprecated
    public Location getPlayerLoc1(String player) {
        return this.getPlayerLoc1(Bukkit.getPlayer((String)player));
    }

    public Location getPlayerLoc2(Player player) {
        if (player == null) {
            return null;
        }
        Selection sel = this.getSelection(player);
        if (sel == null) {
            return null;
        }
        CuboidArea area2 = sel.getResizedArea();
        if (area2 == null) {
            return null;
        }
        return area2.getHighLoc();
    }

    @Deprecated
    public Location getPlayerLoc2(String player) {
        return this.getPlayerLoc2(Bukkit.getPlayer((String)player));
    }

    public CuboidArea getSelectionCuboid(Player player) {
        if (player == null) {
            return null;
        }
        return this.getSelection(player).getResizedArea();
    }

    @Deprecated
    public CuboidArea getSelectionCuboid(String player) {
        if (!this.hasPlacedBoth(player)) {
            return null;
        }
        return this.getSelectionCuboid(Bukkit.getPlayer((String)player));
    }

    public boolean hasPlacedBoth(Player player) {
        if (player == null) {
            return false;
        }
        return this.getSelection(player).hasPlacedBoth();
    }

    @Deprecated
    public boolean hasPlacedBoth(String player) {
        return this.hasPlacedBoth(Bukkit.getPlayer((String)player));
    }

    public void showSelectionInfoInActionBar(Player player) {
        if (!this.plugin.getConfigManager().useActionBarOnSelection()) {
            return;
        }
        CuboidArea cuboidArea = this.getSelectionCuboid(player);
        String Message = this.plugin.msg(lm.Select_TotalSize, cuboidArea.getSize());
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        if (this.plugin.getConfigManager().enableEconomy()) {
            Message = String.valueOf(Message) + " " + this.plugin.msg(lm.General_LandCost, cuboidArea.getCost(group));
        }
        ActionBarTitleMessages.send(player, Message);
    }

    public void showSelectionInfo(Player player) {
        if (this.hasPlacedBoth(player)) {
            this.plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
            CuboidArea cuboidArea = this.getSelectionCuboid(player);
            this.plugin.msg((CommandSender)player, lm.Select_TotalSize, cuboidArea.getSize());
            ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
            PermissionGroup group = rPlayer.getGroup();
            if (this.plugin.getConfigManager().enableEconomy()) {
                this.plugin.msg((CommandSender)player, lm.General_LandCost, cuboidArea.getCost(group));
            }
            player.sendMessage(ChatColor.YELLOW + "X" + this.plugin.msg(lm.General_Size, cuboidArea.getXSize()));
            player.sendMessage(ChatColor.YELLOW + "Y" + this.plugin.msg(lm.General_Size, cuboidArea.getYSize()));
            player.sendMessage(ChatColor.YELLOW + "Z" + this.plugin.msg(lm.General_Size, cuboidArea.getZSize()));
            this.plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
            Visualizer v = new Visualizer(player);
            v.setAreas(this.getSelectionCuboid(player));
            this.showBounds(player, v);
        } else {
            this.plugin.msg((CommandSender)player, lm.Select_Points, new Object[0]);
        }
    }

    public void showBounds(final Player player, final Visualizer v) {
        if (!this.plugin.getConfigManager().useVisualizer()) {
            return;
        }
        Visualizer tv = this.vMap.get(player.getUniqueId());
        if (tv != null) {
            tv.cancelAll();
        }
        this.vMap.put(player.getUniqueId(), v);
        v.setBaseShedId(Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!v.getAreas().isEmpty()) {
                    SelectionManager.this.MakeBorders(player, false);
                }
                if (!v.getErrorAreas().isEmpty()) {
                    SelectionManager.this.MakeBorders(player, true);
                }
            }
        }).getTaskId());
    }

    public List<Location> getLocations(Location lowLoc, Location loc, Double TX, Double TY, Double TZ, Double Range, boolean StartFromZero) {
        double eachCollumn = this.plugin.getConfigManager().getVisualizerRowSpacing();
        double eachRow = this.plugin.getConfigManager().getVisualizerCollumnSpacing();
        if (TX == 0.0) {
            TX = eachCollumn + eachCollumn * 0.1;
        }
        if (TY == 0.0) {
            TY = eachRow + eachRow * 0.1;
        }
        if (TZ == 0.0) {
            TZ = eachCollumn + eachCollumn * 0.1;
        }
        double CollumnStart = eachCollumn;
        double RowStart = eachRow;
        if (StartFromZero) {
            CollumnStart = 0.0;
            RowStart = 0.0;
        }
        ArrayList<Location> locList = new ArrayList<Location>();
        if (lowLoc.getWorld() != loc.getWorld()) {
            return locList;
        }
        double x = CollumnStart;
        while (x < TX) {
            Location CurrentX = lowLoc.clone();
            if (TX > eachCollumn + eachCollumn * 0.1) {
                CurrentX.add(x, 0.0, 0.0);
            }
            double y = RowStart;
            while (y < TY) {
                Location CurrentY = CurrentX.clone();
                if (TY > eachRow + eachRow * 0.1) {
                    CurrentY.add(0.0, y, 0.0);
                }
                double z = CollumnStart;
                while (z < TZ) {
                    double dist;
                    Location CurrentZ = CurrentY.clone();
                    if (TZ > eachCollumn + eachCollumn * 0.1) {
                        CurrentZ.add(0.0, 0.0, z);
                    }
                    if ((dist = loc.distance(CurrentZ)) < Range) {
                        locList.add(CurrentZ.clone());
                    }
                    z += eachCollumn;
                }
                y += eachRow;
            }
            x += eachCollumn;
        }
        return locList;
    }

    public List<Location> GetLocationsWallsByData(Location loc, Double TX, Double TY, Double TZ, Location lowLoc, SelectionSides Sides, double Range) {
        ArrayList<Location> locList = new ArrayList<Location>();
        if (Sides.ShowNorthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone(), loc.clone(), TX, TY, 0.0, Range, false));
        }
        if (Sides.ShowSouthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, 0.0, TZ.doubleValue()), loc.clone(), TX, TY, 0.0, Range, false));
        }
        if (Sides.ShowWestSide()) {
            locList.addAll(this.getLocations(lowLoc.clone(), loc.clone(), 0.0, TY, TZ, Range, false));
        }
        if (Sides.ShowEastSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(TX.doubleValue(), 0.0, 0.0), loc.clone(), 0.0, TY, TZ, Range, false));
        }
        if (Sides.ShowTopSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, TY.doubleValue(), 0.0), loc.clone(), TX, 0.0, TZ, Range, false));
        }
        if (Sides.ShowBottomSide()) {
            locList.addAll(this.getLocations(lowLoc.clone(), loc.clone(), TX, 0.0, TZ, Range, false));
        }
        return locList;
    }

    public List<Location> GetLocationsCornersByData(Location loc, Double TX, Double TY, Double TZ, Location lowLoc, SelectionSides Sides, double Range) {
        ArrayList<Location> locList = new ArrayList<Location>();
        if (Sides.ShowBottomSide() && Sides.ShowNorthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone(), loc.clone(), TX, 0.0, 0.0, Range, true));
        }
        if (Sides.ShowTopSide() && Sides.ShowNorthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, TY.doubleValue(), 0.0), loc.clone(), TX, 0.0, 0.0, Range, true));
        }
        if (Sides.ShowBottomSide() && Sides.ShowSouthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, 0.0, TZ.doubleValue()), loc.clone(), TX, 0.0, 0.0, Range, true));
        }
        if (Sides.ShowTopSide() && Sides.ShowSouthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, TY.doubleValue(), TZ.doubleValue()), loc.clone(), TX, 0.0, 0.0, Range, true));
        }
        if (Sides.ShowWestSide() && Sides.ShowNorthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, 0.0, 0.0), loc.clone(), 0.0, TY, 0.0, Range, true));
        }
        if (Sides.ShowEastSide() && Sides.ShowNorthSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(TX.doubleValue(), 0.0, 0.0), loc.clone(), 0.0, TY, 0.0, Range, true));
        }
        if (Sides.ShowSouthSide() && Sides.ShowWestSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, 0.0, TZ.doubleValue()), loc.clone(), 0.0, TY, 0.0, Range, true));
        }
        if (Sides.ShowSouthSide() && Sides.ShowEastSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(TX.doubleValue(), 0.0, TZ.doubleValue()), loc.clone(), 0.0, TY + 1.0, 0.0, Range, true));
        }
        if (Sides.ShowWestSide() && Sides.ShowBottomSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, 0.0, 0.0), loc.clone(), 0.0, 0.0, TZ, Range, true));
        }
        if (Sides.ShowEastSide() && Sides.ShowBottomSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(TX.doubleValue(), 0.0, 0.0), loc.clone(), 0.0, 0.0, TZ, Range, true));
        }
        if (Sides.ShowWestSide() && Sides.ShowTopSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(0.0, TY.doubleValue(), 0.0), loc.clone(), 0.0, 0.0, TZ, Range, true));
        }
        if (Sides.ShowEastSide() && Sides.ShowTopSide()) {
            locList.addAll(this.getLocations(lowLoc.clone().add(TX.doubleValue(), TY.doubleValue(), 0.0), loc.clone(), 0.0, 0.0, TZ, Range, true));
        }
        return locList;
    }

    public boolean MakeBorders(final Player player, final boolean error) {
        final Visualizer v = this.vMap.get(player.getUniqueId());
        if (v == null) {
            return false;
        }
        List<CuboidArea> areas = null;
        areas = !error ? v.getAreas() : v.getErrorAreas();
        Location loc = player.getLocation();
        int Range = this.plugin.getConfigManager().getVisualizerRange();
        final ArrayList<Location> locList = new ArrayList<Location>();
        final ArrayList<Location> errorLocList = new ArrayList<Location>();
        boolean same = v.isSameLoc();
        if (!same) {
            for (CuboidArea area2 : areas) {
                if (area2 == null) continue;
                CuboidArea cuboidArea = new CuboidArea(area2.getLowLoc(), area2.getHighLoc());
                cuboidArea.getHighLoc().add(1.0, 1.0, 1.0);
                SelectionSides Sides = new SelectionSides();
                double PLLX = loc.getBlockX() - Range;
                double PLLZ = loc.getBlockZ() - Range;
                double PLLY = loc.getBlockY() - Range;
                double PLHX = loc.getBlockX() + Range;
                double PLHZ = loc.getBlockZ() + Range;
                double PLHY = loc.getBlockY() + Range;
                if ((double)cuboidArea.getLowLoc().getBlockX() < PLLX) {
                    cuboidArea.getLowLoc().setX(PLLX);
                    Sides.setWestSide(false);
                }
                if ((double)cuboidArea.getHighLoc().getBlockX() > PLHX) {
                    cuboidArea.getHighLoc().setX(PLHX);
                    Sides.setEastSide(false);
                }
                if ((double)cuboidArea.getLowLoc().getBlockZ() < PLLZ) {
                    cuboidArea.getLowLoc().setZ(PLLZ);
                    Sides.setNorthSide(false);
                }
                if ((double)cuboidArea.getHighLoc().getBlockZ() > PLHZ) {
                    cuboidArea.getHighLoc().setZ(PLHZ);
                    Sides.setSouthSide(false);
                }
                if ((double)cuboidArea.getLowLoc().getBlockY() < PLLY) {
                    cuboidArea.getLowLoc().setY(PLLY);
                    Sides.setBottomSide(false);
                }
                if ((double)cuboidArea.getHighLoc().getBlockY() > PLHY) {
                    cuboidArea.getHighLoc().setY(PLHY);
                    Sides.setTopSide(false);
                }
                double TX = cuboidArea.getXSize() - 1;
                double TY = cuboidArea.getYSize() - 1;
                double TZ = cuboidArea.getZSize() - 1;
                if (!error && v.getId() != -1) {
                    Bukkit.getScheduler().cancelTask(v.getId());
                } else if (error && v.getErrorId() != -1) {
                    Bukkit.getScheduler().cancelTask(v.getErrorId());
                }
                locList.addAll(this.GetLocationsWallsByData(loc, TX, TY, TZ, cuboidArea.getLowLoc().clone(), Sides, Range));
                errorLocList.addAll(this.GetLocationsCornersByData(loc, TX, TY, TZ, cuboidArea.getLowLoc().clone(), Sides, Range));
            }
            v.setLoc(player.getLocation());
        } else if (error) {
            locList.addAll(v.getErrorLocations());
            errorLocList.addAll(v.getErrorLocations2());
        } else {
            locList.addAll(v.getLocations());
            errorLocList.addAll(v.getLocations2());
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                int size = locList.size();
                int errorSize = errorLocList.size();
                int timesMore = 1;
                int errorTimesMore = 1;
                if (size > SelectionManager.this.plugin.getConfigManager().getVisualizerSidesCap()) {
                    timesMore = size / SelectionManager.this.plugin.getConfigManager().getVisualizerSidesCap() + 1;
                }
                if (errorSize > SelectionManager.this.plugin.getConfigManager().getVisualizerFrameCap()) {
                    errorTimesMore = errorSize / SelectionManager.this.plugin.getConfigManager().getVisualizerFrameCap() + 1;
                }
                v.addCurrentSkip();
                if (v.getCurrentSkip() > SelectionManager.this.plugin.getConfigManager().getVisualizerSkipBy()) {
                    v.setCurrentSkip(1);
                }
                try {
                    SelectionManager.this.showParticles(locList, player, timesMore, error, true, v.getCurrentSkip());
                    SelectionManager.this.showParticles(errorLocList, player, errorTimesMore, error, false, v.getCurrentSkip());
                }
                catch (Exception e) {
                    return;
                }
                if (error) {
                    v.setErrorLocations(locList);
                    v.setErrorLocations2(errorLocList);
                } else {
                    v.setLocations(locList);
                    v.setLocations2(errorLocList);
                }
            }
        });
        if (v.isOnce()) {
            return true;
        }
        if (v.getStart() + (long)this.plugin.getConfigManager().getVisualizerShowFor() < System.currentTimeMillis()) {
            return false;
        }
        int scid = Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (player.isOnline()) {
                    SelectionManager.this.MakeBorders(player, error);
                }
            }
        }, (long)this.plugin.getConfigManager().getVisualizerUpdateInterval() * 1L);
        if (!error) {
            v.setId(scid);
        } else {
            v.setErrorId(scid);
        }
        return true;
    }

    private void showParticles(List<Location> locList, Player player, int timesMore, boolean error, boolean sides, int currentSkipBy) {
        int s = 0;
        int i = 0;
        while (i < locList.size()) {
            if (++s > this.plugin.getConfigManager().getVisualizerSkipBy()) {
                s = 1;
            }
            if (s == currentSkipBy) {
                Location l = locList.get(i);
                CMIEffectManager.CMIParticle effect = null;
                effect = sides ? (error ? this.plugin.getConfigManager().getOverlapSides() : this.plugin.getConfigManager().getSelectedSides()) : (error ? this.plugin.getConfigManager().getOverlapFrame() : this.plugin.getConfigManager().getSelectedFrame());
                CMIEffect ef = new CMIEffect(effect);
                Residence.getInstance().getNms().playEffect(player, l, ef);
            }
            i += timesMore;
        }
    }

    public void vert(Player player, boolean resadmin2) {
        if (this.hasPlacedBoth(player)) {
            this.sky(player, resadmin2);
            this.bedrock(player, resadmin2);
        } else {
            this.plugin.msg((CommandSender)player, lm.Select_Points, new Object[0]);
        }
    }

    public void sky(Player player, boolean resadmin2) {
        Selection selection = this.getSelection(player);
        selection.sky(resadmin2);
    }

    public void bedrock(Player player, boolean resadmin2) {
        Selection selection = this.getSelection(player);
        selection.bedrock(resadmin2);
    }

    public void clearSelection(Player player) {
        this.selections.remove(player.getUniqueId());
    }

    @Deprecated
    public void selectChunk(Player player) {
        Selection selection = this.getSelection(player);
        selection.selectChunk();
    }

    public boolean worldEdit(Player player) {
        this.plugin.msg((CommandSender)player, lm.General_WorldEditNotFound, new Object[0]);
        return false;
    }

    public boolean worldEditUpdate(Player player) {
        this.plugin.msg((CommandSender)player, lm.General_WorldEditNotFound, new Object[0]);
        return false;
    }

    public void selectBySize(Player player, int xsize, int ysize, int zsize) {
        Location myloc = player.getLocation();
        Location loc1 = new Location(myloc.getWorld(), (double)(myloc.getBlockX() + xsize), (double)(myloc.getBlockY() + ysize), (double)(myloc.getBlockZ() + zsize));
        Location loc2 = new Location(myloc.getWorld(), (double)(myloc.getBlockX() - xsize), (double)(myloc.getBlockY() - ysize), (double)(myloc.getBlockZ() - zsize));
        CuboidArea area2 = new CuboidArea(loc1, loc2);
        this.placeLoc1(player, loc1, false);
        this.placeLoc2(player, loc2, false);
        Selection selection = this.getSelection(player);
        if (selection.getMaxYAllowed() < area2.getHighLoc().getBlockY()) {
            selection.getBaseLoc2().setY((double)selection.getMaxYAllowed());
        }
        if (selection.getMinYAllowed() > area2.getLowLoc().getBlockY()) {
            selection.getBaseLoc1().setY((double)selection.getMinYAllowed());
        }
        this.afterSelectionUpdate(player);
        this.plugin.msg((CommandSender)player, lm.Select_Success, new Object[0]);
        this.showSelectionInfo(player);
    }

    public void modify(Player player, boolean shift, double amount) {
        if (!this.hasPlacedBoth(player)) {
            this.plugin.msg((CommandSender)player, lm.Select_Points, new Object[0]);
            return;
        }
        Direction d = SelectionManager.getDirection(player);
        if (d == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Direction, new Object[0]);
            return;
        }
        CuboidArea area2 = this.getSelectionCuboid(player);
        switch (d) {
            case DOWN: {
                double oldy = area2.getLowLoc().getBlockY();
                oldy -= amount;
                if (oldy < 0.0) {
                    this.plugin.msg((CommandSender)player, lm.Select_TooLow, new Object[0]);
                    oldy = 0.0;
                }
                area2.getLowLoc().setY(oldy);
                if (shift) {
                    double oldy2 = area2.getHighLoc().getBlockY();
                    area2.getHighLoc().setY(oldy2 -= amount);
                    this.plugin.msg((CommandSender)player, lm.Shifting_Down, amount);
                    break;
                }
                this.plugin.msg((CommandSender)player, lm.Expanding_Down, amount);
                break;
            }
            case MINUSX: {
                double oldx = area2.getLowLoc().getBlockX();
                area2.getLowLoc().setX(oldx -= amount);
                if (shift) {
                    double oldx2 = area2.getHighLoc().getBlockX();
                    area2.getHighLoc().setX(oldx2 -= amount);
                    this.plugin.msg((CommandSender)player, lm.Shifting_West, amount);
                    break;
                }
                this.plugin.msg((CommandSender)player, lm.Expanding_West, amount);
                break;
            }
            case MINUSZ: {
                double oldz = area2.getLowLoc().getBlockZ();
                area2.getLowLoc().setZ(oldz -= amount);
                if (shift) {
                    double oldz2 = area2.getHighLoc().getBlockZ();
                    area2.getHighLoc().setZ(oldz2 -= amount);
                    this.plugin.msg((CommandSender)player, lm.Shifting_North, amount);
                    break;
                }
                this.plugin.msg((CommandSender)player, lm.Expanding_North, amount);
                break;
            }
            case PLUSX: {
                double oldx = area2.getHighLoc().getBlockX();
                area2.getHighLoc().setX(oldx += amount);
                if (shift) {
                    double oldx2 = area2.getLowLoc().getBlockX();
                    area2.getLowLoc().setX(oldx2 += amount);
                    this.plugin.msg((CommandSender)player, lm.Shifting_East, amount);
                    break;
                }
                this.plugin.msg((CommandSender)player, lm.Expanding_East, amount);
                break;
            }
            case PLUSZ: {
                double oldz = area2.getHighLoc().getBlockZ();
                area2.getHighLoc().setZ(oldz += amount);
                if (shift) {
                    double oldz2 = area2.getLowLoc().getBlockZ();
                    area2.getLowLoc().setZ(oldz2 += amount);
                    this.plugin.msg((CommandSender)player, lm.Shifting_South, amount);
                    break;
                }
                this.plugin.msg((CommandSender)player, lm.Expanding_South, amount);
                break;
            }
            case UP: {
                double oldy = area2.getHighLoc().getBlockY();
                oldy += amount;
                if (oldy > (double)(this.getMaxWorldHeight(player.getLocation().getWorld()) - 1)) {
                    this.plugin.msg((CommandSender)player, lm.Select_TooHigh, new Object[0]);
                    oldy = this.getMaxWorldHeight(player.getLocation().getWorld()) - 1;
                }
                area2.getHighLoc().setY(oldy);
                if (shift) {
                    double oldy2 = area2.getLowLoc().getBlockY();
                    area2.getLowLoc().setY(oldy2 += amount);
                    this.plugin.msg((CommandSender)player, lm.Shifting_Up, amount);
                    break;
                }
                this.plugin.msg((CommandSender)player, lm.Expanding_Up, amount);
                break;
            }
        }
        this.updateLocations(player, area2.getHighLoc(), area2.getLowLoc(), true);
    }

    public boolean contract(Player player, double amount) {
        return this.contract(player, amount, false);
    }

    public boolean contract(Player player, double amount, boolean resadmin2) {
        if (!this.hasPlacedBoth(player)) {
            this.plugin.msg((CommandSender)player, lm.Select_Points, new Object[0]);
            return false;
        }
        Direction d = SelectionManager.getDirection(player);
        if (d == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Direction, new Object[0]);
            return false;
        }
        CuboidArea area2 = this.getSelectionCuboid(player);
        switch (d) {
            case UP: {
                double oldy = area2.getHighLoc().getBlockY();
                oldy -= amount;
                if (oldy > (double)(this.getMaxWorldHeight(player.getLocation().getWorld()) - 1)) {
                    this.plugin.msg((CommandSender)player, lm.Select_TooHigh, new Object[0]);
                    oldy = this.getMaxWorldHeight(player.getLocation().getWorld()) - 1;
                }
                area2.getHighLoc().setY(oldy);
                this.plugin.msg((CommandSender)player, lm.Contracting_Down, amount);
                break;
            }
            case PLUSX: {
                double oldx = area2.getHighLoc().getBlockX();
                area2.getHighLoc().setX(oldx -= amount);
                this.plugin.msg((CommandSender)player, lm.Contracting_West, amount);
                break;
            }
            case PLUSZ: {
                double oldz = area2.getHighLoc().getBlockZ();
                area2.getHighLoc().setZ(oldz -= amount);
                this.plugin.msg((CommandSender)player, lm.Contracting_North, amount);
                break;
            }
            case MINUSX: {
                double oldx = area2.getLowLoc().getBlockX();
                area2.getLowLoc().setX(oldx += amount);
                this.plugin.msg((CommandSender)player, lm.Contracting_East, amount);
                break;
            }
            case MINUSZ: {
                double oldz = area2.getLowLoc().getBlockZ();
                area2.getLowLoc().setZ(oldz += amount);
                this.plugin.msg((CommandSender)player, lm.Contracting_South, amount);
                break;
            }
            case DOWN: {
                double oldy = area2.getLowLoc().getBlockY();
                oldy += amount;
                if (oldy < 0.0) {
                    this.plugin.msg((CommandSender)player, lm.Select_TooLow, new Object[0]);
                    oldy = 0.0;
                }
                area2.getLowLoc().setY(oldy);
                this.plugin.msg((CommandSender)player, lm.Contracting_Up, amount);
                break;
            }
        }
        this.updateLocations(player, area2.getHighLoc(), area2.getLowLoc(), true);
        return true;
    }

    private static Direction getDirection(Player player) {
        int yaw = (int)player.getLocation().getYaw();
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += 45;
        int facing = (yaw %= 360) / 90;
        float pitch = player.getLocation().getPitch();
        if (pitch < -50.0f) {
            return Direction.UP;
        }
        if (pitch > 50.0f) {
            return Direction.DOWN;
        }
        if (facing == 1) {
            return Direction.MINUSX;
        }
        if (facing == 3) {
            return Direction.PLUSX;
        }
        if (facing == 2) {
            return Direction.MINUSZ;
        }
        if (facing == 0) {
            return Direction.PLUSZ;
        }
        return null;
    }

    public void regenerate(CuboidArea area2) {
    }

    public static enum Direction {
        UP,
        DOWN,
        PLUSX,
        PLUSZ,
        MINUSX,
        MINUSZ;

    }

    public class Selection {
        private Player player;
        private Location loc1;
        private Location loc2;

        public Selection(Player player) {
            this.player = player;
        }

        public Location getBaseLoc1() {
            return this.loc1 == null ? null : this.loc1.clone();
        }

        public void setBaseLoc1(Location loc1) {
            this.loc1 = loc1.clone();
        }

        public World getWorld() {
            if (this.loc1 != null) {
                return this.loc1.getWorld();
            }
            if (this.loc2 != null) {
                return this.loc2.getWorld();
            }
            return this.player.getWorld();
        }

        public Location getBaseLoc2() {
            return this.loc2 == null ? null : this.loc2.clone();
        }

        public void setBaseLoc2(Location loc2) {
            this.loc2 = loc2.clone();
        }

        public selectionType getSelectionRestrictions() {
            if (this.inSameResidence()) {
                if (SelectionManager.this.plugin.getConfigManager().isSelectionIgnoreYInSubzone() && this.hasPlacedBoth() && !this.player.hasPermission(SelectionManager.this.ignoreyinsubzonePermission)) {
                    return selectionType.residenceBounds;
                }
            } else if (SelectionManager.this.plugin.getConfigManager().isSelectionIgnoreY() && this.hasPlacedBoth() && !this.player.hasPermission(SelectionManager.this.ignoreyPermission)) {
                return selectionType.ignoreY;
            }
            return selectionType.noLimits;
        }

        public int getMaxYAllowed() {
            CuboidArea area2;
            switch (this.getSelectionRestrictions()) {
                default: {
                    return SelectionManager.this.getMaxWorldHeight(this.getWorld());
                }
                case residenceBounds: 
            }
            ClaimedResidence res1 = SelectionManager.this.plugin.getResidenceManager().getByLoc(this.getBaseLoc2());
            if (res1 != null && (area2 = res1.getAreaByLoc(this.getBaseLoc2())) != null) {
                return area2.getHighLoc().getBlockY();
            }
            return SelectionManager.this.getMaxWorldHeight(this.getWorld());
        }

        public int getMinYAllowed() {
            CuboidArea area2;
            switch (this.getSelectionRestrictions()) {
                default: {
                    return 0;
                }
                case residenceBounds: 
            }
            ClaimedResidence res1 = SelectionManager.this.plugin.getResidenceManager().getByLoc(this.getBaseLoc1());
            if (res1 != null && (area2 = res1.getAreaByLoc(this.getBaseLoc1())) != null) {
                return area2.getLowLoc().getBlockY();
            }
            return 0;
        }

        private boolean inSameResidence() {
            if (!this.hasPlacedBoth()) {
                return false;
            }
            ClaimedResidence res1 = SelectionManager.this.plugin.getResidenceManager().getByLoc(this.getBaseLoc1());
            if (res1 == null) {
                return false;
            }
            ClaimedResidence res2 = SelectionManager.this.plugin.getResidenceManager().getByLoc(this.getBaseLoc2());
            if (res2 == null) {
                return false;
            }
            return res1.getName().equals(res2.getName());
        }

        public void vert(boolean resadmin2) {
            if (this.hasPlacedBoth()) {
                this.sky(resadmin2);
                this.bedrock(resadmin2);
            } else {
                SelectionManager.this.plugin.msg((CommandSender)this.player, lm.Select_Points, new Object[0]);
            }
        }

        private void shadowSky(CuboidArea area2) {
            if (!this.hasPlacedBoth()) {
                return;
            }
            area2.setHighLocation(this.getBaseArea().getHighLoc());
            area2.getHighLoc().setY((double)this.getMaxYAllowed());
        }

        private void shadowBedrock(CuboidArea area2) {
            if (!this.hasPlacedBoth()) {
                return;
            }
            area2.setLowLocation(this.getBaseArea().getLowLoc());
            area2.getLowLoc().setY((double)this.getMinYAllowed());
        }

        public void sky(boolean resadmin2) {
            if (this.hasPlacedBoth()) {
                ResidencePlayer rPlayer = SelectionManager.this.plugin.getPlayerManager().getResidencePlayer(this.getPlayer());
                PermissionGroup group = rPlayer.getGroup();
                CuboidArea base = this.getBaseArea();
                int y1 = base.getLowLoc().getBlockY();
                int newy = this.getMaxYAllowed();
                if (!resadmin2) {
                    if (group.getMaxHeight() < newy) {
                        newy = group.getMaxHeight();
                    }
                    if (newy - y1 > group.getMaxY() - 1) {
                        newy = y1 + (group.getMaxY() - 1);
                    }
                }
                this.loc1 = base.getLowLoc();
                this.loc2 = base.getHighLoc();
                this.loc2.setY((double)newy);
                SelectionManager.this.plugin.msg((CommandSender)this.player, lm.Select_Sky, new Object[0]);
            } else {
                SelectionManager.this.plugin.msg((CommandSender)this.player, lm.Select_Points, new Object[0]);
            }
        }

        public void bedrock(boolean resadmin2) {
            if (this.hasPlacedBoth()) {
                ResidencePlayer rPlayer = SelectionManager.this.plugin.getPlayerManager().getResidencePlayer(this.getPlayer());
                PermissionGroup group = rPlayer.getGroup();
                CuboidArea base = this.getBaseArea();
                int y2 = base.getHighLoc().getBlockY();
                int newy = this.getMinYAllowed();
                if (!resadmin2) {
                    if (newy < group.getMinHeight()) {
                        newy = group.getMinHeight();
                    }
                    if (y2 - newy > group.getMaxY() - 1) {
                        newy = y2 - (group.getMaxY() - 1);
                    }
                }
                this.loc1 = base.getLowLoc();
                this.loc2 = base.getHighLoc();
                this.loc1.setY((double)newy);
                SelectionManager.this.plugin.msg((CommandSender)this.player, lm.Select_Bedrock, new Object[0]);
            } else {
                SelectionManager.this.plugin.msg((CommandSender)this.player, lm.Select_Points, new Object[0]);
            }
        }

        public void selectChunk() {
            Chunk chunk = this.player.getWorld().getChunkAt(this.player.getLocation());
            int xcoord = chunk.getX() * 16;
            int zcoord = chunk.getZ() * 16;
            int xmax = xcoord + 15;
            int zmax = zcoord + 15;
            this.setBaseLoc1(new Location(this.player.getWorld(), (double)xcoord, (double)this.getMinYAllowed(), (double)zcoord));
            this.setBaseLoc2(new Location(this.player.getWorld(), (double)xmax, (double)this.getMaxYAllowed(), (double)zmax));
            SelectionManager.this.plugin.msg((CommandSender)this.player, lm.Select_Success, new Object[0]);
        }

        public boolean hasPlacedBoth() {
            return this.getBaseLoc1() != null && this.getBaseLoc2() != null;
        }

        public Player getPlayer() {
            return this.player;
        }

        public void setPlayer(Player player) {
            this.player = player;
        }

        public CuboidArea getBaseArea() {
            if (!this.hasPlacedBoth()) {
                return null;
            }
            return new CuboidArea(this.loc1, this.loc2);
        }

        public CuboidArea getResizedArea() {
            CuboidArea area2 = this.getBaseArea();
            switch (this.getSelectionRestrictions()) {
                case noLimits: {
                    break;
                }
                case ignoreY: 
                case residenceBounds: {
                    this.shadowSky(area2);
                    this.shadowBedrock(area2);
                    break;
                }
            }
            return area2;
        }
    }

    public static enum selectionType {
        noLimits,
        ignoreY,
        residenceBounds;

    }
}

